/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.pkl.core.Release;
import org.pkl.core.StackFrame;
import org.pkl.core.runtime.StackTraceGenerator;
import org.pkl.core.runtime.StackTraceRenderer;
import org.pkl.core.runtime.VmBugException;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmWrappedEvalException;
import org.pkl.core.util.AnsiStringBuilder;
import org.pkl.core.util.AnsiTheme;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;

public final class VmExceptionRenderer {
    @Nullable
    private final StackTraceRenderer stackTraceRenderer;
    private final boolean color;

    public VmExceptionRenderer(@Nullable StackTraceRenderer stackTraceRenderer, boolean color) {
        this.stackTraceRenderer = stackTraceRenderer;
        this.color = color;
    }

    @CompilerDirectives.TruffleBoundary
    public String render(VmException exception) {
        AnsiStringBuilder formatter = new AnsiStringBuilder(this.color);
        this.render(exception, formatter);
        return formatter.toString();
    }

    private void render(VmException exception, AnsiStringBuilder out) {
        if (exception instanceof VmBugException) {
            VmBugException bugException = (VmBugException)exception;
            this.renderBugException(bugException, out);
        } else {
            this.renderException(exception, out, true);
        }
    }

    private void renderBugException(VmBugException exception, AnsiStringBuilder out) {
        Throwable exceptionToReport = exception.getCause() != null ? exception.getCause() : exception;
        String exceptionUrl = URLEncoder.encode(exceptionToReport.toString(), StandardCharsets.UTF_8);
        out.append("An unexpected error has occurred. Would you mind filing a bug report?").append('\n').append("Cmd+Double-click the link below to open an issue.").append('\n').append("Please copy and paste the entire error output into the issue's description.").append("\n".repeat(2)).append("https://github.com/apple/pkl/issues/new").append("\n".repeat(2)).append(exceptionUrl.replaceAll("\\+", "%20")).append("\n\n");
        this.renderException(exception, out, true);
        out.append('\n').append(Release.current().versionInfo()).append("\n".repeat(2));
        exceptionToReport.printStackTrace(out.toPrintWriter());
    }

    private void renderException(VmException exception, AnsiStringBuilder out, boolean withHeader) {
        Throwable cause;
        String causeMessage;
        String message;
        String hint = exception.getHint();
        if (exception.isExternalMessage()) {
            String totalMessage = ErrorMessages.create(exception.getMessage(), exception.getMessageArguments());
            int index = totalMessage.indexOf("\n\n");
            if (index != -1) {
                message = totalMessage.substring(0, index);
                hint = totalMessage.substring(index + 2);
            } else {
                message = totalMessage;
            }
        } else {
            message = exception.getMessage() != null && exception.getMessageArguments().length != 0 ? String.format(exception.getMessage(), exception.getMessageArguments()) : exception.getMessage();
        }
        if (withHeader) {
            out.append(AnsiTheme.ERROR_HEADER, "\u2013\u2013 Pkl Error \u2013\u2013").append('\n');
        }
        out.append(AnsiTheme.ERROR_MESSAGE, message).append('\n');
        if (exception.getCause() != null && (causeMessage = (cause = exception.getCause()).getMessage()) != null && !causeMessage.equals(message)) {
            out.append(cause.getClass().getSimpleName()).append(": ").append(causeMessage).append('\n');
        }
        int maxNameLength = exception.getProgramValues().stream().mapToInt(v -> v.name.length()).max().orElse(0);
        for (VmException.ProgramValue value2 : exception.getProgramValues()) {
            out.append(value2.name).append(" ".repeat(Math.max(0, maxNameLength - value2.name.length()))).append(": ").append(value2).append('\n');
        }
        if (this.stackTraceRenderer != null) {
            List<StackFrame> frames = StackTraceGenerator.capture(exception);
            if (exception instanceof VmWrappedEvalException) {
                VmWrappedEvalException vmWrappedEvalException = (VmWrappedEvalException)exception;
                AnsiStringBuilder sb = out.newInstance();
                this.renderException(vmWrappedEvalException.getWrappedException(), sb, false);
                hint = sb.toString().lines().map(it -> ">\t" + it).collect(Collectors.joining("\n"));
            }
            if (!frames.isEmpty()) {
                this.stackTraceRenderer.render(frames, hint, out.append('\n'));
            } else if (hint != null) {
                out.append('\n').append(AnsiTheme.ERROR_MESSAGE_HINT, hint);
            }
        }
    }
}

