/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.pkl.core.ImportGraph;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.ast.builder.ImportsAndReadsParser;
import org.pkl.core.externalreader.ExternalReaderProcessException;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ResolvedModuleKey;
import org.pkl.core.runtime.ModuleResolver;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.util.GlobResolver;
import org.pkl.core.util.IoUtils;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;

public class VmImportAnalyzer {
    @CompilerDirectives.TruffleBoundary
    public static ImportGraph analyze(URI[] moduleUris, VmContext context) throws IOException, URISyntaxException, SecurityManagerException, ExternalReaderProcessException {
        TreeMap<URI, Set<ImportGraph.Import>> imports = new TreeMap<URI, Set<ImportGraph.Import>>();
        TreeMap<URI, URI> resolvedImports = new TreeMap<URI, URI>();
        for (URI moduleUri : moduleUris) {
            VmImportAnalyzer.analyzeSingle(moduleUri, context, imports, resolvedImports);
        }
        return new ImportGraph(imports, resolvedImports);
    }

    @CompilerDirectives.TruffleBoundary
    private static void analyzeSingle(URI moduleUri, VmContext context, Map<URI, Set<ImportGraph.Import>> imports, Map<URI, URI> resolvedImports) throws IOException, URISyntaxException, SecurityManagerException, ExternalReaderProcessException {
        ModuleResolver moduleResolver = context.getModuleResolver();
        SecurityManager securityManager = context.getSecurityManager();
        Set<ImportGraph.Import> importsInModule = VmImportAnalyzer.collectImports(moduleUri, moduleResolver, securityManager);
        imports.put(moduleUri, importsInModule);
        resolvedImports.put(moduleUri, moduleResolver.resolve(moduleUri).resolve(securityManager).getUri());
        for (ImportGraph.Import imprt : importsInModule) {
            if (imports.containsKey(imprt.uri())) continue;
            VmImportAnalyzer.analyzeSingle(imprt.uri(), context, imports, resolvedImports);
        }
    }

    private static Set<ImportGraph.Import> collectImports(URI moduleUri, ModuleResolver moduleResolver, SecurityManager securityManager) throws IOException, URISyntaxException, SecurityManagerException, ExternalReaderProcessException {
        List<ImportsAndReadsParser.Entry> importsAndReads;
        ModuleKey moduleKey = moduleResolver.resolve(moduleUri);
        ResolvedModuleKey resolvedModuleKey = moduleKey.resolve(securityManager);
        try {
            importsAndReads = ImportsAndReadsParser.parse(moduleKey, resolvedModuleKey);
        }
        catch (VmException err) {
            throw new VmExceptionBuilder().evalError("cannotAnalyzeBecauseSyntaxError", moduleKey.getUri()).wrapping(err).build();
        }
        if (importsAndReads == null) {
            return Set.of();
        }
        TreeSet<ImportGraph.Import> result = new TreeSet<ImportGraph.Import>();
        for (ImportsAndReadsParser.Entry entry : importsAndReads) {
            if (!entry.isModule()) continue;
            if (entry.isGlob()) {
                ModuleKey theModuleKey = moduleResolver.resolve(moduleKey.resolveUri(IoUtils.toUri(entry.stringValue())));
                try {
                    Map<String, GlobResolver.ResolvedGlobElement> elements = GlobResolver.resolveGlob(securityManager, theModuleKey, moduleKey, moduleKey.getUri(), entry.stringValue());
                    List<ImportGraph.Import> globImports = elements.values().stream().map(GlobResolver.ResolvedGlobElement::getUri).map(ImportGraph.Import::new).toList();
                    result.addAll(globImports);
                    continue;
                }
                catch (GlobResolver.InvalidGlobPatternException e2) {
                    throw new VmExceptionBuilder().evalError("invalidGlobPattern", entry.stringValue()).withSourceSection(entry.sourceSection()).build();
                }
            }
            URI resolvedUri = IoUtils.resolve(securityManager, moduleKey, IoUtils.toUri(entry.stringValue()));
            result.add(new ImportGraph.Import(resolvedUri));
        }
        return result;
    }
}

