/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import org.pkl.core.ast.member.ListingOrMappingTypeCastNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableEconomicMap;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.RootCallTarget;
import org.pkl.thirdparty.truffle.api.frame.MaterializedFrame;
import org.pkl.thirdparty.truffle.api.nodes.IndirectCallNode;

public abstract class VmListingOrMapping
extends VmObject {
    @Nullable
    private final ListingOrMappingTypeCastNode typeCastNode;
    @Nullable
    private final Object typeCheckReceiver;
    @Nullable
    private final VmObjectLike typeCheckOwner;

    public VmListingOrMapping(MaterializedFrame enclosingFrame, @Nullable VmObject parent, UnmodifiableEconomicMap<Object, ObjectMember> members) {
        super(enclosingFrame, parent, members);
        this.typeCastNode = null;
        this.typeCheckReceiver = null;
        this.typeCheckOwner = null;
    }

    public VmListingOrMapping(MaterializedFrame enclosingFrame, @Nullable VmObject parent, UnmodifiableEconomicMap<Object, ObjectMember> members, ListingOrMappingTypeCastNode typeCastNode, Object typeCheckReceiver, VmObjectLike typeCheckOwner) {
        super(enclosingFrame, parent, members);
        this.typeCastNode = typeCastNode;
        this.typeCheckReceiver = typeCheckReceiver;
        this.typeCheckOwner = typeCheckOwner;
    }

    public final Object executeTypeCasts(Object value2, VmObjectLike owner, IndirectCallNode callNode, @Nullable ObjectMember member, @Nullable ListingOrMappingTypeCastNode nextTypeCastNode) {
        Object result;
        ListingOrMappingTypeCastNode newNextTypeCastNode = this.typeCastNode != null ? this.typeCastNode : nextTypeCastNode;
        Object object = result = this == owner ? value2 : ((VmListingOrMapping)this.parent).executeTypeCasts(value2, owner, callNode, member, newNextTypeCastNode);
        if (this.typeCastNode == null || this.typeCastNode == nextTypeCastNode) {
            return result;
        }
        RootCallTarget callTarget = this.typeCastNode.getCallTarget();
        try {
            return callNode.call(callTarget, this.typeCheckReceiver, this.typeCheckOwner, result);
        }
        catch (VmException e2) {
            CompilerDirectives.transferToInterpreter();
            if (member != null) {
                VmUtils.insertStackFrame(member, callTarget, e2);
            }
            throw e2;
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    @Nullable
    public final Object getCachedValue(Object key2) {
        Object result = EconomicMaps.get(this.cachedValues, key2);
        if (result != null || !this.members.isEmpty()) {
            return result;
        }
        assert (this.parent != null);
        result = this.parent.getCachedValue(key2);
        if (result == null) {
            return null;
        }
        if (this.typeCastNode != null && !(key2 instanceof Identifier)) {
            IndirectCallNode callNode = IndirectCallNode.getUncached();
            RootCallTarget callTarget = this.typeCastNode.getCallTarget();
            try {
                result = callNode.call(callTarget, this.typeCheckReceiver, this.typeCheckOwner, result);
            }
            catch (VmException e2) {
                ObjectMember member = VmUtils.findMember(this.parent, key2);
                assert (member != null);
                VmUtils.insertStackFrame(member, callTarget, e2);
                throw e2;
            }
        }
        this.setCachedValue(key2, result);
        return result;
    }

    public final boolean isValueTypeKnownSubtypeOf(TypeNode typeNode) {
        if (typeNode.isNoopTypeCheck()) {
            return true;
        }
        if (this.typeCastNode == null) {
            return false;
        }
        return this.typeCastNode.getTypeNode().isEquivalentTo(typeNode);
    }
}

