/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.pkl.core.ast.ConstantNode;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Iterators;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObjectBuilder;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmSafeMath;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.runtime.VmValueVisitor;
import org.pkl.core.util.CollectionUtils;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.paguro.collections.ImSet;
import org.pkl.thirdparty.paguro.collections.MutList;
import org.pkl.thirdparty.paguro.collections.MutSet;
import org.pkl.thirdparty.paguro.collections.PersistentHashSet;
import org.pkl.thirdparty.paguro.collections.RrbTree;
import org.pkl.thirdparty.paguro.tuple.Tuple2;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;

public final class VmSet
extends VmCollection {
    public static final VmSet EMPTY = new VmSet(PersistentHashSet.empty(), RrbTree.empty());
    private final ImSet<Object> set;
    private final RrbTree.ImRrbt<Object> elementOrder;
    boolean forced;

    private VmSet(ImSet<Object> set, RrbTree.ImRrbt<Object> elementOrder) {
        assert (set.size() == elementOrder.size());
        this.set = set;
        this.elementOrder = elementOrder;
    }

    @CompilerDirectives.TruffleBoundary
    public static VmSet of(Object value2) {
        return new VmSet(((PersistentHashSet.MutHashSet)PersistentHashSet.emptyMutable().put(value2)).immutable(), (RrbTree.ImRrbt<Object>)((RrbTree.MutRrbt)RrbTree.emptyMutable().append(value2)).immutable());
    }

    @CompilerDirectives.TruffleBoundary
    static VmSet create(ImSet<Object> set, RrbTree.ImRrbt<Object> elementOrder) {
        if (elementOrder.isEmpty()) {
            return EMPTY;
        }
        return new VmSet(set, elementOrder);
    }

    @CompilerDirectives.TruffleBoundary
    public static VmSet create(Iterable<?> iterable) {
        VmCollection.Builder<VmSet> builder = EMPTY.builder();
        builder.addAll(iterable);
        return builder.build();
    }

    @CompilerDirectives.TruffleBoundary
    public static VmSet createFromConstantNodes(ExpressionNode[] elements) {
        VmCollection.Builder<VmSet> builder = EMPTY.builder();
        for (ExpressionNode elem : elements) {
            assert (elem instanceof ConstantNode);
            builder.add(((ConstantNode)((Object)elem)).getValue());
        }
        return builder.build();
    }

    @Override
    public VmClass getVmClass() {
        return BaseModule.getSetClass();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getLength() {
        return this.elementOrder.size();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isEmpty() {
        return this.elementOrder.isEmpty();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isLengthOne() {
        return this.elementOrder.size() == 1;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public VmSet add(Object element) {
        if (this.set.contains(element)) {
            return this;
        }
        return VmSet.create((ImSet<Object>)this.set.put(element), (RrbTree.ImRrbt<Object>)this.elementOrder.append(element));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public VmSet concatenate(VmCollection other) {
        if (other.isEmpty()) {
            return this;
        }
        MutSet<Object> setBuilder = this.set.mutable();
        MutList elementOrderBuilder = this.elementOrder.mutable();
        for (Object element : other) {
            if (setBuilder.contains(element)) continue;
            setBuilder.put(element);
            ((RrbTree.MutRrbt)elementOrderBuilder).append(element);
        }
        return VmSet.create(setBuilder.immutable(), (RrbTree.ImRrbt<Object>)((RrbTree.MutRrbt)elementOrderBuilder).immutable());
    }

    @Override
    public Iterator<Object> iterator() {
        if (this.elementOrder.isEmpty()) {
            return Iterators.emptyTruffleIterator();
        }
        return new Iterators.TruffleIterator<Object>(this.elementOrder);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Iterator<Object> reverseIterator() {
        if (this.elementOrder.isEmpty()) {
            return Iterators.emptyTruffleIterator();
        }
        return new Iterators.ReverseTruffleIterator<Object>(this.elementOrder);
    }

    public VmCollection.Builder<VmSet> builder() {
        return new Builder();
    }

    public static VmCollection.Builder<VmSet> builder(VmSet set) {
        return new Builder(set);
    }

    @CompilerDirectives.TruffleBoundary
    public Object getFirst() {
        this.checkNonEmpty();
        return this.elementOrder.get(0);
    }

    @CompilerDirectives.TruffleBoundary
    public Object getFirstOrNull() {
        if (this.elementOrder.isEmpty()) {
            return VmNull.withoutDefault();
        }
        return this.elementOrder.get(0);
    }

    @CompilerDirectives.TruffleBoundary
    public VmSet getRest() {
        this.checkNonEmpty();
        Object first2 = this.elementOrder.get(0);
        return VmSet.create((ImSet<Object>)this.set.without(first2), (RrbTree.ImRrbt<Object>)this.elementOrder.without(0));
    }

    @CompilerDirectives.TruffleBoundary
    public Object getRestOrNull() {
        if (this.elementOrder.isEmpty()) {
            return VmNull.withoutDefault();
        }
        Object first2 = this.elementOrder.get(0);
        return VmSet.create((ImSet<Object>)this.set.without(first2), (RrbTree.ImRrbt<Object>)this.elementOrder.without(0));
    }

    @CompilerDirectives.TruffleBoundary
    public Object getLast() {
        this.checkNonEmpty();
        return this.elementOrder.get(this.elementOrder.size() - 1);
    }

    @CompilerDirectives.TruffleBoundary
    public Object getLastOrNull() {
        if (this.elementOrder.isEmpty()) {
            return VmNull.withoutDefault();
        }
        return this.elementOrder.get(this.elementOrder.size() - 1);
    }

    @CompilerDirectives.TruffleBoundary
    public Object getSingle() {
        this.checkLengthOne();
        return this.elementOrder.get(0);
    }

    @CompilerDirectives.TruffleBoundary
    public Object getSingleOrNull() {
        if (!this.isLengthOne()) {
            return VmNull.withoutDefault();
        }
        return this.elementOrder.get(0);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean contains(Object element) {
        return this.set.contains(element);
    }

    @CompilerDirectives.TruffleBoundary
    public VmPair split(long index) {
        Tuple2<RrbTree.ImRrbt<Object>, RrbTree.ImRrbt<Object>> tuple = this.elementOrder.split((int)index);
        return new VmPair(VmSet.create(tuple._1().toImSet(), tuple._1()), VmSet.create(tuple._2().toImSet(), tuple._2()));
    }

    @CompilerDirectives.TruffleBoundary
    public Object splitOrNull(long index) {
        if (index < 0L || index > (long)this.getLength()) {
            return VmNull.withoutDefault();
        }
        return this.split(index);
    }

    @CompilerDirectives.TruffleBoundary
    public VmSet take(long n) {
        if (n == 0L) {
            return EMPTY;
        }
        if (n >= (long)this.elementOrder.size()) {
            return this;
        }
        VmSet.checkPositive(n);
        Tuple2<RrbTree.ImRrbt<Object>, RrbTree.ImRrbt<Object>> keepAndRemove = this.elementOrder.split(VmSafeMath.toInt32(n));
        return VmSet.create(keepAndRemove._1().toImSet(), keepAndRemove._1());
    }

    @CompilerDirectives.TruffleBoundary
    public VmSet takeLast(long n) {
        if (n == 0L) {
            return EMPTY;
        }
        if (n >= (long)this.elementOrder.size()) {
            return this;
        }
        VmSet.checkPositive(n);
        Tuple2<RrbTree.ImRrbt<Object>, RrbTree.ImRrbt<Object>> removeAndKeep = this.elementOrder.split(this.elementOrder.size() - VmSafeMath.toInt32(n));
        return VmSet.create(removeAndKeep._2().toImSet(), removeAndKeep._2());
    }

    @CompilerDirectives.TruffleBoundary
    public VmSet drop(long n) {
        if (n == 0L) {
            return this;
        }
        if (n >= (long)this.elementOrder.size()) {
            return EMPTY;
        }
        VmSet.checkPositive(n);
        Tuple2<RrbTree.ImRrbt<Object>, RrbTree.ImRrbt<Object>> removeAndKeep = this.elementOrder.split(VmSafeMath.toInt32(n));
        return VmSet.create(removeAndKeep._2().toImSet(), removeAndKeep._2());
    }

    @CompilerDirectives.TruffleBoundary
    public VmSet dropLast(long n) {
        if (n == 0L) {
            return this;
        }
        if (n >= (long)this.elementOrder.size()) {
            return EMPTY;
        }
        VmSet.checkPositive(n);
        Tuple2<RrbTree.ImRrbt<Object>, RrbTree.ImRrbt<Object>> keepAndRemove = this.elementOrder.split(this.elementOrder.size() - VmSafeMath.toInt32(n));
        return VmSet.create(keepAndRemove._1().toImSet(), keepAndRemove._1());
    }

    @CompilerDirectives.TruffleBoundary
    public VmList repeat(long n) {
        return VmList.create(this.elementOrder).repeat(n);
    }

    @CompilerDirectives.TruffleBoundary
    public VmList reverse() {
        return VmList.create(this.elementOrder).reverse();
    }

    @CompilerDirectives.TruffleBoundary
    public Object[] toArray() {
        return this.elementOrder.toArray();
    }

    @CompilerDirectives.TruffleBoundary
    public VmList toList() {
        return VmList.create(this.elementOrder);
    }

    public VmSet toSet() {
        return this;
    }

    @CompilerDirectives.TruffleBoundary
    public VmListing toListing() {
        VmObjectBuilder builder = new VmObjectBuilder(this.elementOrder.size());
        for (Object e2 : this.elementOrder) {
            builder.addElement(e2);
        }
        return builder.toListing();
    }

    @CompilerDirectives.TruffleBoundary
    public VmDynamic toDynamic() {
        VmObjectBuilder builder = new VmObjectBuilder(this.elementOrder.size());
        for (Object e2 : this.elementOrder) {
            builder.addElement(e2);
        }
        return builder.toDynamic();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void force(boolean allowUndefinedValues) {
        if (this.forced) {
            return;
        }
        this.forced = true;
        try {
            for (Object e2 : this.elementOrder) {
                VmValue.force(e2, allowUndefinedValues);
            }
        }
        catch (Throwable t) {
            this.forced = false;
            throw t;
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Set<Object> export() {
        LinkedHashSet<Object> result = CollectionUtils.newLinkedHashSet(this.elementOrder.size());
        for (Object e2 : this.elementOrder) {
            result.add(VmValue.export(e2));
        }
        return result;
    }

    @Override
    public void accept(VmValueVisitor visitor) {
        visitor.visitSet(this);
    }

    @Override
    public <T> T accept(VmValueConverter<T> converter, Iterable<Object> path) {
        return converter.convertSet(this, path);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VmSet)) {
            return false;
        }
        VmSet vmSet = (VmSet)other;
        return this.set.equals(vmSet.set);
    }

    @CompilerDirectives.TruffleBoundary
    public int hashCode() {
        return this.set.hashCode();
    }

    private static final class Builder
    implements VmCollection.Builder<VmSet> {
        private final MutSet<Object> setBuilder;
        private final RrbTree.MutRrbt<Object> elementOrderBuilder;

        @CompilerDirectives.TruffleBoundary
        private Builder() {
            this.setBuilder = PersistentHashSet.emptyMutable();
            this.elementOrderBuilder = RrbTree.emptyMutable();
        }

        @CompilerDirectives.TruffleBoundary
        private Builder(VmSet set) {
            this.setBuilder = set.set.mutable();
            this.elementOrderBuilder = set.elementOrder.mutable();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void add(Object element) {
            if (!this.setBuilder.contains(element)) {
                this.setBuilder.put(element);
                this.elementOrderBuilder.append(element);
            }
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void addAll(Iterable<?> elements) {
            for (Object elem : elements) {
                if (this.setBuilder.contains(elem)) continue;
                this.setBuilder.put(elem);
                this.elementOrderBuilder.append(elem);
            }
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public VmSet build() {
            if (this.elementOrderBuilder.isEmpty()) {
                return EMPTY;
            }
            return VmSet.create(this.setBuilder.immutable(), (RrbTree.ImRrbt<Object>)this.elementOrderBuilder.immutable());
        }
    }
}

