/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.pkl.core.PClassInfo;
import org.pkl.core.PObject;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.StackFrame;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.ast.ConstantNode;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.SimpleRootNode;
import org.pkl.core.ast.builder.AstBuilder;
import org.pkl.core.ast.expression.primary.CustomThisNode;
import org.pkl.core.ast.expression.primary.ThisNode;
import org.pkl.core.ast.member.ClassProperty;
import org.pkl.core.ast.member.LocalTypedPropertyNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.PropertyTypeNode;
import org.pkl.core.ast.member.TypeCheckedPropertyNodeGen;
import org.pkl.core.ast.member.TypedPropertyNode;
import org.pkl.core.ast.member.UntypedObjectMemberNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ModuleKeys;
import org.pkl.core.module.ResolvedModuleKey;
import org.pkl.core.parser.LexParseException;
import org.pkl.core.parser.Parser;
import org.pkl.core.parser.antlr.PklParser;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.ModuleInfo;
import org.pkl.core.runtime.ModuleResolver;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmListingOrMapping;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.graalvm.polyglot.Context;
import org.pkl.thirdparty.graalvm.polyglot.Engine;
import org.pkl.thirdparty.paguro.collections.ImMap;
import org.pkl.thirdparty.truffle.api.CallTarget;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.RootCallTarget;
import org.pkl.thirdparty.truffle.api.Truffle;
import org.pkl.thirdparty.truffle.api.TruffleLanguage;
import org.pkl.thirdparty.truffle.api.frame.Frame;
import org.pkl.thirdparty.truffle.api.frame.FrameDescriptor;
import org.pkl.thirdparty.truffle.api.frame.FrameSlotKind;
import org.pkl.thirdparty.truffle.api.frame.MaterializedFrame;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.ExplodeLoop;
import org.pkl.thirdparty.truffle.api.nodes.IndirectCallNode;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.nodes.NodeInfo;
import org.pkl.thirdparty.truffle.api.source.Source;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class VmUtils {
    public static final Object SKIP_TYPECHECK_MARKER = new Object();
    public static final String REPL_TEXT = "repl:text";
    public static final URI REPL_TEXT_URI = URI.create("repl:text");
    private static final Engine PKL_ENGINE = Engine.newBuilder("pkl").option("engine.WarnInterpreterOnly", "false").build();
    private static final Pattern DOC_COMMENT_LINE_START = Pattern.compile("(?:^|\n|\r\n?)[ \t\f]*///[ \t\f]?", 320);
    private static final SourceSection UNAVAILABLE_SOURCE_SECTION = Source.newBuilder("pkl", "", "unavailable").mimeType("application/x-pkl").uri(URI.create("source:unavailable")).cached(false).build().createUnavailableSection();
    private static final DecimalFormatSymbols ROOT_DECIMAL_FORMAT_SYMBOLS = DecimalFormatSymbols.getInstance(Locale.ROOT);

    private VmUtils() {
    }

    static VmTyped createEmptyModule() {
        return new VmTyped(VmUtils.createEmptyMaterializedFrame(), null, null, EconomicMaps.create());
    }

    @CompilerDirectives.TruffleBoundary
    public static MaterializedFrame createEmptyMaterializedFrame() {
        return Truffle.getRuntime().createMaterializedFrame(new Object[]{null, null});
    }

    public static Context createContext(Runnable initializer) {
        Context context = Context.newBuilder("pkl").engine(PKL_ENGINE).build();
        context.initialize("pkl");
        context.enter();
        try {
            initializer.run();
        }
        finally {
            context.leave();
        }
        return context;
    }

    public static int countLeadingWhitespace(String str) {
        int idx;
        for (idx = 0; idx < str.length() && Character.isWhitespace(str.charAt(idx)); ++idx) {
        }
        return idx;
    }

    public static String indent(String text, String indent) {
        return text.lines().map(line -> indent + line).collect(Collectors.joining("\n"));
    }

    @Nullable
    public static Object getReceiverOrNull(Frame frame) {
        return frame.getArguments()[0];
    }

    public static Object getReceiver(Frame frame) {
        Object result = VmUtils.getReceiverOrNull(frame);
        assert (result != null);
        return result;
    }

    public static VmObjectLike getObjectReceiver(Frame frame) {
        return (VmObjectLike)VmUtils.getReceiver(frame);
    }

    public static VmTyped getTypedObjectReceiver(Frame frame) {
        return (VmTyped)VmUtils.getReceiver(frame);
    }

    @Nullable
    public static VmObjectLike getOwnerOrNull(Frame frame) {
        return (VmObjectLike)frame.getArguments()[1];
    }

    public static VmObjectLike getOwner(Frame frame) {
        VmObjectLike result = VmUtils.getOwnerOrNull(frame);
        assert (result != null);
        return result;
    }

    public static Object getMemberKey(Frame frame) {
        return frame.getArguments()[2];
    }

    public static ModuleInfo getModuleInfo(VmObjectLike composite) {
        assert (composite.isModuleObject());
        return (ModuleInfo)composite.getExtraStorage();
    }

    public static String readTextProperty(VmObjectLike receiver) {
        return (String)VmUtils.readMember(receiver, Identifier.TEXT);
    }

    public static String readTextProperty(Object receiver) {
        assert (receiver instanceof VmObjectLike);
        return (String)VmUtils.readMember((VmObjectLike)receiver, Identifier.TEXT);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object readMember(VmObjectLike receiver, Object memberKey) {
        Object result = VmUtils.readMemberOrNull(receiver, memberKey);
        if (result != null) {
            return result;
        }
        throw new VmExceptionBuilder().cannotFindMember(receiver, memberKey).build();
    }

    @CompilerDirectives.TruffleBoundary
    @Nullable
    public static Object readMemberOrNull(VmObjectLike receiver, Object memberKey, boolean checkType) {
        return VmUtils.readMemberOrNull(receiver, memberKey, checkType, IndirectCallNode.getUncached());
    }

    @CompilerDirectives.TruffleBoundary
    @Nullable
    public static Object readMemberOrNull(VmObjectLike receiver, Object memberKey, IndirectCallNode callNode) {
        return VmUtils.readMemberOrNull(receiver, memberKey, true, callNode);
    }

    @CompilerDirectives.TruffleBoundary
    @Nullable
    public static Object readMemberOrNull(VmObjectLike receiver, Object memberKey) {
        return VmUtils.readMemberOrNull(receiver, memberKey, true, IndirectCallNode.getUncached());
    }

    @CompilerDirectives.TruffleBoundary
    public static Object doReadMember(VmObjectLike receiver, VmObjectLike owner, Object memberKey, ObjectMember member) {
        return VmUtils.doReadMember(receiver, owner, memberKey, member, true, IndirectCallNode.getUncached());
    }

    @CompilerDirectives.TruffleBoundary
    public static Object readMember(VmObjectLike receiver, Object memberKey, IndirectCallNode callNode) {
        Object result = VmUtils.readMemberOrNull(receiver, memberKey, true, callNode);
        if (result != null) {
            return result;
        }
        throw new VmExceptionBuilder().cannotFindMember(receiver, memberKey).withLocation(callNode).build();
    }

    @CompilerDirectives.TruffleBoundary
    @Nullable
    public static Object readMemberOrNull(VmObjectLike receiver, Object memberKey, boolean checkType, IndirectCallNode callNode) {
        Identifier identifier;
        assert (!(memberKey instanceof Identifier) || !(identifier = (Identifier)memberKey).isLocalProp()) : "Must use ReadLocalPropertyNode for local properties.";
        Object cachedValue = receiver.getCachedValue(memberKey);
        if (cachedValue != null) {
            return cachedValue;
        }
        for (VmObjectLike owner = receiver; owner != null; owner = owner.getParent()) {
            ObjectMember member = owner.getMember(memberKey);
            if (member == null) continue;
            return VmUtils.doReadMember(receiver, owner, memberKey, member, checkType, callNode);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object doReadMember(VmObjectLike receiver, VmObjectLike owner, Object memberKey, ObjectMember member, boolean checkType, IndirectCallNode callNode) {
        Object constantValue = member.getConstantValue();
        if (constantValue != null) {
            Object result = constantValue;
            if (member.isProp()) {
                ClassProperty property = receiver.getVmClass().getProperty(member.getName());
                if (property != null && property.getTypeNode() != null) {
                    RootCallTarget callTarget = property.getTypeNode().getCallTarget();
                    try {
                        if (checkType) {
                            result = callNode.call(callTarget, receiver, property.getOwner(), constantValue);
                        }
                        result = callNode.call(callTarget, receiver, property.getOwner(), constantValue, SKIP_TYPECHECK_MARKER);
                    }
                    catch (VmException e2) {
                        CompilerDirectives.transferToInterpreter();
                        VmUtils.insertStackFrame(member, callTarget, e2);
                        throw e2;
                    }
                }
            } else if (receiver instanceof VmListingOrMapping) {
                VmListingOrMapping listingOrMapping = (VmListingOrMapping)receiver;
                if (owner instanceof VmListingOrMapping) {
                    result = listingOrMapping.executeTypeCasts(constantValue, owner, callNode, member, null);
                }
            }
            receiver.setCachedValue(memberKey, result);
            return result;
        }
        RootCallTarget callTarget = member.getCallTarget();
        Object result = checkType ? callNode.call(callTarget, receiver, owner, memberKey) : callNode.call(callTarget, receiver, owner, memberKey, SKIP_TYPECHECK_MARKER);
        receiver.setCachedValue(memberKey, result);
        return result;
    }

    public static void insertStackFrame(ObjectMember member, CallTarget location, VmException exception) {
        SourceSection sourceSection = member.getBodySection();
        if (!sourceSection.isAvailable()) {
            sourceSection = member.getSourceSection();
        }
        if (sourceSection.isAvailable()) {
            exception.getInsertedStackFrames().put(location, VmUtils.createStackFrame(sourceSection, member.getQualifiedName()));
        }
    }

    @Nullable
    public static ObjectMember findMember(VmObjectLike receiver, Object memberKey) {
        for (VmObjectLike owner = receiver; owner != null; owner = owner.getParent()) {
            ObjectMember member = owner.getMember(memberKey);
            if (member == null) continue;
            return member;
        }
        return null;
    }

    public static ExpressionNode createThisNode(SourceSection sourceSection, boolean isCustomThisScope) {
        return isCustomThisScope ? new CustomThisNode(sourceSection) : new ThisNode(sourceSection);
    }

    public static boolean isRenderDirective(VmValue value2) {
        return value2.getVmClass() == BaseModule.getRenderDirectiveClass();
    }

    public static boolean isRenderDirective(Object value2) {
        VmTyped typed;
        return value2 instanceof VmTyped && VmUtils.isRenderDirective(typed = (VmTyped)value2);
    }

    public static boolean isPcfRenderDirective(Object value2) {
        VmTyped typed;
        return value2 instanceof VmTyped && (typed = (VmTyped)value2).getVmClass().getPClassInfo() == PClassInfo.PcfRenderDirective;
    }

    @CompilerDirectives.TruffleBoundary
    public static NodeInfo getNodeInfo(Node node) {
        NodeInfo info = node.getClass().getAnnotation(NodeInfo.class);
        if (info != null) {
            return info;
        }
        throw new VmExceptionBuilder().bug("Node class `%s` is missing a `@NodeInfo` annotation.", node.getClass().getName()).build();
    }

    public static VmClass getClass(Object value2) {
        if (value2 instanceof VmValue) {
            VmValue vmValue = (VmValue)value2;
            return vmValue.getVmClass();
        }
        if (value2 instanceof String) {
            return BaseModule.getStringClass();
        }
        if (value2 instanceof Boolean) {
            return BaseModule.getBooleanClass();
        }
        if (value2 instanceof Long) {
            return BaseModule.getIntClass();
        }
        if (value2 instanceof Double) {
            return BaseModule.getFloatClass();
        }
        CompilerDirectives.transferToInterpreter();
        throw new VmExceptionBuilder().bug("Unknown Pkl data type `%s`.", value2).build();
    }

    public static String getConfigValue(TruffleLanguage.Env env, String name, String defaultValue) {
        Object rawValue = env.getConfig().get(name);
        if (rawValue == null) {
            return defaultValue;
        }
        return rawValue.toString();
    }

    public static SourceSection unavailableSourceSection() {
        return UNAVAILABLE_SOURCE_SECTION;
    }

    @CompilerDirectives.TruffleBoundary
    public static ImMap<Object, Object> put(ImMap<Object, Object> map2, String key2, Object value2) {
        return map2.assoc((Object)key2, value2);
    }

    @CompilerDirectives.TruffleBoundary
    public static StringBuilder createBuilder() {
        return new StringBuilder();
    }

    @CompilerDirectives.TruffleBoundary
    public static void appendToBuilder(StringBuilder builder, String string) {
        builder.append(string);
    }

    @CompilerDirectives.TruffleBoundary
    public static String builderToString(StringBuilder builder) {
        return builder.toString();
    }

    public static void checkPositive(long n) {
        if (n < 0L) {
            CompilerDirectives.transferToInterpreter();
            throw new VmExceptionBuilder().evalError("expectedPositiveNumber", n).build();
        }
    }

    public static Source loadSource(ResolvedModuleKey resolvedKey) {
        try {
            String text = resolvedKey.loadSource();
            return VmUtils.createSource(resolvedKey.getOriginal(), text);
        }
        catch (IOException e2) {
            throw new VmExceptionBuilder().evalError("ioErrorLoadingModule", resolvedKey.getOriginal().getUri()).withCause(e2).build();
        }
    }

    public static Source createSource(ModuleKey moduleKey, String text) {
        return Source.newBuilder("pkl", text, moduleKey.getUri().toString()).mimeType("application/x-pkl").uri(moduleKey.getUri()).cached(false).build();
    }

    public static VmException toVmException(LexParseException e2, String text, URI moduleUri, String moduleName) {
        Source source = Source.newBuilder("pkl", text, moduleName).mimeType("application/x-pkl").uri(moduleUri).cached(false).build();
        return VmUtils.toVmException(e2, source, moduleName);
    }

    public static VmException toVmException(LexParseException e2, Source source, String moduleName) {
        int lineStartOffset;
        try {
            lineStartOffset = source.getLineStartOffset(e2.getLine());
        }
        catch (IllegalArgumentException iae) {
            lineStartOffset = source.getLineStartOffset(e2.getLine() - 1);
        }
        return new VmExceptionBuilder().adhocEvalError(e2.getMessage(), new Object[0]).withSourceSection(source.createSection(lineStartOffset + e2.getColumn() - 1, e2.getLength())).withMemberName(moduleName).build();
    }

    @Nullable
    public static String exportDocComment(@Nullable SourceSection docComment) {
        if (docComment == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        Matcher matcher = DOC_COMMENT_LINE_START.matcher(docComment.getCharacters());
        boolean firstMatch = true;
        while (matcher.find()) {
            if (firstMatch) {
                matcher.appendReplacement(builder, "");
                firstMatch = false;
                continue;
            }
            matcher.appendReplacement(builder, "\n");
        }
        matcher.appendTail(builder);
        int newLength = builder.length() - 1;
        assert (builder.charAt(newLength) == '\n');
        builder.setLength(newLength);
        return builder.toString();
    }

    public static List<PObject> exportAnnotations(List<VmTyped> annotations) {
        ArrayList<PObject> result = new ArrayList<PObject>(annotations.size());
        VmUtils.exportAnnotations(annotations, result);
        return result;
    }

    public static void exportAnnotations(List<VmTyped> annotations, List<PObject> result) {
        for (VmTyped annotation : annotations) {
            annotation.force(false);
            result.add((PObject)annotation.export());
        }
    }

    public static List<VmTyped> evaluateAnnotations(VirtualFrame frame, ExpressionNode[] annotationNodes) {
        ArrayList<VmTyped> result = new ArrayList<VmTyped>(annotationNodes.length);
        VmUtils.evaluateAnnotations(frame, annotationNodes, result);
        return result;
    }

    @ExplodeLoop
    public static void evaluateAnnotations(VirtualFrame frame, ExpressionNode[] annotationNodes, List<VmTyped> result) {
        for (ExpressionNode annotationNode : annotationNodes) {
            VmTyped annotation = (VmTyped)annotationNode.executeGeneric(frame);
            result.add(annotation);
        }
    }

    public static int codePointOffsetToCharOffset(String string, long codePointOffset) {
        return VmUtils.codePointOffsetToCharOffset(string, codePointOffset, 0);
    }

    @CompilerDirectives.TruffleBoundary
    public static int codePointOffsetToCharOffset(String string, long codePointOffset, int startIndex) {
        assert (startIndex >= 0);
        assert (startIndex <= string.length());
        int length2 = string.length();
        int charOffset = startIndex;
        while (charOffset < length2 && codePointOffset > 0L) {
            if (Character.isHighSurrogate(string.charAt(charOffset++)) && charOffset < length2 && !Character.isLowSurrogate(string.charAt(charOffset++))) {
                codePointOffset -= 2L;
                continue;
            }
            --codePointOffset;
        }
        return codePointOffset != 0L ? -1 : charOffset;
    }

    @CompilerDirectives.TruffleBoundary
    public static int codePointOffsetFromEndToCharOffset(String string, long codePointOffset) {
        int charOffset = string.length();
        while (charOffset > 0 && codePointOffset > 0L) {
            if (Character.isLowSurrogate(string.charAt(--charOffset)) && charOffset > 0 && !Character.isHighSurrogate(string.charAt(--charOffset))) {
                codePointOffset -= 2L;
                continue;
            }
            --codePointOffset;
        }
        return codePointOffset != 0L ? -1 : charOffset;
    }

    public static DecimalFormat createDecimalFormat(int fractionDigits) {
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(ROOT_DECIMAL_FORMAT_SYMBOLS);
        format.setMinimumFractionDigits(fractionDigits);
        format.setMaximumFractionDigits(fractionDigits);
        format.setGroupingUsed(false);
        return format;
    }

    public static ObjectMember createSyntheticObjectProperty(@Nullable Identifier identifier, String qualifiedName, Object constantValue) {
        ObjectMember member = new ObjectMember(VmUtils.unavailableSourceSection(), VmUtils.unavailableSourceSection(), 0, identifier, qualifiedName);
        member.initConstantValue(constantValue);
        return member;
    }

    public static ObjectMember createSyntheticObjectEntry(String qualifiedName, Object constantValue) {
        ObjectMember member = new ObjectMember(VmUtils.unavailableSourceSection(), VmUtils.unavailableSourceSection(), 1024, null, qualifiedName);
        member.initConstantValue(constantValue);
        return member;
    }

    public static ObjectMember createSyntheticObjectElement(String qualifiedName, Object constantValue) {
        ObjectMember member = new ObjectMember(VmUtils.unavailableSourceSection(), VmUtils.unavailableSourceSection(), 2048, null, qualifiedName);
        member.initConstantValue(constantValue);
        return member;
    }

    public static ObjectMember createObjectProperty(VmLanguage language, SourceSection sourceSection, SourceSection headerSection, Identifier propertyName, String qualifiedName, FrameDescriptor descriptor, int modifiers, ExpressionNode bodyNode, @Nullable PropertyTypeNode typeNode) {
        boolean isLocalTyped;
        ObjectMember property = new ObjectMember(sourceSection, headerSection, modifiers, propertyName, qualifiedName);
        boolean bl = isLocalTyped = property.isLocal() && typeNode != null;
        if (bodyNode instanceof ConstantNode) {
            ConstantNode constantNode = (ConstantNode)((Object)bodyNode);
            if (!isLocalTyped) {
                property.initConstantValue(constantNode);
                return property;
            }
        }
        property.initMemberNode(typeNode != null ? new TypedPropertyNode(language, descriptor, property, bodyNode, typeNode) : (property.isLocal() ? new UntypedObjectMemberNode(language, descriptor, property, bodyNode) : TypeCheckedPropertyNodeGen.create(language, descriptor, property, bodyNode)));
        return property;
    }

    public static ObjectMember createLocalObjectProperty(VmLanguage language, SourceSection sourceSection, SourceSection headerSection, Identifier propertyName, String qualifiedName, FrameDescriptor descriptor, int modifiers, ExpressionNode bodyNode, @Nullable UnresolvedTypeNode typeNode) {
        boolean isLocalTyped;
        ObjectMember property = new ObjectMember(sourceSection, headerSection, modifiers, propertyName, qualifiedName);
        boolean bl = isLocalTyped = property.isLocal() && typeNode != null;
        if (bodyNode instanceof ConstantNode) {
            ConstantNode constantNode = (ConstantNode)((Object)bodyNode);
            if (!isLocalTyped) {
                property.initConstantValue(constantNode);
                return property;
            }
        }
        property.initMemberNode(typeNode != null ? new LocalTypedPropertyNode(language, descriptor, property, bodyNode, typeNode) : new UntypedObjectMemberNode(language, descriptor, property, bodyNode));
        return property;
    }

    public static TypeNode[] resolveParameterTypes(VirtualFrame frame, FrameDescriptor descriptor, @Nullable UnresolvedTypeNode[] parameterTypeNodes) {
        TypeNode[] resolvedNodes = new TypeNode[parameterTypeNodes.length];
        for (int i = 0; i < parameterTypeNodes.length; ++i) {
            UnresolvedTypeNode unresolvedNode = parameterTypeNodes[i];
            TypeNode typeNode = unresolvedNode == null ? new TypeNode.UnknownTypeNode(VmUtils.unavailableSourceSection()) : unresolvedNode.execute(frame);
            descriptor.setSlotKind(i, typeNode.getFrameSlotKind());
            typeNode.initWriteSlotNode(i);
            resolvedNodes[i] = typeNode;
        }
        return resolvedNodes;
    }

    public static void checkIsInstantiable(VmClass parentClass, @Nullable Node parentNode) {
        if (parentClass.isInstantiable()) {
            return;
        }
        CompilerDirectives.transferToInterpreter();
        if (parentClass.isAbstract()) {
            throw new VmExceptionBuilder().evalError("cannotInstantiateAbstractClass", parentClass).withOptionalLocation(parentNode).build();
        }
        assert (parentClass.isExternal());
        throw new VmExceptionBuilder().evalError("cannotInstantiateExternalClass", parentClass).withOptionalLocation(parentNode).build();
    }

    @CompilerDirectives.TruffleBoundary
    public static Pattern compilePattern(String pattern2, Node location) {
        try {
            return Pattern.compile(pattern2, 320);
        }
        catch (PatternSyntaxException e2) {
            throw new VmExceptionBuilder().withLocation(location).evalError("invalidRegexSyntax", pattern2, e2.getMessage()).build();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> K getKey(Map.Entry<K, V> entry) {
        return entry.getKey();
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V getValue(Map.Entry<K, V> entry) {
        return entry.getValue();
    }

    public static String getDisplayUri(SourceSection section, StackFrameTransformer transformer) {
        URI sourceUri = section.getSource().getURI();
        StackFrame frame = new StackFrame(sourceUri.toString(), null, List.of(), section.getStartLine(), section.getStartColumn(), section.getEndLine(), section.getEndColumn());
        StackFrame transformed = (StackFrame)transformer.apply(frame);
        return transformed.getModuleUri();
    }

    public static String getDisplayUri(URI moduleUri, StackFrameTransformer transformer) {
        StackFrame frame = new StackFrame(moduleUri.toString(), null, List.of(), 1, 1, 1, 1);
        StackFrame transformed = (StackFrame)transformer.apply(frame);
        return transformed.getModuleUri();
    }

    public static StackFrame createStackFrame(SourceSection section, @Nullable String memberName) {
        String moduleUri = section.getSource().getURI().toString();
        int startLine = section.getStartLine();
        int endLine = section.getEndLine();
        ArrayList<String> sourceLines = new ArrayList<String>(endLine - startLine + 1);
        for (int line = startLine; line <= endLine; ++line) {
            sourceLines.add(section.getSource().getCharacters(line).toString());
        }
        return new StackFrame(moduleUri, memberName, sourceLines, startLine, section.getStartColumn(), endLine, section.getEndColumn());
    }

    private static PklParser.ExprContext parseExpressionContext(String expression, Source source) {
        try {
            return new Parser().parseExpressionInput(expression).expr();
        }
        catch (LexParseException e2) {
            throw VmUtils.toVmException(e2, source, REPL_TEXT);
        }
    }

    public static Object evaluateExpression(VmTyped module, String expression, SecurityManager securityManager, ModuleResolver moduleResolver) {
        ResolvedModuleKey resolvedModule;
        ModuleKey syntheticModule = ModuleKeys.synthetic(URI.create(REPL_TEXT), expression);
        try {
            resolvedModule = syntheticModule.resolve(securityManager);
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
        catch (SecurityManagerException e3) {
            throw new VmExceptionBuilder().withCause(e3).build();
        }
        Source source = VmUtils.loadSource(resolvedModule);
        ModuleInfo moduleInfo = new ModuleInfo(source.createSection(0, source.getLength()), VmUtils.unavailableSourceSection(), null, REPL_TEXT, syntheticModule, resolvedModule, false);
        VmLanguage language = VmLanguage.get(null);
        AstBuilder builder = new AstBuilder(source, language, moduleInfo, moduleResolver);
        PklParser.ExprContext exprContext = VmUtils.parseExpressionContext(expression, source);
        ExpressionNode exprNode = (ExpressionNode)exprContext.accept(builder);
        SimpleRootNode rootNode = new SimpleRootNode(language, new FrameDescriptor(), exprNode.getSourceSection(), "", exprNode);
        IndirectCallNode callNode = Truffle.getRuntime().createIndirectCallNode();
        return callNode.call(rootNode.getCallTarget(), module, module);
    }

    public static int findSlot(VirtualFrame frame, Object identifier) {
        FrameDescriptor descriptor = frame.getFrameDescriptor();
        for (int i = 0; i < descriptor.getNumberOfSlots(); ++i) {
            if (descriptor.getSlotName(i) != identifier || frame.getTag(i) == FrameSlotKind.Illegal.tag || frame.getTag(i) == FrameSlotKind.Object.tag && frame.getObject(i) == null) continue;
            return i;
        }
        return -1;
    }

    public static int findAuxiliarySlot(VirtualFrame frame, Object identifier) {
        return frame.getFrameDescriptor().getAuxiliarySlots().getOrDefault(identifier, -1);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V getMapValue(Map<K, V> map2, K key2) {
        return map2.get(key2);
    }

    public static boolean shouldRunTypeCheck(VirtualFrame frame) {
        return frame.getArguments().length != 4 || frame.getArguments()[3] != SKIP_TYPECHECK_MARKER;
    }
}

