/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.analyze;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import org.pkl.core.ImportGraph;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.externalreader.ExternalReaderProcessException;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.runtime.AnalyzeModule;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmImportAnalyzer;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.VmObjectFactory;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;

public final class AnalyzeNodes {
    private static VmObjectFactory<ImportGraph.Import> importFactory = new VmObjectFactory<ImportGraph.Import>(AnalyzeModule::getImportClass).addStringProperty("uri", it -> it.uri().toString());
    private static VmObjectFactory<ImportGraph> importGraphFactory = new VmObjectFactory<ImportGraph>(AnalyzeModule::getImportGraphClass).addMapProperty("imports", graph -> {
        VmMap.Builder builder = VmMap.builder();
        for (Map.Entry<URI, Set<ImportGraph.Import>> entry : graph.imports().entrySet()) {
            VmCollection.Builder<VmSet> vmSetBuilder = VmSet.EMPTY.builder();
            for (ImportGraph.Import imprt : entry.getValue()) {
                vmSetBuilder.add(importFactory.create(imprt));
            }
            builder.add(entry.getKey().toString(), vmSetBuilder.build());
        }
        return builder.build();
    }).addMapProperty("resolvedImports", graph -> {
        VmMap.Builder builder = VmMap.builder();
        for (Map.Entry<URI, URI> entry : graph.resolvedImports().entrySet()) {
            builder.add(entry.getKey().toString(), entry.getValue().toString());
        }
        return builder.build();
    });

    private AnalyzeNodes() {
    }

    public static abstract class importGraph
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object eval(VmTyped self, VmSet moduleUris) {
            URI[] uris = new URI[moduleUris.getLength()];
            int idx = 0;
            for (Object moduleUri : moduleUris) {
                URI uri;
                try {
                    uri = new URI((String)moduleUri);
                }
                catch (URISyntaxException e2) {
                    throw this.exceptionBuilder().evalError("invalidModuleUri", moduleUri).withHint(e2.getMessage()).build();
                }
                if (!uri.isAbsolute()) {
                    throw this.exceptionBuilder().evalError("cannotAnalyzeRelativeModuleUri", moduleUri).build();
                }
                uris[idx] = uri;
                ++idx;
            }
            VmContext context = VmContext.get(this);
            try {
                ImportGraph results = VmImportAnalyzer.analyze(uris, context);
                return importGraphFactory.create(results);
            }
            catch (IOException | URISyntaxException | SecurityManagerException | ExternalReaderProcessException | PackageLoadError e3) {
                throw this.exceptionBuilder().withCause(e3).build();
            }
        }
    }
}

