/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.yaml;

import java.net.URI;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmSafeMath;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.PklConverter;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.yaml.snake.YamlUtils;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;
import org.pkl.thirdparty.snakeyaml.engine.v2.api.ConstructNode;
import org.pkl.thirdparty.snakeyaml.engine.v2.api.Load;
import org.pkl.thirdparty.snakeyaml.engine.v2.api.LoadSettings;
import org.pkl.thirdparty.snakeyaml.engine.v2.constructor.StandardConstructor;
import org.pkl.thirdparty.snakeyaml.engine.v2.exceptions.Mark;
import org.pkl.thirdparty.snakeyaml.engine.v2.exceptions.YamlEngineException;
import org.pkl.thirdparty.snakeyaml.engine.v2.nodes.MappingNode;
import org.pkl.thirdparty.snakeyaml.engine.v2.nodes.Node;
import org.pkl.thirdparty.snakeyaml.engine.v2.nodes.NodeTuple;
import org.pkl.thirdparty.snakeyaml.engine.v2.nodes.ScalarNode;
import org.pkl.thirdparty.snakeyaml.engine.v2.nodes.SequenceNode;
import org.pkl.thirdparty.snakeyaml.engine.v2.nodes.Tag;
import org.pkl.thirdparty.snakeyaml.engine.v2.resolver.ScalarResolver;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Cached;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.nodes.IndirectCallNode;
import org.pkl.thirdparty.truffle.api.source.Source;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class ParserNodes {
    private static final Pattern WHITESPACE = Pattern.compile("\\s");

    private ParserNodes() {
    }

    private static PklConverter createConverter(VmTyped self) {
        VmMapping converters = (VmMapping)VmUtils.readMember(self, Identifier.CONVERTERS);
        return new PklConverter(converters);
    }

    private static int getMaxCollectionAliases(VmTyped self) {
        Long max2 = (Long)VmUtils.readMember(self, Identifier.MAX_COLLECTION_ALIASES);
        return max2.intValue();
    }

    private static Load createLoad(VmTyped self, String text, String uri, PklConverter converter) {
        String mode = (String)VmUtils.readMember(self, Identifier.MODE);
        ScalarResolver resolver = YamlUtils.getParserResolver(mode);
        boolean useMapping = (Boolean)VmUtils.readMember(self, Identifier.USE_MAPPING);
        LoadSettings settings = LoadSettings.builder().setMaxAliasesForCollections(ParserNodes.getMaxCollectionAliases(self)).setScalarResolver(resolver).setLabel(uri).build();
        Source source = Source.newBuilder("pkl", text, uri).mimeType("application/x-yaml").uri(URI.create(uri)).cached(false).build();
        return new Load(settings, new Constructor(settings, source, converter, mode, useMapping));
    }

    private static final class Constructor
    extends StandardConstructor {
        private final Source source;
        private final PklConverter converter;
        private final boolean useMapping;
        private Deque<Object> currPath = new ArrayDeque<Object>();

        public Constructor(LoadSettings settings, Source source, PklConverter converter, String mode, boolean useMapping) {
            super(settings);
            this.source = source;
            this.converter = converter;
            this.useMapping = useMapping;
            this.currPath.push(VmValueConverter.TOP_LEVEL_VALUE);
            this.tagConstructors.clear();
            this.tagConstructors.put(Tag.NULL, new ConstructNull());
            this.tagConstructors.put(Tag.BOOL, new ConstructBoolean());
            this.tagConstructors.put(Tag.INT, new ConstructInt(mode.equals("compat") || mode.equals("1.1")));
            this.tagConstructors.put(Tag.FLOAT, new ConstructFloat());
            this.tagConstructors.put(Tag.BINARY, new ConstructBinary());
            this.tagConstructors.put(Tag.SET, new ConstructSet());
            this.tagConstructors.put(Tag.STR, new ConstructStr());
            this.tagConstructors.put(Tag.SEQ, new ConstructSeq());
            this.tagConstructors.put(Tag.MAP, new ConstructMap());
            this.tagConstructors.put(new Tag("tag:yaml.org,2002:timestamp"), new ConstructStr());
        }

        private SourceSection createSourceSection(Optional<Mark> start2, Optional<Mark> end2) {
            Source s2 = this.source;
            return VmUtils.unavailableSourceSection();
        }

        static /* synthetic */ void access$300(Constructor x0, MappingNode x1) {
            x0.flattenMapping(x1);
        }

        static /* synthetic */ Object access$400(Constructor x0, Node x1) {
            return x0.constructObject(x1);
        }

        static /* synthetic */ Object access$500(Constructor x0, Node x1) {
            return x0.constructObject(x1);
        }

        private static class ConstructNull
        implements ConstructNode {
            private ConstructNull() {
            }

            @Override
            public VmNull construct(Node node) {
                return VmNull.withoutDefault();
            }
        }

        public static class ConstructBoolean
        implements ConstructNode {
            @Override
            public Object construct(Node node) {
                String value2;
                return switch (value2 = ((ScalarNode)node).getValue()) {
                    case "true", "True", "TRUE", "on", "On", "ON", "y", "Y", "yes", "Yes", "YES" -> true;
                    default -> false;
                };
            }
        }

        private static class ConstructInt
        implements ConstructNode {
            final boolean enable11Octals;

            ConstructInt(boolean enable11Octals) {
                this.enable11Octals = enable11Octals;
            }

            @Override
            public Long construct(Node node) {
                int offset;
                String value2 = ((ScalarNode)node).getValue().replace("_", "");
                char firstChar = value2.charAt(0);
                boolean isNegative = firstChar == '-';
                int n = offset = isNegative || firstChar == '+' ? 1 : 0;
                if (value2.contains(":")) {
                    return ConstructInt.parseBase60(value2, isNegative, offset);
                }
                int radix = 10;
                if (value2.charAt(offset) == '0' && value2.length() > offset + 1) {
                    switch (value2.charAt(offset + 1)) {
                        case 'b': {
                            radix = 2;
                            offset += 2;
                            break;
                        }
                        case 'o': {
                            radix = 8;
                            offset += 2;
                            break;
                        }
                        case 'x': {
                            radix = 16;
                            offset += 2;
                            break;
                        }
                        default: {
                            if (!this.enable11Octals) break;
                            radix = 8;
                            ++offset;
                        }
                    }
                }
                long result = Long.parseLong(value2, offset, value2.length(), radix);
                if (isNegative) {
                    result = -result;
                }
                return result;
            }

            private static long parseBase60(String value2, boolean isNegative, int offset) {
                String[] segments;
                long result = 0L;
                for (String segment : segments = value2.substring(offset).split(":")) {
                    long segmentNum = Long.parseLong(segment);
                    result = VmSafeMath.add(VmSafeMath.multiply(result, 60L), segmentNum);
                }
                if (isNegative) {
                    result = -result;
                }
                return result;
            }
        }

        public static class ConstructFloat
        implements ConstructNode {
            @Override
            public Double construct(Node node) {
                String value2 = ((ScalarNode)node).getValue().replace("_", "");
                if (value2.equals(".")) {
                    return 0.0;
                }
                if (value2.contains(":")) {
                    return ConstructFloat.parseBase60(value2);
                }
                return switch (value2) {
                    case ".nan", ".NaN", ".NAN" -> Double.NaN;
                    case ".inf", ".Inf", ".INF", "+.inf", "+.Inf", "+.INF" -> Double.POSITIVE_INFINITY;
                    case "-.inf", "-.Inf", "-.INF" -> Double.NEGATIVE_INFINITY;
                    default -> Double.valueOf(value2);
                };
            }

            private static double parseBase60(String value2) {
                String[] segments;
                boolean isNegative = value2.startsWith("-");
                if (isNegative || value2.startsWith("+")) {
                    value2 = value2.substring(1);
                }
                double result = 0.0;
                for (String segment : segments = value2.split(":")) {
                    double segmentNum = Double.parseDouble(segment);
                    result = VmSafeMath.add(VmSafeMath.multiply(result, 60.0), segmentNum);
                }
                if (isNegative) {
                    result = -result;
                }
                return result;
            }
        }

        private static class ConstructBinary
        implements ConstructNode {
            private ConstructBinary() {
            }

            @Override
            public String construct(Node node) {
                String value2 = ((ScalarNode)node).getValue();
                return WHITESPACE.matcher(value2).replaceAll("");
            }
        }

        private class ConstructSet
        implements ConstructNode {
            private ConstructSet() {
            }

            @Override
            public VmListing construct(Node node) {
                MappingNode mappingNode = (MappingNode)node;
                int size = mappingNode.getValue().size();
                EconomicMap<Object, ObjectMember> members = EconomicMaps.create(size);
                VmListing result = new VmListing(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getListingClass().getPrototype(), members, size);
                if (!node.isRecursive()) {
                    this.addMembers(mappingNode, result);
                }
                return result;
            }

            @Override
            public void constructRecursive(Node node, Object data) {
                if (!node.isRecursive()) {
                    throw new YamlEngineException("Unexpected recursive sequence structure. Node: " + node);
                }
                this.addMembers((MappingNode)node, (VmListing)data);
            }

            private void addMembers(MappingNode node, VmListing listing) {
                EconomicMap members = (EconomicMap)listing.getMembers();
                long index = 0L;
                Constructor.this.flattenMapping(node);
                Constructor.this.currPath.push(VmValueConverter.WILDCARD_ELEMENT);
                for (NodeTuple tuple : node.getValue()) {
                    Node keyNode = tuple.getKeyNode();
                    SourceSection sourceSection = Constructor.this.createSourceSection(keyNode.getStartMark(), keyNode.getEndMark());
                    ObjectMember member = new ObjectMember(sourceSection, sourceSection, 2048, null, String.valueOf(index));
                    member.initConstantValue(Constructor.this.converter.convert(Constructor.this.constructObject(keyNode), Constructor.this.currPath));
                    EconomicMaps.put(members, index++, member);
                }
                Constructor.this.currPath.pop();
            }
        }

        public static class ConstructStr
        implements ConstructNode {
            @Override
            public Object construct(Node node) {
                return ((ScalarNode)node).getValue();
            }
        }

        private class ConstructSeq
        implements ConstructNode {
            private ConstructSeq() {
            }

            @Override
            public VmListing construct(Node node) {
                SequenceNode sequenceNode = (SequenceNode)node;
                int size = sequenceNode.getValue().size();
                EconomicMap<Object, ObjectMember> members = EconomicMaps.create(size);
                VmListing result = new VmListing(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getListingClass().getPrototype(), members, size);
                if (!node.isRecursive()) {
                    this.addMembers(sequenceNode, result);
                }
                return result;
            }

            @Override
            public void constructRecursive(Node node, Object data) {
                if (!node.isRecursive()) {
                    throw new YamlEngineException("Unexpected recursive sequence structure. Node: " + node);
                }
                this.addMembers((SequenceNode)node, (VmListing)data);
            }

            private void addMembers(SequenceNode node, VmListing listing) {
                EconomicMap members = (EconomicMap)listing.getMembers();
                long index = 0L;
                Constructor.this.currPath.push(VmValueConverter.WILDCARD_ELEMENT);
                for (Node childNode : node.getValue()) {
                    SourceSection sourceSection = Constructor.this.createSourceSection(childNode.getStartMark(), childNode.getEndMark());
                    ObjectMember member = new ObjectMember(sourceSection, sourceSection, 2048, null, String.valueOf(index));
                    member.initConstantValue(Constructor.this.converter.convert(Constructor.this.constructObject(childNode), Constructor.this.currPath));
                    EconomicMaps.put(members, index++, member);
                }
                Constructor.this.currPath.pop();
            }
        }

        private class ConstructMap
        implements ConstructNode {
            private ConstructMap() {
            }

            @Override
            public VmObject construct(Node node) {
                MappingNode mappingNode = (MappingNode)node;
                int size = mappingNode.getValue().size();
                EconomicMap<Object, ObjectMember> members = EconomicMaps.create(size);
                VmObject result = Constructor.this.useMapping ? new VmMapping(VmUtils.createEmptyMaterializedFrame(), BaseModule.getMappingClass().getPrototype(), members) : new VmDynamic(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getDynamicClass().getPrototype(), members, 0);
                if (!node.isRecursive()) {
                    this.addMembers(mappingNode, result);
                }
                return result;
            }

            @Override
            public void constructRecursive(Node node, Object data) {
                if (!node.isRecursive()) {
                    throw new YamlEngineException("Unexpected recursive sequence structure. Node: " + node);
                }
                this.addMembers((MappingNode)node, (VmObject)data);
            }

            /*
             * Unable to fully structure code
             */
            private void addMembers(MappingNode node, VmObject object) {
                members = (EconomicMap)object.getMembers();
                valuePath = Constructor.this.currPath;
                keyPath = new ArrayDeque<Object>();
                Constructor.access$300(Constructor.this, node);
                for (NodeTuple tuple : node.getValue()) {
                    keyNode = tuple.getKeyNode();
                    valueNode = tuple.getValueNode();
                    sourceSection = Constructor.this.createSourceSection(keyNode.getStartMark(), valueNode.getEndMark());
                    headerSection = Constructor.this.createSourceSection(keyNode.getStartMark(), keyNode.getEndMark());
                    Constructor.this.currPath = keyPath;
                    key = Constructor.access$400(Constructor.this, keyNode);
                    convertedKey = Constructor.this.converter.convert(key, Constructor.this.currPath);
                    Constructor.this.currPath = valuePath;
                    if (!(convertedKey instanceof String)) ** GOTO lbl-1000
                    string = (String)convertedKey;
                    if (!Constructor.this.useMapping) {
                        v0 = Identifier.get(string);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = null;
                    }
                    memberName = v0;
                    member = new ObjectMember(sourceSection, headerSection, memberName == null ? 1024 : 0, memberName, "generated");
                    v1 = Constructor.this.currPath;
                    if (key instanceof String) {
                        string = (String)key;
                        v2 = Identifier.get(string);
                    } else {
                        v2 = VmValueConverter.WILDCARD_PROPERTY;
                    }
                    v1.push(v2);
                    value = Constructor.access$500(Constructor.this, valueNode);
                    convertedValue = Constructor.this.converter.convert(value, Constructor.this.currPath);
                    member.initConstantValue(convertedValue);
                    Constructor.this.currPath.pop();
                    EconomicMaps.put(members, memberName != null ? memberName : convertedKey, member);
                }
            }
        }
    }

    public static abstract class parseAll
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmList eval(VmTyped self, String text) {
            String uri = "input_string";
            return this.doParseAll(self, text, uri);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object eval(VmTyped self, VmTyped resource, @Cached(value="create()") IndirectCallNode callNode) {
            String text = (String)VmUtils.readMember(resource, Identifier.TEXT, callNode);
            String uri = (String)VmUtils.readMember(resource, Identifier.URI, callNode);
            return this.doParseAll(self, text, uri);
        }

        private VmList doParseAll(VmTyped self, String text, String uri) {
            PklConverter converter = ParserNodes.createConverter(self);
            Load load = ParserNodes.createLoad(self, text, uri, converter);
            VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
            try {
                for (Object document : load.loadAllFromString(text)) {
                    builder.add(converter.convert(document, List.of(VmValueConverter.TOP_LEVEL_VALUE)));
                }
            }
            catch (YamlEngineException e2) {
                if (e2.getMessage().startsWith("Number of aliases for non-scalar nodes exceeds the specified")) {
                    throw this.exceptionBuilder().evalError("yamlParseErrorTooManyAliases", ParserNodes.getMaxCollectionAliases(self)).build();
                }
                throw this.exceptionBuilder().evalError("yamlParseError", new Object[0]).withHint(e2.getMessage()).build();
            }
            return builder.build();
        }
    }

    public static abstract class parse
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object eval(VmTyped self, String text) {
            String uri = "input_string";
            return this.doParse(self, text, uri);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object eval(VmTyped self, VmTyped resource, @Cached(value="create()") IndirectCallNode callNode) {
            String text = (String)VmUtils.readMember(resource, Identifier.TEXT, callNode);
            String uri = (String)VmUtils.readMember(resource, Identifier.URI, callNode);
            return this.doParse(self, text, uri);
        }

        private Object doParse(VmTyped self, String text, String uri) {
            PklConverter converter = ParserNodes.createConverter(self);
            Load load = ParserNodes.createLoad(self, text, uri, converter);
            try {
                Object document = load.loadFromString(text);
                return converter.convert(document, List.of());
            }
            catch (YamlEngineException e2) {
                if (e2.getMessage().startsWith("Number of aliases for non-scalar nodes exceeds the specified")) {
                    throw this.exceptionBuilder().evalError("yamlParseErrorTooManyAliases", ParserNodes.getMaxCollectionAliases(self)).build();
                }
                throw this.exceptionBuilder().evalError("yamlParseError", new Object[0]).withHint(e2.getMessage()).build();
            }
        }
    }
}

