/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util;

import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;

@CompilerDirectives.ValueType
public final class Pair<S, T> {
    public final S first;
    public final T second;

    private Pair(S first2, T second2) {
        this.first = first2;
        this.second = second2;
    }

    public static <S, T> Pair<S, T> of(S first2, T second2) {
        return new Pair<S, T>(first2, second2);
    }

    public S getFirst() {
        return this.first;
    }

    public T getSecond() {
        return this.second;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)obj;
        return this.first.equals(other.first) && this.second.equals(other.second);
    }

    public int hashCode() {
        return 31 * this.first.hashCode() + this.second.hashCode();
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "Pair(" + this.first + ", " + this.second + ")";
    }
}

