/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.graalvm.collections;

import java.util.concurrent.atomic.AtomicReference;

public class LockFreePool<T> {
    private final AtomicReference<Node<T>> head = new AtomicReference();

    public T get() {
        Node newHead;
        Node<T> oldHead;
        do {
            if ((oldHead = this.head.get()) != null) continue;
            return null;
        } while (!this.head.compareAndSet(oldHead, newHead = oldHead.tail));
        return (T)oldHead.element;
    }

    public void add(T element) {
        Node<T> newHead;
        Node<T> oldHead;
        while (!this.head.compareAndSet(oldHead = this.head.get(), newHead = new Node<T>(element, oldHead))) {
        }
    }

    private static final class Node<E> {
        final E element;
        final Node<E> tail;

        private Node(E element, Node<E> tail) {
            this.element = element;
            this.tail = tail;
        }
    }
}

