/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.paguro.collections;

import java.util.Map;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.paguro.collections.BaseMap;
import org.pkl.thirdparty.paguro.collections.ImSortedSet;
import org.pkl.thirdparty.paguro.collections.PersistentTreeSet;
import org.pkl.thirdparty.paguro.collections.UnmodMap;
import org.pkl.thirdparty.paguro.collections.UnmodSortedIterator;
import org.pkl.thirdparty.paguro.collections.UnmodSortedMap;
import org.pkl.thirdparty.paguro.oneOf.Option;

public interface ImSortedMap<K, V>
extends UnmodSortedMap<K, V>,
BaseMap<K, V> {
    @Override
    @NotNull
    public Option<UnmodMap.UnEntry<K, V>> entry(K var1);

    @Override
    default public boolean containsKey(Object key2) {
        return this.entry(key2).isSome();
    }

    @Override
    @NotNull
    public ImSortedSet<Map.Entry<K, V>> entrySet();

    @Override
    default public V get(Object key2) {
        Option<UnmodMap.UnEntry<Object, V>> entry = this.entry(key2);
        return entry.isSome() ? (V)entry.get().getValue() : null;
    }

    @Override
    default public V getOrElse(K key2, V notFound) {
        Option<UnmodMap.UnEntry<K, V>> entry = this.entry(key2);
        return entry.isSome() ? entry.get().getValue() : notFound;
    }

    @Override
    @NotNull
    default public ImSortedMap<K, V> headMap(K toKey) {
        return this.subMap(this.firstKey(), (Object)toKey);
    }

    @Override
    @NotNull
    public UnmodSortedIterator<UnmodMap.UnEntry<K, V>> iterator();

    @Override
    @NotNull
    default public ImSortedSet<K> keySet() {
        return PersistentTreeSet.ofMap(this);
    }

    @Override
    @NotNull
    public ImSortedMap<K, V> subMap(K var1, K var2);

    @Override
    @NotNull
    public ImSortedMap<K, V> tailMap(K var1);

    @Override
    @NotNull
    public ImSortedMap<K, V> assoc(K var1, V var2);

    @Override
    @NotNull
    default public ImSortedMap<K, V> assoc(@NotNull Map.Entry<K, V> entry) {
        return this.assoc((Object)entry.getKey(), (Object)entry.getValue());
    }

    @Override
    @NotNull
    public ImSortedMap<K, V> without(K var1);
}

