/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.paguro.collections;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.paguro.collections.AbstractUnmodSet;
import org.pkl.thirdparty.paguro.collections.Equator;
import org.pkl.thirdparty.paguro.collections.ImSortedMap;
import org.pkl.thirdparty.paguro.collections.ImSortedSet;
import org.pkl.thirdparty.paguro.collections.PersistentTreeMap;
import org.pkl.thirdparty.paguro.collections.UnmodMap;
import org.pkl.thirdparty.paguro.collections.UnmodSortedIterable;
import org.pkl.thirdparty.paguro.collections.UnmodSortedIterator;
import org.pkl.thirdparty.paguro.oneOf.Option;

public class PersistentTreeSet<E>
extends AbstractUnmodSet<E>
implements ImSortedSet<E>,
Serializable {
    public static final PersistentTreeSet EMPTY = new PersistentTreeSet(PersistentTreeMap.EMPTY);
    private final transient ImSortedMap<E, ?> impl;
    private static final long serialVersionUID = 20160904120000L;

    public static <T extends Comparable<T>> PersistentTreeSet<T> empty() {
        return EMPTY;
    }

    public static <T> PersistentTreeSet<T> ofComp(Comparator<? super T> comp) {
        return new PersistentTreeSet<T>(PersistentTreeMap.empty(comp));
    }

    public static <T> PersistentTreeSet<T> ofComp(Comparator<? super T> comp, Iterable<T> elements) {
        ImSortedSet<Object> ret = new PersistentTreeSet<T>(PersistentTreeMap.empty(comp));
        if (elements == null) {
            return ret;
        }
        for (T element : elements) {
            ret = ret.put((Object)element);
        }
        return ret;
    }

    public static <T extends Comparable<T>> PersistentTreeSet<T> of(Iterable<T> items) {
        if (items == null) {
            return PersistentTreeSet.empty();
        }
        ImSortedSet<Object> ret = PersistentTreeSet.empty();
        for (Comparable item : items) {
            ret = ret.put((Object)item);
        }
        return ret;
    }

    public static <T> PersistentTreeSet<T> ofMap(ImSortedMap<T, ?> i) {
        return new PersistentTreeSet<T>(i);
    }

    private PersistentTreeSet(ImSortedMap<E, ?> i) {
        this.impl = i;
    }

    private Object writeReplace() {
        return new SerializationProxy<E>(this.impl);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("Proxy required");
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.impl.comparator();
    }

    @Override
    public boolean contains(Object o) {
        return this.impl.containsKey(o);
    }

    @Override
    @NotNull
    public PersistentTreeSet<E> without(E key2) {
        return this.impl.containsKey(key2) ? new PersistentTreeSet<E>(this.impl.without((Object)key2)) : this;
    }

    @Override
    @NotNull
    public UnmodSortedIterator<E> iterator() {
        return new UnmodSortedIterator<E>(){
            UnmodSortedIterator<? extends UnmodMap.UnEntry<E, ?>> iter;
            {
                this.iter = PersistentTreeSet.this.impl.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public E next() {
                UnmodMap.UnEntry e2 = (UnmodMap.UnEntry)this.iter.next();
                return e2 == null ? null : (Object)e2.getKey();
            }
        };
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SortedSet)) {
            return false;
        }
        SortedSet that = (SortedSet)other;
        if (this.size() != that.size()) {
            return false;
        }
        return UnmodSortedIterable.equal(this, UnmodSortedIterable.castFromSortedSet(that));
    }

    @Override
    public E first() {
        return (E)this.impl.firstKey();
    }

    @Override
    @NotNull
    public Option<E> head() {
        return this.size() > 0 ? Option.some(this.impl.firstKey()) : Option.none();
    }

    @Override
    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    @Override
    public E last() {
        return (E)this.impl.lastKey();
    }

    @Override
    @NotNull
    public PersistentTreeSet<E> put(E e2) {
        return this.impl.containsKey(e2) ? this : new PersistentTreeSet<E>(this.impl.assoc((Object)e2, (Object)null));
    }

    @Override
    public int size() {
        return this.impl.size();
    }

    @Override
    @NotNull
    public ImSortedSet<E> subSet(E fromElement, E toElement) {
        return PersistentTreeSet.ofMap(this.impl.subMap((Object)fromElement, (Object)toElement));
    }

    @Override
    @NotNull
    public ImSortedSet<E> tailSet(E fromElement) {
        return PersistentTreeSet.ofMap(this.impl.tailMap((Object)fromElement));
    }

    private static class SerializationProxy<K>
    implements Serializable {
        private static final long serialVersionUID = 20160904120000L;
        private Comparator<? super K> comparator;
        private final int size;
        private transient ImSortedMap<K, ?> theMap;

        SerializationProxy(ImSortedMap<K, ?> phm) {
            Comparator wc;
            this.comparator = phm.comparator();
            if (this.comparator != null && !(this.comparator instanceof Serializable)) {
                throw new IllegalStateException("Comparator must implement serializable.  Instead it was " + this.comparator);
            }
            if (this.comparator instanceof PersistentTreeMap.KeyComparator && !((wc = ((PersistentTreeMap.KeyComparator)this.comparator).unwrap()) instanceof Serializable)) {
                throw new IllegalStateException("Wrapped key comparator must implementserializable.  Instead it was " + wc);
            }
            this.size = phm.size();
            this.theMap = phm;
        }

        private void writeObject(ObjectOutputStream s2) throws IOException {
            s2.defaultWriteObject();
            for (Map.Entry entry : this.theMap) {
                s2.writeObject(entry.getKey());
            }
        }

        private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
            s2.defaultReadObject();
            if (this.comparator == null) {
                this.comparator = Equator.defaultComparator();
            }
            this.theMap = PersistentTreeMap.ofComp(this.comparator, null);
            for (int i = 0; i < this.size; ++i) {
                this.theMap = this.theMap.assoc(s2.readObject(), (Object)null);
            }
        }

        private Object readResolve() {
            return new PersistentTreeSet<K>(this.theMap);
        }
    }
}

