/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.paguro.collections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.paguro.collections.Equator;
import org.pkl.thirdparty.paguro.collections.UnmodIterable;
import org.pkl.thirdparty.paguro.collections.UnmodIterator;
import org.pkl.thirdparty.paguro.collections.UnmodMap;
import org.pkl.thirdparty.paguro.collections.UnmodSet;
import org.pkl.thirdparty.paguro.collections.UnmodSortedCollection;
import org.pkl.thirdparty.paguro.collections.UnmodSortedIterable;
import org.pkl.thirdparty.paguro.collections.UnmodSortedIterator;
import org.pkl.thirdparty.paguro.collections.UnmodSortedSet;
import org.pkl.thirdparty.paguro.tuple.Tuple2;

public interface UnmodSortedMap<K, V>
extends UnmodMap<K, V>,
SortedMap<K, V>,
UnmodSortedIterable<UnmodMap.UnEntry<K, V>> {
    @Override
    @NotNull
    default public UnmodSortedSet<Map.Entry<K, V>> entrySet() {
        class Implementation
        implements UnmodSortedSet<Map.Entry<K, V>>,
        Serializable {
            private static final long serialVersionUID = 20160901201600L;
            private final UnmodSortedMap<K, V> parentMap;

            private Implementation(UnmodSortedMap<K, V> pm) {
                this.parentMap = pm;
            }

            @Override
            public int size() {
                return this.parentMap.size();
            }

            @Override
            public boolean contains(Object o) {
                return o instanceof Map.Entry && UnmodSortedMap.this.containsKey(((Map.Entry)o).getKey());
            }

            @Override
            @NotNull
            public UnmodSortedIterator<Map.Entry<K, V>> iterator() {
                return this.parentMap.iterator();
            }

            @Override
            public Comparator<Map.Entry<K, V>> comparator() {
                if (this.parentMap.comparator() == null) {
                    return (a, b2) -> Equator.Comp.DEFAULT.compare((Comparable)a.getKey(), (Comparable)b2.getKey());
                }
                return (o1, o2) -> this.parentMap.comparator().compare(o1.getKey(), o2.getKey());
            }

            @Override
            @NotNull
            public UnmodSortedSet<Map.Entry<K, V>> subSet(Map.Entry<K, V> fromElement, Map.Entry<K, V> toElement) {
                return this.parentMap.subMap(fromElement.getKey(), toElement.getKey()).entrySet();
            }

            @Override
            @NotNull
            public UnmodSortedSet<Map.Entry<K, V>> tailSet(Map.Entry<K, V> fromElement) {
                return this.parentMap.tailMap(fromElement.getKey()).entrySet();
            }

            @Override
            public Map.Entry<K, V> first() {
                Object key2 = this.parentMap.firstKey();
                return Tuple2.of(key2, this.parentMap.get(key2));
            }

            @Override
            public Map.Entry<K, V> last() {
                Object key2 = this.parentMap.lastKey();
                return Tuple2.of(key2, this.parentMap.get(key2));
            }

            @Override
            public int hashCode() {
                return UnmodIterable.hash(this);
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Set)) {
                    return false;
                }
                if (o instanceof UnmodSet && !(o instanceof UnmodSortedSet)) {
                    return false;
                }
                Set that = (Set)o;
                if (that.size() != this.size()) {
                    return false;
                }
                return this.containsAll(that);
            }

            public String toString() {
                return UnmodIterable.toString("UnmodSortedMap.entrySet", this);
            }
        }
        return new Implementation(this);
    }

    @Override
    @NotNull
    default public UnmodSortedMap<K, V> headMap(K toKey) {
        return this.subMap(this.firstKey(), (Object)toKey);
    }

    @Override
    @NotNull
    default public UnmodSortedIterator<K> keyIterator() {
        return new UnmodMap.UnEntry.UnmodSortedKeyIter(this.iterator());
    }

    @Override
    @NotNull
    default public UnmodSortedIterator<V> valIterator() {
        return new UnmodMap.UnEntry.UnmodSortedValIter(this.iterator());
    }

    @Override
    @NotNull
    default public UnmodSortedSet<K> keySet() {
        class KeySet
        implements UnmodSortedSet<K>,
        Serializable {
            private static final long serialVersionUID = 20160903174100L;
            private final UnmodSortedMap<K, V> parentMap;

            private KeySet(UnmodSortedMap<K, V> m) {
                this.parentMap = m;
            }

            @Override
            public boolean contains(Object o) {
                return this.parentMap.containsKey(o);
            }

            @Override
            @NotNull
            public UnmodSortedIterator<K> iterator() {
                return this.parentMap.keyIterator();
            }

            @Override
            public int size() {
                return this.parentMap.size();
            }

            @Override
            @NotNull
            public UnmodSortedSet<K> subSet(K fromElement, K toElement) {
                return this.parentMap.subMap(fromElement, toElement).keySet();
            }

            @Override
            @NotNull
            public UnmodSortedSet<K> tailSet(K fromElement) {
                return this.parentMap.tailMap(fromElement).keySet();
            }

            @Override
            public Comparator<? super K> comparator() {
                return this.parentMap.comparator() == null ? Equator.defaultComparator() : this.parentMap.comparator();
            }

            @Override
            public K first() {
                return this.parentMap.firstKey();
            }

            @Override
            public K last() {
                return this.parentMap.lastKey();
            }

            @Override
            public int hashCode() {
                return UnmodIterable.hash(this);
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Set)) {
                    return false;
                }
                if (o instanceof UnmodSet && !(o instanceof UnmodSortedSet)) {
                    return false;
                }
                Set that = (Set)o;
                if (that.size() != this.size()) {
                    return false;
                }
                UnmodIterator as = this.iterator();
                Iterator bs = that.iterator();
                Comparator comp = this.comparator();
                assert (comp != null);
                while (as.hasNext() && bs.hasNext()) {
                    Object b2;
                    Object a = as.next();
                    if (comp.compare(a, b2 = bs.next()) == 0) continue;
                    return false;
                }
                return !as.hasNext() && !bs.hasNext();
            }

            public String toString() {
                return UnmodIterable.toString("UnmodSortedMap.entrySet", this);
            }
        }
        return new KeySet(this);
    }

    @Override
    @NotNull
    public UnmodSortedMap<K, V> subMap(K var1, K var2);

    @Override
    @NotNull
    public UnmodSortedMap<K, V> tailMap(K var1);

    @Override
    @NotNull
    default public UnmodSortedCollection<V> values() {
        class Impl
        implements UnmodSortedCollection<V>,
        Serializable {
            private static final long serialVersionUID = 20160903104400L;
            private final UnmodSortedMap<K, V> parent;

            private Impl(UnmodSortedMap<K, V> p) {
                this.parent = p;
            }

            @Override
            public boolean contains(Object o) {
                return this.parent.containsValue(o);
            }

            @Override
            @NotNull
            public UnmodSortedIterator<V> iterator() {
                return this.parent.valIterator();
            }

            @Override
            public int size() {
                return this.parent.size();
            }

            @Override
            public int hashCode() {
                return UnmodIterable.hash(this);
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                return o instanceof UnmodSortedCollection && UnmodSortedIterable.equal(this, (UnmodSortedCollection)o);
            }

            public String toString() {
                return UnmodIterable.toString("UnmodSortedMap.values", this);
            }
        }
        return new Impl(this);
    }
}

