/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.interop;

import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.interop.InteropLibrary;
import org.pkl.thirdparty.truffle.api.interop.InvalidArrayIndexException;
import org.pkl.thirdparty.truffle.api.interop.StopIterationException;
import org.pkl.thirdparty.truffle.api.interop.TruffleObject;
import org.pkl.thirdparty.truffle.api.interop.UnsupportedMessageException;
import org.pkl.thirdparty.truffle.api.library.CachedLibrary;
import org.pkl.thirdparty.truffle.api.library.ExportLibrary;
import org.pkl.thirdparty.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class)
final class HashIterator
implements TruffleObject {
    final Object entriesIterator;
    private final long index;

    private HashIterator(Object entriesIterator, long index) {
        assert (InteropLibrary.getUncached().isIterator(entriesIterator)) : "EntriesIterator must be an iterator.";
        assert (index >= 0L && index < 2L);
        this.entriesIterator = entriesIterator;
        this.index = index;
    }

    @ExportMessage
    boolean isIterator() {
        return true;
    }

    @ExportMessage
    boolean hasIteratorNextElement(@CachedLibrary(value="this.entriesIterator") InteropLibrary iterators) {
        try {
            return iterators.hasIteratorNextElement(this.entriesIterator);
        }
        catch (UnsupportedMessageException ume) {
            throw CompilerDirectives.shouldNotReachHere(ume);
        }
    }

    @ExportMessage
    Object getIteratorNextElement(@CachedLibrary(value="this.entriesIterator") InteropLibrary iterators, @CachedLibrary(limit="1") InteropLibrary arrays) throws UnsupportedMessageException, StopIterationException {
        try {
            Object entry = iterators.getIteratorNextElement(this.entriesIterator);
            return arrays.readArrayElement(entry, this.index);
        }
        catch (InvalidArrayIndexException e2) {
            throw CompilerDirectives.shouldNotReachHere("Hash entry must have two array elements.", e2);
        }
    }

    static HashIterator keys(Object entriesIterator) {
        return new HashIterator(entriesIterator, 0L);
    }

    static HashIterator values(Object entriesIterator) {
        return new HashIterator(entriesIterator, 1L);
    }
}

