/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.interop;

import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.interop.InteropException;
import org.pkl.thirdparty.truffle.api.interop.InteropLibrary;
import org.pkl.thirdparty.truffle.api.interop.UnsupportedMessageException;

public final class UnknownKeyException
extends InteropException {
    private static final long serialVersionUID = 1857745390734085182L;
    private final Object unknownKey;

    private UnknownKeyException(Object unknownKey) {
        super((String)null);
        this.unknownKey = unknownKey;
    }

    private UnknownKeyException(Object unknownKey, Throwable cause) {
        super(null, cause);
        this.unknownKey = unknownKey;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String getMessage() {
        InteropLibrary interop = InteropLibrary.getUncached();
        try {
            return "Unknown identifier: " + interop.asString(interop.toDisplayString(this.unknownKey, false));
        }
        catch (UnsupportedMessageException e2) {
            throw CompilerDirectives.shouldNotReachHere(e2);
        }
    }

    public Object getUnknownKey() {
        return this.unknownKey;
    }

    public static UnknownKeyException create(Object unknownKey) {
        return new UnknownKeyException(unknownKey);
    }

    public static UnknownKeyException create(Object unknownKey, Throwable cause) {
        return new UnknownKeyException(unknownKey, cause);
    }
}

