/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.profiles;

import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.HostCompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.InlineSupport;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.profiles.ConditionProfile;
import org.pkl.thirdparty.truffle.api.profiles.InlinedProfile;
import org.pkl.thirdparty.truffle.api.profiles.Profile;

public final class InlinedCountingConditionProfile
extends InlinedProfile {
    private static final InlinedCountingConditionProfile DISABLED;
    private final InlineSupport.IntField trueCount;
    private final InlineSupport.IntField falseCount;
    static final int MAX_VALUE = 0x3FFFFFFF;

    private InlinedCountingConditionProfile() {
        this.trueCount = null;
        this.falseCount = null;
    }

    private InlinedCountingConditionProfile(InlineSupport.InlineTarget target) {
        this.trueCount = target.getPrimitive(0, InlineSupport.IntField.class);
        this.falseCount = target.getPrimitive(1, InlineSupport.IntField.class);
    }

    public boolean profile(Node node, boolean value2) {
        if (this.trueCount == null) {
            return value2;
        }
        int t = this.trueCount.get(node);
        int f = this.falseCount.get(node);
        boolean val = value2;
        if (val) {
            if (t == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            if (f == 0) {
                val = true;
            }
            if (HostCompilerDirectives.inInterpreterFastPath() && t < 0x3FFFFFFF) {
                this.trueCount.set(node, t + 1);
            }
        } else {
            if (f == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            if (t == 0) {
                val = false;
            }
            if (HostCompilerDirectives.inInterpreterFastPath() && f < 0x3FFFFFFF) {
                this.falseCount.set(node, f + 1);
            }
        }
        if (CompilerDirectives.inInterpreter()) {
            return val;
        }
        int sum = t + f;
        return CompilerDirectives.injectBranchProbability((double)t / (double)sum, val);
    }

    public boolean wasTrue(Node node) {
        return this.getTrueCount(node) != 0;
    }

    public boolean wasFalse(Node node) {
        return this.getFalseCount(node) != 0;
    }

    @Override
    public void disable(Node node) {
        if (this.trueCount == null) {
            return;
        }
        if (this.trueCount.get(node) == 0) {
            this.trueCount.set(node, 1);
        }
        if (this.falseCount.get(node) == 0) {
            this.falseCount.set(node, 1);
        }
    }

    @Override
    public void reset(Node node) {
        if (this.trueCount == null) {
            return;
        }
        this.trueCount.set(node, 0);
        this.falseCount.set(node, 0);
    }

    int getTrueCount(Node node) {
        if (this.trueCount == null) {
            return Integer.MAX_VALUE;
        }
        return this.trueCount.get(node);
    }

    int getFalseCount(Node node) {
        if (this.trueCount == null) {
            return Integer.MAX_VALUE;
        }
        return this.falseCount.get(node);
    }

    boolean isGeneric(Node node) {
        if (this.trueCount == null) {
            return true;
        }
        return this.getTrueCount(node) != 0 && this.getFalseCount(node) != 0;
    }

    boolean isUninitialized(Node node) {
        if (this.trueCount == null) {
            return false;
        }
        return this.getTrueCount(node) == 0 && this.getFalseCount(node) == 0;
    }

    @Override
    public String toString(Node node) {
        if (this.trueCount == null) {
            return this.toStringDisabled();
        }
        int t = this.trueCount.get(node);
        int f = this.falseCount.get(node);
        int sum = t + f;
        String details = String.format("trueProbability=%s (trueCount=%s, falseCount=%s)", (double)t / (double)sum, t, f);
        return this.toString(ConditionProfile.class, sum == 0, false, details);
    }

    public static InlinedCountingConditionProfile inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(value=InlineSupport.IntField.class), @InlineSupport.RequiredField(value=InlineSupport.IntField.class)}) InlineSupport.InlineTarget target) {
        if (Profile.isProfilingEnabled()) {
            return new InlinedCountingConditionProfile(target);
        }
        return InlinedCountingConditionProfile.getUncached();
    }

    public static InlinedCountingConditionProfile getUncached() {
        return DISABLED;
    }

    static {
        InlinedCountingConditionProfile profile;
        DISABLED = profile = new InlinedCountingConditionProfile();
    }
}

