/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.profiles;

import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.InlineSupport;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.profiles.AbstractInlinedValueProfile;
import org.pkl.thirdparty.truffle.api.profiles.DoubleValueProfile;
import org.pkl.thirdparty.truffle.api.profiles.Profile;

public final class InlinedDoubleValueProfile
extends AbstractInlinedValueProfile {
    private static final InlinedDoubleValueProfile DISABLED;
    private final InlineSupport.LongField cachedValue0;

    private InlinedDoubleValueProfile() {
        this.cachedValue0 = null;
    }

    private InlinedDoubleValueProfile(InlineSupport.InlineTarget target) {
        super(target);
        this.cachedValue0 = target.getPrimitive(1, InlineSupport.LongField.class);
    }

    public double profile(Node node, double value2) {
        int localState;
        if (this.state != null && (localState = this.state.get(node)) != 2) {
            long v;
            if (localState == 1 && (v = this.cachedValue0.get(node)) == Double.doubleToRawLongBits(value2)) {
                if (CompilerDirectives.inCompiledCode()) {
                    return Double.longBitsToDouble(v);
                }
                return value2;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            if (localState == 0) {
                this.cachedValue0.set(node, Double.doubleToRawLongBits(value2));
                this.state.set(node, 1);
            } else {
                this.state.set(node, 2);
            }
        }
        return value2;
    }

    double getCachedValue(Node node) {
        return Double.longBitsToDouble(this.cachedValue0.get(node));
    }

    @Override
    public String toString(Node node) {
        if (this.state == null) {
            return this.toStringDisabled();
        }
        return this.toString(DoubleValueProfile.class, this.isUninitialized(node), this.isGeneric(node), String.format("value == (double)%s (raw %h)", this.getCachedValue(node), Double.doubleToRawLongBits(this.getCachedValue(node))));
    }

    public static InlinedDoubleValueProfile inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(value=InlineSupport.StateField.class, bits=2), @InlineSupport.RequiredField(value=InlineSupport.LongField.class)}) InlineSupport.InlineTarget target) {
        if (Profile.isProfilingEnabled()) {
            return new InlinedDoubleValueProfile(target);
        }
        return InlinedDoubleValueProfile.getUncached();
    }

    public static InlinedDoubleValueProfile getUncached() {
        return DISABLED;
    }

    static {
        InlinedDoubleValueProfile profile;
        DISABLED = profile = new InlinedDoubleValueProfile();
    }
}

