/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.profiles;

import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.InlineSupport;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.profiles.AbstractInlinedValueProfile;
import org.pkl.thirdparty.truffle.api.profiles.IntValueProfile;
import org.pkl.thirdparty.truffle.api.profiles.Profile;

public final class InlinedIntValueProfile
extends AbstractInlinedValueProfile {
    private static final InlinedIntValueProfile DISABLED;
    private final InlineSupport.IntField cachedValue;

    private InlinedIntValueProfile() {
        this.cachedValue = null;
    }

    private InlinedIntValueProfile(InlineSupport.InlineTarget target) {
        super(target);
        this.cachedValue = target.getPrimitive(1, InlineSupport.IntField.class);
    }

    public int profile(Node node, int value2) {
        int localState;
        if (this.state != null && (localState = this.state.get(node)) != 2) {
            int v;
            if (localState == 1 && (v = this.cachedValue.get(node)) == value2) {
                return v;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            if (localState == 0) {
                this.cachedValue.set(node, value2);
                this.state.set(node, 1);
            } else {
                this.state.set(node, 2);
            }
        }
        return value2;
    }

    int getCachedValue(Node node) {
        if (this.state == null) {
            return 0;
        }
        return this.cachedValue.get(node);
    }

    @Override
    public String toString(Node node) {
        if (this.state == null) {
            return this.toStringDisabled();
        }
        return this.toString(IntValueProfile.class, this.isUninitialized(node), this.isGeneric(node), String.format("value == (int)%s", this.cachedValue));
    }

    public static InlinedIntValueProfile inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(value=InlineSupport.StateField.class, bits=2), @InlineSupport.RequiredField(value=InlineSupport.IntField.class)}) InlineSupport.InlineTarget target) {
        if (Profile.isProfilingEnabled()) {
            return new InlinedIntValueProfile(target);
        }
        return InlinedIntValueProfile.getUncached();
    }

    public static InlinedIntValueProfile getUncached() {
        return DISABLED;
    }

    static {
        InlinedIntValueProfile profile;
        DISABLED = profile = new InlinedIntValueProfile();
    }
}

