/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.profiles;

import org.pkl.thirdparty.truffle.api.dsl.InlineSupport;
import org.pkl.thirdparty.truffle.api.nodes.Node;

public abstract class InlinedProfile {
    InlinedProfile() {
    }

    public abstract void disable(Node var1);

    public abstract void reset(Node var1);

    public abstract String toString(Node var1);

    public final String toString() {
        return String.format("%s(INLINED)", this.getClass().getSimpleName());
    }

    static int getStateInt(InlineSupport.StateField field, Node node) {
        return field.get(node);
    }

    static byte getStateByte(InlineSupport.StateField field, Node node) {
        return (byte)(field.get(node) & 0xFF);
    }

    static void setStateByte(InlineSupport.StateField field, Node node, byte b2) {
        field.set(node, b2 & 0xFF);
    }

    static float getStateFloat(InlineSupport.StateField field, Node node) {
        return Float.intBitsToFloat(field.get(node));
    }

    static void setStateFloat(InlineSupport.StateField field, Node node, float f) {
        field.set(node, Float.floatToRawIntBits(f));
    }

    static boolean getStateBoolean(InlineSupport.StateField field, Node node) {
        return field.get(node) == 1;
    }

    static void setStateInt(InlineSupport.StateField field, Node node, int value2) {
        field.set(node, value2);
    }

    static void setStateBoolean(InlineSupport.StateField field, Node node, boolean value2) {
        field.set(node, value2 ? 1 : 0);
    }

    final String toStringDisabled() {
        return String.format("%s(DISABLED)", this.getClass().getSimpleName());
    }

    final String toString(Class<?> profileClass, boolean uninitialized, boolean generic, String specialization) {
        String s2 = uninitialized ? "UNINITIALIZED" : (generic ? "GENERIC" : (specialization == null ? "" : specialization));
        return String.format("%s(%s)@%s", profileClass.getSimpleName(), s2, Integer.toHexString(this.hashCode()));
    }
}

