/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.staticobject;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import org.pkl.thirdparty.truffle.api.impl.asm.ClassVisitor;
import org.pkl.thirdparty.truffle.api.impl.asm.ClassWriter;
import org.pkl.thirdparty.truffle.api.impl.asm.MethodVisitor;
import org.pkl.thirdparty.truffle.api.impl.asm.Type;
import org.pkl.thirdparty.truffle.api.staticobject.FieldBasedStaticShape;
import org.pkl.thirdparty.truffle.api.staticobject.GeneratorClassLoaders;
import org.pkl.thirdparty.truffle.api.staticobject.ShapeGenerator;
import org.pkl.thirdparty.truffle.api.staticobject.StaticProperty;
import org.pkl.thirdparty.truffle.api.staticobject.StaticShape;

final class FieldBasedShapeGenerator<T>
extends ShapeGenerator<T> {
    private final GeneratorClassLoaders gcls;
    private final Class<?> storageSuperClass;
    private final Class<T> storageFactoryInterface;

    private FieldBasedShapeGenerator(GeneratorClassLoaders gcls, Class<?> storageSuperClass, Class<T> storageFactoryInterface) {
        this.gcls = gcls;
        this.storageSuperClass = storageSuperClass;
        this.storageFactoryInterface = storageFactoryInterface;
    }

    static <T> FieldBasedShapeGenerator<T> getShapeGenerator(GeneratorClassLoaders gcls, Class<?> storageSuperClass, Class<T> storageFactoryInterface) {
        return new FieldBasedShapeGenerator<T>(gcls, storageSuperClass, storageFactoryInterface);
    }

    @Override
    StaticShape<T> generateShape(StaticShape<T> parentShape, Map<String, StaticProperty> staticProperties, boolean safetyChecks, String storageClassName) {
        Class<?> generatedStorageClass = FieldBasedShapeGenerator.generateStorage(this.gcls, this.storageSuperClass, staticProperties, storageClassName);
        Class<T> generatedFactoryClass = FieldBasedShapeGenerator.generateFactory(this.gcls, generatedStorageClass, this.storageFactoryInterface);
        for (Map.Entry<String, StaticProperty> entry : staticProperties.entrySet()) {
            int offset = FieldBasedShapeGenerator.getObjectFieldOffset(generatedStorageClass, entry.getKey());
            entry.getValue().initOffset(offset);
        }
        return FieldBasedStaticShape.create(generatedStorageClass, generatedFactoryClass, safetyChecks);
    }

    private static int getObjectFieldOffset(Class<?> c, String fieldName) {
        try {
            return Math.toIntExact(UNSAFE.objectFieldOffset(c.getField(fieldName)));
        }
        catch (NoSuchFieldException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static String getStorageConstructorDescriptor(Constructor<?> superConstructor) {
        return Type.getConstructorDescriptor(superConstructor);
    }

    private static void addStorageConstructors(ClassVisitor cv, Class<?> storageSuperClass, String storageSuperName) {
        for (Constructor<?> superConstructor : storageSuperClass.getDeclaredConstructors()) {
            String storageConstructorDescriptor;
            String superConstructorDescriptor = storageConstructorDescriptor = FieldBasedShapeGenerator.getStorageConstructorDescriptor(superConstructor);
            MethodVisitor mv = cv.visitMethod(1, "<init>", storageConstructorDescriptor, null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            int var = 1;
            for (Class<?> constructorParameter : superConstructor.getParameterTypes()) {
                Type parameterType = Type.getType(constructorParameter);
                int loadOpcode = parameterType.getOpcode(21);
                mv.visitVarInsn(loadOpcode, var);
                var += parameterType.getSize();
            }
            mv.visitMethodInsn(183, storageSuperName, "<init>", superConstructorDescriptor, false);
            mv.visitInsn(177);
            mv.visitMaxs(var + 1, var);
            mv.visitEnd();
        }
    }

    private static void addFactoryConstructor(ClassVisitor cv) {
        MethodVisitor mv = cv.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void addFactoryMethods(ClassVisitor cv, Class<?> storageClass, Class<?> storageFactoryInterface) {
        for (Method m : storageFactoryInterface.getMethods()) {
            Class<?>[] params;
            MethodVisitor mv = cv.visitMethod(17, m.getName(), Type.getMethodDescriptor(m), null, null);
            mv.visitCode();
            mv.visitTypeInsn(187, Type.getInternalName(storageClass));
            mv.visitInsn(89);
            int maxStack = 2;
            int maxLocals = 1;
            StringBuilder constructorDescriptor = new StringBuilder();
            constructorDescriptor.append('(');
            for (Class<?> param : params = m.getParameterTypes()) {
                Type paramType = Type.getType(param);
                int loadOpcode = paramType.getOpcode(21);
                mv.visitVarInsn(loadOpcode, maxLocals);
                constructorDescriptor.append(Type.getDescriptor(param));
                maxStack += paramType.getSize();
                maxLocals += paramType.getSize();
            }
            constructorDescriptor.append(")V");
            String storageName = Type.getInternalName(storageClass);
            mv.visitMethodInsn(183, storageName, "<init>", constructorDescriptor.toString(), false);
            mv.visitInsn(176);
            mv.visitMaxs(maxStack, maxLocals);
            mv.visitEnd();
        }
    }

    private static Class<?> generateStorage(GeneratorClassLoaders gcls, Class<?> storageSuperClass, Map<String, StaticProperty> staticProperties, String storageClassName) {
        String storageSuperName = Type.getInternalName(storageSuperClass);
        ClassWriter storageWriter = new ClassWriter(0);
        int storageAccess = 4129;
        storageWriter.visit(52, storageAccess, storageClassName, null, storageSuperName, null);
        FieldBasedShapeGenerator.addStorageConstructors(storageWriter, storageSuperClass, storageSuperName);
        FieldBasedShapeGenerator.addStorageFields(storageWriter, staticProperties);
        storageWriter.visitEnd();
        return FieldBasedShapeGenerator.load(gcls, storageClassName, storageWriter.toByteArray(), true);
    }

    private static <T> Class<? extends T> generateFactory(GeneratorClassLoaders gcls, Class<?> storageClass, Class<T> storageFactoryInterface) {
        ClassWriter factoryWriter = new ClassWriter(0);
        int factoryAccess = 4145;
        String factoryName = FieldBasedShapeGenerator.generateFactoryName(storageClass);
        factoryWriter.visit(52, factoryAccess, factoryName, null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(storageFactoryInterface)});
        FieldBasedShapeGenerator.addFactoryConstructor(factoryWriter);
        FieldBasedShapeGenerator.addFactoryMethods(factoryWriter, storageClass, storageFactoryInterface);
        factoryWriter.visitEnd();
        return FieldBasedShapeGenerator.load(gcls, factoryName, factoryWriter.toByteArray(), false);
    }
}

