//===----------------------------------------------------------------------===//
// Copyright © 2024-2025 Apple Inc. and the Pkl project authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//===----------------------------------------------------------------------===//

/// Information about the Pkl release that the current program runs on.
@ModuleInfo { minPklVersion = "0.27.2" }
module pkl.release

import "pkl:semver"

/// The Pkl release that the current program runs on.
external current: Release

/// A Pkl release.
class Release {
  /// The version of this release.
  version: semver.Version

  /// The output of `pkl --version` for this release.
  versionInfo: String

  /// The Git commit ID of this release.
  commitId: String

  /// The source code of this release.
  sourceCode: SourceCode

  /// The documentation of this release.
  documentation: Documentation

  /// The standard library of this release.
  standardLibrary: StandardLibrary
}

/// The source code of a Pkl release.
class SourceCode {
  /// The homepage of this source code.
  homepage: Uri(endsWith("/"))
}

/// The documentation of a Pkl release.
class Documentation {
  /// The homepage of this documentation.
  homepage: Uri(endsWith("/"))
}

/// The standard library of a Pkl release.
class StandardLibrary {
  /// The module URIs of this standard library.
  modules: Set<Uri(startsWith("pkl:"))>
}
