/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.api.io;

import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.platanios.tensorflow.api.core.package$exception$;
import org.platanios.tensorflow.api.io.FileIO;
import org.platanios.tensorflow.api.io.FileIO$READ$;
import org.platanios.tensorflow.api.io.FileIO$WRITE$;
import org.platanios.tensorflow.jni.FileStatistics;
import org.platanios.tensorflow.jni.FileStatistics$;
import org.platanios.tensorflow.jni.NotFoundException;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class FileIO$
implements scala.Serializable {
    public static FileIO$ MODULE$;
    private final FileStatistics$ FileStatistics;

    static {
        new FileIO$();
    }

    public long $lessinit$greater$default$3() {
        return 524288L;
    }

    public FileStatistics$ FileStatistics() {
        return this.FileStatistics;
    }

    public boolean exists(Path filePath) {
        boolean bl;
        try {
            org.platanios.tensorflow.jni.FileIO$.MODULE$.fileExists(((Object)filePath.toAbsolutePath()).toString());
            bl = true;
        }
        catch (NotFoundException notFoundException) {
            bl = false;
        }
        return bl;
    }

    public void deleteFile(Path filePath) {
        org.platanios.tensorflow.jni.FileIO$.MODULE$.deleteFile(((Object)filePath.toAbsolutePath()).toString());
    }

    public void mkDir(Path path) {
        org.platanios.tensorflow.jni.FileIO$.MODULE$.mkDir(((Object)path.toAbsolutePath()).toString());
    }

    public void mkDirs(Path path) {
        org.platanios.tensorflow.jni.FileIO$.MODULE$.mkDirs(((Object)path.toAbsolutePath()).toString());
    }

    public void deleteRecursively(Path path) {
        org.platanios.tensorflow.jni.FileIO$.MODULE$.deleteRecursively(((Object)path.toAbsolutePath()).toString());
    }

    public boolean isDirectory(Path path) {
        return org.platanios.tensorflow.jni.FileIO$.MODULE$.isDirectory(((Object)path.toAbsolutePath()).toString());
    }

    public boolean isGCSPath(Path path) {
        return path.startsWith("gs://");
    }

    public FileStatistics fileStatistics(Path path) {
        return org.platanios.tensorflow.jni.FileIO$.MODULE$.statistics(((Object)path.toAbsolutePath()).toString());
    }

    public void copyFile(Path oldPath, Path newPath, boolean overwrite) {
        org.platanios.tensorflow.jni.FileIO$.MODULE$.copyFile(((Object)oldPath.toAbsolutePath()).toString(), ((Object)newPath.toAbsolutePath()).toString(), overwrite);
    }

    public boolean copyFile$default$3() {
        return false;
    }

    public void rename(Path oldPath, Path newPath, boolean overwrite) {
        org.platanios.tensorflow.jni.FileIO$.MODULE$.renameFile(((Object)oldPath.toAbsolutePath()).toString(), ((Object)newPath.toAbsolutePath()).toString(), overwrite);
    }

    public boolean rename$default$3() {
        return false;
    }

    public Seq<Path> listDirectories(Path dirPath) throws NotFoundException {
        if (!this.isDirectory(dirPath)) {
            throw package$exception$.MODULE$.NotFoundException().apply("Could not find the specified directory.");
        }
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])org.platanios.tensorflow.jni.FileIO$.MODULE$.getChildren(((Object)dirPath.toAbsolutePath()).toString()))).map((Function1 & Serializable & scala.Serializable)x$1 -> Paths.get(x$1, new String[0]), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Stream<Tuple3<Path, Seq<Path>, Seq<Path>>> walk(Path dirPath, boolean inOrder) {
        Seq seq;
        try {
            seq = this.listDirectories(dirPath);
        }
        catch (NotFoundException notFoundException) {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        Seq children = seq;
        ObjectRef files = ObjectRef.create((Object)((Seq)Seq$.MODULE$.empty()));
        ObjectRef subDirs = ObjectRef.create((Object)((Seq)Seq$.MODULE$.empty()));
        children.foreach((Function1 & Serializable & scala.Serializable)child -> {
            FileIO$.$anonfun$walk$1(dirPath, files, subDirs, child);
            return BoxedUnit.UNIT;
        });
        Stream hereStream = package$.MODULE$.Stream().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)dirPath, (Object)((Seq)subDirs.elem), (Object)((Seq)files.elem))}));
        Stream subDirsStream = (Stream)((Stream)((Seq)subDirs.elem).toStream().map((Function1 & Serializable & scala.Serializable)s -> MODULE$.walk(dirPath.resolve((Path)s), inOrder), Stream$.MODULE$.canBuildFrom())).foldLeft((Object)package$.MODULE$.Stream().empty(), (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> (Stream)x$2.$plus$plus((GenTraversableOnce)x$3, Stream$.MODULE$.canBuildFrom()));
        return inOrder ? (Stream)hereStream.$plus$plus((GenTraversableOnce)subDirsStream, Stream$.MODULE$.canBuildFrom()) : (Stream)subDirsStream.$plus$plus((GenTraversableOnce)hereStream, Stream$.MODULE$.canBuildFrom());
    }

    public boolean walk$default$2() {
        return true;
    }

    public long getLastModifiedTime(Path path, TimeUnit unit, boolean followSymbolicLinks) {
        return !followSymbolicLinks ? Files.getLastModifiedTime(path, LinkOption.NOFOLLOW_LINKS).to(unit) : Files.getLastModifiedTime(path, new LinkOption[0]).to(unit);
    }

    public TimeUnit getLastModifiedTime$default$2() {
        return TimeUnit.SECONDS;
    }

    public boolean getLastModifiedTime$default$3() {
        return true;
    }

    public Set<Path> getMatchingPaths(Path path, boolean useNativeFileIO) {
        Set set;
        String pathAsString = ((Object)path.toAbsolutePath()).toString();
        if (useNativeFileIO) {
            set = (Set)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])org.platanios.tensorflow.jni.FileIO$.MODULE$.getMatchingFiles(pathAsString))).toSet().map((Function1 & Serializable & scala.Serializable)x$4 -> Paths.get(x$4, new String[0]), Set$.MODULE$.canBuildFrom());
        } else {
            String glob;
            String separator = FileSystems.getDefault().getSeparator();
            int wildcard = new StringOps(Predef$.MODULE$.augmentString(pathAsString)).indexWhere((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FileIO$.$anonfun$getMatchingPaths$2(BoxesRunTime.unboxToChar((Object)x$5))));
            String prefix = wildcard != -1 ? pathAsString.substring(0, wildcard) : pathAsString;
            String suffix = wildcard != -1 ? pathAsString.substring(wildcard) : "";
            int separatorIndex = prefix.lastIndexOf(separator);
            Path directory = path.getFileSystem().getPath(prefix.substring(0, separatorIndex), new String[0]);
            Tuple2 tuple2 = new Tuple2((Object)directory, (Object)(glob = new StringBuilder(0).append(prefix.substring(separatorIndex + 1)).append(suffix).toString().replaceAll("([^\\[]*)\\[\\^", "$1\\[!")));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path directory2 = (Path)tuple2._1();
            String glob2 = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)directory2, (Object)glob2);
            Tuple2 tuple23 = tuple22;
            Path directory3 = (Path)tuple23._1();
            String glob3 = (String)tuple23._2();
            set = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(Files.newDirectoryStream(directory3, glob3)).asScala()).toSet();
        }
        return set;
    }

    public boolean getMatchingPaths$default$2() {
        return true;
    }

    public void deleteMatchingPaths(Path path) {
        this.getMatchingPaths(path, this.getMatchingPaths$default$2()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            FileIO$.$anonfun$deleteMatchingPaths$1(x$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public String readFileToString(Path filePath) {
        void var3_3;
        FileIO fileIO = new FileIO(filePath, FileIO$READ$.MODULE$, this.apply$default$3());
        String content = fileIO.read(fileIO.read$default$1());
        fileIO.close();
        return var3_3;
    }

    public void writeStringToFile(Path filePath, String content) {
        new FileIO(filePath, FileIO$WRITE$.MODULE$, this.apply$default$3()).write(content).close();
    }

    public void writeStringToFileAtomic(Path filePath, String content, boolean overwrite) {
        Path temporaryFilePath = filePath.resolveSibling(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)filePath), new StringBuilder(4).append(".tmp").append(UUID.randomUUID().toString()).toString()));
        this.writeStringToFile(temporaryFilePath, content);
        try {
            this.rename(temporaryFilePath, filePath, overwrite);
        }
        finally {
            if (this.exists(temporaryFilePath)) {
                this.deleteFile(temporaryFilePath);
            }
        }
    }

    public boolean writeStringToFileAtomic$default$3() {
        return true;
    }

    public FileIO apply(Path filePath, FileIO.Mode mode, long readBufferSize) {
        return new FileIO(filePath, mode, readBufferSize);
    }

    public long apply$default$3() {
        return 524288L;
    }

    public Option<Tuple3<Path, FileIO.Mode, Object>> unapply(FileIO x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.filePath(), (Object)x$0.mode(), (Object)BoxesRunTime.boxToLong((long)x$0.readBufferSize())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$walk$1(Path dirPath$1, ObjectRef files$1, ObjectRef subDirs$1, Path child) {
        Path fullPath = dirPath$1.resolve(child);
        if (!MODULE$.isDirectory(fullPath)) {
            files$1.elem = (Seq)((Seq)files$1.elem).$colon$plus((Object)child, Seq$.MODULE$.canBuildFrom());
        } else {
            subDirs$1.elem = (Seq)((Seq)subDirs$1.elem).$colon$plus((Object)child, Seq$.MODULE$.canBuildFrom());
        }
    }

    public static final /* synthetic */ boolean $anonfun$getMatchingPaths$2(char x$5) {
        return new StringOps(Predef$.MODULE$.augmentString("*?[\\")).contains((Object)BoxesRunTime.boxToCharacter((char)x$5));
    }

    public static final /* synthetic */ void $anonfun$deleteMatchingPaths$1(Path x$1) {
        Files.delete(x$1);
    }

    private FileIO$() {
        MODULE$ = this;
        this.FileStatistics = FileStatistics$.MODULE$;
    }
}

