/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.api.io;

import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.platanios.tensorflow.api.core.Shape$;
import org.platanios.tensorflow.api.core.package;
import org.platanios.tensorflow.api.core.package$exception$InvalidDataTypeException$;
import org.platanios.tensorflow.api.io.NPY;
import org.platanios.tensorflow.api.package$;
import org.platanios.tensorflow.api.tensors.Tensor;
import org.platanios.tensorflow.api.tensors.Tensor$;
import org.platanios.tensorflow.api.tensors.ops.Basic;
import org.platanios.tensorflow.api.types.DataType;
import org.platanios.tensorflow.api.utilities.NativeHandleWrapper$Lock$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;
import spire.math.UByte;
import spire.math.UShort;

public final class NPY$ {
    public static NPY$ MODULE$;
    private final Regex dtypeParser;

    static {
        new NPY$();
    }

    public Regex dtypeParser() {
        return this.dtypeParser;
    }

    public Tensor read(Path file) throws package.exception.InvalidDataTypeException {
        Tensor tensor;
        String magicString;
        ByteBuffer byteBuffer = ByteBuffer.wrap(Files.readAllBytes(file));
        Predef$.MODULE$.require(byteBuffer.get() == (byte)147, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Wrong magic string in Numpy file. File: ").append(file).append(".").toString());
        byte[] magicBytes = new byte[5];
        byteBuffer.get(magicBytes, 0, 5);
        String string = magicString = new String(magicBytes, StandardCharsets.US_ASCII);
        String string2 = "NUMPY";
        Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Wrong magic string in Numpy file. File: ").append(file).append(".").toString());
        int majorVersion = byteBuffer.get() & 0xFF;
        int minorVersion = byteBuffer.get() & 0xFF;
        Predef$.MODULE$.require(majorVersion == 1 && minorVersion == 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Only version 1.0 is supported for Numpy files. File: ").append(file).append(".").toString());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        short headerLength = byteBuffer.getShort();
        byte[] headerBytes = new byte[headerLength];
        byteBuffer.get(headerBytes);
        String headerString = new String(headerBytes, StandardCharsets.US_ASCII);
        UnanchoredRegex headerPattern = new StringOps(Predef$.MODULE$.augmentString("'descr': '([^']+)', 'fortran_order': (True|False), 'shape': \\(([^)]+?),?\\)")).r().unanchored();
        String string3 = headerString;
        Option option = ((Regex)headerPattern).unapplySeq((CharSequence)string3);
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(3) != 0) {
            throw new Exception("wrong header");
        }
        String description = (String)((LinearSeqOptimized)option.get()).apply(0);
        String fortranOrderString = (String)((LinearSeqOptimized)option.get()).apply(1);
        String shapeString = (String)((LinearSeqOptimized)option.get()).apply(2);
        String string4 = fortranOrderString;
        String string5 = "True";
        boolean fortranOrder = !(string4 != null ? !string4.equals(string5) : string5 != null);
        int[] shape = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])shapeString.trim().split(", "))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)NPY$.$anonfun$read$4(x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        NPY.Header header = new NPY.Header(description, fortranOrder, Shape$.MODULE$.fromSeq((Seq<Object>)Predef$.MODULE$.wrapIntArray(shape)));
        NPY.Header header2 = header;
        byteBuffer.order(header2.byteOrder());
        long numBytes = header2.shape().numElements() * (long)header2.dataType().byteSize();
        if (header2.fortranOrder()) {
            Basic.BasicOps qual$1 = package$.MODULE$.tensorToBasicOps(Tensor$.MODULE$.fromBuffer(header2.dataType(), Shape$.MODULE$.fromSeq((Seq<Object>)Predef$.MODULE$.wrapIntArray((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(header2.shape().asArray())).reverse())), numBytes, byteBuffer));
            Tensor x$3 = qual$1.transpose$default$1();
            boolean x$4 = qual$1.transpose$default$2();
            tensor = qual$1.transpose(x$3, x$4);
        } else {
            tensor = Tensor$.MODULE$.fromBuffer(header2.dataType(), header2.shape(), numBytes, byteBuffer);
        }
        return tensor;
    }

    public void write(Tensor tensor, Path file, boolean fortranOrder) throws package.exception.InvalidDataTypeException {
        String description = new StringBuilder(1).append(">").append(this.dataTypeToNumpyDType(tensor.dataType())).toString();
        String header = new NPY.Header(description, fortranOrder, tensor.shape()).toString();
        long resolvedHandle = tensor.resolve();
        ByteBuffer buffer = org.platanios.tensorflow.jni.Tensor$.MODULE$.buffer(resolvedHandle).order(ByteOrder.nativeOrder());
        byte[] dataBytes = buffer.array();
        NativeHandleWrapper$Lock$ nativeHandleWrapper$Lock$ = tensor.NativeHandleLock();
        synchronized (nativeHandleWrapper$Lock$) {
            if (resolvedHandle != 0L) {
                org.platanios.tensorflow.jni.Tensor$.MODULE$.delete(resolvedHandle);
            }
        }
        int remaining = (header.length() + 11) % 16;
        int padLength = remaining > 0 ? 16 - remaining : 0;
        int headerLength = header.length() + padLength + 1;
        int size = header.length() + 11 + padLength + dataBytes.length;
        byte[] array = new byte[size];
        ByteBuffer byteBuffer = ByteBuffer.wrap(array);
        byteBuffer.put(new byte[]{(byte)147, (byte)78, (byte)85, (byte)77, (byte)80, (byte)89, (byte)1, (byte)0});
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putShort((short)headerLength);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.put(header.getBytes());
        byteBuffer.put((byte[])Array$.MODULE$.fill(padLength, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> (byte)32, ClassTag$.MODULE$.Byte()));
        byteBuffer.put((byte)10);
        byteBuffer.put(dataBytes);
        OutputStream fileWriter = Files.newOutputStream(file, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        fileWriter.write(array);
        fileWriter.flush();
        fileWriter.close();
    }

    public boolean write$default$3() {
        return false;
    }

    public DataType numpyDTypeToDataType(String dtype) throws package.exception.InvalidDataTypeException {
        DataType.Aux<Object> aux;
        String string = dtype;
        if ("b".equals(string)) {
            aux = org.platanios.tensorflow.api.types.package$.MODULE$.BOOLEAN();
        } else if ("f2".equals(string)) {
            aux = org.platanios.tensorflow.api.types.package$.MODULE$.FLOAT16();
        } else if ("f4".equals(string)) {
            aux = org.platanios.tensorflow.api.types.package$.MODULE$.FLOAT32();
        } else if ("f8".equals(string)) {
            aux = org.platanios.tensorflow.api.types.package$.MODULE$.FLOAT64();
        } else if ("i1".equals(string)) {
            aux = org.platanios.tensorflow.api.types.package$.MODULE$.INT8();
        } else if ("i2".equals(string)) {
            aux = org.platanios.tensorflow.api.types.package$.MODULE$.INT16();
        } else if ("i4".equals(string)) {
            aux = org.platanios.tensorflow.api.types.package$.MODULE$.INT32();
        } else if ("i8".equals(string)) {
            aux = org.platanios.tensorflow.api.types.package$.MODULE$.INT64();
        } else if ("u1".equals(string)) {
            aux = org.platanios.tensorflow.api.types.package$.MODULE$.UINT8();
        } else if ("u2".equals(string)) {
            aux = org.platanios.tensorflow.api.types.package$.MODULE$.UINT16();
        } else if ("u4".equals(string)) {
            aux = org.platanios.tensorflow.api.types.package$.MODULE$.UINT32();
        } else if ("u8".equals(string)) {
            aux = org.platanios.tensorflow.api.types.package$.MODULE$.UINT64();
        } else {
            throw new package.exception.InvalidDataTypeException(new StringBuilder(65).append("Numpy data type '").append(string).append("' cannot be converted to a TensorFlow data type.").toString(), package$exception$InvalidDataTypeException$.MODULE$.apply$default$2());
        }
        return aux;
    }

    public String dataTypeToNumpyDType(DataType dataType) throws package.exception.InvalidDataTypeException {
        String string;
        DataType dataType2 = dataType;
        DataType.Aux<Object> aux = org.platanios.tensorflow.api.types.package$.MODULE$.BOOLEAN();
        DataType dataType3 = dataType2;
        if (!(aux != null ? !aux.equals(dataType3) : dataType3 != null)) {
            string = "b";
        } else {
            DataType.Aux<Object> aux2 = org.platanios.tensorflow.api.types.package$.MODULE$.FLOAT16();
            DataType dataType4 = dataType2;
            if (!(aux2 != null ? !aux2.equals(dataType4) : dataType4 != null)) {
                string = "f2";
            } else {
                DataType.Aux<Object> aux3 = org.platanios.tensorflow.api.types.package$.MODULE$.FLOAT32();
                DataType dataType5 = dataType2;
                if (!(aux3 != null ? !aux3.equals(dataType5) : dataType5 != null)) {
                    string = "f4";
                } else {
                    DataType.Aux<Object> aux4 = org.platanios.tensorflow.api.types.package$.MODULE$.FLOAT64();
                    DataType dataType6 = dataType2;
                    if (!(aux4 != null ? !aux4.equals(dataType6) : dataType6 != null)) {
                        string = "f8";
                    } else {
                        DataType.Aux<Object> aux5 = org.platanios.tensorflow.api.types.package$.MODULE$.INT8();
                        DataType dataType7 = dataType2;
                        if (!(aux5 != null ? !aux5.equals(dataType7) : dataType7 != null)) {
                            string = "i1";
                        } else {
                            DataType.Aux<Object> aux6 = org.platanios.tensorflow.api.types.package$.MODULE$.INT16();
                            DataType dataType8 = dataType2;
                            if (!(aux6 != null ? !aux6.equals(dataType8) : dataType8 != null)) {
                                string = "i2";
                            } else {
                                DataType.Aux<Object> aux7 = org.platanios.tensorflow.api.types.package$.MODULE$.INT32();
                                DataType dataType9 = dataType2;
                                if (!(aux7 != null ? !aux7.equals(dataType9) : dataType9 != null)) {
                                    string = "i3";
                                } else {
                                    DataType.Aux<Object> aux8 = org.platanios.tensorflow.api.types.package$.MODULE$.INT64();
                                    DataType dataType10 = dataType2;
                                    if (!(aux8 != null ? !aux8.equals(dataType10) : dataType10 != null)) {
                                        string = "i4";
                                    } else {
                                        DataType.Aux<UByte> aux9 = org.platanios.tensorflow.api.types.package$.MODULE$.UINT8();
                                        DataType dataType11 = dataType2;
                                        if (!(aux9 != null ? !aux9.equals(dataType11) : dataType11 != null)) {
                                            string = "u1";
                                        } else {
                                            DataType.Aux<UShort> aux10 = org.platanios.tensorflow.api.types.package$.MODULE$.UINT16();
                                            DataType dataType12 = dataType2;
                                            if (!(aux10 != null ? !aux10.equals(dataType12) : dataType12 != null)) {
                                                string = "u2";
                                            } else {
                                                DataType.Aux<Object> aux11 = org.platanios.tensorflow.api.types.package$.MODULE$.UINT32();
                                                DataType dataType13 = dataType2;
                                                if (!(aux11 != null ? !aux11.equals(dataType13) : dataType13 != null)) {
                                                    string = "u3";
                                                } else {
                                                    DataType.Aux<Object> aux12 = org.platanios.tensorflow.api.types.package$.MODULE$.UINT64();
                                                    DataType dataType14 = dataType2;
                                                    if (!(aux12 != null ? !aux12.equals(dataType14) : dataType14 != null)) {
                                                        string = "u4";
                                                    } else {
                                                        throw new package.exception.InvalidDataTypeException(new StringBuilder(65).append("TensorFlow data type '").append(dataType2).append("' cannot be converted to a Numpy data type.").toString(), package$exception$InvalidDataTypeException$.MODULE$.apply$default$2());
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return string;
    }

    public static final /* synthetic */ int $anonfun$read$4(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    private NPY$() {
        MODULE$ = this;
        this.dtypeParser = new StringOps(Predef$.MODULE$.augmentString("^[<=>]?(\\w\\d*)$")).r();
    }
}

