/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.api.io.events;

import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.nio.file.Path;
import org.platanios.tensorflow.api.io.events.AudioEventRecord;
import org.platanios.tensorflow.api.io.events.AudioEventType$;
import org.platanios.tensorflow.api.io.events.AudioValue;
import org.platanios.tensorflow.api.io.events.CompressedHistogramEventRecord;
import org.platanios.tensorflow.api.io.events.CompressedHistogramEventType$;
import org.platanios.tensorflow.api.io.events.EventAccumulator$;
import org.platanios.tensorflow.api.io.events.EventAccumulator$EventLoaderLock$;
import org.platanios.tensorflow.api.io.events.EventPluginUtilities$;
import org.platanios.tensorflow.api.io.events.EventRecord;
import org.platanios.tensorflow.api.io.events.EventType;
import org.platanios.tensorflow.api.io.events.GraphEventType$;
import org.platanios.tensorflow.api.io.events.HistogramEventRecord;
import org.platanios.tensorflow.api.io.events.HistogramEventType$;
import org.platanios.tensorflow.api.io.events.HistogramValue;
import org.platanios.tensorflow.api.io.events.ImageEventRecord;
import org.platanios.tensorflow.api.io.events.ImageEventType$;
import org.platanios.tensorflow.api.io.events.ImageValue;
import org.platanios.tensorflow.api.io.events.MetaGraphEventType$;
import org.platanios.tensorflow.api.io.events.RunMetadataEventType$;
import org.platanios.tensorflow.api.io.events.ScalarEventRecord;
import org.platanios.tensorflow.api.io.events.ScalarEventType$;
import org.platanios.tensorflow.api.io.events.TensorEventRecord;
import org.platanios.tensorflow.api.io.events.TensorEventType$;
import org.platanios.tensorflow.api.utilities.Reservoir;
import org.platanios.tensorflow.api.utilities.Reservoir$;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.HistogramProto;
import org.tensorflow.framework.MetaGraphDef;
import org.tensorflow.framework.RunMetadata;
import org.tensorflow.framework.Summary;
import org.tensorflow.framework.SummaryMetadata;
import org.tensorflow.util.Event;
import org.tensorflow.util.SessionLog;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0011ea\u0001B\u0001\u0003\u0001>\u0011\u0001#\u0012<f]R\f5mY;nk2\fGo\u001c:\u000b\u0005\r!\u0011AB3wK:$8O\u0003\u0002\u0006\r\u0005\u0011\u0011n\u001c\u0006\u0003\u000f!\t1!\u00199j\u0015\tI!\"\u0001\u0006uK:\u001cxN\u001d4m_^T!a\u0003\u0007\u0002\u0013Ad\u0017\r^1oS>\u001c(\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001b#\u0007\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E9\u0012B\u0001\r\u0013\u0005\u001d\u0001&o\u001c3vGR\u0004\"!\u0005\u000e\n\u0005m\u0011\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\u000f\u0001\u0005+\u0007I\u0011\u0001\u0010\u0002\tA\fG\u000f[\u000b\u0002?A\u0011\u0001eJ\u0007\u0002C)\u0011!eI\u0001\u0005M&dWM\u0003\u0002%K\u0005\u0019a.[8\u000b\u0003\u0019\nAA[1wC&\u0011\u0001&\t\u0002\u0005!\u0006$\b\u000e\u0003\u0005+\u0001\tE\t\u0015!\u0003 \u0003\u0015\u0001\u0018\r\u001e5!\u0011!a\u0003A!f\u0001\n\u0003i\u0013\u0001D:ju\u0016<U/\u001b3b]\u000e,W#\u0001\u0018\u0011\t=2\u0014(\u0010\b\u0003aQ\u0002\"!\r\n\u000e\u0003IR!a\r\b\u0002\rq\u0012xn\u001c;?\u0013\t)$#\u0001\u0004Qe\u0016$WMZ\u0005\u0003oa\u00121!T1q\u0015\t)$\u0003\u0005\u0002;w5\t!!\u0003\u0002=\u0005\tIQI^3oiRK\b/\u001a\t\u0003#yJ!a\u0010\n\u0003\u0007%sG\u000f\u0003\u0005B\u0001\tE\t\u0015!\u0003/\u00035\u0019\u0018N_3Hk&$\u0017M\\2fA!A1\t\u0001BK\u0002\u0013\u0005A)A\fiSN$xn\u001a:b[\u000e{W\u000e\u001d:fgNLwN\u001c\"qgV\tQ\tE\u0002G\u0017vr!aR%\u000f\u0005EB\u0015\"A\n\n\u0005)\u0013\u0012a\u00029bG.\fw-Z\u0005\u0003\u00196\u00131aU3r\u0015\tQ%\u0003\u0003\u0005P\u0001\tE\t\u0015!\u0003F\u0003aA\u0017n\u001d;pOJ\fWnQ8naJ,7o]5p]\n\u00038\u000f\t\u0005\t#\u0002\u0011)\u001a!C\u0001%\u0006\t\u0002/\u001e:hK>\u0013\b\u000f[1oK\u0012$\u0015\r^1\u0016\u0003M\u0003\"!\u0005+\n\u0005U\u0013\"a\u0002\"p_2,\u0017M\u001c\u0005\t/\u0002\u0011\t\u0012)A\u0005'\u0006\u0011\u0002/\u001e:hK>\u0013\b\u000f[1oK\u0012$\u0015\r^1!\u0011\u0015I\u0006\u0001\"\u0001[\u0003\u0019a\u0014N\\5u}Q)1\fX/_?B\u0011!\b\u0001\u0005\u0006;a\u0003\ra\b\u0005\bYa\u0003\n\u00111\u0001/\u0011\u001d\u0019\u0005\f%AA\u0002\u0015Cq!\u0015-\u0011\u0002\u0003\u00071\u000b\u0003\u0004b\u0001\u0001\u0006IAY\u0001\fKZ,g\u000e\u001e'pC\u0012,'\u000fE\u0002\u0012G\u0016L!\u0001\u001a\n\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004c\u0001$gQ&\u0011q-\u0014\u0002\t\u0013R,'/\u0019;peB\u0011\u0011.\\\u0007\u0002U*\u00111\u000e\\\u0001\u0005kRLGN\u0003\u0002\n\u0019%\u0011aN\u001b\u0002\u0006\u000bZ,g\u000e^\u0004\u0007a\u0002\u0001\u000b\u0012B9\u0002\u001f\u00153XM\u001c;M_\u0006$WM\u001d'pG.\u0004\"A]:\u000e\u0003\u00011a\u0001\u001e\u0001!\u0012\u0013)(aD#wK:$Hj\\1eKJdunY6\u0014\u0005M\u0004\u0002\"B-t\t\u00039H#A9\t\re\u0004\u0001\u0015)\u0003{\u0003Qyf-\u001b:ti\u00163XM\u001c;US6,7\u000b^1naB\u0011\u0011c_\u0005\u0003yJ\u0011a\u0001R8vE2,\u0007B\u0002@\u0001A\u0003&q0\u0001\u0007`M&dWMV3sg&|g\u000eE\u0002\u0012\u0003\u0003I1!a\u0001\u0013\u0005\u00151En\\1u\u0011\u001d\t9\u0001\u0001Q!\ni\f1cX7pgR\u0014VmY3oi^\u000bG\u000e\u001c+j[\u0016D\u0001\"a\u0003\u0001A\u0003&\u0011QB\u0001\u0010?6|7\u000f\u001e*fG\u0016tGo\u0015;faB\u0019\u0011#a\u0004\n\u0007\u0005E!C\u0001\u0003M_:<\u0007\u0002CA\u000b\u0001\u0001\u0006I!a\u0006\u0002'}\u000b7\r^;bYNK'0Z$vS\u0012\fgnY3\u0011\r\u0005e\u00111E\u001d>\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011!C5n[V$\u0018M\u00197f\u0015\r\t\tCE\u0001\u000bG>dG.Z2uS>t\u0017bA\u001c\u0002\u001c!A\u0011q\u0005\u0001!\u0002\u0013\tI#A\u0006`e\u0016\u001cXM\u001d<pSJ\u001c\b#B\u00187s\u0005-\u0002\u0007BA\u0017\u0003\u0007\u0002\u0002\"a\f\u00026\u0005e\u0012qH\u0007\u0003\u0003cQ1!a\r\u0007\u0003%)H/\u001b7ji&,7/\u0003\u0003\u00028\u0005E\"!\u0003*fg\u0016\u0014ho\\5s!\ry\u00131H\u0005\u0004\u0003{A$AB*ue&tw\r\u0005\u0003\u0002B\u0005\rC\u0002\u0001\u0003\r\u0003\u000b\n)#!A\u0001\u0002\u000b\u0005\u0011q\t\u0002\u0004?\u0012\n\u0014\u0003BA%\u0003\u001f\u00022!EA&\u0013\r\tiE\u0005\u0002\b\u001d>$\b.\u001b8ha\u0011\t\t&!\u0017\u0011\u000bi\n\u0019&a\u0016\n\u0007\u0005U#AA\u0006Fm\u0016tGOU3d_J$\u0007\u0003BA!\u00033\"A\"a\u0017\u0002^\u0005\u0005\t\u0011!B\u0001\u0003?\u00121a\u0018\u00133\t1\t)%!\n\u0002\u0002\u0007\u0005)\u0011AA$#\u0011\tI%!\u0019\u0011\u0007E\t\u0019'C\u0002\u0002fI\u00111!\u00118z\u0011-\tI\u0007\u0001a\u0001\u0002\u0003\u0006K!a\u001b\u0002\u0013};'/\u00199i\t\u00164\u0007\u0003BA7\u0003wj!!a\u001c\u000b\t\u0005E\u00141O\u0001\taJ|Go\u001c2vM*!\u0011QOA<\u0003\u00199wn\\4mK*\u0011\u0011\u0011P\u0001\u0004G>l\u0017\u0002BA?\u0003_\u0012!BQ=uKN#(/\u001b8h\u0011\u001d\t\t\t\u0001Q!\nM\u000b1cX4sCBDgI]8n\u001b\u0016$\u0018m\u0012:ba\"D1\"!\"\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002l\u0005iq,\\3uC\u001e\u0013\u0018\r\u001d5EK\u001aD\u0001\"!#\u0001A\u0003&\u00111R\u0001\u0013?R\fwmZ3e%VtW*\u001a;bI\u0006$\u0018\r\u0005\u00040m\u0005e\u00121\u000e\u0005\t\u0003\u001f\u0003\u0001\u0015)\u0003\u0002\u0012\u0006\u0001rl];n[\u0006\u0014\u00180T3uC\u0012\fG/\u0019\t\u0007_Y\nI$a%\u0011\t\u0005U\u00151T\u0007\u0003\u0003/S1!!'m\u0003%1'/Y7fo>\u00148.\u0003\u0003\u0002\u001e\u0006]%aD*v[6\f'/_'fi\u0006$\u0017\r^1\t\u0011\u0005\u0005\u0006\u0001)A\u0005\u0003G\u000b\u0011c\u00189mk\u001eLg\u000eV1h\u0007>tG/\u001a8u!!\t)+a+\u0002:\u00055VBAAT\u0015\u0011\tI+a\b\u0002\u000f5,H/\u00192mK&\u0019q'a*\u0011\u0011\u0005\u0015\u00161VA\u001d\u0003sAq!!-\u0001\t\u0003\t\u0019,\u0001\u0004sK2|\u0017\r\u001a\u000b\u00027\"9\u0011q\u0017\u0001\u0005\u0002\u0005e\u0016a\u00054jeN$XI^3oiRKW.Z*uC6\u0004X#\u0001>\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\u000691oY1mCJ\u001cH\u0003BAa\u0003\u001b\u0004RARAb\u0003\u000fL1!!2N\u0005\u0011a\u0015n\u001d;\u0011\u0007i\nI-C\u0002\u0002L\n\u0011\u0011cU2bY\u0006\u0014XI^3oiJ+7m\u001c:e\u0011!\ty-a/A\u0002\u0005e\u0012a\u0001;bO\"9\u00111\u001b\u0001\u0005\u0002\u0005U\u0017AB5nC\u001e,7\u000f\u0006\u0003\u0002X\u0006}\u0007#\u0002$\u0002D\u0006e\u0007c\u0001\u001e\u0002\\&\u0019\u0011Q\u001c\u0002\u0003!%k\u0017mZ3Fm\u0016tGOU3d_J$\u0007\u0002CAh\u0003#\u0004\r!!\u000f\t\u000f\u0005\r\b\u0001\"\u0001\u0002f\u0006)\u0011-\u001e3j_R!\u0011q]Ax!\u00151\u00151YAu!\rQ\u00141^\u0005\u0004\u0003[\u0014!\u0001E!vI&|WI^3oiJ+7m\u001c:e\u0011!\ty-!9A\u0002\u0005e\u0002bBAz\u0001\u0011\u0005\u0011Q_\u0001\u000bQ&\u001cHo\\4sC6\u001cH\u0003BA|\u0003\u007f\u0004RARAb\u0003s\u00042AOA~\u0013\r\tiP\u0001\u0002\u0015\u0011&\u001cHo\\4sC6,e/\u001a8u%\u0016\u001cwN\u001d3\t\u0011\u0005=\u0017\u0011\u001fa\u0001\u0003sAqAa\u0001\u0001\t\u0003\u0011)!\u0001\u000bd_6\u0004(/Z:tK\u0012D\u0015n\u001d;pOJ\fWn\u001d\u000b\u0005\u0005\u000f\u0011y\u0001E\u0003G\u0003\u0007\u0014I\u0001E\u0002;\u0005\u0017I1A!\u0004\u0003\u0005y\u0019u.\u001c9sKN\u001cX\r\u001a%jgR|wM]1n\u000bZ,g\u000e\u001e*fG>\u0014H\r\u0003\u0005\u0002P\n\u0005\u0001\u0019AA\u001d\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u0005+\tq\u0001^3og>\u00148\u000f\u0006\u0003\u0003\u0018\t}\u0001#\u0002$\u0002D\ne\u0001c\u0001\u001e\u0003\u001c%\u0019!Q\u0004\u0002\u0003#Q+gn]8s\u000bZ,g\u000e\u001e*fG>\u0014H\r\u0003\u0005\u0002P\nE\u0001\u0019AA\u001d\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0005K\tQa\u001a:ba\",\"Aa\n\u0011\t\u0005U%\u0011F\u0005\u0005\u0005W\t9J\u0001\u0005He\u0006\u0004\b\u000eR3gQ\u0019\u0011\tCa\f\u0003BA)\u0011C!\r\u00036%\u0019!1\u0007\n\u0003\rQD'o\\<t!\u0011\u00119D!\u0010\u000e\u0005\te\"b\u0001B\u001eK\u0005!A.\u00198h\u0013\u0011\u0011yD!\u000f\u0003+%cG.Z4bYN#\u0018\r^3Fq\u000e,\u0007\u000f^5p]F:a$!\u000f\u0003D\t%\u0014'C\u0012\u0003F\t5#q\fB(+\u0011\u00119E!\u0013\u0016\u0005\u0005eBa\u0002B&\u001d\t\u0007!Q\u000b\u0002\u0002)&!!q\nB)\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019!1\u000b\n\u0002\rQD'o\\<t#\u0011\tIEa\u0016\u0011\t\te#1\f\b\u0003#%K1A!\u0018N\u0005%!\u0006N]8xC\ndW-M\u0005$\u0005C\u0012\u0019G!\u001a\u0003T9\u0019\u0011Ca\u0019\n\u0007\tM##M\u0003##I\u00119GA\u0003tG\u0006d\u0017-M\u0002'\u0005kAqA!\u001c\u0001\t\u0003\u0011y'A\u0005nKR\fwI]1qQV\u0011!\u0011\u000f\t\u0005\u0003+\u0013\u0019(\u0003\u0003\u0003v\u0005]%\u0001D'fi\u0006<%/\u00199i\t\u00164\u0007F\u0002B6\u0005_\u0011I(M\u0004\u001f\u0003s\u0011YH!!2\u0013\r\u0012)E!\u0014\u0003~\t=\u0013'C\u0012\u0003b\t\r$q\u0010B*c\u0015\u0011\u0013C\u0005B4c\r1#Q\u0007\u0005\b\u0005\u000b\u0003A\u0011\u0001BD\u0003-\u0011XO\\'fi\u0006$\u0017\r^1\u0015\t\t%%q\u0012\t\u0005\u0003+\u0013Y)\u0003\u0003\u0003\u000e\u0006]%a\u0003*v]6+G/\u00193bi\u0006D\u0001\"a4\u0003\u0004\u0002\u0007\u0011\u0011\b\u0015\u0007\u0005\u0007\u0013\u0019Ja'\u0011\u000bE\u0011\tD!&\u0011\u0007\u0019\u00139*C\u0002\u0003\u001a6\u0013\u0001$\u00137mK\u001e\fG.\u0011:hk6,g\u000e^#yG\u0016\u0004H/[8oc\u001dq\u0012\u0011\bBO\u0005G\u000b\u0014b\tB#\u0005\u001b\u0012yJa\u00142\u0013\r\u0012\tGa\u0019\u0003\"\nM\u0013'\u0002\u0012\u0012%\t\u001d\u0014g\u0001\u0014\u0003\u0016\"9!q\u0015\u0001\u0005\u0002\t%\u0016aD:v[6\f'/_'fi\u0006$\u0017\r^1\u0015\t\u0005M%1\u0016\u0005\t\u0003\u001f\u0014)\u000b1\u0001\u0002:!9!q\u0016\u0001\u0005\u0002\tE\u0016A\u00059mk\u001eLg\u000eV1h)>\u001cuN\u001c;f]R$BAa-\u0003<B)\u0011C!.\u0003:&\u0019!q\u0017\n\u0003\r=\u0003H/[8o!\u0019yc'!\u000f\u0002:!A!Q\u0018BW\u0001\u0004\tI$\u0001\u0006qYV<\u0017N\u001c(b[\u0016DqA!1\u0001\t\u0003\u0011\u0019-\u0001\u0007qYV<\u0017N\\!tg\u0016$8\u000f\u0006\u0003\u0003F\n\u001d\u0007c\u0001$L?!A!Q\u0018B`\u0001\u0004\tI\u0004C\u0004\u0003L\u0002!\tA!4\u0002'I,GO]5fm\u0016\u0004F.^4j]\u0006\u001b8/\u001a;\u0015\r\u0005e\"q\u001aBi\u0011!\u0011iL!3A\u0002\u0005e\u0002\u0002\u0003Bj\u0005\u0013\u0004\r!!\u000f\u0002\u0013\u0005\u001c8/\u001a;OC6,\u0007b\u0002Bl\u0001\u0011\u0005!\u0011\\\u0001\u0005i\u0006<7/\u0006\u0002\u0003\\B)qFN\u001d\u0003^B!aiSA\u001d\u0011!\u0011\t\u000f\u0001Q\u0005\n\t\r\u0018\u0001\u00049s_\u000e,7o]#wK:$H\u0003\u0002Bs\u0005W\u00042!\u0005Bt\u0013\r\u0011IO\u0005\u0002\u0005+:LG\u000fC\u0004\u0003n\n}\u0007\u0019\u00015\u0002\u000b\u00154XM\u001c;\t\u0011\tE\b\u0001)C\u0005\u0005g\fa#\\1zE\u0016\u0004VO]4f\u001fJ\u0004\b.\u00198fI\u0012\u000bG/\u0019\u000b\u0005\u0005K\u0014)\u0010C\u0004\u0003n\n=\b\u0019\u00015\t\u0011\te\b\u0001)C\u0005\u0005w\fAd\u00195fG.4uN\u001d*fgR\f'\u000f^!oI6\u000b\u0017PY3QkJ<W\r\u0006\u0003\u0003f\nu\bb\u0002Bw\u0005o\u0004\r\u0001\u001b\u0005\t\u0007\u0003\u0001\u0001\u0015\"\u0003\u0004\u0004\u0005\u00193\r[3dW\u001a{'oT;u\u001f\u001a|%\u000fZ3s'R,\u0007/\u00118e\u001b\u0006L(-\u001a)ve\u001e,G\u0003\u0002Bs\u0007\u000bAqA!<\u0003\u0000\u0002\u0007\u0001\u000e\u0003\u0005\u0004\n\u0001\u0001K\u0011BB\u0006\u0003\u0015\u0001XO]4f)\u0019\u0011)o!\u0004\u0004\u0010!9!Q^B\u0004\u0001\u0004A\u0007bBB\t\u0007\u000f\u0001\raU\u0001\u0007Ef$\u0016mZ:\t\u0013\rU\u0001!!A\u0005\u0002\r]\u0011\u0001B2paf$\u0012bWB\r\u00077\u0019iba\b\t\u0011u\u0019\u0019\u0002%AA\u0002}A\u0001\u0002LB\n!\u0003\u0005\rA\f\u0005\t\u0007\u000eM\u0001\u0013!a\u0001\u000b\"A\u0011ka\u0005\u0011\u0002\u0003\u00071\u000bC\u0005\u0004$\u0001\t\n\u0011\"\u0001\u0004&\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAB\u0014U\ry2\u0011F\u0016\u0003\u0007W\u0001Ba!\f\u000485\u00111q\u0006\u0006\u0005\u0007c\u0019\u0019$A\u0005v]\u000eDWmY6fI*\u00191Q\u0007\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004:\r=\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I1Q\b\u0001\u0012\u0002\u0013\u00051qH\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019\tEK\u0002/\u0007SA\u0011b!\u0012\u0001#\u0003%\taa\u0012\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u00111\u0011\n\u0016\u0004\u000b\u000e%\u0002\"CB'\u0001E\u0005I\u0011AB(\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"a!\u0015+\u0007M\u001bI\u0003C\u0005\u0004V\u0001\t\t\u0011\"\u0011\u0004X\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"a!\u0017\u0011\t\t]21L\u0005\u0005\u0003{\u0011I\u0004C\u0005\u0004`\u0001\t\t\u0011\"\u0001\u0004b\u0005a\u0001O]8ek\u000e$\u0018I]5usV\tQ\bC\u0005\u0004f\u0001\t\t\u0011\"\u0001\u0004h\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA1\u0007SB\u0011ba\u001b\u0004d\u0005\u0005\t\u0019A\u001f\u0002\u0007a$\u0013\u0007C\u0005\u0004p\u0001\t\t\u0011\"\u0011\u0004r\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0004tA11QOB<\u0003Cj!!a\b\n\u0007\u001d\fy\u0002C\u0005\u0004|\u0001\t\t\u0011\"\u0001\u0004~\u0005A1-\u00198FcV\fG\u000eF\u0002T\u0007\u007fB!ba\u001b\u0004z\u0005\u0005\t\u0019AA1\u0011%\u0019\u0019\tAA\u0001\n\u0003\u001a))\u0001\u0005iCND7i\u001c3f)\u0005i\u0004\"CBE\u0001\u0005\u0005I\u0011IBF\u0003!!xn\u0015;sS:<GCAB-\u0011%\u0019y\tAA\u0001\n\u0003\u001a\t*\u0001\u0004fcV\fGn\u001d\u000b\u0004'\u000eM\u0005BCB6\u0007\u001b\u000b\t\u00111\u0001\u0002b\u001d91q\u0013\u0002\t\u0002\re\u0015\u0001E#wK:$\u0018iY2v[Vd\u0017\r^8s!\rQ41\u0014\u0004\u0007\u0003\tA\ta!(\u0014\t\rm\u0005#\u0007\u0005\b3\u000emE\u0011ABQ)\t\u0019I\n\u0003\u0007\u0004&\u000em%\u0019!C\u0001\u00077\u001b9+\u0001\u0004m_\u001e<WM]\u000b\u0003\u0007S\u0003Baa+\u000466\u00111Q\u0016\u0006\u0005\u0007_\u001b\t,\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0003\u00044\u0006]\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\n\t\r]6Q\u0016\u0002\u0007\u0019><w-\u001a:\t\u0013\rm61\u0014Q\u0001\n\r%\u0016a\u00027pO\u001e,'\u000f\t\u0005\u000b\u0007\u007f\u001bYJ1A\u0005\u0002\ti\u0013!\u0006#F\r\u0006+F\nV0T\u0013j+ulR+J\t\u0006s5)\u0012\u0005\t\u0007\u0007\u001cY\n)A\u0005]\u00051B)\u0012$B+2#vlU%[\u000b~;U+\u0013#B\u001d\u000e+\u0005\u0005\u0003\u0006\u0004H\u000em%\u0019!C\u0001\u0005\u0011\u000b\u0011\u0005R#G\u0003VcEk\u0018%J'R{uIU!N?\u000e{U\n\u0015*F'NKuJT0C!NC\u0001ba3\u0004\u001c\u0002\u0006I!R\u0001#\t\u00163\u0015)\u0016'U?\"K5\u000bV(H%\u0006kulQ(N!J+5kU%P\u001d~\u0013\u0005k\u0015\u0011\t\u0015\r=71\u0014C\u0001\u00077\u001b\t.A\nfm\u0016tG\u000fT8bI\u0016\u0014hI]8n!\u0006$\b\u000eF\u0002c\u0007'Da!HBg\u0001\u0004y\u0002BCBl\u00077\u000b\t\u0011\"!\u0004Z\u0006)\u0011\r\u001d9msRI1la7\u0004^\u000e}7\u0011\u001d\u0005\u0007;\rU\u0007\u0019A\u0010\t\u00111\u001a)\u000e%AA\u00029B\u0001bQBk!\u0003\u0005\r!\u0012\u0005\t#\u000eU\u0007\u0013!a\u0001'\"Q1Q]BN\u0003\u0003%\tia:\u0002\u000fUt\u0017\r\u001d9msR!1\u0011^By!\u0015\t\"QWBv!\u001d\t2Q^\u0010/\u000bNK1aa<\u0013\u0005\u0019!V\u000f\u001d7fi!I11_Br\u0003\u0003\u0005\raW\u0001\u0004q\u0012\u0002\u0004BCB|\u00077\u000b\n\u0011\"\u0001\u0004@\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIIB!ba?\u0004\u001cF\u0005I\u0011AB$\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g!Q1q`BN#\u0003%\taa\u0014\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0011)!\u0019aa'\u0012\u0002\u0013\u00051qH\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e!QAqABN#\u0003%\taa\u0012\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIMB!\u0002b\u0003\u0004\u001cF\u0005I\u0011AB(\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0004B\u0003C\b\u00077\u000b\t\u0011\"\u0003\u0005\u0012\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t!\u0019\u0002\u0005\u0003\u00038\u0011U\u0011\u0002\u0002C\f\u0005s\u0011aa\u00142kK\u000e$\b")
public class EventAccumulator
implements Product,
scala.Serializable {
    private volatile EventAccumulator$EventLoaderLock$ EventLoaderLock$module;
    private final Path path;
    private final Map<EventType, Object> sizeGuidance;
    private final Seq<Object> histogramCompressionBps;
    private final boolean purgeOrphanedData;
    private final Function0<Iterator<Event>> eventLoader;
    private double _firstEventTimeStamp;
    private float _fileVersion;
    private double _mostRecentWallTime;
    private long _mostRecentStep;
    private final Map<EventType, Object> _actualSizeGuidance;
    private final Map<EventType, Reservoir<String, ? extends EventRecord<?>>> _reservoirs;
    private ByteString _graphDef;
    private boolean _graphFromMetaGraph;
    private ByteString _metaGraphDef;
    private Map<String, ByteString> _taggedRunMetadata;
    private Map<String, SummaryMetadata> _summaryMetadata;
    private final scala.collection.mutable.Map<String, scala.collection.mutable.Map<String, String>> _pluginTagContent;

    public static boolean apply$default$4() {
        return EventAccumulator$.MODULE$.apply$default$4();
    }

    public static Seq<Object> apply$default$3() {
        return EventAccumulator$.MODULE$.apply$default$3();
    }

    public static Map<EventType, Object> apply$default$2() {
        return EventAccumulator$.MODULE$.apply$default$2();
    }

    public static boolean $lessinit$greater$default$4() {
        return EventAccumulator$.MODULE$.$lessinit$greater$default$4();
    }

    public static Seq<Object> $lessinit$greater$default$3() {
        return EventAccumulator$.MODULE$.$lessinit$greater$default$3();
    }

    public static Map<EventType, Object> $lessinit$greater$default$2() {
        return EventAccumulator$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple4<Path, Map<EventType, Object>, Seq<Object>, Object>> unapply(EventAccumulator eventAccumulator) {
        return EventAccumulator$.MODULE$.unapply(eventAccumulator);
    }

    public static EventAccumulator apply(Path path, Map<EventType, Object> map, Seq<Object> seq, boolean bl) {
        return EventAccumulator$.MODULE$.apply(path, map, seq, bl);
    }

    private EventAccumulator$EventLoaderLock$ EventLoaderLock() {
        if (this.EventLoaderLock$module == null) {
            this.EventLoaderLock$lzycompute$1();
        }
        return this.EventLoaderLock$module;
    }

    public Path path() {
        return this.path;
    }

    public Map<EventType, Object> sizeGuidance() {
        return this.sizeGuidance;
    }

    public Seq<Object> histogramCompressionBps() {
        return this.histogramCompressionBps;
    }

    public boolean purgeOrphanedData() {
        return this.purgeOrphanedData;
    }

    public EventAccumulator reload() {
        EventAccumulator eventAccumulator;
        EventAccumulator$EventLoaderLock$ eventAccumulator$EventLoaderLock$ = this.EventLoaderLock();
        synchronized (eventAccumulator$EventLoaderLock$) {
            ((Iterator)this.eventLoader.apply()).foreach((Function1 & Serializable & scala.Serializable)event -> {
                this.processEvent(event);
                return BoxedUnit.UNIT;
            });
            eventAccumulator = this;
        }
        return eventAccumulator;
    }

    public double firstEventTimeStamp() {
        double d;
        if (this._firstEventTimeStamp >= 0.0) {
            d = this._firstEventTimeStamp;
        } else {
            EventAccumulator$EventLoaderLock$ eventAccumulator$EventLoaderLock$ = this.EventLoaderLock();
            synchronized (eventAccumulator$EventLoaderLock$) {
                double d2 = this.liftedTree1$1();
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
                d = d2;
            }
        }
        return d;
    }

    public List<ScalarEventRecord> scalars(String tag) {
        return ((Reservoir)this._reservoirs.apply((Object)ScalarEventType$.MODULE$)).items(tag);
    }

    public List<ImageEventRecord> images(String tag) {
        return ((Reservoir)this._reservoirs.apply((Object)ImageEventType$.MODULE$)).items(tag);
    }

    public List<AudioEventRecord> audio(String tag) {
        return ((Reservoir)this._reservoirs.apply((Object)AudioEventType$.MODULE$)).items(tag);
    }

    public List<HistogramEventRecord> histograms(String tag) {
        return ((Reservoir)this._reservoirs.apply((Object)HistogramEventType$.MODULE$)).items(tag);
    }

    public List<CompressedHistogramEventRecord> compressedHistograms(String tag) {
        return ((Reservoir)this._reservoirs.apply((Object)CompressedHistogramEventType$.MODULE$)).items(tag);
    }

    public List<TensorEventRecord> tensors(String tag) {
        return ((Reservoir)this._reservoirs.apply((Object)TensorEventType$.MODULE$)).items(tag);
    }

    public GraphDef graph() throws IllegalStateException {
        if (this._graphDef == null) {
            throw new IllegalStateException("There is no graph in this event accumulator.");
        }
        return GraphDef.parseFrom((ByteString)this._graphDef);
    }

    public MetaGraphDef metaGraph() throws IllegalStateException {
        if (this._metaGraphDef == null) {
            throw new IllegalStateException("There is no meta-graph in this event accumulator.");
        }
        return MetaGraphDef.parseFrom((ByteString)this._metaGraphDef);
    }

    public RunMetadata runMetadata(String tag) throws IllegalArgumentException {
        if (!this._taggedRunMetadata.contains((Object)tag)) {
            throw new IllegalArgumentException("There is no run metadata for the provided tag name.");
        }
        return RunMetadata.parseFrom((ByteString)((ByteString)this._taggedRunMetadata.apply((Object)tag)));
    }

    public SummaryMetadata summaryMetadata(String tag) {
        return (SummaryMetadata)this._summaryMetadata.apply((Object)tag);
    }

    public Option<Map<String, String>> pluginTagToContent(String pluginName) {
        return this._pluginTagContent.get((Object)pluginName).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toMap(Predef$.MODULE$.$conforms()));
    }

    public Seq<Path> pluginAssets(String pluginName) {
        return EventPluginUtilities$.MODULE$.listPluginAssets(this.path(), pluginName);
    }

    public String retrievePluginAsset(String pluginName, String assetName) {
        return EventPluginUtilities$.MODULE$.retrievePluginAsset(this.path(), pluginName, assetName);
    }

    public Map<EventType, Seq<String>> tags() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ScalarEventType$.MODULE$), (Object)((Reservoir)this._reservoirs.apply((Object)ScalarEventType$.MODULE$)).keys().toSeq()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ImageEventType$.MODULE$), (Object)((Reservoir)this._reservoirs.apply((Object)ImageEventType$.MODULE$)).keys().toSeq()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AudioEventType$.MODULE$), (Object)((Reservoir)this._reservoirs.apply((Object)AudioEventType$.MODULE$)).keys().toSeq()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HistogramEventType$.MODULE$), (Object)((Reservoir)this._reservoirs.apply((Object)HistogramEventType$.MODULE$)).keys().toSeq()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CompressedHistogramEventType$.MODULE$), (Object)((Reservoir)this._reservoirs.apply((Object)CompressedHistogramEventType$.MODULE$)).keys().toSeq()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TensorEventType$.MODULE$), (Object)((Reservoir)this._reservoirs.apply((Object)TensorEventType$.MODULE$)).keys().toSeq()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GraphEventType$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToBoolean((this._graphDef != null ? 1 : 0) != 0)).toString()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MetaGraphEventType$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToBoolean((this._metaGraphDef != null ? 1 : 0) != 0)).toString()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RunMetadataEventType$.MODULE$), (Object)this._taggedRunMetadata.keys().toSeq())}));
    }

    private void processEvent(Event event) {
        if (this._firstEventTimeStamp < 0.0) {
            this._firstEventTimeStamp = event.getWallTime();
        }
        Event.WhatCase whatCase = event.getWhatCase();
        Event.WhatCase whatCase2 = Event.WhatCase.FILE_VERSION;
        if (!(whatCase != null ? !whatCase.equals(whatCase2) : whatCase2 != null)) {
            BoxedUnit boxedUnit;
            float newFileVersion;
            float f;
            String[] tokens = event.getFileVersion().split("brain.Event:");
            try {
                f = new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens)).last())).toFloat();
            }
            catch (NumberFormatException numberFormatException) {
                BoxedUnit boxedUnit2;
                if (EventAccumulator$.MODULE$.logger().underlying().isWarnEnabled()) {
                    EventAccumulator$.MODULE$.logger().underlying().warn("Invalid event.proto file_version. Defaulting to use of out-of-order event.step logic for purging expired events.");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                f = newFileVersion = -1.0f;
            }
            if (this._fileVersion >= 0.0f && this._fileVersion != newFileVersion) {
                if (EventAccumulator$.MODULE$.logger().underlying().isWarnEnabled()) {
                    EventAccumulator$.MODULE$.logger().underlying().warn(new StringBuilder(90).append("Found new file version for event. This will affect purging logic for TensorFlow restarts. ").append(new StringBuilder(13).append("Old: ").append(this._fileVersion).append(". New: ").append(newFileVersion).append(".").toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this._fileVersion = newFileVersion;
        }
        this.maybePurgeOrphanedData(event);
        Event.WhatCase whatCase3 = event.getWhatCase();
        if (Event.WhatCase.GRAPH_DEF.equals(whatCase3)) {
            BoxedUnit boxedUnit;
            if (this._graphDef != null) {
                if (EventAccumulator$.MODULE$.logger().underlying().isWarnEnabled()) {
                    EventAccumulator$.MODULE$.logger().underlying().warn("Found more than one graph event per run, or there was a meta-graph containing a graph definition, as well as one or more graph events. Overwriting the graph with the newest event.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this._graphDef = event.getGraphDef();
            this._graphFromMetaGraph = false;
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else if (Event.WhatCase.META_GRAPH_DEF.equals(whatCase3)) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit4;
            if (this._metaGraphDef != null) {
                if (EventAccumulator$.MODULE$.logger().underlying().isWarnEnabled()) {
                    EventAccumulator$.MODULE$.logger().underlying().warn("Found more than one meta-graph event per run. Overwriting the meta-graph with the newest event.");
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            this._metaGraphDef = event.getMetaGraphDef();
            if (this._graphDef == null || this._graphFromMetaGraph) {
                MetaGraphDef metaGraphDef = MetaGraphDef.parseFrom((ByteString)this._metaGraphDef);
                if (metaGraphDef.hasGraphDef()) {
                    BoxedUnit boxedUnit5;
                    if (this._graphDef != null) {
                        if (EventAccumulator$.MODULE$.logger().underlying().isWarnEnabled()) {
                            EventAccumulator$.MODULE$.logger().underlying().warn("Found multiple meta-graphs containing graph definitions, but did not find any graph events. Overwriting the graph with the newest meta-graph version.");
                            boxedUnit5 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit5 = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit5 = BoxedUnit.UNIT;
                    }
                    this._graphDef = metaGraphDef.getGraphDef().toByteString();
                    this._graphFromMetaGraph = true;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit6 = boxedUnit;
        } else if (Event.WhatCase.TAGGED_RUN_METADATA.equals(whatCase3)) {
            BoxedUnit boxedUnit;
            String tag = event.getTaggedRunMetadata().getTag();
            if (this._taggedRunMetadata.contains((Object)tag)) {
                if (EventAccumulator$.MODULE$.logger().underlying().isWarnEnabled()) {
                    EventAccumulator$.MODULE$.logger().underlying().warn("Found more than one run metadata event with tag '{}'. Overwriting it with the newest event.", new Object[]{tag});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this._taggedRunMetadata = this._taggedRunMetadata.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tag), (Object)event.getTaggedRunMetadata().getRunMetadata()));
            BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
        } else if (Event.WhatCase.SUMMARY.equals(whatCase3)) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(event.getSummary().getValueList()).asScala()).foreach((Function1 & Serializable & scala.Serializable)value -> {
                EventAccumulator.$anonfun$processEvent$1(this, event, value);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void maybePurgeOrphanedData(Event event) {
        block2: {
            if (!this.purgeOrphanedData()) break block2;
            if (this._fileVersion >= (float)2) {
                this.checkForRestartAndMaybePurge(event);
            } else {
                this.checkForOutOfOrderStepAndMaybePurge(event);
            }
        }
    }

    private void checkForRestartAndMaybePurge(Event event) {
        block1: {
            if (event.getSessionLog() == null) break block1;
            SessionLog.SessionStatus sessionStatus = event.getSessionLog().getStatus();
            SessionLog.SessionStatus sessionStatus2 = SessionLog.SessionStatus.START;
            if (!(sessionStatus != null ? !sessionStatus.equals(sessionStatus2) : sessionStatus2 != null)) {
                this.purge(event, false);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkForOutOfOrderStepAndMaybePurge(Event event) {
        if (event.getStep() < this._mostRecentStep) {
            Event.WhatCase whatCase = event.getWhatCase();
            Event.WhatCase whatCase2 = Event.WhatCase.SUMMARY;
            if (!(whatCase != null ? !whatCase.equals(whatCase2) : whatCase2 != null)) {
                this.purge(event, true);
                return;
            }
        }
        this._mostRecentWallTime = event.getWallTime();
        this._mostRecentStep = event.getStep();
    }

    private void purge(Event event, boolean byTags) {
        block4: {
            BoxedUnit boxedUnit;
            Map expiredPerType;
            Map map;
            Function1 & Serializable & scala.Serializable notExpired = (Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)EventAccumulator.$anonfun$purge$1(event, e));
            if (byTags) {
                Buffer tags = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(event.getSummary().getValueList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getTag(), Buffer$.MODULE$.canBuildFrom());
                map = this._reservoirs.mapValues((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToInteger((int)EventAccumulator.$anonfun$purge$3(notExpired, tags, r)));
            } else {
                map = expiredPerType = this._reservoirs.mapValues((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.filter(notExpired, x$5.filter$default$2())));
            }
            if (BoxesRunTime.unboxToInt((Object)expiredPerType.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) <= 0) break block4;
            if (EventAccumulator$.MODULE$.logger().underlying().isWarnEnabled()) {
                EventAccumulator$.MODULE$.logger().underlying().warn(new StringBuilder(120).append("Detected out of order event step likely caused by a TensorFlow restart.").append("Purging expired events between the previous step ").append(new StringBuilder(39).append("(").append(this._mostRecentStep).append(" - timestamp = ").append(this._mostRecentWallTime).append(") and the current step ").toString()).append(new StringBuilder(19).append("(").append(event.getStep()).append(" - timestamp = ").append(event.getWallTime()).append("). ").toString()).append(new StringBuilder(28).append("Removing ").append(expiredPerType.apply((Object)ScalarEventType$.MODULE$)).append(" scalars, ").append(expiredPerType.apply((Object)ImageEventType$.MODULE$)).append(" images, ").toString()).append(new StringBuilder(25).append(expiredPerType.apply((Object)AudioEventType$.MODULE$)).append(" audio, ").append(expiredPerType.apply((Object)HistogramEventType$.MODULE$)).append(" histograms, and ").toString()).append(new StringBuilder(24).append(expiredPerType.apply((Object)CompressedHistogramEventType$.MODULE$)).append("} compressed histograms.").toString()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public EventAccumulator copy(Path path, Map<EventType, Object> sizeGuidance, Seq<Object> histogramCompressionBps, boolean purgeOrphanedData) {
        return new EventAccumulator(path, sizeGuidance, histogramCompressionBps, purgeOrphanedData);
    }

    public Path copy$default$1() {
        return this.path();
    }

    public Map<EventType, Object> copy$default$2() {
        return this.sizeGuidance();
    }

    public Seq<Object> copy$default$3() {
        return this.histogramCompressionBps();
    }

    public boolean copy$default$4() {
        return this.purgeOrphanedData();
    }

    public String productPrefix() {
        return "EventAccumulator";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.path();
                break;
            }
            case 1: {
                object = this.sizeGuidance();
                break;
            }
            case 2: {
                object = this.histogramCompressionBps();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.purgeOrphanedData());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EventAccumulator;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.sizeGuidance()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.histogramCompressionBps()));
        n = Statics.mix((int)n, (int)(this.purgeOrphanedData() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)4);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EventAccumulator)) return false;
        boolean bl = true;
        if (!bl) return false;
        EventAccumulator eventAccumulator = (EventAccumulator)x$1;
        Path path = this.path();
        Path path2 = eventAccumulator.path();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!((Object)path).equals(path2)) return false;
        Map<EventType, Object> map = this.sizeGuidance();
        Map<EventType, Object> map2 = eventAccumulator.sizeGuidance();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Seq<Object> seq = this.histogramCompressionBps();
        Seq<Object> seq2 = eventAccumulator.histogramCompressionBps();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.purgeOrphanedData() != eventAccumulator.purgeOrphanedData()) return false;
        if (!eventAccumulator.canEqual(this)) return false;
        return true;
    }

    private final void EventLoaderLock$lzycompute$1() {
        EventAccumulator eventAccumulator = this;
        synchronized (eventAccumulator) {
            if (this.EventLoaderLock$module == null) {
                this.EventLoaderLock$module = new EventAccumulator$EventLoaderLock$(this);
            }
        }
    }

    private final double liftedTree1$1() {
        double d;
        try {
            this.processEvent((Event)((Iterator)this.eventLoader.apply()).next());
            d = this._firstEventTimeStamp;
        }
        catch (Throwable t) {
            throw new IllegalStateException("No event timestamp could be found.", t);
        }
        return d;
    }

    public static final /* synthetic */ void $anonfun$processEvent$1(EventAccumulator $this, Event event$1, Summary.Value value) {
        BoxedUnit boxedUnit;
        if (value.hasMetadata()) {
            String tag = value.getTag();
            if (!$this._summaryMetadata.contains((Object)tag)) {
                $this._summaryMetadata = $this._summaryMetadata.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tag), (Object)value.getMetadata()));
                SummaryMetadata.PluginData pluginData = value.getMetadata().getPluginData();
                if (pluginData.getPluginName() != null) {
                    ((MapLike)$this._pluginTagContent.getOrElseUpdate((Object)pluginData.getPluginName(), (Function0 & Serializable & scala.Serializable)() -> Map$.MODULE$.empty())).update((Object)tag, (Object)pluginData.getContent().toStringUtf8());
                    boxedUnit = BoxedUnit.UNIT;
                } else if (EventAccumulator$.MODULE$.logger().underlying().isWarnEnabled()) {
                    EventAccumulator$.MODULE$.logger().underlying().warn("The summary with tag '{}' is oddly not associated with any plugin.", new Object[]{tag});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Summary.Value.ValueCase valueCase = value.getValueCase();
        if (Summary.Value.ValueCase.SIMPLE_VALUE.equals(valueCase)) {
            ScalarEventRecord record = new ScalarEventRecord(event$1.getWallTime(), event$1.getStep(), value.getSimpleValue());
            Reservoir qual$1 = (Reservoir)$this._reservoirs.apply((Object)ScalarEventType$.MODULE$);
            String x$10 = value.getTag();
            ScalarEventRecord x$11 = record;
            Function1 x$12 = qual$1.add$default$3();
            qual$1.add(x$10, x$11, x$12);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (Summary.Value.ValueCase.IMAGE.equals(valueCase)) {
            Summary.Image image = value.getImage();
            ImageValue imageValue = new ImageValue(image.getEncodedImageString(), image.getWidth(), image.getHeight(), image.getColorspace());
            ImageEventRecord record = new ImageEventRecord(event$1.getWallTime(), event$1.getStep(), imageValue);
            Reservoir qual$2 = (Reservoir)$this._reservoirs.apply((Object)ImageEventType$.MODULE$);
            String x$13 = value.getTag();
            ImageEventRecord x$14 = record;
            Function1 x$15 = qual$2.add$default$3();
            qual$2.add(x$13, x$14, x$15);
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else if (Summary.Value.ValueCase.AUDIO.equals(valueCase)) {
            Summary.Audio audio = value.getAudio();
            AudioValue audioValue = new AudioValue(audio.getEncodedAudioString(), audio.getContentType(), audio.getSampleRate(), audio.getNumChannels(), audio.getLengthFrames());
            AudioEventRecord record = new AudioEventRecord(event$1.getWallTime(), event$1.getStep(), audioValue);
            Reservoir qual$3 = (Reservoir)$this._reservoirs.apply((Object)AudioEventType$.MODULE$);
            String x$16 = value.getTag();
            AudioEventRecord x$17 = record;
            Function1 x$18 = qual$3.add$default$3();
            qual$3.add(x$16, x$17, x$18);
            BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
        } else if (Summary.Value.ValueCase.HISTO.equals(valueCase)) {
            HistogramProto histogram = value.getHisto();
            HistogramValue histogramValue = new HistogramValue(histogram.getMin(), histogram.getMax(), histogram.getNum(), histogram.getSum(), histogram.getSumSquares(), (Seq<Object>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(histogram.getBucketLimitList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(x$2)), Buffer$.MODULE$.canBuildFrom())), (Seq<Object>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(histogram.getBucketList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(x$3)), Buffer$.MODULE$.canBuildFrom())));
            HistogramEventRecord record = new HistogramEventRecord(event$1.getWallTime(), event$1.getStep(), histogramValue);
            Reservoir qual$4 = (Reservoir)$this._reservoirs.apply((Object)HistogramEventType$.MODULE$);
            String x$19 = value.getTag();
            HistogramEventRecord x$20 = record;
            Function1 x$21 = qual$4.add$default$3();
            qual$4.add(x$19, x$20, x$21);
            BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
        } else if (Summary.Value.ValueCase.TENSOR.equals(valueCase)) {
            String tag = value.getTag() == null ? value.getNodeName() : value.getTag();
            TensorEventRecord record = new TensorEventRecord(event$1.getWallTime(), event$1.getStep(), value.getTensor());
            Reservoir qual$5 = (Reservoir)$this._reservoirs.apply((Object)TensorEventType$.MODULE$);
            String x$22 = tag;
            TensorEventRecord x$23 = record;
            Function1 x$24 = qual$5.add$default$3();
            qual$5.add(x$22, x$23, x$24);
            BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit7;
            if (EventAccumulator$.MODULE$.logger().underlying().isWarnEnabled()) {
                EventAccumulator$.MODULE$.logger().underlying().warn("Unrecognized value type ({}) is ignored.", new Object[]{value.getValueCase()});
                boxedUnit7 = BoxedUnit.UNIT;
            } else {
                boxedUnit7 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit8 = boxedUnit7;
        }
    }

    public static final /* synthetic */ boolean $anonfun$purge$1(Event event$2, EventRecord e) {
        return e.step() < event$2.getStep();
    }

    public static final /* synthetic */ int $anonfun$purge$3(Function1 notExpired$1, Buffer tags$1, Reservoir r) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)tags$1.map((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToInteger((int)r.filter(notExpired$1, new Some((Object)t))), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public EventAccumulator(Path path, Map<EventType, Object> sizeGuidance, Seq<Object> histogramCompressionBps, boolean purgeOrphanedData) {
        this.path = path;
        this.sizeGuidance = sizeGuidance;
        this.histogramCompressionBps = histogramCompressionBps;
        this.purgeOrphanedData = purgeOrphanedData;
        Product.$init$((Product)this);
        this.eventLoader = EventAccumulator$.MODULE$.eventLoaderFromPath(path);
        this._firstEventTimeStamp = -1.0;
        this._fileVersion = -1.0f;
        this._mostRecentWallTime = -1.0;
        this._mostRecentStep = -1L;
        this._actualSizeGuidance = EventAccumulator$.MODULE$.DEFAULT_SIZE_GUIDANCE().$plus$plus(sizeGuidance);
        Tuple2[] tuple2Array = new Tuple2[5];
        tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ScalarEventType$.MODULE$), new Reservoir(BoxesRunTime.unboxToInt((Object)this._actualSizeGuidance.apply((Object)ScalarEventType$.MODULE$)), Reservoir$.MODULE$.apply$default$2(), Reservoir$.MODULE$.apply$default$3()));
        tuple2Array[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ImageEventType$.MODULE$), new Reservoir(BoxesRunTime.unboxToInt((Object)this._actualSizeGuidance.apply((Object)ImageEventType$.MODULE$)), Reservoir$.MODULE$.apply$default$2(), Reservoir$.MODULE$.apply$default$3()));
        tuple2Array[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AudioEventType$.MODULE$), new Reservoir(BoxesRunTime.unboxToInt((Object)this._actualSizeGuidance.apply((Object)AudioEventType$.MODULE$)), Reservoir$.MODULE$.apply$default$2(), Reservoir$.MODULE$.apply$default$3()));
        tuple2Array[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HistogramEventType$.MODULE$), new Reservoir(BoxesRunTime.unboxToInt((Object)this._actualSizeGuidance.apply((Object)HistogramEventType$.MODULE$)), Reservoir$.MODULE$.apply$default$2(), Reservoir$.MODULE$.apply$default$3()));
        int x$7 = BoxesRunTime.unboxToInt((Object)this._actualSizeGuidance.apply((Object)CompressedHistogramEventType$.MODULE$));
        boolean x$8 = false;
        long x$9 = Reservoir$.MODULE$.apply$default$2();
        tuple2Array[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CompressedHistogramEventType$.MODULE$), new Reservoir(x$7, x$9, x$8));
        this._reservoirs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        this._graphFromMetaGraph = false;
        this._taggedRunMetadata = Predef$.MODULE$.Map().empty();
        this._summaryMetadata = Predef$.MODULE$.Map().empty();
        this._pluginTagContent = Map$.MODULE$.empty();
    }
}

