/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.api.io.events;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.nio.file.Path;
import org.platanios.tensorflow.api.io.CompressionType;
import org.platanios.tensorflow.api.io.NoCompression$;
import org.platanios.tensorflow.api.io.events.EventFileReader;
import org.platanios.tensorflow.api.utilities.Disposer$;
import org.platanios.tensorflow.api.utilities.NativeHandleWrapper;
import org.platanios.tensorflow.api.utilities.NativeHandleWrapper$;
import org.platanios.tensorflow.api.utilities.NativeHandleWrapper$Lock$;
import org.platanios.tensorflow.jni.RecordReader$;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

public final class EventFileReader$ {
    public static EventFileReader$ MODULE$;
    private final Logger logger;

    static {
        new EventFileReader$();
    }

    public CompressionType $lessinit$greater$default$2() {
        return NoCompression$.MODULE$;
    }

    public Logger logger() {
        return this.logger;
    }

    public EventFileReader apply(Path filePath, CompressionType compressionType) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Opening a TensorFlow events file located at '{}'.", new Object[]{filePath.toAbsolutePath()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        long nativeHandle = RecordReader$.MODULE$.newRecordReaderWrapper(((Object)filePath.toAbsolutePath()).toString(), compressionType.name(), 0L);
        NativeHandleWrapper nativeHandleWrapper = NativeHandleWrapper$.MODULE$.apply(nativeHandle);
        JFunction0.mcV.sp & java.io.Serializable & Serializable closeFn = (JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            NativeHandleWrapper$Lock$ nativeHandleWrapper$Lock$ = nativeHandleWrapper.Lock();
            synchronized (nativeHandleWrapper$Lock$) {
                if (nativeHandleWrapper.handle() != 0L) {
                    RecordReader$.MODULE$.deleteRecordReaderWrapper(nativeHandleWrapper.handle());
                    nativeHandleWrapper.handle_$eq(0L);
                }
            }
        };
        EventFileReader eventFileReader = new EventFileReader(filePath, compressionType, nativeHandleWrapper, (Function0<BoxedUnit>)closeFn);
        Disposer$.MODULE$.add(eventFileReader, (Function0<BoxedUnit>)closeFn);
        return eventFileReader;
    }

    public CompressionType apply$default$2() {
        return NoCompression$.MODULE$;
    }

    private EventFileReader$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)"Event File Reader"));
    }
}

