/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.api.io.events;

import java.io.BufferedOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.platanios.tensorflow.api.io.events.EventWriter$;
import org.platanios.tensorflow.api.utilities.CRC32C$;
import org.platanios.tensorflow.api.utilities.Coding$;
import org.tensorflow.util.Event;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eb!B\u0001\u0003\u0001\u0011q!aC#wK:$xK]5uKJT!a\u0001\u0003\u0002\r\u00154XM\u001c;t\u0015\t)a!\u0001\u0002j_*\u0011q\u0001C\u0001\u0004CBL'BA\u0005\u000b\u0003)!XM\\:pe\u001adwn\u001e\u0006\u0003\u00171\t\u0011\u0002\u001d7bi\u0006t\u0017n\\:\u000b\u00035\t1a\u001c:h'\t\u0001q\u0002\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\u0005\t-\u0001\u0011)\u0019!C\u00011\u0005Qqo\u001c:lS:<G)\u001b:\u0004\u0001U\t\u0011\u0004\u0005\u0002\u001bC5\t1D\u0003\u0002\u001d;\u0005!a-\u001b7f\u0015\tqr$A\u0002oS>T\u0011\u0001I\u0001\u0005U\u00064\u0018-\u0003\u0002#7\t!\u0001+\u0019;i\u0011!!\u0003A!A!\u0002\u0013I\u0012aC<pe.Lgn\u001a#je\u0002B\u0001B\n\u0001\u0003\u0006\u0004%\taJ\u0001\u000fM&dWM\\1nKB\u0013XMZ5y+\u0005A\u0003CA\u00151\u001d\tQc\u0006\u0005\u0002,#5\tAF\u0003\u0002./\u00051AH]8pizJ!aL\t\u0002\rA\u0013X\rZ3g\u0013\t\t$G\u0001\u0004TiJLgn\u001a\u0006\u0003_EA\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0010M&dWM\\1nKB\u0013XMZ5yA!Aa\u0007\u0001BC\u0002\u0013\u0005q%\u0001\bgS2,g.Y7f'V4g-\u001b=\t\u0011a\u0002!\u0011!Q\u0001\n!\nqBZ5mK:\fW.Z*vM\u001aL\u0007\u0010\t\u0005\u0007u\u0001!\t\u0001B\u001e\u0002\rqJg.\u001b;?)\u0011adh\u0010!\u0011\u0005u\u0002Q\"\u0001\u0002\t\u000bYI\u0004\u0019A\r\t\u000b\u0019J\u0004\u0019\u0001\u0015\t\u000fYJ\u0004\u0013!a\u0001Q!I!\t\u0001a\u0001\u0002\u0003\u0006K!G\u0001\n?\u001aLG.\u001a)bi\"Da\u0001\u0012\u0001!B\u0013)\u0015aC0gS2,7\u000b\u001e:fC6\u00042\u0001\u0005$I\u0013\t9\u0015C\u0001\u0004PaRLwN\u001c\t\u0003\u0013.k\u0011A\u0013\u0006\u0003\u000b}I!\u0001\u0014&\u0003)\t+hMZ3sK\u0012|U\u000f\u001e9viN#(/Z1n\u0011\u0019q\u0005\u0001)Q\u0005\u001f\u0006)rL\\;n\u001fV$8\u000f^1oI&tw-\u0012<f]R\u001c\bC\u0001\tQ\u0013\t\t\u0016CA\u0002J]RDQa\u0015\u0001\u0005\u0002a\t\u0001BZ5mKB\u000bG\u000f\u001b\u0005\u0006+\u0002!\tAV\u0001\u000bS:LG/[1mSj,G#A,\u0011\u0005AA\u0016BA-\u0012\u0005\u0011)f.\u001b;\t\u000bm\u0003A\u0011\u0001/\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0005]k\u0006\"\u00020[\u0001\u0004y\u0016!B3wK:$\bC\u00011e\u001b\u0005\t'B\u00012d\u0003\u0011)H/\u001b7\u000b\u0005%a\u0011BA3b\u0005\u0015)e/\u001a8u\u0011\u00159\u0007\u0001\"\u0001W\u0003\u00151G.^:i\u0011\u0015I\u0007\u0001\"\u0001W\u0003\u0015\u0019Gn\\:f\u0011\u0019Y\u0007\u0001)C\u0005Y\u0006\u0011b-\u001b7f\u0011\u0006\u001cH)[:baB,\u0017M]3e+\u0005i\u0007C\u0001\to\u0013\ty\u0017CA\u0004C_>dW-\u00198\b\rE\u0014\u0001\u0012\u0001\u0003s\u0003-)e/\u001a8u/JLG/\u001a:\u0011\u0005u\u001ahAB\u0001\u0003\u0011\u0003!Ao\u0005\u0002t\u001f!)!h\u001dC\u0001mR\t!\u000f\u0003\u0005yg\n\u0007I\u0011A:z\u0003\u0019awnZ4feV\t!\u0010E\u0002|\u0003\u000bi\u0011\u0001 \u0006\u0003{z\fAb]2bY\u0006dwnZ4j]\u001eT1a`A\u0001\u0003!!\u0018\u0010]3tC\u001a,'BAA\u0002\u0003\r\u0019w.\\\u0005\u0004\u0003\u000fa(A\u0002'pO\u001e,'\u000fC\u0004\u0002\fM\u0004\u000b\u0011\u0002>\u0002\u000f1|wmZ3sA!I\u0011qB:C\u0002\u0013\u00051oJ\u0001\u000f-\u0016\u00136+S(O?B\u0013VIR%Y\u0011\u001d\t\u0019b\u001dQ\u0001\n!\nqBV#S'&{ej\u0018)S\u000b\u001aK\u0005\f\t\u0005\u000b\u0003/\u0019(\u0019!C\u0001g\u0006e\u0011A\u0004,F%NKuJT0O+6\u0013UIU\u000b\u0002\u001f\"9\u0011QD:!\u0002\u0013y\u0015a\u0004,F%NKuJT0O+6\u0013UI\u0015\u0011\t\u0015\u0005\u00052/%A\u0005\u0002\u0011\t\u0019#A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003KQ3\u0001KA\u0014W\t\tI\u0003\u0005\u0003\u0002,\u0005URBAA\u0017\u0015\u0011\ty#!\r\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001a#\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0012Q\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class EventWriter {
    private final Path workingDir;
    private final String filenamePrefix;
    private final String filenameSuffix;
    private Path _filePath;
    private Option<BufferedOutputStream> _fileStream;
    private int _numOutstandingEvents;

    public Path workingDir() {
        return this.workingDir;
    }

    public String filenamePrefix() {
        return this.filenamePrefix;
    }

    public String filenameSuffix() {
        return this.filenameSuffix;
    }

    public Path filePath() {
        block0: {
            if (this._filePath != null) break block0;
            this.initialize();
        }
        return this._filePath;
    }

    public void initialize() {
        block8: {
            BoxedUnit boxedUnit;
            boolean initialized = false;
            if (this._fileStream.isDefined()) {
                if (this.fileHasDisappeared()) {
                    if (this._numOutstandingEvents > 0) {
                        if (EventWriter$.MODULE$.logger().underlying().isWarnEnabled()) {
                            EventWriter$.MODULE$.logger().underlying().warn("Re-initialization: attempting to open a new file. {} events will be lost.", new Object[]{BoxesRunTime.boxToInteger((int)this._numOutstandingEvents)});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    initialized = true;
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (initialized) break block8;
            double currentTime = (double)System.currentTimeMillis() / 1000.0;
            String hostname = InetAddress.getLocalHost().getHostName();
            String arg$macro$49 = this.filenamePrefix();
            int arg$macro$50 = (int)currentTime;
            String arg$macro$51 = hostname;
            String arg$macro$52 = this.filenameSuffix();
            this._filePath = this.workingDir().resolve(new StringOps("%s.out.tfevents.%010d.%s%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$49, BoxesRunTime.boxToInteger((int)arg$macro$50), arg$macro$51, arg$macro$52})));
            this._fileStream = new Some((Object)new BufferedOutputStream(Files.newOutputStream(this._filePath, StandardOpenOption.CREATE_NEW, StandardOpenOption.APPEND)));
            this._numOutstandingEvents = 0;
            Event.Builder eventBuilder = Event.newBuilder();
            eventBuilder.setWallTime(currentTime);
            eventBuilder.setFileVersion(new StringBuilder(0).append(EventWriter$.MODULE$.VERSION_PREFIX()).append(EventWriter$.MODULE$.VERSION_NUMBER()).toString());
            this.write(eventBuilder.build());
            this.flush();
        }
    }

    public void write(Event event) {
        if (this._filePath == null) {
            this.initialize();
        }
        ++this._numOutstandingEvents;
        byte[] recordBytes = event.toByteArray();
        byte[] encLength = Coding$.MODULE$.encodeFixedInt64(recordBytes.length, Coding$.MODULE$.encodeFixedInt64$default$2());
        byte[] encLengthMaskedCrc = Coding$.MODULE$.encodeFixedInt32(CRC32C$.MODULE$.mask(CRC32C$.MODULE$.value(encLength, CRC32C$.MODULE$.value$default$2())), Coding$.MODULE$.encodeFixedInt32$default$2());
        byte[] encDataMaskedCrc = Coding$.MODULE$.encodeFixedInt32(CRC32C$.MODULE$.mask(CRC32C$.MODULE$.value(recordBytes, CRC32C$.MODULE$.value$default$2())), Coding$.MODULE$.encodeFixedInt32$default$2());
        this._fileStream.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.write((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(encLength)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(encLengthMaskedCrc)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())))).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(recordBytes)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())))).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(encDataMaskedCrc)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())));
            return BoxedUnit.UNIT;
        });
    }

    public void flush() {
        this._fileStream.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.flush();
            return BoxedUnit.UNIT;
        });
        this._numOutstandingEvents = 0;
    }

    public void close() {
        this._fileStream.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        this._numOutstandingEvents = 0;
    }

    private boolean fileHasDisappeared() {
        boolean bl;
        if (Files.exists(this._filePath, new LinkOption[0])) {
            bl = false;
        } else {
            BoxedUnit boxedUnit;
            if (EventWriter$.MODULE$.logger().underlying().isErrorEnabled()) {
                EventWriter$.MODULE$.logger().underlying().error("The events file '{}' has disappeared.", new Object[]{this._filePath});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = true;
        }
        return bl;
    }

    public EventWriter(Path workingDir, String filenamePrefix, String filenameSuffix) {
        this.workingDir = workingDir;
        this.filenamePrefix = filenamePrefix;
        this.filenameSuffix = filenameSuffix;
        this._fileStream = None$.MODULE$;
        this._numOutstandingEvents = 0;
    }
}

