/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.api.learn;

import java.io.Serializable;
import java.nio.file.Path;
import org.platanios.tensorflow.api.config.CheckpointConfig;
import org.platanios.tensorflow.api.config.ClusterConfig;
import org.platanios.tensorflow.api.config.TimeBasedCheckpoints;
import org.platanios.tensorflow.api.core.client.SessionConfig;
import org.platanios.tensorflow.api.learn.Configuration;
import org.platanios.tensorflow.api.learn.Configuration$CHIEF$;
import org.platanios.tensorflow.api.learn.Configuration$PARAMETER_SERVER$;
import org.platanios.tensorflow.api.learn.Configuration$WORKER$;
import org.platanios.tensorflow.jni.InvalidArgumentException;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public final class Configuration$
implements scala.Serializable {
    public static Configuration$ MODULE$;
    private final String TF_CONFIG_ENV;
    private final String TASK_ENV_KEY;
    private final String TASK_TYPE_KEY;
    private final String TASK_ID_KEY;
    private final String CLUSTER_KEY;
    private final String LOCAL_MASTER;
    private final String GRPC_SCHEME;

    static {
        new Configuration$();
    }

    public Option<Path> $lessinit$greater$default$1() {
        return None$.MODULE$;
    }

    public Option<SessionConfig> $lessinit$greater$default$2() {
        return None$.MODULE$;
    }

    public CheckpointConfig $lessinit$greater$default$3() {
        return new TimeBasedCheckpoints(600, 5, 10000);
    }

    public Option<Object> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public String TF_CONFIG_ENV() {
        return this.TF_CONFIG_ENV;
    }

    public String TASK_ENV_KEY() {
        return this.TASK_ENV_KEY;
    }

    public String TASK_TYPE_KEY() {
        return this.TASK_TYPE_KEY;
    }

    public String TASK_ID_KEY() {
        return this.TASK_ID_KEY;
    }

    public String CLUSTER_KEY() {
        return this.CLUSTER_KEY;
    }

    public String LOCAL_MASTER() {
        return this.LOCAL_MASTER;
    }

    public String GRPC_SCHEME() {
        return this.GRPC_SCHEME;
    }

    public String getNetworkAddress(ClusterConfig clusterConfig, String taskType, int taskIndex) throws InvalidArgumentException {
        Predef$.MODULE$.require(clusterConfig.jobs().contains((Object)taskType), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("'").append(taskType).append("' is not a valid job name in the provided cluster configuration: ").append(clusterConfig).append("\n\n").append(new StringBuilder(68).append("Note that these values may be coming from the ").append(MODULE$.TF_CONFIG_ENV()).append(" environment variable.").toString()).toString());
        Map jobTasks = (Map)clusterConfig.jobTasks(taskType).get();
        Predef$.MODULE$.require(jobTasks.contains((Object)BoxesRunTime.boxToInteger((int)taskIndex)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("'").append(taskIndex).append("' is not a valid task index for job '").append(taskType).append("' ").append(new StringBuilder(41).append("in the provided cluster configuration: ").append(clusterConfig).append("\n\n").toString()).append(new StringBuilder(68).append("Note that these values may be coming from the ").append(MODULE$.TF_CONFIG_ENV()).append(" environment variable.").toString()).toString());
        return new StringBuilder(0).append(this.GRPC_SCHEME()).append(jobTasks.apply((Object)BoxesRunTime.boxToInteger((int)taskIndex))).toString();
    }

    public int countParameterServers(ClusterConfig clusterSpec) {
        return clusterSpec.jobs().count((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Configuration$.$anonfun$countParameterServers$1(x$5)));
    }

    public int countWorkers(ClusterConfig clusterSpec) {
        return clusterSpec.jobs().count((Function1 & Serializable & scala.Serializable)j -> BoxesRunTime.boxToBoolean((boolean)Configuration$.$anonfun$countWorkers$1(j)));
    }

    public Configuration apply(Option<Path> workingDir, Option<SessionConfig> sessionConfig, CheckpointConfig checkpointConfig, Option<Object> randomSeed) {
        return new Configuration(workingDir, sessionConfig, checkpointConfig, randomSeed);
    }

    public Option<Path> apply$default$1() {
        return None$.MODULE$;
    }

    public Option<SessionConfig> apply$default$2() {
        return None$.MODULE$;
    }

    public CheckpointConfig apply$default$3() {
        return new TimeBasedCheckpoints(600, 5, 10000);
    }

    public Option<Object> apply$default$4() {
        return None$.MODULE$;
    }

    public Option<Tuple4<Option<Path>, Option<SessionConfig>, CheckpointConfig, Option<Object>>> unapply(Configuration x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4(x$0.workingDir(), x$0.sessionConfig(), (Object)x$0.checkpointConfig(), x$0.randomSeed()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$countParameterServers$1(String x$5) {
        String string = x$5;
        String string2 = Configuration$PARAMETER_SERVER$.MODULE$.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$countWorkers$1(String j) {
        String string = j;
        String string2 = Configuration$WORKER$.MODULE$.name();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = j;
        String string4 = Configuration$CHIEF$.MODULE$.name();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private Configuration$() {
        MODULE$ = this;
        this.TF_CONFIG_ENV = "TF_CONFIG";
        this.TASK_ENV_KEY = "task";
        this.TASK_TYPE_KEY = "type";
        this.TASK_ID_KEY = "index";
        this.CLUSTER_KEY = "cluster";
        this.LOCAL_MASTER = "";
        this.GRPC_SCHEME = "grpc://";
    }
}

