/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.api.learn;

import io.circe.Decoder$;
import io.circe.HCursor;
import io.circe.Json;
import io.circe.KeyDecoder$;
import java.io.Serializable;
import java.nio.file.Path;
import org.platanios.tensorflow.api.config.CheckpointConfig;
import org.platanios.tensorflow.api.config.ClusterConfig;
import org.platanios.tensorflow.api.config.JobConfig;
import org.platanios.tensorflow.api.config.JobConfig$;
import org.platanios.tensorflow.api.core.client.SessionConfig;
import org.platanios.tensorflow.api.core.package$exception$;
import org.platanios.tensorflow.api.learn.Configuration$;
import org.platanios.tensorflow.api.learn.Configuration$CHIEF$;
import org.platanios.tensorflow.api.learn.Configuration$EVALUATOR$;
import org.platanios.tensorflow.api.learn.Configuration$WORKER$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple7;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\reg\u0001B\u0001\u0003\u00016\u0011QbQ8oM&<WO]1uS>t'BA\u0002\u0005\u0003\u0015aW-\u0019:o\u0015\t)a!A\u0002ba&T!a\u0002\u0005\u0002\u0015Q,gn]8sM2|wO\u0003\u0002\n\u0015\u0005I\u0001\u000f\\1uC:Lwn\u001d\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0018!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011q\"F\u0005\u0003-A\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u00101%\u0011\u0011\u0004\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t7\u0001\u0011)\u001a!C\u00019\u0005Qqo\u001c:lS:<G)\u001b:\u0016\u0003u\u00012a\u0004\u0010!\u0013\ty\u0002C\u0001\u0004PaRLwN\u001c\t\u0003C!j\u0011A\t\u0006\u0003G\u0011\nAAZ5mK*\u0011QEJ\u0001\u0004]&|'\"A\u0014\u0002\t)\fg/Y\u0005\u0003S\t\u0012A\u0001U1uQ\"A1\u0006\u0001B\tB\u0003%Q$A\u0006x_J\\\u0017N\\4ESJ\u0004\u0003\u0002C\u0017\u0001\u0005+\u0007I\u0011\u0001\u0018\u0002\u001bM,7o]5p]\u000e{gNZ5h+\u0005y\u0003cA\b\u001faA\u0011\u0011GN\u0007\u0002e)\u00111\u0007N\u0001\u0007G2LWM\u001c;\u000b\u0005U\"\u0011\u0001B2pe\u0016L!a\u000e\u001a\u0003\u001bM+7o]5p]\u000e{gNZ5h\u0011!I\u0004A!E!\u0002\u0013y\u0013AD:fgNLwN\\\"p]\u001aLw\r\t\u0005\tw\u0001\u0011)\u001a!C\u0001y\u0005\u00012\r[3dWB|\u0017N\u001c;D_:4\u0017nZ\u000b\u0002{A\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tB\u0001\u0007G>tg-[4\n\u0005\t{$\u0001E\"iK\u000e\\\u0007o\\5oi\u000e{gNZ5h\u0011!!\u0005A!E!\u0002\u0013i\u0014!E2iK\u000e\\\u0007o\\5oi\u000e{gNZ5hA!Aa\t\u0001BK\u0002\u0013\u0005q)\u0001\u0006sC:$w.\\*fK\u0012,\u0012\u0001\u0013\t\u0004\u001fyI\u0005CA\bK\u0013\tY\u0005CA\u0002J]RD\u0001\"\u0014\u0001\u0003\u0012\u0003\u0006I\u0001S\u0001\fe\u0006tGm\\7TK\u0016$\u0007\u0005C\u0003P\u0001\u0011\u0005\u0001+\u0001\u0004=S:LGO\u0010\u000b\u0006#N#VK\u0016\t\u0003%\u0002i\u0011A\u0001\u0005\b79\u0003\n\u00111\u0001\u001e\u0011\u001dic\n%AA\u0002=Bqa\u000f(\u0011\u0002\u0003\u0007Q\bC\u0004G\u001dB\u0005\t\u0019\u0001%\t\u0015a\u0003\u0001\u0013!A\u0002B\u0003%\u0011,A\u0002yIQ\u0002\u0012b\u0004.]A&\u0003\u0017*S6\n\u0005m\u0003\"A\u0002+va2,w\u0007E\u0002\u0010=u\u0003\"A\u00100\n\u0005}{$!D\"mkN$XM]\"p]\u001aLw\r\u0005\u0002bQ:\u0011!M\u001a\t\u0003GBi\u0011\u0001\u001a\u0006\u0003K2\ta\u0001\u0010:p_Rt\u0014BA4\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011N\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d\u0004\u0002CA\bm\u0013\ti\u0007CA\u0004C_>dW-\u00198\t\u000f=\u0004!\u0019!C\u0001a\u0006i1\r\\;ti\u0016\u00148i\u001c8gS\u001e,\u0012\u0001\u0018\u0005\u0007e\u0002\u0001\u000b\u0011\u0002/\u0002\u001d\rdWo\u001d;fe\u000e{gNZ5hA!9A\u000f\u0001b\u0001\n\u0003)\u0018\u0001\u0003;bg.$\u0016\u0010]3\u0016\u0003\u0001Daa\u001e\u0001!\u0002\u0013\u0001\u0017!\u0003;bg.$\u0016\u0010]3!\u0011\u001dI\bA1A\u0005\u0002i\f\u0011\u0002^1tW&sG-\u001a=\u0016\u0003%Ca\u0001 \u0001!\u0002\u0013I\u0015A\u0003;bg.Le\u000eZ3yA!9a\u0010\u0001b\u0001\n\u0003)\u0018AB7bgR,'\u000fC\u0004\u0002\u0002\u0001\u0001\u000b\u0011\u00021\u0002\u000f5\f7\u000f^3sA!A\u0011Q\u0001\u0001C\u0002\u0013\u0005!0A\nok6\u0004\u0016M]1nKR,'oU3sm\u0016\u00148\u000fC\u0004\u0002\n\u0001\u0001\u000b\u0011B%\u0002)9,X\u000eU1sC6,G/\u001a:TKJ4XM]:!\u0011!\ti\u0001\u0001b\u0001\n\u0003Q\u0018A\u00038v[^{'o[3sg\"9\u0011\u0011\u0003\u0001!\u0002\u0013I\u0015a\u00038v[^{'o[3sg\u0002B\u0011\"!\u0006\u0001\u0005\u0004%\t!a\u0006\u0002\u000f%\u001c8\t[5fMV\t1\u000eC\u0004\u0002\u001c\u0001\u0001\u000b\u0011B6\u0002\u0011%\u001c8\t[5fM\u0002B\u0001\"a\b\u0001\u0005\u0004%\t!^\u0001\u0011KZ\fG.^1uS>tW*Y:uKJDq!a\t\u0001A\u0003%\u0001-A\tfm\u0006dW/\u0019;j_:l\u0015m\u001d;fe\u0002B\u0011\"a\n\u0001\u0003\u0003%\t!!\u000b\u0002\t\r|\u0007/\u001f\u000b\n#\u0006-\u0012QFA\u0018\u0003cA\u0001bGA\u0013!\u0003\u0005\r!\b\u0005\t[\u0005\u0015\u0002\u0013!a\u0001_!A1(!\n\u0011\u0002\u0003\u0007Q\b\u0003\u0005G\u0003K\u0001\n\u00111\u0001I\u0011%\t)\u0004AI\u0001\n\u0003\t9$\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e\"fA\u000f\u0002<-\u0012\u0011Q\b\t\u0005\u0003\u007f\tI%\u0004\u0002\u0002B)!\u00111IA#\u0003%)hn\u00195fG.,GMC\u0002\u0002HA\t!\"\u00198o_R\fG/[8o\u0013\u0011\tY%!\u0011\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002P\u0001\t\n\u0011\"\u0001\u0002R\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA*U\ry\u00131\b\u0005\n\u0003/\u0002\u0011\u0013!C\u0001\u00033\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\\)\u001aQ(a\u000f\t\u0013\u0005}\u0003!%A\u0005\u0002\u0005\u0005\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003GR3\u0001SA\u001e\u0011%\t9\u0007AA\u0001\n\u0003\nI'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003W\u0002B!!\u001c\u0002t5\u0011\u0011q\u000e\u0006\u0004\u0003c2\u0013\u0001\u00027b]\u001eL1![A8\u0011!\t9\bAA\u0001\n\u0003Q\u0018\u0001\u00049s_\u0012,8\r^!sSRL\b\"CA>\u0001\u0005\u0005I\u0011AA?\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a \u0002\u0006B\u0019q\"!!\n\u0007\u0005\r\u0005CA\u0002B]fD\u0011\"a\"\u0002z\u0005\u0005\t\u0019A%\u0002\u0007a$\u0013\u0007C\u0005\u0002\f\u0002\t\t\u0011\"\u0011\u0002\u000e\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0010B1\u0011\u0011SAL\u0003\u007fj!!a%\u000b\u0007\u0005U\u0005#\u0001\u0006d_2dWm\u0019;j_:LA!!'\u0002\u0014\nA\u0011\n^3sCR|'\u000fC\u0005\u0002\u001e\u0002\t\t\u0011\"\u0001\u0002 \u0006A1-\u00198FcV\fG\u000eF\u0002l\u0003CC!\"a\"\u0002\u001c\u0006\u0005\t\u0019AA@\u0011%\t)\u000bAA\u0001\n\u0003\n9+\u0001\u0005iCND7i\u001c3f)\u0005I\u0005\"CAV\u0001\u0005\u0005I\u0011IAW\u0003!!xn\u0015;sS:<GCAA6\u0011%\t\t\fAA\u0001\n\u0003\n\u0019,\u0001\u0004fcV\fGn\u001d\u000b\u0004W\u0006U\u0006BCAD\u0003_\u000b\t\u00111\u0001\u0002\u0000\u001d9\u0011\u0011\u0018\u0002\t\u0002\u0005m\u0016!D\"p]\u001aLw-\u001e:bi&|g\u000eE\u0002S\u0003{3a!\u0001\u0002\t\u0002\u0005}6\u0003BA_\u001d]AqaTA_\t\u0003\t\u0019\r\u0006\u0002\u0002<\"Q\u0011qYA_\u0005\u0004%\tAA;\u0002\u001bQ3ulQ(O\r&;u,\u0012(W\u0011!\tY-!0!\u0002\u0013\u0001\u0017A\u0004+G?\u000e{eJR%H?\u0016se\u000b\t\u0005\u000b\u0003\u001f\fiL1A\u0005\u0002\t)\u0018\u0001\u0004+B'.{VI\u0014,`\u0017\u0016K\u0006\u0002CAj\u0003{\u0003\u000b\u0011\u00021\u0002\u001bQ\u000b5kS0F\u001dZ{6*R-!\u0011)\t9.!0C\u0002\u0013\u0005!!^\u0001\u000e)\u0006\u001b6j\u0018+Z!\u0016{6*R-\t\u0011\u0005m\u0017Q\u0018Q\u0001\n\u0001\fa\u0002V!T\u0017~#\u0016\fU#`\u0017\u0016K\u0006\u0005\u0003\u0006\u0002`\u0006u&\u0019!C\u0001\u0005U\f1\u0002V!T\u0017~KEiX&F3\"A\u00111]A_A\u0003%\u0001-\u0001\u0007U\u0003N[u,\u0013#`\u0017\u0016K\u0006\u0005\u0003\u0006\u0002h\u0006u&\u0019!C\u0001\u0005U\f1b\u0011'V'R+%kX&F3\"A\u00111^A_A\u0003%\u0001-\u0001\u0007D\u0019V\u001bF+\u0012*`\u0017\u0016K\u0006\u0005\u0003\u0006\u0002p\u0006u&\u0019!C\u0001\u0005U\fA\u0002T(D\u00032{V*Q*U\u000bJC\u0001\"a=\u0002>\u0002\u0006I\u0001Y\u0001\u000e\u0019>\u001b\u0015\tT0N\u0003N#VI\u0015\u0011\t\u0015\u0005]\u0018Q\u0018b\u0001\n\u0003\u0011Q/A\u0006H%B\u001bulU\"I\u000b6+\u0005\u0002CA~\u0003{\u0003\u000b\u0011\u00021\u0002\u0019\u001d\u0013\u0006kQ0T\u0007\"+U*\u0012\u0011\t\u0015\u0005}\u0018Q\u0018C\u0001\u0003{\u0013\t!A\thKRtU\r^<pe.\fE\r\u001a:fgN$r\u0001\u0019B\u0002\u0005\u000b\u00119\u0001\u0003\u0004p\u0003{\u0004\r!\u0018\u0005\u0007i\u0006u\b\u0019\u00011\t\re\fi\u00101\u0001JQ\u0019\tiPa\u0003\u0003<A)qB!\u0004\u0003\u0012%\u0019!q\u0002\t\u0003\rQD'o\\<t!\u0011\u0011\u0019B!\u000e\u000f\t\tU!q\u0006\b\u0005\u0005/\u0011YC\u0004\u0003\u0003\u001a\t%b\u0002\u0002B\u000e\u0005OqAA!\b\u0003&9!!q\u0004B\u0012\u001d\r\u0019'\u0011E\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005U\"\u0011b\u0001B\u0017i\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0019\u0005g\t\u0011\"\u001a=dKB$\u0018n\u001c8\u000b\u0007\t5B'\u0003\u0003\u00038\te\"\u0001G%om\u0006d\u0017\u000eZ!sOVlWM\u001c;Fq\u000e,\u0007\u000f^5p]*!!\u0011\u0007B\u001ac\u0019q\u0002M!\u0010\u0003lEJ1Ea\u0010\u0003F\t\u0005$qI\u000b\u0004k\n\u0005Ca\u0002B\"\u0019\t\u0007!Q\n\u0002\u0002)&!!q\tB%\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019!1\n\t\u0002\rQD'o\\<t#\u0011\u0011yE!\u0016\u0011\u0007=\u0011\t&C\u0002\u0003TA\u0011qAT8uQ&tw\r\u0005\u0003\u0003X\tmcbA\b\u0003Z%\u0019!Q\u0006\t\n\t\tu#q\f\u0002\n)\"\u0014xn^1cY\u0016T1A!\f\u0011c%\u0019#1\rB3\u0005O\u0012YED\u0002\u0010\u0005KJ1Aa\u0013\u0011c\u0015\u0011s\u0002\u0005B5\u0005\u0015\u00198-\u00197bc\r1#\u0011\u0003\u0005\u000b\u0005_\ni\f\"\u0001\u0002>\nE\u0014!F2pk:$\b+\u0019:b[\u0016$XM]*feZ,'o\u001d\u000b\u0004\u0013\nM\u0004b\u0002B;\u0005[\u0002\r!X\u0001\fG2,8\u000f^3s'B,7\r\u0003\u0006\u0003z\u0005uF\u0011AA_\u0005w\nAbY8v]R<vN]6feN$2!\u0013B?\u0011\u001d\u0011)Ha\u001eA\u0002u3!B!!\u0002>B\u0005\u0019\u0013\u0005BB\u0005!!\u0016m]6UsB,7c\u0001B@\u001d!I!q\u0011B@\u0005\u00045\t!^\u0001\u0005]\u0006lW-\u000b\u0007\u0003\u0000\t-%1\u0019Bv\u0007'\u0019YD\u0002\u0005\u0003\u000e\u0006u\u0006\u0012\u0011BH\u0005\u0015\u0019\u0005*S#G'\u001d\u0011YI\u0004BI)]\u0001BAa%\u0003\u00005\u0011\u0011Q\u0018\u0005\b\u001f\n-E\u0011\u0001BL)\t\u0011I\n\u0005\u0003\u0003\u0014\n-\u0005\"\u0003BD\u0005\u0017\u0013\r\u0011\"\u0011v\u0011!\u0011yJa#!\u0002\u0013\u0001\u0017!\u00028b[\u0016\u0004\u0003BCA4\u0005\u0017\u000b\t\u0011\"\u0011\u0002j!I\u0011q\u000fBF\u0003\u0003%\tA\u001f\u0005\u000b\u0003w\u0012Y)!A\u0005\u0002\t\u001dF\u0003BA@\u0005SC\u0011\"a\"\u0003&\u0006\u0005\t\u0019A%\t\u0015\u0005-%1RA\u0001\n\u0003\ni\t\u0003\u0006\u0002\u001e\n-\u0015\u0011!C\u0001\u0005_#2a\u001bBY\u0011)\t9I!,\u0002\u0002\u0003\u0007\u0011q\u0010\u0005\u000b\u0003K\u0013Y)!A\u0005B\u0005\u001d\u0006BCAV\u0005\u0017\u000b\t\u0011\"\u0011\u0002.\"Q!\u0011\u0018BF\u0003\u0003%IAa/\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005{\u0003B!!\u001c\u0003@&!!\u0011YA8\u0005\u0019y%M[3di\u001aA!QYA_\u0011\u0003\u00139MA\u0005F-\u0006cU+\u0011+P%N9!1\u0019\b\u0003\u0012R9\u0002bB(\u0003D\u0012\u0005!1\u001a\u000b\u0003\u0005\u001b\u0004BAa%\u0003D\"I!q\u0011Bb\u0005\u0004%\t%\u001e\u0005\t\u0005?\u0013\u0019\r)A\u0005A\"Q\u0011q\rBb\u0003\u0003%\t%!\u001b\t\u0013\u0005]$1YA\u0001\n\u0003Q\bBCA>\u0005\u0007\f\t\u0011\"\u0001\u0003ZR!\u0011q\u0010Bn\u0011%\t9Ia6\u0002\u0002\u0003\u0007\u0011\n\u0003\u0006\u0002\f\n\r\u0017\u0011!C!\u0003\u001bC!\"!(\u0003D\u0006\u0005I\u0011\u0001Bq)\rY'1\u001d\u0005\u000b\u0003\u000f\u0013y.!AA\u0002\u0005}\u0004BCAS\u0005\u0007\f\t\u0011\"\u0011\u0002(\"Q\u00111\u0016Bb\u0003\u0003%\t%!,\t\u0015\te&1YA\u0001\n\u0013\u0011YL\u0002\u0005\u0003n\u0006u\u0006\u0012\u0011Bx\u0005\u0019i\u0015i\u0015+F%N9!1\u001e\b\u0003\u0012R9\u0002bB(\u0003l\u0012\u0005!1\u001f\u000b\u0003\u0005k\u0004BAa%\u0003l\"I!q\u0011Bv\u0005\u0004%\t%\u001e\u0005\t\u0005?\u0013Y\u000f)A\u0005A\"Q\u0011q\rBv\u0003\u0003%\t%!\u001b\t\u0013\u0005]$1^A\u0001\n\u0003Q\bBCA>\u0005W\f\t\u0011\"\u0001\u0004\u0002Q!\u0011qPB\u0002\u0011%\t9Ia@\u0002\u0002\u0003\u0007\u0011\n\u0003\u0006\u0002\f\n-\u0018\u0011!C!\u0003\u001bC!\"!(\u0003l\u0006\u0005I\u0011AB\u0005)\rY71\u0002\u0005\u000b\u0003\u000f\u001b9!!AA\u0002\u0005}\u0004BCAS\u0005W\f\t\u0011\"\u0011\u0002(\"Q\u00111\u0016Bv\u0003\u0003%\t%!,\t\u0015\te&1^A\u0001\n\u0013\u0011YL\u0002\u0005\u0004\u0016\u0005u\u0006\u0012QB\f\u0005A\u0001\u0016IU!N\u000bR+%kX*F%Z+%kE\u0004\u0004\u00149\u0011\t\nF\f\t\u000f=\u001b\u0019\u0002\"\u0001\u0004\u001cQ\u00111Q\u0004\t\u0005\u0005'\u001b\u0019\u0002C\u0005\u0003\b\u000eM!\u0019!C!k\"A!qTB\nA\u0003%\u0001\r\u0003\u0006\u0002h\rM\u0011\u0011!C!\u0003SB\u0011\"a\u001e\u0004\u0014\u0005\u0005I\u0011\u0001>\t\u0015\u0005m41CA\u0001\n\u0003\u0019I\u0003\u0006\u0003\u0002\u0000\r-\u0002\"CAD\u0007O\t\t\u00111\u0001J\u0011)\tYia\u0005\u0002\u0002\u0013\u0005\u0013Q\u0012\u0005\u000b\u0003;\u001b\u0019\"!A\u0005\u0002\rEBcA6\u00044!Q\u0011qQB\u0018\u0003\u0003\u0005\r!a \t\u0015\u0005\u001561CA\u0001\n\u0003\n9\u000b\u0003\u0006\u0002,\u000eM\u0011\u0011!C!\u0003[C!B!/\u0004\u0014\u0005\u0005I\u0011\u0002B^\r!\u0019i$!0\t\u0002\u000e}\"AB,P%.+%kE\u0004\u0004<9\u0011\t\nF\f\t\u000f=\u001bY\u0004\"\u0001\u0004DQ\u00111Q\t\t\u0005\u0005'\u001bY\u0004C\u0005\u0003\b\u000em\"\u0019!C!k\"A!qTB\u001eA\u0003%\u0001\r\u0003\u0006\u0002h\rm\u0012\u0011!C!\u0003SB\u0011\"a\u001e\u0004<\u0005\u0005I\u0011\u0001>\t\u0015\u0005m41HA\u0001\n\u0003\u0019\t\u0006\u0006\u0003\u0002\u0000\rM\u0003\"CAD\u0007\u001f\n\t\u00111\u0001J\u0011)\tYia\u000f\u0002\u0002\u0013\u0005\u0013Q\u0012\u0005\u000b\u0003;\u001bY$!A\u0005\u0002\reCcA6\u0004\\!Q\u0011qQB,\u0003\u0003\u0005\r!a \t\u0015\u0005\u001561HA\u0001\n\u0003\n9\u000b\u0003\u0006\u0002,\u000em\u0012\u0011!C!\u0003[C!B!/\u0004<\u0005\u0005I\u0011\u0002B^\u000f!\u0019)'!0\t\u0002\r\u001d\u0014\u0001\u0003+bg.$\u0016\u0010]3\u0011\t\tM5\u0011\u000e\u0004\t\u0005\u0003\u000bi\f#\u0001\u0004lM\u00191\u0011\u000e\b\t\u000f=\u001bI\u0007\"\u0001\u0004pQ\u00111q\r\u0005\t\u0007g\u001aI\u0007\"\u0001\u0004v\u0005AaM]8n\u001d\u0006lW\r\u0006\u0003\u0003\u0012\u000e]\u0004b\u0002BD\u0007c\u0002\r\u0001\u0019\u0015\u0007\u0007c\u0012Yaa\u001f2\ry\u00017QPBBc%\u0019#q\bB#\u0007\u007f\u00129%M\u0005$\u0005G\u0012)g!!\u0003LE*!e\u0004\t\u0003jE\u001aaE!\u0005\b\u0011\r\u001d\u0015Q\u0018EA\u0005k\fa!T!T)\u0016\u0013v\u0001CBF\u0003{C\ti!\b\u0002!A\u000b%+Q'F)\u0016\u0013vlU#S-\u0016\u0013v\u0001CBH\u0003{C\ti!\u0012\u0002\r]{%kS#S\u000f!\u0019\u0019*!0\t\u0002\ne\u0015!B\"I\u0013\u00163u\u0001CBL\u0003{C\tI!4\u0002\u0013\u00153\u0016\tT+B)>\u0013\u0006BCBN\u0003{\u000b\t\u0011\"!\u0004\u001e\u0006)\u0011\r\u001d9msRI\u0011ka(\u0004\"\u000e\r6Q\u0015\u0005\t7\re\u0005\u0013!a\u0001;!AQf!'\u0011\u0002\u0003\u0007q\u0006\u0003\u0005<\u00073\u0003\n\u00111\u0001>\u0011!15\u0011\u0014I\u0001\u0002\u0004A\u0005BCBU\u0003{\u000b\t\u0011\"!\u0004,\u00069QO\\1qa2LH\u0003BBW\u0007k\u0003Ba\u0004\u0010\u00040B9qb!-\u001e_uB\u0015bABZ!\t1A+\u001e9mKRB\u0011ba.\u0004(\u0006\u0005\t\u0019A)\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003H\u0005u\u0016\u0013!C\u0001\u0003oA!b!0\u0002>F\u0005I\u0011AA)\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e!Q1\u0011YA_#\u0003%\t!!\u0017\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0011)\u0019)-!0\u0012\u0002\u0013\u0005\u0011\u0011M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\t\u0015\r%\u0017QXI\u0001\n\u0003\t9$A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00132\u0011)\u0019i-!0\u0012\u0002\u0013\u0005\u0011\u0011K\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e!Q1\u0011[A_#\u0003%\t!!\u0017\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIMB!b!6\u0002>F\u0005I\u0011AA1\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0004B\u0003B]\u0003{\u000b\t\u0011\"\u0003\u0003<\u0002")
public class Configuration
implements Product,
scala.Serializable {
    private final Option<Path> workingDir;
    private final Option<SessionConfig> sessionConfig;
    private final CheckpointConfig checkpointConfig;
    private final Option<Object> randomSeed;
    private final /* synthetic */ Tuple7 x$4;
    private final Option<ClusterConfig> clusterConfig;
    private final String taskType;
    private final int taskIndex;
    private final String master;
    private final int numParameterServers;
    private final int numWorkers;
    private final boolean isChief;
    private final String evaluationMaster;

    public static Option<Object> apply$default$4() {
        return Configuration$.MODULE$.apply$default$4();
    }

    public static CheckpointConfig apply$default$3() {
        return Configuration$.MODULE$.apply$default$3();
    }

    public static Option<SessionConfig> apply$default$2() {
        return Configuration$.MODULE$.apply$default$2();
    }

    public static Option<Path> apply$default$1() {
        return Configuration$.MODULE$.apply$default$1();
    }

    public static Option<Object> $lessinit$greater$default$4() {
        return Configuration$.MODULE$.$lessinit$greater$default$4();
    }

    public static CheckpointConfig $lessinit$greater$default$3() {
        return Configuration$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<SessionConfig> $lessinit$greater$default$2() {
        return Configuration$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Path> $lessinit$greater$default$1() {
        return Configuration$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Tuple4<Option<Path>, Option<SessionConfig>, CheckpointConfig, Option<Object>>> unapply(Configuration configuration) {
        return Configuration$.MODULE$.unapply(configuration);
    }

    public static Configuration apply(Option<Path> option, Option<SessionConfig> option2, CheckpointConfig checkpointConfig, Option<Object> option3) {
        return Configuration$.MODULE$.apply(option, option2, checkpointConfig, option3);
    }

    public Option<Path> workingDir() {
        return this.workingDir;
    }

    public Option<SessionConfig> sessionConfig() {
        return this.sessionConfig;
    }

    public CheckpointConfig checkpointConfig() {
        return this.checkpointConfig;
    }

    public Option<Object> randomSeed() {
        return this.randomSeed;
    }

    public Option<ClusterConfig> clusterConfig() {
        return this.clusterConfig;
    }

    public String taskType() {
        return this.taskType;
    }

    public int taskIndex() {
        return this.taskIndex;
    }

    public String master() {
        return this.master;
    }

    public int numParameterServers() {
        return this.numParameterServers;
    }

    public int numWorkers() {
        return this.numWorkers;
    }

    public boolean isChief() {
        return this.isChief;
    }

    public String evaluationMaster() {
        return this.evaluationMaster;
    }

    public Configuration copy(Option<Path> workingDir, Option<SessionConfig> sessionConfig, CheckpointConfig checkpointConfig, Option<Object> randomSeed) {
        return new Configuration(workingDir, sessionConfig, checkpointConfig, randomSeed);
    }

    public Option<Path> copy$default$1() {
        return this.workingDir();
    }

    public Option<SessionConfig> copy$default$2() {
        return this.sessionConfig();
    }

    public CheckpointConfig copy$default$3() {
        return this.checkpointConfig();
    }

    public Option<Object> copy$default$4() {
        return this.randomSeed();
    }

    public String productPrefix() {
        return "Configuration";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.workingDir();
                break;
            }
            case 1: {
                object = this.sessionConfig();
                break;
            }
            case 2: {
                object = this.checkpointConfig();
                break;
            }
            case 3: {
                object = this.randomSeed();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Configuration;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Configuration)) return false;
        boolean bl = true;
        if (!bl) return false;
        Configuration configuration = (Configuration)x$1;
        Option<Path> option = this.workingDir();
        Option<Path> option2 = configuration.workingDir();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<SessionConfig> option3 = this.sessionConfig();
        Option<SessionConfig> option4 = configuration.sessionConfig();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        CheckpointConfig checkpointConfig = this.checkpointConfig();
        CheckpointConfig checkpointConfig2 = configuration.checkpointConfig();
        if (checkpointConfig == null) {
            if (checkpointConfig2 != null) {
                return false;
            }
        } else if (!checkpointConfig.equals(checkpointConfig2)) return false;
        Option<Object> option5 = this.randomSeed();
        Option<Object> option6 = configuration.randomSeed();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (!configuration.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ Tuple2 $anonfun$x$4$7(String t$1, int i) {
        return new Tuple2((Object)t$1, (Object)BoxesRunTime.boxToInteger((int)i));
    }

    public Configuration(Option<Path> workingDir, Option<SessionConfig> sessionConfig, CheckpointConfig checkpointConfig, Option<Object> randomSeed) {
        Tuple7 tuple7;
        Tuple7 tuple72;
        this.workingDir = workingDir;
        this.sessionConfig = sessionConfig;
        this.checkpointConfig = checkpointConfig;
        this.randomSeed = randomSeed;
        Product.$init$((Product)this);
        String tfConfigJson = System.getenv(Configuration$.MODULE$.TF_CONFIG_ENV());
        Either tfConfigJsonParsed = io.circe.parser.package$.MODULE$.parse(tfConfigJson);
        Either tfClusterConfig = tfConfigJsonParsed.right().flatMap((Function1 & Serializable & scala.Serializable)parsed -> {
            Left left;
            List clusterConfigJson = parsed.findAllByKey(Configuration$.MODULE$.CLUSTER_KEY());
            if (clusterConfigJson.isEmpty()) {
                left = package$.MODULE$.Left().apply(null);
            } else {
                if (clusterConfigJson.length() > 1) {
                    throw package$exception$.MODULE$.InvalidArgumentException().apply(new StringBuilder(67).append("Only a single 'cluster' configuration field should be provided in ").append(Configuration$.MODULE$.TF_CONFIG_ENV()).append(".").toString());
                }
                left = ((Json)clusterConfigJson.head()).as(Decoder$.MODULE$.decodeMap(KeyDecoder$.MODULE$.decodeKeyString(), Decoder$.MODULE$.decodeJson())).right().map((Function1 & Serializable & scala.Serializable)x$1 -> (Seq)x$1.toSeq().flatMap((Function1 & Serializable & scala.Serializable)p -> {
                    Map map;
                    Either either = ((Json)p._2()).as(Decoder$.MODULE$.decodeSeq(Decoder$.MODULE$.decodeString()));
                    if (either instanceof Left) {
                        Either either2 = ((Json)p._2()).as(Decoder$.MODULE$.decodeMap(KeyDecoder$.MODULE$.decodeKeyInt(), Decoder$.MODULE$.decodeString()));
                        if (either2 instanceof Left) {
                            throw package$exception$.MODULE$.InvalidArgumentException().apply(new StringBuilder(46).append("Could not parse the cluster configuration in ").append(Configuration$.MODULE$.TF_CONFIG_ENV()).append(".").toString());
                        }
                        if (!(either2 instanceof Right)) {
                            throw new MatchError((Object)either2);
                        }
                        Right right = (Right)either2;
                        Map tasks = (Map)right.value();
                        Map map2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p._1()), (Object)JobConfig$.MODULE$.fromMap((Map<Object, String>)tasks))}));
                        map = map2;
                    } else if (either instanceof Right) {
                        Right right = (Right)either;
                        Seq tasks = (Seq)right.value();
                        map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p._1()), (Object)JobConfig$.MODULE$.fromSeq((Seq<String>)tasks))}));
                    } else {
                        throw new MatchError((Object)either);
                    }
                    return map;
                }, Seq$.MODULE$.canBuildFrom())).right().map((Function1 & Serializable & scala.Serializable)m -> new ClusterConfig((Map<String, JobConfig>)((Map)Predef$.MODULE$.Map().apply(m))));
            }
            return left;
        });
        Either tfTaskConfig = tfConfigJsonParsed.right().flatMap((Function1 & Serializable & scala.Serializable)parsed -> {
            HCursor cursor = parsed.hcursor();
            Either taskType = cursor.downField(Configuration$.MODULE$.TASK_ENV_KEY()).get(Configuration$.MODULE$.TASK_TYPE_KEY(), Decoder$.MODULE$.decodeString());
            Either taskIndex = cursor.downField(Configuration$.MODULE$.TASK_ENV_KEY()).get(Configuration$.MODULE$.TASK_ID_KEY(), Decoder$.MODULE$.decodeInt());
            return taskType.right().flatMap((Function1 & Serializable & scala.Serializable)t -> taskIndex.right().map((Function1 & Serializable & scala.Serializable)i -> Configuration.$anonfun$x$4$7(t, BoxesRunTime.unboxToInt((Object)i))));
        });
        if (tfClusterConfig.isRight()) {
            Tuple7 tuple73;
            ClusterConfig config = (ClusterConfig)tfClusterConfig.right().get();
            Option<Map<Object, String>> option = config.jobTasks(Configuration$CHIEF$.MODULE$.name());
            if (None$.MODULE$.equals(option)) {
                throw package$exception$.MODULE$.InvalidArgumentException().apply(new StringBuilder(55).append("If 'cluster' is set in ").append(Configuration$.MODULE$.TF_CONFIG_ENV()).append(", it must have one 'chief' node.").toString());
            }
            if (option instanceof Some) {
                Tuple2 taskConfig;
                if (((TraversableOnce)config.jobTasks(Configuration$CHIEF$.MODULE$.name()).get()).size() > 1) {
                    throw package$exception$.MODULE$.InvalidArgumentException().apply(new StringBuilder(50).append("The 'cluster' in ").append(Configuration$.MODULE$.TF_CONFIG_ENV()).append(" must have only one 'chief' node.").toString());
                }
                Either either = tfTaskConfig;
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Exception exception2 = (Exception)left.value();
                    throw package$exception$.MODULE$.InvalidArgumentException().apply(new StringBuilder(61).append("If 'cluster' is set in ").append(Configuration$.MODULE$.TF_CONFIG_ENV()).append(", task type and index must be set too.").toString(), (Throwable)exception2);
                }
                if (!(either instanceof Right)) {
                    throw new MatchError((Object)either);
                }
                Right right = (Right)either;
                Tuple2 tuple2 = taskConfig = (Tuple2)right.value();
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                String taskType = (String)tuple22._1();
                int taskIndex = tuple22._2$mcI$sp();
                Tuple2 tuple23 = new Tuple2((Object)taskType, (Object)BoxesRunTime.boxToInteger((int)taskIndex));
                Tuple2 tuple24 = tuple23;
                String taskType2 = (String)tuple24._1();
                int taskIndex2 = tuple24._2$mcI$sp();
                if (taskIndex2 < 0) {
                    throw package$exception$.MODULE$.InvalidArgumentException().apply("The task index must be a non-negative number.");
                }
                String string = taskType2;
                String string2 = Configuration$EVALUATOR$.MODULE$.name();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    None$ clusterConfig = None$.MODULE$;
                    String master = Configuration$.MODULE$.LOCAL_MASTER();
                    int numParameterServers = 0;
                    int numWorkers = 0;
                    boolean isChief = false;
                    tuple73 = new Tuple7((Object)clusterConfig, (Object)taskType2, (Object)BoxesRunTime.boxToInteger((int)taskIndex2), (Object)master, (Object)BoxesRunTime.boxToInteger((int)numParameterServers), (Object)BoxesRunTime.boxToInteger((int)numWorkers), (Object)BoxesRunTime.boxToBoolean((boolean)isChief));
                } else {
                    Some clusterConfig = new Some((Object)config);
                    String master = Configuration$.MODULE$.getNetworkAddress(config, taskType2, taskIndex2);
                    int numParameterServers = Configuration$.MODULE$.countParameterServers(config);
                    int numWorkers = Configuration$.MODULE$.countWorkers(config);
                    String string4 = taskType2;
                    String string5 = Configuration$CHIEF$.MODULE$.name();
                    boolean isChief = !(string4 != null ? !string4.equals(string5) : string5 != null);
                    tuple73 = new Tuple7((Object)clusterConfig, (Object)taskType2, (Object)BoxesRunTime.boxToInteger((int)taskIndex2), (Object)master, (Object)BoxesRunTime.boxToInteger((int)numParameterServers), (Object)BoxesRunTime.boxToInteger((int)numWorkers), (Object)BoxesRunTime.boxToBoolean((boolean)isChief));
                }
            } else {
                throw new MatchError(option);
            }
            Tuple7 tuple74 = tuple73;
            tuple72 = tuple74;
        } else {
            Tuple2 tuple2;
            Either either = tfTaskConfig;
            if (either instanceof Left) {
                tuple2 = new Tuple2((Object)Configuration$WORKER$.MODULE$.name(), (Object)BoxesRunTime.boxToInteger((int)0));
            } else if (either instanceof Right) {
                Tuple2 taskConfig;
                Right right = (Right)either;
                tuple2 = taskConfig = (Tuple2)right.value();
            } else {
                throw new MatchError((Object)either);
            }
            Tuple2 tuple25 = tuple2;
            if (tuple25 == null) {
                throw new MatchError((Object)tuple25);
            }
            String taskType = (String)tuple25._1();
            int taskIndex = tuple25._2$mcI$sp();
            Tuple2 tuple26 = new Tuple2((Object)taskType, (Object)BoxesRunTime.boxToInteger((int)taskIndex));
            Tuple2 tuple27 = tuple26;
            String taskType3 = (String)tuple27._1();
            int taskIndex3 = tuple27._2$mcI$sp();
            String string = taskType3;
            String string6 = Configuration$WORKER$.MODULE$.name();
            if (string == null ? string6 != null : !string.equals(string6)) {
                throw package$exception$.MODULE$.InvalidArgumentException().apply(new StringBuilder(48).append("If 'cluster' is not set in ").append(Configuration$.MODULE$.TF_CONFIG_ENV()).append(", task type must be ").append(Configuration$WORKER$.MODULE$.name()).append(".").toString());
            }
            if (taskIndex3 != 0) {
                throw package$exception$.MODULE$.InvalidArgumentException().apply(new StringBuilder(50).append("If 'cluster' is not set in ").append(Configuration$.MODULE$.TF_CONFIG_ENV()).append(", task index must be 0.").toString());
            }
            None$ clusterConfig = None$.MODULE$;
            String master = "";
            int numParameterServers = 0;
            int numWorkers = 1;
            boolean isChief = true;
            tuple72 = tuple7 = new Tuple7((Object)clusterConfig, (Object)taskType3, (Object)BoxesRunTime.boxToInteger((int)taskIndex3), (Object)master, (Object)BoxesRunTime.boxToInteger((int)numParameterServers), (Object)BoxesRunTime.boxToInteger((int)numWorkers), (Object)BoxesRunTime.boxToBoolean((boolean)isChief));
        }
        if (tuple7 == null) {
            throw new MatchError((Object)tuple7);
        }
        Option clusterConfig = (Option)tuple7._1();
        String taskType = (String)tuple7._2();
        int taskIndex = BoxesRunTime.unboxToInt((Object)tuple7._3());
        String master = (String)tuple7._4();
        int numParameterServers = BoxesRunTime.unboxToInt((Object)tuple7._5());
        int numWorkers = BoxesRunTime.unboxToInt((Object)tuple7._6());
        boolean isChief = BoxesRunTime.unboxToBoolean((Object)tuple7._7());
        Tuple7 tuple75 = new Tuple7((Object)clusterConfig, (Object)taskType, (Object)BoxesRunTime.boxToInteger((int)taskIndex), (Object)master, (Object)BoxesRunTime.boxToInteger((int)numParameterServers), (Object)BoxesRunTime.boxToInteger((int)numWorkers), (Object)BoxesRunTime.boxToBoolean((boolean)isChief));
        this.x$4 = tuple75;
        this.clusterConfig = (Option)this.x$4._1();
        this.taskType = (String)this.x$4._2();
        this.taskIndex = BoxesRunTime.unboxToInt((Object)this.x$4._3());
        this.master = (String)this.x$4._4();
        this.numParameterServers = BoxesRunTime.unboxToInt((Object)this.x$4._5());
        this.numWorkers = BoxesRunTime.unboxToInt((Object)this.x$4._6());
        this.isChief = BoxesRunTime.unboxToBoolean((Object)this.x$4._7());
        this.evaluationMaster = "";
    }

    public static interface TaskType {
        public String name();
    }
}

