/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.api.learn.hooks;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.platanios.tensorflow.api.core.Graph;
import org.platanios.tensorflow.api.core.Graph$Keys$SAVERS$;
import org.platanios.tensorflow.api.core.client.Executable;
import org.platanios.tensorflow.api.core.client.Fetchable;
import org.platanios.tensorflow.api.core.client.Session;
import org.platanios.tensorflow.api.core.package$exception$;
import org.platanios.tensorflow.api.io.events.SummaryFileWriter;
import org.platanios.tensorflow.api.io.events.SummaryFileWriterCache$;
import org.platanios.tensorflow.api.learn.SessionWrapper;
import org.platanios.tensorflow.api.learn.hooks.CheckpointSaver$;
import org.platanios.tensorflow.api.learn.hooks.Hook;
import org.platanios.tensorflow.api.learn.hooks.HookTrigger;
import org.platanios.tensorflow.api.learn.hooks.TriggeredHook;
import org.platanios.tensorflow.api.ops.Op$;
import org.platanios.tensorflow.api.ops.Output;
import org.platanios.tensorflow.api.ops.variables.Saver;
import org.platanios.tensorflow.api.tensors.Tensor;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.MetaGraphDef;
import org.tensorflow.util.SaverDef;
import org.tensorflow.util.SessionLog;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5b\u0001B\u0001\u0003\u0001=\u0011qb\u00115fG.\u0004x.\u001b8u'\u00064XM\u001d\u0006\u0003\u0007\u0011\tQ\u0001[8pWNT!!\u0002\u0004\u0002\u000b1,\u0017M\u001d8\u000b\u0005\u001dA\u0011aA1qS*\u0011\u0011BC\u0001\u000bi\u0016t7o\u001c:gY><(BA\u0006\r\u0003%\u0001H.\u0019;b]&|7OC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\tiAK]5hO\u0016\u0014X\r\u001a%p_.D\u0001\"\u0006\u0001\u0003\u0006\u0004%\tAF\u0001\nI&\u0014Xm\u0019;pef,\u0012a\u0006\t\u00031}i\u0011!\u0007\u0006\u00035m\tAAZ5mK*\u0011A$H\u0001\u0004]&|'\"\u0001\u0010\u0002\t)\fg/Y\u0005\u0003Ae\u0011A\u0001U1uQ\"A!\u0005\u0001B\u0001B\u0003%q#\u0001\u0006eSJ,7\r^8ss\u0002B\u0001\u0002\n\u0001\u0003\u0006\u0004%\t!J\u0001\biJLwmZ3s+\u00051\u0003CA\t(\u0013\tA#AA\u0006I_>\\GK]5hO\u0016\u0014\b\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\u0011Q\u0014\u0018nZ4fe\u0002B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!L\u0001\riJLwmZ3s\u0003R,e\u000eZ\u000b\u0002]A\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t9!i\\8mK\u0006t\u0007\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\u0002\u001bQ\u0014\u0018nZ4fe\u0006#XI\u001c3!\u0011!9\u0004A!b\u0001\n\u0003A\u0014AE2iK\u000e\\\u0007o\\5oi\n\u000b7/\u001a(b[\u0016,\u0012!\u000f\t\u0003u\u0005s!aO \u0011\u0005q\u0002T\"A\u001f\u000b\u0005yr\u0011A\u0002\u001fs_>$h(\u0003\u0002Aa\u00051\u0001K]3eK\u001aL!AQ\"\u0003\rM#(/\u001b8h\u0015\t\u0001\u0005\u0007\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003:\u0003M\u0019\u0007.Z2la>Lg\u000e\u001e\"bg\u0016t\u0015-\\3!\u0011\u00159\u0005\u0001\"\u0005I\u0003\u0019a\u0014N\\5u}Q)\u0011JS&M\u001bB\u0011\u0011\u0003\u0001\u0005\u0006+\u0019\u0003\ra\u0006\u0005\bI\u0019\u0003\n\u00111\u0001'\u0011\u001dac\t%AA\u00029Bqa\u000e$\u0011\u0002\u0003\u0007\u0011\b\u0003\u0005P\u0001\t\u0007I\u0011\t\u0003Q\u0003!\u0001(/[8sSRLX#A)\u0011\u0005=\u0012\u0016BA*1\u0005\rIe\u000e\u001e\u0005\u0007+\u0002\u0001\u000b\u0011B)\u0002\u0013A\u0014\u0018n\u001c:jif\u0004\u0003BB,\u0001A\u0003%q#\u0001\u0005tCZ,\u0007+\u0019;i\u0011\u0019I\u0006\u0001)Q\u00055\u0006)1/\u0019<feB\u0019qfW/\n\u0005q\u0003$AB(qi&|g\u000e\u0005\u0002_G6\tqL\u0003\u0002aC\u0006Ia/\u0019:jC\ndWm\u001d\u0006\u0003E\u001a\t1a\u001c9t\u0013\t!wLA\u0003TCZ,'\u000f\u0003\u0004g\u0001\u0001\u0006KaZ\u0001\u000egVlW.\u0019:z/JLG/\u001a:\u0011\u0007=Z\u0006\u000e\u0005\u0002j]6\t!N\u0003\u0002lY\u00061QM^3oiNT!!\u001c\u0004\u0002\u0005%|\u0017BA8k\u0005E\u0019V/\\7bef4\u0015\u000e\\3Xe&$XM\u001d\u0005\u0006c\u0002!\tF]\u0001\u0006E\u0016<\u0017N\u001c\u000b\u0002gB\u0011q\u0006^\u0005\u0003kB\u0012A!\u00168ji\")q\u000f\u0001C)q\u0006\u0019QM\u001c3\u0015\u0005ML\b\"\u0002>w\u0001\u0004Y\u0018aB:fgNLwN\u001c\t\u0004y\u0006\rQ\"A?\u000b\u0005y|\u0018AB2mS\u0016tGOC\u0002\u0002\u0002\u0019\tAaY8sK&\u0019\u0011QA?\u0003\u000fM+7o]5p]\"9\u0011\u0011\u0002\u0001\u0005R\u0005-\u0011AD8o\r&\u00148\u000f\u001e+sS\u001e<WM]\u000b\t\u0003\u001b\t)%a\b\u0002LQ!\u0011qBA()\u0015\u0019\u0018\u0011CA\u0019\u0011!\t\u0019\"a\u0002A\u0004\u0005U\u0011\u0001D3yK\u000e,H/\u00192mK\u00163\b#\u0002?\u0002\u0018\u0005m\u0011bAA\r{\nQQ\t_3dkR\f'\r\\3\u0011\t\u0005u\u0011q\u0004\u0007\u0001\t!\t\t#a\u0002C\u0002\u0005\r\"!A#\u0012\t\u0005\u0015\u00121\u0006\t\u0004_\u0005\u001d\u0012bAA\u0015a\t9aj\u001c;iS:<\u0007cA\u0018\u0002.%\u0019\u0011q\u0006\u0019\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u00024\u0005\u001d\u00019AA\u001b\u0003-1W\r^2iC\ndW-\u0012<\u0011\u0011\u0005]\u0012QHA\"\u0003\u0013r1\u0001`A\u001d\u0013\r\tY$`\u0001\n\r\u0016$8\r[1cY\u0016LA!a\u0010\u0002B\t\u0019\u0011)\u001e=\u000b\u0007\u0005mR\u0010\u0005\u0003\u0002\u001e\u0005\u0015C\u0001CA$\u0003\u000f\u0011\r!a\t\u0003\u0003\u0019\u0003B!!\b\u0002L\u0011A\u0011QJA\u0004\u0005\u0004\t\u0019CA\u0001S\u0011!\t\t&a\u0002A\u0002\u0005M\u0013A\u0003:v]\u000e{g\u000e^3yiBQ\u0011QKA.\u0003\u0007\nY\"!\u0013\u000f\u0007E\t9&C\u0002\u0002Z\t\tA\u0001S8pW&!\u0011QLA0\u0005E\u0019Vm]:j_:\u0014VO\\\"p]R,\u0007\u0010\u001e\u0006\u0004\u00033\u0012\u0001bBA2\u0001\u0011E\u0013QM\u0001\n_:$&/[4hKJ$\u0012b]A4\u0003c\n\u0019)!.\t\u0011\u0005%\u0014\u0011\ra\u0001\u0003W\nAa\u001d;faB\u0019q&!\u001c\n\u0007\u0005=\u0004G\u0001\u0003M_:<\u0007\u0002CA:\u0003C\u0002\r!!\u001e\u0002\u000f\u0015d\u0017\r]:fIB!qfWA<!\u0019y\u0013\u0011PA?#&\u0019\u00111\u0010\u0019\u0003\rQ+\b\u000f\\33!\ry\u0013qP\u0005\u0004\u0003\u0003\u0003$A\u0002#pk\ndW\r\u0003\u0005\u0002\u0006\u0006\u0005\u0004\u0019AAD\u0003%\u0011XO\u001c*fgVdG\u000f\u0005\u0005\u0002V\u0005%\u0015QRAT\u0013\u0011\tY)a\u0018\u0003!M+7o]5p]J+hNU3tk2$\bCBAH\u00033\u000byJ\u0004\u0003\u0002\u0012\u0006Ueb\u0001\u001f\u0002\u0014&\t\u0011'C\u0002\u0002\u0018B\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001c\u0006u%aA*fc*\u0019\u0011q\u0013\u0019\u0011\t\u0005\u0005\u00161U\u0007\u0002C&\u0019\u0011QU1\u0003\r=+H\u000f];u!\u0019\ty)!'\u0002*B!\u00111VAY\u001b\t\tiKC\u0002\u00020\u001a\tq\u0001^3og>\u00148/\u0003\u0003\u00024\u00065&A\u0002+f]N|'\u000f\u0003\u0004{\u0003C\u0002\ra_\u0004\b\u0003s\u0013\u0001\u0012AA^\u0003=\u0019\u0005.Z2la>Lg\u000e^*bm\u0016\u0014\bcA\t\u0002>\u001a1\u0011A\u0001E\u0001\u0003\u007f\u001bB!!0\u0002BB\u0019q&a1\n\u0007\u0005\u0015\u0007G\u0001\u0004B]f\u0014VM\u001a\u0005\b\u000f\u0006uF\u0011AAe)\t\tY\f\u0003\u0007\u0002N\u0006u&\u0019!C\u0001\u0003{\u000by-\u0001\u0004m_\u001e<WM]\u000b\u0003\u0003#\u0004B!a5\u0002b6\u0011\u0011Q\u001b\u0006\u0005\u0003/\fI.\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0003\u0002\\\u0006u\u0017\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0005\u0005}\u0017aA2p[&!\u00111]Ak\u0005\u0019aunZ4fe\"I\u0011q]A_A\u0003%\u0011\u0011[\u0001\bY><w-\u001a:!\u0011!\tY/!0\u0005\u0002\u00055\u0018!B1qa2LH#C%\u0002p\u0006E\u00181_A{\u0011\u0019)\u0012\u0011\u001ea\u0001/!AA%!;\u0011\u0002\u0003\u0007a\u0005\u0003\u0005-\u0003S\u0004\n\u00111\u0001/\u0011!9\u0014\u0011\u001eI\u0001\u0002\u0004I\u0004BCA}\u0003{\u000b\n\u0011\"\u0001\u0002|\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'\u0006\u0002\u0002~*\u001aa%a@,\u0005\t\u0005\u0001\u0003\u0002B\u0002\u0005\u001bi!A!\u0002\u000b\t\t\u001d!\u0011B\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u00031\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u001f\u0011)AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!Ba\u0005\u0002>F\u0005I\u0011\u0001B\u000b\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001aTC\u0001B\fU\rq\u0013q \u0005\u000b\u00057\ti,%A\u0005\u0002\tu\u0011aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t}!fA\u001d\u0002\u0000\"Q!1EA_#\u0003%\t\"a?\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0011)\u00119#!0\u0012\u0002\u0013E!QC\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\t\u0015\t-\u0012QXI\u0001\n#\u0011i\"A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005\u000e")
public class CheckpointSaver
extends TriggeredHook {
    private final Path directory;
    private final HookTrigger trigger;
    private final boolean triggerAtEnd;
    private final String checkpointBaseName;
    private final int priority;
    private final Path savePath;
    private Option<Saver> saver;
    private Option<SummaryFileWriter> summaryWriter;

    public static String apply$default$4() {
        return CheckpointSaver$.MODULE$.apply$default$4();
    }

    public static boolean apply$default$3() {
        return CheckpointSaver$.MODULE$.apply$default$3();
    }

    public static HookTrigger apply$default$2() {
        return CheckpointSaver$.MODULE$.apply$default$2();
    }

    public static CheckpointSaver apply(Path path, HookTrigger hookTrigger, boolean bl, String string) {
        return CheckpointSaver$.MODULE$.apply(path, hookTrigger, bl, string);
    }

    public Path directory() {
        return this.directory;
    }

    public HookTrigger trigger() {
        return this.trigger;
    }

    public boolean triggerAtEnd() {
        return this.triggerAtEnd;
    }

    public String checkpointBaseName() {
        return this.checkpointBaseName;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public void begin() {
        Set<Saver> savers = Op$.MODULE$.currentGraph().getCollection(Graph$Keys$SAVERS$.MODULE$);
        if (savers.isEmpty() || savers.size() > 1) {
            throw package$exception$.MODULE$.InvalidArgumentException().apply("There should exist one (and only one) saver in the graph.");
        }
        this.saver = new Some(savers.head());
        this.summaryWriter = new Some((Object)SummaryFileWriterCache$.MODULE$.get(this.directory(), SummaryFileWriterCache$.MODULE$.get$default$2()));
    }

    @Override
    public void end(Session session) {
        this.summaryWriter.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.flush();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public <F, E, R> void onFirstTrigger(Hook.SessionRunContext<F, E, R> runContext, Executable<E> executableEv, Fetchable<F> fetchableEv) {
        GraphDef graphDef = runContext.session().graph().toGraphDef();
        SaverDef x$7 = (SaverDef)this.saver.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toSaverDef(x$2.toSaverDef$default$1())).orNull(Predef$.MODULE$.$conforms());
        String x$8 = runContext.session().graph().toMetaGraphDef$default$1();
        MetaGraphDef.MetaInfoDef x$9 = runContext.session().graph().toMetaGraphDef$default$2();
        Set<Graph.Key<?>> x$10 = runContext.session().graph().toMetaGraphDef$default$4();
        Graph.Key<String> x$11 = runContext.session().graph().toMetaGraphDef$default$5();
        boolean x$12 = runContext.session().graph().toMetaGraphDef$default$6();
        MetaGraphDef metaGraphDef = runContext.session().graph().toMetaGraphDef(x$8, x$9, x$7, x$10, x$11, x$12);
        Files.write(this.directory().resolve("graph.pbtxt"), graphDef.toByteArray(), new OpenOption[0]);
        this.summaryWriter.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.writeGraphDef(graphDef, x$3.writeGraphDef$default$2());
            return BoxedUnit.UNIT;
        });
        this.summaryWriter.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.writeMetaGraphDef(metaGraphDef, x$4.writeMetaGraphDef$default$2());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void onTrigger(long step, Option<Tuple2<Object, Object>> elapsed, Hook.SessionRunResult<Seq<Output>, Seq<Tensor>> runResult, Session session) {
        BoxedUnit boxedUnit;
        if (CheckpointSaver$.MODULE$.logger().underlying().isInfoEnabled()) {
            CheckpointSaver$.MODULE$.logger().underlying().info("Saving checkpoint for step {}.", new Object[]{BoxesRunTime.boxToLong((long)step)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Session session2 = session;
        if (session2 instanceof SessionWrapper) {
            SessionWrapper sessionWrapper = (SessionWrapper)session2;
            sessionWrapper.disableHooks();
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        }
        this.saver.foreach((Function1 & Serializable & scala.Serializable)x$5 -> x$5.save(session, $this.savePath, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)((int)step))), x$5.save$default$4(), x$5.save$default$5(), x$5.save$default$6(), x$5.save$default$7()));
        Session session3 = session;
        if (session3 instanceof SessionWrapper) {
            SessionWrapper sessionWrapper = (SessionWrapper)session3;
            sessionWrapper.enableHooks();
            BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
        }
        this.summaryWriter.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.writeSessionLog(SessionLog.newBuilder().setStatus(SessionLog.SessionStatus.CHECKPOINT).setCheckpointPath(((Object)this.savePath.toAbsolutePath()).toString()).build(), step);
            return BoxedUnit.UNIT;
        });
    }

    public CheckpointSaver(Path directory, HookTrigger trigger, boolean triggerAtEnd, String checkpointBaseName) {
        this.directory = directory;
        this.trigger = trigger;
        this.triggerAtEnd = triggerAtEnd;
        this.checkpointBaseName = checkpointBaseName;
        super(trigger, triggerAtEnd);
        this.priority = 1000;
        this.savePath = directory.resolve(checkpointBaseName);
        this.saver = None$.MODULE$;
        this.summaryWriter = None$.MODULE$;
    }
}

