/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.api.ops;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import org.platanios.tensorflow.api.core.Graph;
import org.platanios.tensorflow.api.core.package;
import org.platanios.tensorflow.api.core.package$exception$InvalidDataTypeException$;
import org.platanios.tensorflow.api.ops.Basic$;
import org.platanios.tensorflow.api.ops.Gradients;
import org.platanios.tensorflow.api.ops.Gradients$AddAggregationMethod$;
import org.platanios.tensorflow.api.ops.Gradients$Registry$;
import org.platanios.tensorflow.api.ops.Op;
import org.platanios.tensorflow.api.ops.Op$;
import org.platanios.tensorflow.api.ops.OpSpecification;
import org.platanios.tensorflow.api.ops.Output;
import org.platanios.tensorflow.api.ops.Output$;
import org.platanios.tensorflow.api.ops.OutputIndexedSlices;
import org.platanios.tensorflow.api.ops.OutputLike;
import org.platanios.tensorflow.api.ops.SparseOutput;
import org.platanios.tensorflow.api.ops.control_flow.Context$;
import org.platanios.tensorflow.api.ops.control_flow.ControlFlow$;
import org.platanios.tensorflow.api.ops.control_flow.GradientLoopState;
import org.platanios.tensorflow.api.ops.control_flow.GradientState;
import org.platanios.tensorflow.api.ops.control_flow.GradientState$;
import org.platanios.tensorflow.api.types.DataType;
import org.platanios.tensorflow.api.types.package$;
import org.platanios.tensorflow.jni.Graph$;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.Seq$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.Tuple2Zipped;
import scala.runtime.ZippedTraversable2;
import scala.runtime.ZippedTraversable2$;
import scala.runtime.java8.JFunction0;

public final class Gradients$ {
    public static Gradients$ MODULE$;
    private final Logger logger;

    static {
        new Gradients$();
    }

    public Logger logger() {
        return this.logger;
    }

    public Seq<OutputLike> gradients(Seq<Output> ys, Seq<Output> xs, Seq<OutputLike> dys, boolean gateGradients, Gradients.AggregationMethod aggregationMethod, boolean colocateGradientsWithOps, String name) {
        Seq seq;
        Graph graph = Op$.MODULE$.currentGraph();
        synchronized (graph) {
            Map accumulatedGradients = Map$.MODULE$.empty();
            scala.collection.immutable.Set ops = (scala.collection.immutable.Set)((TraversableOnce)ys.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.op(), scala.collection.Seq$.MODULE$.canBuildFrom())).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)xs.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.op(), scala.collection.Seq$.MODULE$.canBuildFrom())).toSet()).$plus$plus((GenTraversableOnce)(dys != null ? ((TraversableOnce)dys.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.op(), scala.collection.Seq$.MODULE$.canBuildFrom())).toSet() : Predef$.MODULE$.Set().empty()));
            Op$.MODULE$.createWithNameScope(name, (scala.collection.immutable.Set<Op>)ops, (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                scala.collection.immutable.Set destinationOps;
                Graph qual$1 = Op$.MODULE$.currentGraph();
                String x$54 = "GradientUID";
                boolean x$55 = qual$1.uniqueName$default$2();
                String gradientUID = qual$1.uniqueName(x$54, x$55);
                scala.collection.immutable.Set sourceOps = ((TraversableOnce)xs.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.op(), scala.collection.Seq$.MODULE$.canBuildFrom())).toSet();
                Tuple2<Map<Op, Object>, Option<GradientState>> tuple2 = MODULE$.initialPendingCounts((scala.collection.immutable.Set<Op>)sourceOps, (scala.collection.immutable.Set<Op>)(destinationOps = ys.lengthCompare(1) > 0 ? ((TraversableOnce)ys.map((Function1 & Serializable & scala.Serializable)y -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])y.consumers())).nonEmpty() ? Basic$.MODULE$.identity(y, Basic$.MODULE$.identity$default$2()).op() : y.op(), scala.collection.Seq$.MODULE$.canBuildFrom())).toSet() : ((TraversableOnce)ys.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.op(), scala.collection.Seq$.MODULE$.canBuildFrom())).toSet()), colocateGradientsWithOps);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Map pendingCounts = (Map)tuple2._1();
                Option controlFlowGradientState = (Option)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)pendingCounts, (Object)controlFlowGradientState);
                Tuple2 tuple23 = tuple22;
                Map pendingCounts2 = (Map)tuple23._1();
                Option controlFlowGradientState2 = (Option)tuple23._2();
                Queue readyOps = (Queue)Queue$.MODULE$.apply(((scala.collection.SetLike)destinationOps.filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)Gradients$.$anonfun$gradients$8(pendingCounts2, x$7)))).toSeq());
                Seq<OutputLike> dyInitial = MODULE$.initialGradients((Seq<OutputLike>)ys, dys, colocateGradientsWithOps, gradientUID);
                ZippedTraversable2$.MODULE$.zippedTraversable2ToTraversable((ZippedTraversable2)new Tuple2Zipped(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)ys, dyInitial)), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Gradients$.$anonfun$gradients$10(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                    Gradients$.$anonfun$gradients$11(accumulatedGradients, x$8);
                    return BoxedUnit.UNIT;
                });
                controlFlowGradientState2.foreach((Function1 & Serializable & scala.Serializable)state -> {
                    Gradients$.$anonfun$gradients$12(accumulatedGradients, destinationOps, pendingCounts2, readyOps, state);
                    return BoxedUnit.UNIT;
                });
                scala.collection.immutable.Set stopOps = (scala.collection.immutable.Set)sourceOps.filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)Gradients$.$anonfun$gradients$15(pendingCounts2, x$9)));
                while (readyOps.nonEmpty()) {
                    Op op = (Op)readyOps.dequeue();
                    MODULE$.maybeColocateWith(op, colocateGradientsWithOps, gradientUID, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        Object object;
                        controlFlowGradientState2.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                            x$10.enterGradientWhileLoopContext(op, true);
                            return BoxedUnit.UNIT;
                        });
                        scala.collection.mutable.Seq<Seq<OutputLike>> opGradients = aggregationMethod.aggregateGradients((Map<Op, scala.collection.mutable.Seq<Seq<OutputLike>>>)accumulatedGradients, op, gradientUID);
                        controlFlowGradientState2.foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                            x$11.exitGradientWhileLoopContext(op, true);
                            return BoxedUnit.UNIT;
                        });
                        boolean hasOutputGradients = opGradients.nonEmpty();
                        Function2<Op, Seq<OutputLike>, Seq<OutputLike>> gradientFunction = hasOutputGradients && !stopOps.contains((Object)op) ? Gradients$Registry$.MODULE$.apply(op.opType()) : null;
                        controlFlowGradientState2.foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
                            x$12.enterGradientWhileLoopContext(op, false);
                            return BoxedUnit.UNIT;
                        });
                        if (hasOutputGradients && gradientFunction != null) {
                            ((TraversableLike)opGradients.zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Gradients$.$anonfun$gradients$22(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
                                Gradients$.$anonfun$gradients$23(controlFlowGradientState2, op, opGradients, x$14);
                                return BoxedUnit.UNIT;
                            });
                            String x$56 = new StringBuilder(8).append(op.name()).append("Gradient").toString();
                            Graph x$57 = Op$.MODULE$.createWith$default$1();
                            String x$58 = Op$.MODULE$.createWith$default$3();
                            Function1<OpSpecification, String> x$59 = Op$.MODULE$.createWith$default$4();
                            scala.collection.immutable.Set<Op> x$60 = Op$.MODULE$.createWith$default$5();
                            scala.collection.immutable.Set<Op> x$61 = Op$.MODULE$.createWith$default$6();
                            scala.collection.immutable.Map<String, Object> x$62 = Op$.MODULE$.createWith$default$7();
                            String x$63 = Op$.MODULE$.createWith$default$8();
                            JFunction0.mcV.sp & Serializable & scala.Serializable x$73 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                                Object object;
                                scala.collection.mutable.Seq outputGradients = (scala.collection.mutable.Seq)opGradients.map((Function1 & Serializable & scala.Serializable)x$15 -> (OutputLike)x$15.headOption().orNull(Predef$.MODULE$.$conforms()), Seq$.MODULE$.canBuildFrom());
                                ObjectRef inputGradients = ObjectRef.create(MODULE$.maybeCompile(name, op, (Function0<Seq<OutputLike>>)(Function0 & Serializable & scala.Serializable)() -> (Seq)gradientFunction.apply((Object)op, (Object)outputGradients)));
                                if (gateGradients && ((Seq)inputGradients.elem).count((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)Gradients$.$anonfun$gradients$29(x$16))) > 1) {
                                    Object x$64 = null;
                                    Graph x$65 = Op$.MODULE$.createWith$default$1();
                                    String x$66 = Op$.MODULE$.createWith$default$2();
                                    Function1<OpSpecification, String> x$67 = Op$.MODULE$.createWith$default$4();
                                    scala.collection.immutable.Set<Op> x$68 = Op$.MODULE$.createWith$default$5();
                                    scala.collection.immutable.Set<Op> x$69 = Op$.MODULE$.createWith$default$6();
                                    scala.collection.immutable.Map<String, Object> x$70 = Op$.MODULE$.createWith$default$7();
                                    String x$71 = Op$.MODULE$.createWith$default$8();
                                    JFunction0.mcV.sp & Serializable & scala.Serializable x$72 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Op$.MODULE$.colocateWithForGradient((scala.collection.immutable.Set<Op>)Predef$.MODULE$.Set().empty(), (Option<String>)new Some((Object)gradientUID), true, (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                                        inputGradients$1.elem = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ControlFlow$.MODULE$.tuple((OutputLike[])((Seq)inputGradients$1.elem).toArray(ClassTag$.MODULE$.apply(OutputLike.class)), ControlFlow$.MODULE$.tuple$default$2(), ControlFlow$.MODULE$.tuple$default$3(), ClassTag$.MODULE$.apply(OutputLike.class)))).toSeq();
                                    });
                                    object = Op$.MODULE$.createWith(x$65, x$66, (String)null, x$67, x$68, x$69, x$70, x$71, x$72);
                                } else {
                                    object = BoxedUnit.UNIT;
                                }
                                int nInp = op.inputs().length;
                                int nGrd = ((Seq)inputGradients.elem).length();
                                Predef$.MODULE$.assert(nInp == nGrd, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Gradients size (").append(nGrd).append(") for op '").append(op).append("' does not match inputs size (").append(nInp).append(").").toString());
                                MODULE$.logGradients(op, (Seq<OutputLike>)outputGradients, (Seq<OutputLike>)((Seq)inputGradients.elem));
                                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])op.inputs())).zip((GenIterable)((Seq)inputGradients.elem), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)Gradients$.$anonfun$gradients$33(x$17))))).foreach((Function1 & Serializable & scala.Serializable)i -> {
                                    Gradients$.$anonfun$gradients$34(accumulatedGradients, i);
                                    return BoxedUnit.UNIT;
                                });
                            };
                            object = Op$.MODULE$.createWith(x$57, x$56, x$58, x$59, x$60, x$61, x$62, x$63, x$73);
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        controlFlowGradientState2.foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
                            x$18.exitGradientWhileLoopContext(op, false);
                            return BoxedUnit.UNIT;
                        });
                    });
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])op.inputs())).foreach((Function1 & Serializable & scala.Serializable)input -> {
                        Gradients$.$anonfun$gradients$36(accumulatedGradients, pendingCounts2, controlFlowGradientState2, readyOps, input);
                        return BoxedUnit.UNIT;
                    });
                }
                controlFlowGradientState2.foreach((Function1 & Serializable & scala.Serializable)x$24 -> {
                    x$24.postProcess();
                    return BoxedUnit.UNIT;
                });
            });
            seq = (Seq)xs.map((Function1 & Serializable & scala.Serializable)x -> {
                Option gradients = accumulatedGradients.get((Object)x.op()).map((Function1 & Serializable & scala.Serializable)x$25 -> (Seq)x$25.apply(x.index()));
                if (gradients.isDefined() && ((SeqLike)gradients.get()).lengthCompare(1) > 0) {
                    throw new IllegalArgumentException("The gradients should have been aggregated by now.");
                }
                return (OutputLike)gradients.map((Function1 & Serializable & scala.Serializable)x$26 -> (OutputLike)x$26.head()).orNull(Predef$.MODULE$.$conforms());
            }, scala.collection.Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    public Seq<OutputLike> gradients$default$3() {
        return null;
    }

    public boolean gradients$default$4() {
        return false;
    }

    public Gradients.AggregationMethod gradients$default$5() {
        return Gradients$AddAggregationMethod$.MODULE$;
    }

    public boolean gradients$default$6() {
        return false;
    }

    public String gradients$default$7() {
        return "Gradients";
    }

    private <R> R maybeColocateWith(Op op, boolean colocateGradientsWithOps, String gradientUID, Function0<R> block) {
        return (R)(colocateGradientsWithOps ? Op$.MODULE$.colocateWithForGradient((scala.collection.immutable.Set<Op>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Op[]{op}))), (Option<String>)new Some((Object)gradientUID), Op$.MODULE$.colocateWithForGradient$default$3(), block) : block.apply());
    }

    private Seq<OutputLike> maybeCompile(String nameScope, Op op, Function0<Seq<OutputLike>> gradientFunction) {
        Seq seq;
        block3: {
            String cleanNameScope = new StringOps(Predef$.MODULE$.augmentString(nameScope)).stripSuffix("/").replace('/', '_');
            try {
                boolean xlaCompile = op.booleanAttribute("_XlaCompile");
                if (!xlaCompile) {
                    seq = (Seq)gradientFunction.apply();
                    break block3;
                }
                boolean xlaSeparateCompileGradient = op.booleanAttribute("_XlaSeparateCompiledGradients");
                String xlaScope = op.stringAttribute("_XlaScope");
                String xlaGradientsScope = xlaSeparateCompileGradient ? new StringBuilder(6).append(xlaScope).append("_grad_").append(cleanNameScope).toString() : xlaScope;
                scala.collection.immutable.Map x$74 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"_XlaCompile"), (Object)BoxesRunTime.boxToBoolean((boolean)xlaCompile)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"_XlaScope"), (Object)xlaGradientsScope)}));
                Graph x$75 = Op$.MODULE$.createWith$default$1();
                String x$76 = Op$.MODULE$.createWith$default$2();
                String x$77 = Op$.MODULE$.createWith$default$3();
                Function1<OpSpecification, String> x$78 = Op$.MODULE$.createWith$default$4();
                scala.collection.immutable.Set<Op> x$79 = Op$.MODULE$.createWith$default$5();
                scala.collection.immutable.Set<Op> x$80 = Op$.MODULE$.createWith$default$6();
                String x$81 = Op$.MODULE$.createWith$default$8();
                Function0 & Serializable & scala.Serializable x$82 = (Function0 & Serializable & scala.Serializable)() -> (Seq)gradientFunction.apply();
                seq = (Seq)Op$.MODULE$.createWith(x$75, x$76, x$77, x$78, x$79, x$80, (scala.collection.immutable.Map<String, Object>)x$74, x$81, x$82);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                seq = (Seq)gradientFunction.apply();
            }
        }
        return seq;
    }

    private boolean isTrainable(OutputLike tensor) {
        return ((scala.collection.SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{package$.MODULE$.FLOAT16(), package$.MODULE$.FLOAT32(), package$.MODULE$.FLOAT64(), package$.MODULE$.COMPLEX64(), package$.MODULE$.COMPLEX128()}))).contains((Object)tensor.dataType());
    }

    private Seq<OutputLike> initialGradients(Seq<OutputLike> ys, Seq<OutputLike> dys, boolean colocateGradientsWithOps, String gradientUID) throws package.exception.InvalidDataTypeException {
        return (Seq)((TraversableLike)((IterableLike)ys.zip(dys != null ? dys : (GenIterable)scala.collection.Seq$.MODULE$.fill(ys.length(), (Function0 & Serializable & scala.Serializable)() -> null), scala.collection.Seq$.MODULE$.canBuildFrom())).zipWithIndex(scala.collection.Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            OutputLike outputLike;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            OutputLike y = (OutputLike)tuple22._1();
            OutputLike dy = (OutputLike)tuple22._2();
            if (dy == null) {
                if (y.dataType().isComplex()) {
                    throw new package.exception.InvalidDataTypeException(new StringBuilder(75).append("Gradients of complex tensors must set 'gradients' (variable.dataType = '").append(y.dataType()).append("').").toString(), package$exception$InvalidDataTypeException$.MODULE$.apply$default$2());
                }
                outputLike = (OutputLike)MODULE$.maybeColocateWith(y.op(), colocateGradientsWithOps, gradientUID, (Function0 & Serializable & scala.Serializable)() -> {
                    Output output;
                    OutputLike outputLike = y;
                    if (outputLike instanceof Output) {
                        Output output2;
                        Output x$83 = output2 = (Output)outputLike;
                        String x$84 = new StringBuilder(10).append("Gradients_").append(index).toString();
                        DataType x$85 = Basic$.MODULE$.onesLike$default$2();
                        boolean x$86 = Basic$.MODULE$.onesLike$default$3();
                        output = Basic$.MODULE$.onesLike(x$83, x$85, x$86, x$84);
                    } else if (outputLike instanceof OutputIndexedSlices) {
                        OutputIndexedSlices outputIndexedSlices = (OutputIndexedSlices)outputLike;
                        if (outputIndexedSlices.denseShape() == null) {
                            throw new IllegalArgumentException("The dense shape of output indexed slices must be known in order to obtain their gradients.");
                        }
                        output = Basic$.MODULE$.ones(outputIndexedSlices.dataType(), outputIndexedSlices.denseShape(), new StringBuilder(10).append("Gradients_").append(index).toString());
                    } else if (outputLike instanceof SparseOutput) {
                        SparseOutput sparseOutput = (SparseOutput)outputLike;
                        output = Basic$.MODULE$.ones(sparseOutput.dataType(), sparseOutput.denseShape(), new StringBuilder(10).append("Gradients_").append(index).toString());
                    } else {
                        throw new MatchError((Object)outputLike);
                    }
                    return output;
                });
                return outputLike;
            } else {
                void var4_13;
                OutputLike outputLike2;
                if (y.dataType().isFloatingPoint() || y.dataType().isInteger()) {
                    if (!dy.dataType().isFloatingPoint() && !dy.dataType().isInteger()) {
                        throw new package.exception.InvalidDataTypeException(new StringBuilder(84).append("Gradient data type '").append(dy.dataType()).append("' generated for real or integer-valued tensor '").append(y).append("' with data type ").append(new StringBuilder(27).append("'").append(y.dataType()).append("' must be real or integer.").toString()).toString(), package$exception$InvalidDataTypeException$.MODULE$.apply$default$2());
                    }
                } else {
                    if (!y.dataType().isComplex()) throw new package.exception.InvalidDataTypeException(new StringBuilder(82).append("Tensor '").append(y).append("' with data type '").append(y.dataType()).append("' must be numeric in order to obtain a default gradient.").toString(), package$exception$InvalidDataTypeException$.MODULE$.apply$default$2());
                    if (!dy.dataType().isComplex()) {
                        throw new package.exception.InvalidDataTypeException(new StringBuilder(76).append("Gradient data type '").append(dy.dataType()).append("' generated for complex-valued tensor '").append(y).append("' with data type ").append(new StringBuilder(19).append("'").append(y.dataType()).append("' must be complex.").toString()).toString(), package$exception$InvalidDataTypeException$.MODULE$.apply$default$2());
                    }
                }
                if ((outputLike2 = dy) instanceof Output) {
                    Output output = (Output)outputLike2;
                    Output output2 = Basic$.MODULE$.identity(output, new StringBuilder(10).append("Gradients_").append(index).toString());
                } else if (outputLike2 instanceof OutputIndexedSlices) {
                    OutputIndexedSlices outputIndexedSlices = (OutputIndexedSlices)outputLike2;
                    OutputIndexedSlices outputIndexedSlices2 = new OutputIndexedSlices(Basic$.MODULE$.identity(outputIndexedSlices.indices(), new StringBuilder(18).append("Gradients_").append(index).append("_Indices").toString()), Basic$.MODULE$.identity(outputIndexedSlices.values(), new StringBuilder(17).append("Gradients_").append(index).append("_Values").toString()), outputIndexedSlices.denseShape() == null ? outputIndexedSlices.denseShape() : Basic$.MODULE$.identity(outputIndexedSlices.denseShape(), new StringBuilder(21).append("Gradients_").append(index).append("_DenseShape").toString()));
                } else {
                    if (!(outputLike2 instanceof SparseOutput)) throw new MatchError((Object)outputLike2);
                    SparseOutput sparseOutput = (SparseOutput)outputLike2;
                    SparseOutput sparseOutput2 = new SparseOutput(Basic$.MODULE$.identity(sparseOutput.indices(), new StringBuilder(18).append("Gradients_").append(index).append("_Indices").toString()), Basic$.MODULE$.identity(sparseOutput.values(), new StringBuilder(17).append("Gradients_").append(index).append("_Values").toString()), sparseOutput.denseShape() == null ? sparseOutput.denseShape() : Basic$.MODULE$.identity(sparseOutput.denseShape(), new StringBuilder(21).append("Gradients_").append(index).append("_DenseShape").toString()));
                }
                outputLike = var4_13;
            }
            return outputLike;
        }, scala.collection.Seq$.MODULE$.canBuildFrom());
    }

    private String initialGradients$default$4() {
        return "__unsupported__";
    }

    private Tuple2<Map<Op, Object>, Option<GradientState>> initialPendingCounts(scala.collection.immutable.Set<Op> sourceOps, scala.collection.immutable.Set<Op> destinationOps, boolean colocateGradientsWithOps) {
        Set reached = (Set)Set$.MODULE$.apply(destinationOps.toSeq());
        Queue reachedQueue = (Queue)Queue$.MODULE$.apply(sourceOps.toSeq());
        while (reachedQueue.nonEmpty()) {
            Op op = (Op)reachedQueue.dequeue();
            if (reached.contains((Object)op)) continue;
            reached.$plus$eq((Object)op);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])op.outputs())).foreach((Function1 & Serializable & scala.Serializable)o -> {
                reachedQueue.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])o.consumers())).map((Function1 & Serializable & scala.Serializable)x$27 -> x$27.op(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Op.class)))));
                return BoxedUnit.UNIT;
            });
        }
        Set between = Set$.MODULE$.empty();
        ListBuffer betweenList = (ListBuffer)ListBuffer$.MODULE$.empty();
        Queue betweenQueue = (Queue)Queue$.MODULE$.apply(destinationOps.toSeq());
        while (betweenQueue.nonEmpty()) {
            Op op = (Op)betweenQueue.dequeue();
            if (!reached.contains((Object)op)) continue;
            between.$plus$eq((Object)op);
            betweenList.$plus$eq((Object)op);
            reached.$minus$eq((Object)op);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])op.inputs())).foreach((Function1 & Serializable & scala.Serializable)i -> {
                betweenQueue.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Op[]{i.op()}));
                return BoxedUnit.UNIT;
            });
        }
        Option<GradientState> controlFlowGradientState = GradientState$.MODULE$.maybeCreate((Set<Op>)between, (ListBuffer<Op>)betweenList, colocateGradientsWithOps);
        Map pendingCounts = Map$.MODULE$.empty();
        ((TraversableForwarder)((TraversableLike)((TraversableLike)betweenList.flatMap((Function1 & Serializable & scala.Serializable)x$28 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$28.inputs())), ListBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$29 -> x$29.op(), ListBuffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)between.contains((Object)elem)))).foreach((Function1 & Serializable & scala.Serializable)input -> {
            pendingCounts.update((Object)input, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)pendingCounts.getOrElse((Object)input, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + 1)));
            return BoxedUnit.UNIT;
        });
        return new Tuple2((Object)pendingCounts, controlFlowGradientState);
    }

    private void setGradient(Map<Op, scala.collection.mutable.Seq<Seq<OutputLike>>> gradients, Output output, OutputLike gradient) {
        scala.collection.mutable.Seq opGradients = (scala.collection.mutable.Seq)gradients.getOrElseUpdate((Object)output.op(), (Function0 & Serializable & scala.Serializable)() -> (scala.collection.mutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])output.op().outputs())).map((Function1 & Serializable & scala.Serializable)x$30 -> (Seq)scala.collection.Seq$.MODULE$.empty(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class))))));
        if (ControlFlow$.MODULE$.isLoopSwitch(output.op())) {
            opGradients.update(output.index(), (Object)scala.collection.Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OutputLike[]{gradient})));
        } else {
            opGradients.update(output.index(), ((SeqLike)opGradients.apply(output.index())).$colon$plus((Object)gradient, scala.collection.Seq$.MODULE$.canBuildFrom()));
        }
    }

    private void logGradients(Op op, Seq<OutputLike> outputGradients, Seq<OutputLike> inputGradients) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Gradients for op '{}':", new Object[]{op.name()});
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("  in  --> {}", new Object[]{((TraversableOnce)((TraversableLike)outputGradients.filter((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)Gradients$.$anonfun$logGradients$1(x$31)))).map((Function1 & Serializable & scala.Serializable)x$32 -> x$32.name(), scala.collection.Seq$.MODULE$.canBuildFrom())).mkString(", ")});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("  out --> {}", new Object[]{((TraversableOnce)((TraversableLike)inputGradients.filter((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)Gradients$.$anonfun$logGradients$3(x$33)))).map((Function1 & Serializable & scala.Serializable)x$34 -> x$34.name(), scala.collection.Seq$.MODULE$.canBuildFrom())).mkString(", ")});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Output[] ccGradients(Output[] y, Output[] x, Output[] dx) {
        if (dx != null && dx.length != y.length) {
            throw new IllegalArgumentException(new StringBuilder(52).append("The number of ys (").append(y.length).append(") must match the number of dxs (").append(dx.length).append(").").toString());
        }
        Graph graph = ((Output)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])y)).head()).graph();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])y)).foreach((Function1 & Serializable & scala.Serializable)o -> {
            Op$.MODULE$.assertSameGraph(o.op(), ((Output)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])y)).head()).op());
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x)).foreach((Function1 & Serializable & scala.Serializable)o -> {
            Op$.MODULE$.assertSameGraph(o.op(), ((Output)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])y)).head()).op());
            return BoxedUnit.UNIT;
        });
        if (dx != null) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dx)).foreach((Function1 & Serializable & scala.Serializable)o -> {
                Op$.MODULE$.assertSameGraph(o.op(), ((Output)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])y)).head()).op());
                return BoxedUnit.UNIT;
            });
        }
        org.platanios.tensorflow.jni.Output[] yJNI = (org.platanios.tensorflow.jni.Output[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])y)).map((Function1 & Serializable & scala.Serializable)o -> new org.platanios.tensorflow.jni.Output(o.op().nativeHandle(), o.index()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(org.platanios.tensorflow.jni.Output.class)));
        org.platanios.tensorflow.jni.Output[] xJNI = (org.platanios.tensorflow.jni.Output[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x)).map((Function1 & Serializable & scala.Serializable)o -> new org.platanios.tensorflow.jni.Output(o.op().nativeHandle(), o.index()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(org.platanios.tensorflow.jni.Output.class)));
        org.platanios.tensorflow.jni.Output[] dxJNI = dx == null ? null : (org.platanios.tensorflow.jni.Output[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dx)).map((Function1 & Serializable & scala.Serializable)o -> new org.platanios.tensorflow.jni.Output(o.op().nativeHandle(), o.index()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(org.platanios.tensorflow.jni.Output.class)));
        org.platanios.tensorflow.jni.Output[] jniGradients = Graph$.MODULE$.addGradients(graph.nativeHandle(), yJNI, xJNI, dxJNI);
        return (Output[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jniGradients)).map((Function1 & Serializable & scala.Serializable)o -> {
            Op op = (Op)graph.opsCache().getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)o.opHandle()), (Function0 & Serializable & scala.Serializable)() -> Op$.MODULE$.apply(graph, o.opHandle()));
            return Output$.MODULE$.apply(op, o.outputIndex());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Output.class)));
    }

    public Output[] ccGradients$default$3() {
        return null;
    }

    public static final /* synthetic */ boolean $anonfun$gradients$8(Map pendingCounts$1, Op x$7) {
        return BoxesRunTime.unboxToInt((Object)pendingCounts$1.getOrElse((Object)x$7, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) == 0;
    }

    public static final /* synthetic */ boolean $anonfun$gradients$10(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$gradients$11(Map accumulatedGradients$1, Tuple2 x$8) {
        Tuple2 tuple2 = x$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Output y = (Output)tuple2._1();
        OutputLike dy = (OutputLike)tuple2._2();
        MODULE$.setGradient((Map<Op, scala.collection.mutable.Seq<Seq<OutputLike>>>)accumulatedGradients$1, y, dy);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$gradients$14(Map accumulatedGradients$1, Queue readyOps$1, GradientState state$1, Output loopExit) {
        MODULE$.setGradient((Map<Op, scala.collection.mutable.Seq<Seq<OutputLike>>>)accumulatedGradients$1, loopExit, state$1.zerosLikeForExit(loopExit));
        readyOps$1.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Op[]{loopExit.op()}));
    }

    public static final /* synthetic */ void $anonfun$gradients$12(Map accumulatedGradients$1, scala.collection.immutable.Set destinationOps$1, Map pendingCounts$1, Queue readyOps$1, GradientState state) {
        ((IterableLike)state.processUnusedLoopExits((Map<Op, Object>)pendingCounts$1, (scala.collection.immutable.Set<Op>)destinationOps$1).filter((Function1 & Serializable & scala.Serializable)tensor -> BoxesRunTime.boxToBoolean((boolean)Gradients$.MODULE$.isTrainable(tensor)))).foreach((Function1 & Serializable & scala.Serializable)loopExit -> {
            Gradients$.$anonfun$gradients$14(accumulatedGradients$1, readyOps$1, state, loopExit);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$gradients$16(Map pendingCounts$1, Output i) {
        return BoxesRunTime.unboxToInt((Object)pendingCounts$1.getOrElse((Object)i.op(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) <= 0;
    }

    public static final /* synthetic */ boolean $anonfun$gradients$15(Map pendingCounts$1, Op x$9) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$9.inputs())).forall((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)Gradients$.$anonfun$gradients$16(pendingCounts$1, i)));
    }

    public static final /* synthetic */ boolean $anonfun$gradients$22(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$gradients$23(Option controlFlowGradientState$1, Op op$1, scala.collection.mutable.Seq opGradients$1, Tuple2 x$14) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$14;
        if (tuple2 != null) {
            Seq gradient = (Seq)tuple2._1();
            int outputIndex = tuple2._2$mcI$sp();
            Output output = op$1.outputs()[outputIndex];
            if (gradient.isEmpty() && MODULE$.isTrainable(output)) {
                opGradients$1.update(outputIndex, (Object)scala.collection.Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OutputLike[]{(OutputLike)((Option)controlFlowGradientState$1.map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.zerosLike(op$1, outputIndex)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)Context$.MODULE$.zerosLikeOutsideLoop(op$1, outputIndex)))).orNull(Predef$.MODULE$.$conforms())})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$gradients$29(OutputLike x$16) {
        return x$16 != null;
    }

    public static final /* synthetic */ boolean $anonfun$gradients$33(Tuple2 x$17) {
        return x$17._2() != null;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$gradients$34(Map accumulatedGradients$1, Tuple2 i) {
        var3_2 = (OutputLike)i._2();
        if (!(var3_2 instanceof Output)) ** GOTO lbl-1000
        var4_3 = (Output)var3_2;
        v0 = ((Output)i._1()).dataType();
        var5_4 = package$.MODULE$.RESOURCE();
        if (v0 == null ? var5_4 != null : v0.equals(var5_4) == false) {
            var4_3.setShape(((Output)i._1()).shape());
            var2_5 = BoxedUnit.UNIT;
        } else lbl-1000:
        // 2 sources

        {
            var2_6 = BoxedUnit.UNIT;
        }
        Gradients$.MODULE$.setGradient((Map<Op, scala.collection.mutable.Seq<Seq<OutputLike>>>)accumulatedGradients$1, (Output)i._1(), (OutputLike)i._2());
    }

    public static final /* synthetic */ boolean $anonfun$gradients$44(OutputLike x$23) {
        return x$23 != null;
    }

    public static final /* synthetic */ void $anonfun$gradients$45(Map accumulatedGradients$1, Option controlFlowGradientState$1, Queue readyOps$1, Output exit) {
        if (MODULE$.isTrainable(exit)) {
            MODULE$.setGradient((Map<Op, scala.collection.mutable.Seq<Seq<OutputLike>>>)accumulatedGradients$1, exit, ((GradientState)controlFlowGradientState$1.get()).zerosLikeForExit(exit));
        }
        readyOps$1.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Op[]{exit.op()}));
    }

    public static final /* synthetic */ void $anonfun$gradients$40(Map accumulatedGradients$1, Option controlFlowGradientState$1, Queue readyOps$1, Output input$1, GradientLoopState state) {
        block2: {
            state.deferredExits().$plus$eq((Object)input$1);
            state.pendingExitsCount_$eq(state.pendingExitsCount() - 1);
            if (state.pendingExitsCount() != 0) break block2;
            BooleanRef hasRealGradient = BooleanRef.create((boolean)false);
            state.deferredExits().foreach((Function1 & Serializable & scala.Serializable)exit -> {
                SetLike setLike;
                if (accumulatedGradients$1.get((Object)exit.op()).exists((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)x$21.exists((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)x$22.exists((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)Gradients$.$anonfun$gradients$44(x$23)))))))) {
                    hasRealGradient$1.elem = true;
                    readyOps$1.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Op[]{exit.op()}));
                    setLike = BoxedUnit.UNIT;
                } else {
                    setLike = state.unusedExits().$plus$eq(exit);
                }
                return setLike;
            });
            if (hasRealGradient.elem) {
                state.unusedExits().foreach((Function1 & Serializable & scala.Serializable)exit -> {
                    Gradients$.$anonfun$gradients$45(accumulatedGradients$1, controlFlowGradientState$1, readyOps$1, exit);
                    return BoxedUnit.UNIT;
                });
            } else {
                state.unusedExits().foreach((Function1 & Serializable & scala.Serializable)exit -> {
                    readyOps$1.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Op[]{exit.op()}));
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    public static final /* synthetic */ void $anonfun$gradients$36(Map accumulatedGradients$1, Map pendingCounts$1, Option controlFlowGradientState$1, Queue readyOps$1, Output input) {
        block3: {
            pendingCounts$1.update((Object)input.op(), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)pendingCounts$1.getOrElse((Object)input.op(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) - 1)));
            BooleanRef ready = BooleanRef.create((BoxesRunTime.unboxToInt((Object)pendingCounts$1.apply((Object)input.op())) == 0 ? 1 : 0) != 0);
            if (!ready.elem) {
                controlFlowGradientState$1.foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
                    ready.elem = BoxesRunTime.unboxToInt((Object)pendingCounts$1.apply((Object)input.op())) > 0 && ControlFlow$.MODULE$.isLoopSwitch(input.op());
                    return BoxedUnit.UNIT;
                });
            }
            if (!ready.elem) break block3;
            if (ControlFlow$.MODULE$.isLoopExit(input.op())) {
                controlFlowGradientState$1.flatMap((Function1 & Serializable & scala.Serializable)x$20 -> x$20.getGradientLoopState(input.op(), false)).foreach((Function1 & Serializable & scala.Serializable)state -> {
                    Gradients$.$anonfun$gradients$40(accumulatedGradients$1, controlFlowGradientState$1, readyOps$1, input, state);
                    return BoxedUnit.UNIT;
                });
            } else {
                readyOps$1.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Op[]{input.op()}));
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$logGradients$1(OutputLike x$31) {
        return x$31 != null;
    }

    public static final /* synthetic */ boolean $anonfun$logGradients$3(OutputLike x$33) {
        return x$33 != null;
    }

    private Gradients$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)"Gradients"));
    }
}

