/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.api.ops;

import java.io.Serializable;
import org.platanios.tensorflow.api.core.Shape;
import org.platanios.tensorflow.api.ops.Op;
import org.platanios.tensorflow.api.ops.Output;
import org.platanios.tensorflow.api.ops.Parsing;
import org.platanios.tensorflow.api.tensors.Tensor;
import org.platanios.tensorflow.api.types.DataType;
import org.platanios.tensorflow.api.types.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple8;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Parsing$
implements Parsing {
    public static Parsing$ MODULE$;

    static {
        new Parsing$();
    }

    @Override
    public Output encodeTensor(Output tensor, String name) {
        return Parsing.encodeTensor$(this, tensor, name);
    }

    @Override
    public Output decodeTensor(Output data, DataType dataType, String name) throws IllegalArgumentException {
        return Parsing.decodeTensor$(this, data, dataType, name);
    }

    @Override
    public Output decodeRaw(Output bytes, DataType dataType, boolean littleEndian, String name) throws IllegalArgumentException {
        return Parsing.decodeRaw$(this, bytes, dataType, littleEndian, name);
    }

    @Override
    public Seq<Output> decodeCSV(Output records, Seq<Output> recordDefaults, Seq<DataType> dataTypes, String delimiter, boolean useQuoteDelimiters, String name) throws IllegalArgumentException {
        return Parsing.decodeCSV$(this, records, recordDefaults, dataTypes, delimiter, useQuoteDelimiters, name);
    }

    @Override
    public Output stringToNumber(Output data, DataType dataType, String name) throws IllegalArgumentException {
        return Parsing.stringToNumber$(this, data, dataType, name);
    }

    @Override
    public Output decodeJSONExample(Output jsonExamples, String name) throws IllegalArgumentException {
        return Parsing.decodeJSONExample$(this, jsonExamples, name);
    }

    @Override
    public String encodeTensor$default$2() {
        return Parsing.encodeTensor$default$2$(this);
    }

    @Override
    public String decodeTensor$default$3() {
        return Parsing.decodeTensor$default$3$(this);
    }

    @Override
    public boolean decodeRaw$default$3() {
        return Parsing.decodeRaw$default$3$(this);
    }

    @Override
    public String decodeRaw$default$4() {
        return Parsing.decodeRaw$default$4$(this);
    }

    @Override
    public String decodeCSV$default$4() {
        return Parsing.decodeCSV$default$4$(this);
    }

    @Override
    public boolean decodeCSV$default$5() {
        return Parsing.decodeCSV$default$5$(this);
    }

    @Override
    public String decodeCSV$default$6() {
        return Parsing.decodeCSV$default$6$(this);
    }

    @Override
    public String stringToNumber$default$3() {
        return Parsing.stringToNumber$default$3$(this);
    }

    @Override
    public String decodeJSONExample$default$2() {
        return Parsing.decodeJSONExample$default$2$(this);
    }

    private Parsing.RawParameters featuresToRawParameters(Map<String, Parsing.Feature> features) throws IllegalArgumentException {
        ListBuffer sparseKeys = (ListBuffer)ListBuffer$.MODULE$.empty();
        ListBuffer sparseTypes = (ListBuffer)ListBuffer$.MODULE$.empty();
        ListBuffer denseKeys = (ListBuffer)ListBuffer$.MODULE$.empty();
        ListBuffer denseTypes = (ListBuffer)ListBuffer$.MODULE$.empty();
        ListBuffer denseShapes = (ListBuffer)ListBuffer$.MODULE$.empty();
        ListBuffer denseDefaults = (ListBuffer)ListBuffer$.MODULE$.empty();
        ((IterableLike)features.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Parsing$.$anonfun$featuresToRawParameters$2(sparseKeys, sparseTypes, denseKeys, denseTypes, denseShapes, denseDefaults, x0$1);
            return BoxedUnit.UNIT;
        });
        return new Parsing.RawParameters((Seq<String>)sparseKeys.toList(), (Seq<DataType>)sparseTypes.toList(), (Seq<String>)denseKeys.toList(), (Seq<DataType>)denseTypes.toList(), (Seq<Shape>)denseShapes.toList(), (ListMap<String, Tensor>)((ListMap)ListMap$.MODULE$.apply((Seq)denseDefaults)));
    }

    public Tuple4<Seq<Output>, Seq<Output>, Seq<Output>, Seq<Output>> parseExample(Output bytes, Seq<Output> sparseKeys, Seq<DataType> sparseTypes, Seq<Output> denseKeys, Seq<Shape> denseShapes, Seq<Output> denseDefaults, Output debugNames, String name) throws IllegalArgumentException {
        DataType dataType = bytes.dataType();
        DataType.Aux<String> aux = package$.MODULE$.STRING();
        Predef$.MODULE$.require(!(dataType != null ? !((Object)dataType).equals(aux) : aux != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Tensor data type was ").append(bytes.dataType()).append(", while STRING was expected.").toString());
        Predef$.MODULE$.require(!sparseKeys.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Parsing$.$anonfun$parseExample$3(x$2))), (Function0 & Serializable & scala.Serializable)() -> "The sparse keys must all be STRING tensors.");
        Predef$.MODULE$.require(!denseKeys.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Parsing$.$anonfun$parseExample$5(x$3))), (Function0 & Serializable & scala.Serializable)() -> "The dense keys must all be STRING tensors.");
        Predef$.MODULE$.require(sparseKeys.length() == sparseTypes.length(), (Function0 & Serializable & scala.Serializable)() -> "The number of sparse keys does not match that of sparse types.");
        Predef$.MODULE$.require(denseKeys.length() == denseShapes.length(), (Function0 & Serializable & scala.Serializable)() -> "The number of dense keys does not match that of dense shapes.");
        Predef$.MODULE$.require(denseKeys.length() == denseDefaults.length(), (Function0 & Serializable & scala.Serializable)() -> "The number of dense keys does not match that of dense defaults.");
        DataType dataType2 = debugNames.dataType();
        DataType.Aux<String> aux2 = package$.MODULE$.STRING();
        Predef$.MODULE$.require(!(dataType2 != null ? !((Object)dataType2).equals(aux2) : aux2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Tensor data type was ").append(debugNames.dataType()).append(", while STRING was expected.").toString());
        int numSparse = sparseKeys.length();
        int numDense = denseKeys.length();
        Output[] outputs = new Op.Builder("ParseExample", name).addInput(bytes).addInput(debugNames).addInputList(sparseKeys).addInputList(denseKeys).addInputList(denseDefaults).setAttribute("sparse_types", (DataType[])sparseTypes.toArray(ClassTag$.MODULE$.apply(DataType.class))).setAttribute("dense_shapes", (Shape[])denseShapes.toArray(ClassTag$.MODULE$.apply(Shape.class))).build().outputs();
        Output[] sparseIndices = (Output[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputs)).take(numSparse);
        Output[] sparseValues = (Output[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputs)).slice(numSparse, 2 * numSparse);
        Output[] sparseShapes = (Output[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputs)).slice(2 * numSparse, 3 * numSparse);
        Output[] denseValues = (Output[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputs)).takeRight(numDense);
        return new Tuple4((Object)Predef$.MODULE$.wrapRefArray((Object[])sparseIndices), (Object)Predef$.MODULE$.wrapRefArray((Object[])sparseValues), (Object)Predef$.MODULE$.wrapRefArray((Object[])sparseShapes), (Object)Predef$.MODULE$.wrapRefArray((Object[])denseValues));
    }

    public String parseExample$default$8() {
        return "ParseExample";
    }

    public Tuple8<Seq<Output>, Seq<Output>, Seq<Output>, Seq<Output>, Seq<Output>, Seq<Output>, Seq<Output>, Seq<Output>> parseSingleSequenceExample(Output bytes, Seq<Output> contextSparseKeys, Seq<DataType> contextSparseTypes, Seq<Output> contextDenseKeys, Seq<Shape> contextDenseShapes, Seq<Output> contextDenseDefaults, Seq<Output> featureListSparseKeys, Seq<DataType> featureListSparseTypes, Seq<Output> featureListDenseKeys, Seq<Shape> featureListDenseShapes, Output featureListDenseMissingAssumedEmpty, Output debugName, String name) {
        DataType dataType = bytes.dataType();
        DataType.Aux<String> aux = package$.MODULE$.STRING();
        Predef$.MODULE$.require(!(dataType != null ? !((Object)dataType).equals(aux) : aux != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Tensor data type was ").append(bytes.dataType()).append(", while STRING was expected.").toString());
        Predef$.MODULE$.require(!contextSparseKeys.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Parsing$.$anonfun$parseSingleSequenceExample$3(x$4))), (Function0 & Serializable & scala.Serializable)() -> "The context sparse keys must all be STRING tensors.");
        Predef$.MODULE$.require(!contextDenseKeys.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Parsing$.$anonfun$parseSingleSequenceExample$5(x$5))), (Function0 & Serializable & scala.Serializable)() -> "The context dense keys must all be STRING tensors.");
        Predef$.MODULE$.require(!featureListSparseKeys.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Parsing$.$anonfun$parseSingleSequenceExample$7(x$6))), (Function0 & Serializable & scala.Serializable)() -> "The feature list sparse keys must all be STRING tensors.");
        Predef$.MODULE$.require(!featureListDenseKeys.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)Parsing$.$anonfun$parseSingleSequenceExample$9(x$7))), (Function0 & Serializable & scala.Serializable)() -> "The feature list dense keys must all be STRING tensors.");
        Predef$.MODULE$.require(contextSparseKeys.length() == contextSparseTypes.length(), (Function0 & Serializable & scala.Serializable)() -> "The number of context sparse keys does not match that of context sparse types.");
        Predef$.MODULE$.require(contextDenseKeys.length() == featureListDenseShapes.length(), (Function0 & Serializable & scala.Serializable)() -> "The number of context dense keys does not match that of context dense shapes.");
        Predef$.MODULE$.require(contextDenseKeys.length() == contextDenseDefaults.length(), (Function0 & Serializable & scala.Serializable)() -> "The number of context dense keys does not match that of context dense defaults.");
        Predef$.MODULE$.require(featureListSparseKeys.length() == featureListSparseTypes.length(), (Function0 & Serializable & scala.Serializable)() -> "The number of feature list sparse keys does not match that of feature list sparse types.");
        Predef$.MODULE$.require(featureListDenseKeys.length() == featureListDenseShapes.length(), (Function0 & Serializable & scala.Serializable)() -> "The number of feature list dense keys does not match that of feature list dense shapes.");
        DataType dataType2 = featureListDenseMissingAssumedEmpty.dataType();
        DataType.Aux<String> aux2 = package$.MODULE$.STRING();
        Predef$.MODULE$.require(!(dataType2 != null ? !((Object)dataType2).equals(aux2) : aux2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Tensor data type was ").append(featureListDenseMissingAssumedEmpty.dataType()).append(", while STRING was expected.").toString());
        DataType dataType3 = debugName.dataType();
        DataType.Aux<String> aux3 = package$.MODULE$.STRING();
        Predef$.MODULE$.require(!(dataType3 != null ? !((Object)dataType3).equals(aux3) : aux3 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Tensor data type was ").append(debugName.dataType()).append(", while STRING was expected.").toString());
        int numContextSparse = contextSparseKeys.length();
        int numContextDense = contextDenseKeys.length();
        int numFeatureListSparse = featureListSparseKeys.length();
        int numFeatureListDense = featureListDenseKeys.length();
        Output[] outputs = new Op.Builder("ParseSingleSequenceExample", name).addInput(bytes).addInput(featureListDenseMissingAssumedEmpty).addInputList(contextSparseKeys).addInputList(contextDenseKeys).addInputList(featureListSparseKeys).addInputList(featureListDenseKeys).addInputList(contextDenseDefaults).addInput(debugName).setAttribute("context_sparse_types", (DataType[])contextSparseTypes.toArray(ClassTag$.MODULE$.apply(DataType.class))).setAttribute("context_dense_shapes", (Shape[])contextDenseShapes.toArray(ClassTag$.MODULE$.apply(Shape.class))).setAttribute("feature_list_sparse_types", (DataType[])featureListSparseTypes.toArray(ClassTag$.MODULE$.apply(DataType.class))).setAttribute("feature_list_dense_shapes", (Shape[])featureListDenseShapes.toArray(ClassTag$.MODULE$.apply(Shape.class))).build().outputs();
        int index = 0;
        Output[] contextSparseIndices = (Output[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputs)).take(index + numContextSparse);
        Output[] contextSparseValues = (Output[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputs)).slice(index += numContextSparse, index + numContextSparse);
        Output[] contextSparseShapes = (Output[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputs)).slice(index += numContextSparse, index + numContextSparse);
        Output[] contextDenseValues = (Output[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputs)).slice(index += numContextSparse, index + numContextDense);
        Output[] featureListSparseIndices = (Output[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputs)).slice(index += numContextDense, index + numFeatureListSparse);
        Output[] featureListSparseValues = (Output[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputs)).slice(index += numFeatureListSparse, index + numFeatureListSparse);
        Output[] featureListSparseShapes = (Output[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputs)).slice(index += numFeatureListSparse, index + numFeatureListSparse);
        Output[] featureListDenseValues = (Output[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputs)).slice(index += numFeatureListSparse, index + numFeatureListDense);
        return new Tuple8((Object)Predef$.MODULE$.wrapRefArray((Object[])contextSparseIndices), (Object)Predef$.MODULE$.wrapRefArray((Object[])contextSparseValues), (Object)Predef$.MODULE$.wrapRefArray((Object[])contextSparseShapes), (Object)Predef$.MODULE$.wrapRefArray((Object[])contextDenseValues), (Object)Predef$.MODULE$.wrapRefArray((Object[])featureListSparseIndices), (Object)Predef$.MODULE$.wrapRefArray((Object[])featureListSparseValues), (Object)Predef$.MODULE$.wrapRefArray((Object[])featureListSparseShapes), (Object)Predef$.MODULE$.wrapRefArray((Object[])featureListDenseValues));
    }

    public String parseSingleSequenceExample$default$13() {
        return "ParseSingleSequenceExample";
    }

    public static final /* synthetic */ void $anonfun$featuresToRawParameters$3(ListBuffer sparseKeys$1, ListBuffer sparseTypes$1, String k) {
        if (sparseKeys$1.contains((Object)k)) {
            DataType dType;
            DataType dataType = dType = (DataType)sparseTypes$1.apply(sparseKeys$1.indexOf((Object)k));
            DataType.Aux<Object> aux = package$.MODULE$.INT64();
            if (dataType == null ? aux != null : !((Object)dataType).equals(aux)) {
                throw new IllegalArgumentException(new StringBuilder(40).append("Conflicting type ").append(dType).append(" vs INT64 for feature ").append(k).append(".").toString());
            }
        } else {
            sparseKeys$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{k}));
            sparseTypes$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{package$.MODULE$.INT64()}));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$featuresToRawParameters$2(ListBuffer sparseKeys$1, ListBuffer sparseTypes$1, ListBuffer denseKeys$1, ListBuffer denseTypes$1, ListBuffer denseShapes$1, ListBuffer denseDefaults$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            Parsing.Feature feature = (Parsing.Feature)tuple2._2();
            if (feature instanceof Parsing.VariableLengthFeature) {
                Parsing.VariableLengthFeature variableLengthFeature = (Parsing.VariableLengthFeature)feature;
                DataType dataType = variableLengthFeature.dataType();
                sparseKeys$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{key}));
                sparseTypes$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{dataType}));
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            Parsing.Feature feature = (Parsing.Feature)tuple2._2();
            if (feature instanceof Parsing.FixedLengthFeature) {
                BoxedUnit boxedUnit3;
                Parsing.FixedLengthFeature fixedLengthFeature = (Parsing.FixedLengthFeature)feature;
                DataType dataType = fixedLengthFeature.dataType();
                Shape shape = fixedLengthFeature.shape();
                Tensor defaultValue = fixedLengthFeature.defaultValue();
                if (!shape.isFullyDefined()) {
                    throw new IllegalArgumentException(new StringBuilder(71).append("All dimensions of shape for feature '").append(key).append("' need to be known, but received ").append(shape).append(".").toString());
                }
                denseKeys$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{key}));
                denseTypes$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{dataType}));
                denseShapes$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Shape[]{shape}));
                if (defaultValue != null) {
                    denseDefaults$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)key, (Object)defaultValue)}));
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit4 = boxedUnit3;
                return;
            }
        }
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            Parsing.Feature feature = (Parsing.Feature)tuple2._2();
            if (feature instanceof Parsing.FixedLengthSequenceFeature) {
                BoxedUnit boxedUnit5;
                Parsing.FixedLengthSequenceFeature fixedLengthSequenceFeature = (Parsing.FixedLengthSequenceFeature)feature;
                DataType dataType = fixedLengthSequenceFeature.dataType();
                Shape shape = fixedLengthSequenceFeature.shape();
                boolean allowMissing = fixedLengthSequenceFeature.allowMissing();
                Tensor defaultValue = fixedLengthSequenceFeature.defaultValue();
                denseKeys$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{key}));
                denseTypes$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{dataType}));
                denseShapes$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Shape[]{shape}));
                if (allowMissing || defaultValue != null) {
                    denseDefaults$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)key, (Object)defaultValue)}));
                    boxedUnit5 = BoxedUnit.UNIT;
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit6 = boxedUnit5;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Parsing.Feature feature = (Parsing.Feature)tuple2._2();
        if (!(feature instanceof Parsing.SparseFeature)) throw new MatchError((Object)tuple2);
        Parsing.SparseFeature sparseFeature = (Parsing.SparseFeature)feature;
        Seq<String> indexKey = sparseFeature.indexKey();
        String valueKey = sparseFeature.valueKey();
        DataType dataType = sparseFeature.dataType();
        ((IterableLike)indexKey.sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)k -> {
            Parsing$.$anonfun$featuresToRawParameters$3(sparseKeys$1, sparseTypes$1, k);
            return BoxedUnit.UNIT;
        });
        if (sparseKeys$1.contains((Object)valueKey)) {
            DataType dType;
            DataType dataType2 = dType = (DataType)sparseTypes$1.apply(sparseKeys$1.indexOf((Object)valueKey));
            DataType.Aux<Object> aux = package$.MODULE$.INT64();
            if (dataType2 == null ? aux != null : !((Object)dataType2).equals(aux)) {
                throw new IllegalArgumentException(new StringBuilder(40).append("Conflicting type ").append(dType).append(" vs INT64 for feature ").append(valueKey).append(".").toString());
            }
            boxedUnit = BoxedUnit.UNIT;
        } else {
            sparseKeys$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{valueKey}));
            sparseTypes$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{dataType}));
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit7 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$parseExample$3(Output x$2) {
        DataType dataType = x$2.dataType();
        DataType.Aux<String> aux = package$.MODULE$.STRING();
        return !(dataType != null ? !((Object)dataType).equals(aux) : aux != null);
    }

    public static final /* synthetic */ boolean $anonfun$parseExample$5(Output x$3) {
        DataType dataType = x$3.dataType();
        DataType.Aux<String> aux = package$.MODULE$.STRING();
        return !(dataType != null ? !((Object)dataType).equals(aux) : aux != null);
    }

    public static final /* synthetic */ boolean $anonfun$parseSingleSequenceExample$3(Output x$4) {
        DataType dataType = x$4.dataType();
        DataType.Aux<String> aux = package$.MODULE$.STRING();
        return !(dataType != null ? !((Object)dataType).equals(aux) : aux != null);
    }

    public static final /* synthetic */ boolean $anonfun$parseSingleSequenceExample$5(Output x$5) {
        DataType dataType = x$5.dataType();
        DataType.Aux<String> aux = package$.MODULE$.STRING();
        return !(dataType != null ? !((Object)dataType).equals(aux) : aux != null);
    }

    public static final /* synthetic */ boolean $anonfun$parseSingleSequenceExample$7(Output x$6) {
        DataType dataType = x$6.dataType();
        DataType.Aux<String> aux = package$.MODULE$.STRING();
        return !(dataType != null ? !((Object)dataType).equals(aux) : aux != null);
    }

    public static final /* synthetic */ boolean $anonfun$parseSingleSequenceExample$9(Output x$7) {
        DataType dataType = x$7.dataType();
        DataType.Aux<String> aux = package$.MODULE$.STRING();
        return !(dataType != null ? !((Object)dataType).equals(aux) : aux != null);
    }

    private Parsing$() {
        MODULE$ = this;
        Parsing.$init$(this);
    }
}

