/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.api.ops;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import java.nio.file.Path;
import org.platanios.tensorflow.api.core.Graph;
import org.platanios.tensorflow.api.ops.Op;
import org.platanios.tensorflow.api.ops.Op$;
import org.platanios.tensorflow.api.ops.Output;
import org.platanios.tensorflow.api.ops.Summary;
import org.platanios.tensorflow.api.ops.control_flow.ControlFlow$;
import org.platanios.tensorflow.api.package$;
import org.platanios.tensorflow.api.tensors.Tensor;
import org.platanios.tensorflow.api.tensors.TensorConvertible$;
import org.platanios.tensorflow.api.types.SupportedType$;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class Summary$
implements Summary {
    public static Summary$ MODULE$;
    private final Logger logger;
    private final Regex INVALID_TAG_CHARACTERS;

    static {
        new Summary$();
    }

    @Override
    public Output tensor(String name, Output tensor, Set<Graph.Key<Output>> collections, String family) {
        return Summary.tensor$(this, name, tensor, collections, family);
    }

    @Override
    public Output scalar(String name, Output value, Set<Graph.Key<Output>> collections, String family) {
        return Summary.scalar$(this, name, value, collections, family);
    }

    @Override
    public Output histogram(String name, Output values, Set<Graph.Key<Output>> collections, String family) {
        return Summary.histogram$(this, name, values, collections, family);
    }

    @Override
    public Output image(String name, Output tensor, Tensor badColor, int maxOutputs, Set<Graph.Key<Output>> collections, String family) {
        return Summary.image$(this, name, tensor, badColor, maxOutputs, collections, family);
    }

    @Override
    public Output audio(String name, Output tensor, Output samplingRate, int maxOutputs, Set<Graph.Key<Output>> collections, String family) {
        return Summary.audio$(this, name, tensor, samplingRate, maxOutputs, collections, family);
    }

    @Override
    public Output merge(Set<Output> summaries, Set<Graph.Key<Output>> collections, String name) {
        return Summary.merge$(this, summaries, collections, name);
    }

    @Override
    public Option<Output> mergeAll(Graph.Key<Output> key, String name) {
        return Summary.mergeAll$(this, key, name);
    }

    @Override
    public Graph.Key<Output> mergeAll$default$1() {
        return Summary.mergeAll$default$1$(this);
    }

    @Override
    public String mergeAll$default$2() {
        return Summary.mergeAll$default$2$(this);
    }

    @Override
    public Set<Graph.Key<Output>> scalar$default$3() {
        return Summary.scalar$default$3$(this);
    }

    @Override
    public String scalar$default$4() {
        return Summary.scalar$default$4$(this);
    }

    @Override
    public Set<Graph.Key<Output>> histogram$default$3() {
        return Summary.histogram$default$3$(this);
    }

    @Override
    public String histogram$default$4() {
        return Summary.histogram$default$4$(this);
    }

    @Override
    public Tensor image$default$3() {
        return Summary.image$default$3$(this);
    }

    @Override
    public int image$default$4() {
        return Summary.image$default$4$(this);
    }

    @Override
    public Set<Graph.Key<Output>> image$default$5() {
        return Summary.image$default$5$(this);
    }

    @Override
    public String image$default$6() {
        return Summary.image$default$6$(this);
    }

    @Override
    public int audio$default$4() {
        return Summary.audio$default$4$(this);
    }

    @Override
    public Set<Graph.Key<Output>> audio$default$5() {
        return Summary.audio$default$5$(this);
    }

    @Override
    public String audio$default$6() {
        return Summary.audio$default$6$(this);
    }

    @Override
    public Set<Graph.Key<Output>> tensor$default$3() {
        return Summary.tensor$default$3$(this);
    }

    @Override
    public String tensor$default$4() {
        return Summary.tensor$default$4$(this);
    }

    @Override
    public Set<Graph.Key<Output>> merge$default$2() {
        return Summary.merge$default$2$(this);
    }

    @Override
    public String merge$default$3() {
        return Summary.merge$default$3$(this);
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public Set<Op> initializers() {
        return Op$.MODULE$.currentGraph().tableInitializers();
    }

    @Override
    public Op initializer(Set<Op> initializers, String name) {
        return initializers.isEmpty() ? ControlFlow$.MODULE$.noOp(name) : ControlFlow$.MODULE$.group(initializers, name);
    }

    @Override
    public String initializer$default$2() {
        return "TablesInitializer";
    }

    /*
     * WARNING - void declaration
     */
    public String sanitizeName(String name) {
        String string;
        if (name != null) {
            void var2_2;
            BoxedUnit boxedUnit;
            String newName;
            String string2 = newName = this.INVALID_TAG_CHARACTERS.replaceAllIn((CharSequence)name, "_").replaceAll("^/+", "");
            String string3 = name;
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Summary name '{}' is invalid; using '{}' instead.", (Object[])new String[]{name, newName});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            string = var2_2;
        } else {
            string = null;
        }
        return string;
    }

    public Output scoped(Function2<String, String, Output> function, String name, String family) {
        String sanitizedName = this.sanitizeName(name);
        String sanitizedFamily = this.sanitizeName(family);
        String nameScope = sanitizedFamily == null ? sanitizedName : new StringBuilder(1).append(sanitizedFamily).append("/").append(sanitizedName).toString();
        return (Output)Op$.MODULE$.createWithNameScope(nameScope, Op$.MODULE$.createWithNameScope$default$2(), (Function0 & Serializable & scala.Serializable)() -> {
            String scope = Op$.MODULE$.currentNameScope();
            String tag = sanitizedFamily == null ? new StringOps(Predef$.MODULE$.augmentString(scope)).stripSuffix("/") : new StringBuilder(1).append(sanitizedFamily).append("/").append(new StringOps(Predef$.MODULE$.augmentString(scope)).stripSuffix("/")).toString();
            return (Output)function.apply((Object)scope, (Object)tag);
        });
    }

    public String scoped$default$3() {
        return null;
    }

    public Output tensorSummary(Output tensor, Output tag, Output summaryMetadata, String name) {
        return new Op.Builder("TensorSummaryV2", name).addInput(tensor).addInput(tag).addInput(summaryMetadata).build().outputs()[0];
    }

    public String tensorSummary$default$4() {
        return "TensorSummary";
    }

    public Output scalarSummary(Output value, Output tags, String name) {
        return new Op.Builder("ScalarSummary", name).addInput(tags).addInput(value).build().outputs()[0];
    }

    public String scalarSummary$default$3() {
        return "ScalarSummary";
    }

    public Output histogramSummary(Output values, Output tag, String name) {
        return new Op.Builder("HistogramSummary", name).addInput(tag).addInput(values).build().outputs()[0];
    }

    public String histogramSummary$default$3() {
        return "HistogramSummary";
    }

    public Output imageSummary(Output tensor, Tensor badColor, Output tag, int maxOutputs, String name) {
        return new Op.Builder("ImageSummary", name).addInput(tag).addInput(tensor).setAttribute("bad_color", badColor).setAttribute("max_images", maxOutputs).build().outputs()[0];
    }

    public int imageSummary$default$4() {
        return 3;
    }

    public String imageSummary$default$5() {
        return "ImageSummary";
    }

    public Output audioSummary(Output tensor, Output samplingRate, Output tag, int maxOutputs, String name) {
        return new Op.Builder("AudioSummaryV2", name).addInput(tag).addInput(tensor).addInput(samplingRate).setAttribute("max_outputs", maxOutputs).build().outputs()[0];
    }

    public int audioSummary$default$4() {
        return 3;
    }

    public String audioSummary$default$5() {
        return "AudioSummary";
    }

    public Output mergeSummaries(Seq<Output> inputs, String name) {
        return new Op.Builder("MergeSummary", name).addInputList(inputs).build().outputs()[0];
    }

    public String mergeSummaries$default$2() {
        return "MergeSummaries";
    }

    public Output summaryWriter(String sharedName, String container, String name) {
        return new Op.Builder("SummaryWriter", name).setAttribute("shared_name", sharedName).setAttribute("container", container).build().outputs()[0];
    }

    public String summaryWriter$default$1() {
        return "";
    }

    public String summaryWriter$default$2() {
        return "";
    }

    public String summaryWriter$default$3() {
        return "SummaryWriter";
    }

    public Op createSummaryFileWriter(Output writerHandle, Path workingDir, int queueCapacity, int flushFrequency, String filenameSuffix, String name) {
        return new Op.Builder("CreateSummaryFileWriter", name).addInput(writerHandle).addInput(package$.MODULE$.tensorConvertibleToOutput(((Object)workingDir).toString(), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.stringIsSupportedType()))).addInput(package$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)queueCapacity), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType()))).addInput(package$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)flushFrequency), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType()))).addInput(package$.MODULE$.tensorConvertibleToOutput(filenameSuffix, TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.stringIsSupportedType()))).build();
    }

    public int createSummaryFileWriter$default$3() {
        return 10;
    }

    public int createSummaryFileWriter$default$4() {
        return 10;
    }

    public String createSummaryFileWriter$default$5() {
        return "";
    }

    public String createSummaryFileWriter$default$6() {
        return "CreateSummaryFileWriter";
    }

    public Op flushSummaryWriter(Output writerHandle, String name) {
        return new Op.Builder("FlushSummaryWriter", name).addInput(writerHandle).build();
    }

    public String flushSummaryWriter$default$2() {
        return "FlushSummaryWriter";
    }

    public Op closeSummaryWriter(Output writerHandle, String name) {
        return new Op.Builder("CloseSummaryWriter", name).addInput(writerHandle).build();
    }

    public String closeSummaryWriter$default$2() {
        return "CloseSummaryWriter";
    }

    public Op writeTensorSummary(Output writerHandle, Output globalStep, Output tag, Output tensor, Output summaryMetadata, String name) {
        return new Op.Builder("WriteSummary", name).addInput(writerHandle).addInput(globalStep).addInput(tensor).addInput(tag).addInput(summaryMetadata).build();
    }

    public String writeTensorSummary$default$6() {
        return "WriteTensorSummary";
    }

    public Op writeScalarSummary(Output writerHandle, Output globalStep, Output value, Output tags, String name) {
        return new Op.Builder("WriteScalarSummary", name).addInput(writerHandle).addInput(globalStep).addInput(tags).addInput(value).build();
    }

    public String writeScalarSummary$default$5() {
        return "WriteScalarSummary";
    }

    public Op writeHistogramSummary(Output writerHandle, Output globalStep, Output values, Output tag, String name) {
        return new Op.Builder("WriteScalarSummary", name).addInput(writerHandle).addInput(globalStep).addInput(tag).addInput(values).build();
    }

    public String writeHistogramSummary$default$5() {
        return "WriteHistogramSummary";
    }

    public Op writeImageSummary(Output writerHandle, Output globalStep, Output tensor, Output badColor, Output tag, int maxOutputs, String name) {
        return new Op.Builder("WriteImageSummary", name).addInput(writerHandle).addInput(globalStep).addInput(tag).addInput(tensor).addInput(badColor).setAttribute("max_images", maxOutputs).build();
    }

    public int writeImageSummary$default$6() {
        return 3;
    }

    public String writeImageSummary$default$7() {
        return "WriteImageSummary";
    }

    public Op writeAudioSummary(Output writerHandle, Output globalStep, Output tensor, Output samplingRate, Output tag, int maxOutputs, String name) {
        return new Op.Builder("WriteAudioSummary", name).addInput(writerHandle).addInput(globalStep).addInput(tag).addInput(tensor).addInput(samplingRate).setAttribute("max_outputs", maxOutputs).build();
    }

    public int writeAudioSummary$default$6() {
        return 3;
    }

    public String writeAudioSummary$default$7() {
        return "WriteAudioSummary";
    }

    private Summary$() {
        MODULE$ = this;
        Summary.$init$(this);
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)"Ops / Summary"));
        this.INVALID_TAG_CHARACTERS = new StringOps(Predef$.MODULE$.augmentString("[^-/a-zA-Z0-9_.]")).r();
    }
}

