/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.api.ops.seq2seq.decoders;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.platanios.tensorflow.api.core.Indexer;
import org.platanios.tensorflow.api.core.IndexerConstructionWithTwoNumbers$;
import org.platanios.tensorflow.api.core.NewAxis$;
import org.platanios.tensorflow.api.core.Shape;
import org.platanios.tensorflow.api.core.Shape$;
import org.platanios.tensorflow.api.core.package;
import org.platanios.tensorflow.api.core.package$exception$;
import org.platanios.tensorflow.api.core.package$exception$InvalidShapeException$;
import org.platanios.tensorflow.api.implicits.Implicits$;
import org.platanios.tensorflow.api.ops.Basic;
import org.platanios.tensorflow.api.ops.Basic$;
import org.platanios.tensorflow.api.ops.Checks$;
import org.platanios.tensorflow.api.ops.Math;
import org.platanios.tensorflow.api.ops.Math$;
import org.platanios.tensorflow.api.ops.Op;
import org.platanios.tensorflow.api.ops.Op$;
import org.platanios.tensorflow.api.ops.Output;
import org.platanios.tensorflow.api.ops.Output$;
import org.platanios.tensorflow.api.ops.OutputConvertible;
import org.platanios.tensorflow.api.ops.TensorArray;
import org.platanios.tensorflow.api.ops.control_flow.WhileLoopVariable;
import org.platanios.tensorflow.api.ops.rnn.cell.RNNCell;
import org.platanios.tensorflow.api.ops.seq2seq.decoders.BeamSearchDecoder;
import org.platanios.tensorflow.api.ops.seq2seq.decoders.LengthPenalty;
import org.platanios.tensorflow.api.ops.seq2seq.decoders.NoPenalty$;
import org.platanios.tensorflow.api.tensors.Tensor;
import org.platanios.tensorflow.api.tensors.Tensor$;
import org.platanios.tensorflow.api.tensors.TensorConvertible$;
import org.platanios.tensorflow.api.types.DataType;
import org.platanios.tensorflow.api.types.SupportedType$;
import org.platanios.tensorflow.api.types.package$;
import org.platanios.tensorflow.jni.InvalidArgumentException;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class BeamSearchDecoder$ {
    public static BeamSearchDecoder$ MODULE$;
    private final Logger logger;

    static {
        new BeamSearchDecoder$();
    }

    public <S, SS> LengthPenalty $lessinit$greater$default$7() {
        return NoPenalty$.MODULE$;
    }

    public <S, SS> Function1<BeamSearchDecoder.Output, BeamSearchDecoder.Output> $lessinit$greater$default$8() {
        return (Function1 & Serializable & scala.Serializable)o -> o;
    }

    public <S, SS> boolean $lessinit$greater$default$9() {
        return true;
    }

    public <S, SS> String $lessinit$greater$default$10() {
        return "BeamSearchRNNDecoder";
    }

    public Logger logger() {
        return this.logger;
    }

    public <S, SS> BeamSearchDecoder<S, SS> apply(RNNCell<Output, Shape, S, SS> cell, S initialCellState, Function1<Output, Output> embeddingFn, Output beginTokens, Output endToken, int beamWidth, LengthPenalty lengthPenalty, Function1<Output, Output> outputLayer, boolean reorderTensorArrays, String name, WhileLoopVariable<Output> evOutput, WhileLoopVariable<S> evS) {
        return new BeamSearchDecoder<S, SS>(cell, initialCellState, embeddingFn, beginTokens, endToken, beamWidth, lengthPenalty, outputLayer, reorderTensorArrays, name, evOutput, evS);
    }

    public <S, SS> LengthPenalty apply$default$7() {
        return NoPenalty$.MODULE$;
    }

    public <S, SS> Function1<Output, Output> apply$default$8() {
        return (Function1 & Serializable & scala.Serializable)o -> o;
    }

    public <S, SS> boolean apply$default$9() {
        return true;
    }

    public <S, SS> String apply$default$10() {
        return "BeamSearchRNNDecoder";
    }

    public Output maskLogProbabilities(Output logProbabilities, Output endToken, Output finished) {
        Output vocabSize = Basic$.MODULE$.shape(logProbabilities, Basic$.MODULE$.shape$default$2(), Basic$.MODULE$.shape$default$3(), Basic$.MODULE$.shape$default$4()).apply((Seq<Indexer>)Predef$.MODULE$.wrapRefArray((Object[])new Indexer[]{Implicits$.MODULE$.intToIndex(2)}));
        DataType dType = logProbabilities.dataType();
        Tensor dTypeMin = Tensor$.MODULE$.apply(dType.min(), Predef$.MODULE$.genericWrapArray((Object)new Object[0]), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(dType.supportedType())).slice((Seq<Indexer>)Predef$.MODULE$.wrapRefArray((Object[])new Indexer[]{Implicits$.MODULE$.intToIndex(0)}));
        Output finishedRow = Basic$.MODULE$.oneHot(endToken, vocabSize, Basic$.MODULE$.zeros(dType, Implicits$.MODULE$.tensorConvertibleToOutput(Shape$.MODULE$.apply((Seq<Object>)Nil$.MODULE$), TensorConvertible$.MODULE$.shapeTensorConvertible()), Basic$.MODULE$.zeros$default$3()), Basic$.MODULE$.constant(dTypeMin, Basic$.MODULE$.constant$default$2(), Basic$.MODULE$.constant$default$3(), Basic$.MODULE$.constant$default$4()), Basic$.MODULE$.oneHot$default$5(), Basic$.MODULE$.oneHot$default$6(), Basic$.MODULE$.oneHot$default$7());
        Output finishedLogProbabilities = Basic$.MODULE$.tile(Implicits$.MODULE$.outputToBasicOps(finishedRow).reshape(Implicits$.MODULE$.tensorConvertibleToOutput(Shape$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{1, 1, -1})), TensorConvertible$.MODULE$.shapeTensorConvertible())), Basic$.MODULE$.concatenate((Seq<Output>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Output[]{Basic$.MODULE$.shape(finished, Basic$.MODULE$.shape$default$2(), Basic$.MODULE$.shape$default$3(), Basic$.MODULE$.shape$default$4()), Implicits$.MODULE$.tensorConvertibleToOutput(Tensor$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), Predef$.MODULE$.wrapIntArray(new int[0]), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())), TensorConvertible$.MODULE$.tensorLikeTensorConvertible())}))), Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)0), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())), Basic$.MODULE$.concatenate$default$3()), Basic$.MODULE$.tile$default$3());
        Output finishedMask = Basic$.MODULE$.tile(Implicits$.MODULE$.outputToBasicOps(finished).expandDims(Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)2), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType()))), Basic$.MODULE$.stack((Seq<Output>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Output[]{Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)1), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())), Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)1), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())), vocabSize}))), Basic$.MODULE$.stack$default$2(), Basic$.MODULE$.stack$default$3()), Basic$.MODULE$.tile$default$3());
        return Math$.MODULE$.select(finishedMask, finishedLogProbabilities, logProbabilities, Math$.MODULE$.select$default$4());
    }

    public Output gatherTree(Output stepIDs, Output parentIDs, Output maxSequenceLengths, Output endToken, String name) {
        return new Op.Builder("GatherTree", name).addInput(stepIDs).addInput(parentIDs).addInput(maxSequenceLengths).addInput(endToken).build().outputs()[0];
    }

    public OutputConvertible tileBatch(OutputConvertible value, int multiplier) throws InvalidArgumentException {
        OutputConvertible outputConvertible;
        OutputConvertible outputConvertible2 = value;
        if (outputConvertible2 instanceof Output) {
            Output output;
            Output output2 = (Output)outputConvertible2;
            if (output2.rank() == -1) {
                throw package$exception$.MODULE$.InvalidArgumentException().apply("The provided tensor must have statically known rank.");
            }
            if (output2.rank() == 0) {
                Tensor tiling = Tensor$.MODULE$.apply(BoxesRunTime.boxToInteger((int)multiplier), Predef$.MODULE$.wrapIntArray(new int[0]), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType()));
                Output tiled = Basic$.MODULE$.tile(Implicits$.MODULE$.outputToBasicOps(output2).expandDims(Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)0), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType()))), Implicits$.MODULE$.tensorConvertibleToOutput(tiling, TensorConvertible$.MODULE$.tensorLikeTensorConvertible()), Basic$.MODULE$.tile$default$3());
                tiled.setShape(Shape$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{multiplier})));
                output = tiled;
            } else {
                Output outputShape = Basic$.MODULE$.shape(output2, Basic$.MODULE$.shape$default$2(), Basic$.MODULE$.shape$default$3(), Basic$.MODULE$.shape$default$4());
                ArrayBuffer tiling = (ArrayBuffer)ArrayBuffer$.MODULE$.fill(output2.rank() + 1, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1);
                tiling.update(1, (Object)BoxesRunTime.boxToInteger((int)multiplier));
                int tiledStaticBatchSize = output2.shape().apply(0) != -1 ? output2.shape().apply(0) * multiplier : -1;
                Output tiled = Implicits$.MODULE$.outputToBasicOps(Basic$.MODULE$.tile(Implicits$.MODULE$.outputToBasicOps(output2).expandDims(Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)1), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType()))), Implicits$.MODULE$.tensorConvertibleToOutput(tiling, TensorConvertible$.MODULE$.traversableTensorConvertible(TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType()))), Basic$.MODULE$.tile$default$3())).reshape(Basic$.MODULE$.concatenate((Seq<Output>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Output[]{Implicits$.MODULE$.outputToBasicOps(Implicits$.MODULE$.outputToMathOps(outputShape.apply((Seq<Indexer>)Predef$.MODULE$.wrapRefArray((Object[])new Indexer[]{Implicits$.MODULE$.intToIndex(0)}))).$times(Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)multiplier), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())))).expandDims(Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)0), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType()))), outputShape.apply((Seq<Indexer>)Predef$.MODULE$.wrapRefArray((Object[])new Indexer[]{Implicits$.MODULE$.intToIndexerConstruction(1).$colon$colon()}))}))), Basic$.MODULE$.concatenate$default$2(), Basic$.MODULE$.concatenate$default$3()));
                if (output2.rank() > 1) {
                    tiled.setShape(Shape$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{tiledStaticBatchSize})).$plus$plus(output2.shape().apply(Implicits$.MODULE$.intToIndexerConstruction(1).$colon$colon())));
                } else {
                    tiled.setShape(Shape$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{tiledStaticBatchSize})));
                }
                output = tiled;
            }
            outputConvertible = output;
        } else if (outputConvertible2 instanceof TensorArray) {
            outputConvertible = value;
        } else {
            throw package$exception$.MODULE$.InvalidArgumentException().apply("Unsupported argument type for use with the beam search decoder.");
        }
        return outputConvertible;
    }

    public <S> S tileForBeamSearch(S value, int beamWidth, WhileLoopVariable<S> evS) throws InvalidArgumentException {
        return evS.map(value, (Function1<OutputConvertible, OutputConvertible>)(Function1 & Serializable & scala.Serializable)x$23 -> MODULE$.tileBatch((OutputConvertible)x$23, beamWidth));
    }

    public OutputConvertible maybeSplitBatchBeams(OutputConvertible value, Shape shape, Output batchSize, int beamWidth) throws InvalidArgumentException {
        OutputConvertible outputConvertible;
        OutputConvertible outputConvertible2 = value;
        if (outputConvertible2 instanceof Output) {
            Output output = (Output)outputConvertible2;
            if (output.rank() == -1) {
                throw package$exception$.MODULE$.InvalidArgumentException().apply(new StringBuilder(58).append("Expected tensor (").append(output).append(") to have known rank, but it was unknown.").toString());
            }
            outputConvertible = output.rank() == 0 ? value : this.splitBatchBeams(value, shape, batchSize, beamWidth);
        } else if (outputConvertible2 instanceof TensorArray) {
            outputConvertible = value;
        } else {
            throw package$exception$.MODULE$.InvalidArgumentException().apply("Unsupported argument type for use with the beam search decoder.");
        }
        return outputConvertible;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OutputConvertible splitBatchBeams(OutputConvertible value, Shape shape, Output batchSize, int beamWidth) throws InvalidArgumentException, package.exception.InvalidShapeException {
        Tuple2 tuple2 = new Tuple2((Object)value, (Object)shape);
        if (tuple2 != null) {
            OutputConvertible output = (OutputConvertible)tuple2._1();
            Shape s = (Shape)tuple2._2();
            if (output instanceof Output) {
                Output output2 = (Output)output;
                if (s != null) {
                    Shape shape2 = s;
                    Output valueShape = Basic$.MODULE$.shape(output2, Basic$.MODULE$.shape$default$2(), Basic$.MODULE$.shape$default$3(), Basic$.MODULE$.shape$default$4());
                    Output reshapedValue = Basic$.MODULE$.reshape(output2, Basic$.MODULE$.concatenate((Seq<Output>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Output[]{batchSize.apply((Seq<Indexer>)Predef$.MODULE$.wrapRefArray((Object[])new Indexer[]{NewAxis$.MODULE$})), Tensor$.MODULE$.apply(batchSize.dataType(), BoxesRunTime.boxToInteger((int)beamWidth), Predef$.MODULE$.wrapIntArray(new int[0]), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())).toOutput(), Implicits$.MODULE$.outputToMathOps(valueShape.apply((Seq<Indexer>)Predef$.MODULE$.wrapRefArray((Object[])new Indexer[]{Implicits$.MODULE$.intToIndexerConstruction(1).$colon$colon()}))).cast(batchSize.dataType())}))), Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)0), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())), Basic$.MODULE$.concatenate$default$3()), Basic$.MODULE$.reshape$default$3());
                    int staticBatchSize = BoxesRunTime.unboxToInt((Object)Output$.MODULE$.constantValue(batchSize).map((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToInteger((int)BeamSearchDecoder$.$anonfun$splitBatchBeams$1(x$24))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
                    Shape expectedReshapedShape = Shape$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{staticBatchSize, beamWidth})).$plus$plus(shape2);
                    if (!reshapedValue.shape().isCompatibleWith(expectedReshapedShape)) {
                        throw new package.exception.InvalidShapeException(new StringBuilder(158).append("Unexpected behavior when reshaping between beam width and batch size. ").append(new StringBuilder(33).append("The reshaped tensor has shape: ").append(reshapedValue.shape()).append(". ").toString()).append(new StringBuilder(64).append("We expected it to have shape [batchSize, beamWidth, depth] == ").append(expectedReshapedShape).append(". ").toString()).append("Perhaps you forgot to create a zero state with batchSize = encoderBatchSize * beamWidth?").toString(), package$exception$InvalidShapeException$.MODULE$.apply$default$2());
                    }
                    reshapedValue.setShape(expectedReshapedShape);
                    return reshapedValue;
                }
            }
        }
        if (tuple2 == null) throw package$exception$.MODULE$.InvalidArgumentException().apply("Unsupported argument type for use with the beam search decoder.");
        if (!(tuple2._1() instanceof TensorArray)) throw package$exception$.MODULE$.InvalidArgumentException().apply("Unsupported argument type for use with the beam search decoder.");
        return value;
    }

    public OutputConvertible maybeMergeBatchBeams(OutputConvertible value, Shape shape, Output batchSize, int beamWidth) throws InvalidArgumentException {
        OutputConvertible outputConvertible;
        OutputConvertible outputConvertible2 = value;
        if (outputConvertible2 instanceof Output) {
            Output output = (Output)outputConvertible2;
            if (output.rank() == -1) {
                throw package$exception$.MODULE$.InvalidArgumentException().apply(new StringBuilder(58).append("Expected tensor (").append(output).append(") to have known rank, but it was unknown.").toString());
            }
            outputConvertible = output.rank() == 0 ? value : this.mergeBatchBeams(value, shape, batchSize, beamWidth);
        } else if (outputConvertible2 instanceof TensorArray) {
            outputConvertible = value;
        } else {
            throw package$exception$.MODULE$.InvalidArgumentException().apply("Unsupported argument type for use with the beam search decoder.");
        }
        return outputConvertible;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OutputConvertible mergeBatchBeams(OutputConvertible value, Shape shape, Output batchSize, int beamWidth) throws InvalidArgumentException, package.exception.InvalidShapeException {
        Tuple2 tuple2 = new Tuple2((Object)value, (Object)shape);
        if (tuple2 != null) {
            OutputConvertible output = (OutputConvertible)tuple2._1();
            Shape s = (Shape)tuple2._2();
            if (output instanceof Output) {
                Output output2 = (Output)output;
                if (s != null) {
                    Shape shape2 = s;
                    Output valueShape = Basic$.MODULE$.shape(output2, Basic$.MODULE$.shape$default$2(), Basic$.MODULE$.shape$default$3(), Basic$.MODULE$.shape$default$4());
                    Output reshapedValue = Basic$.MODULE$.reshape(output2, Basic$.MODULE$.concatenate((Seq<Output>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Output[]{Implicits$.MODULE$.outputToMathOps(batchSize.apply((Seq<Indexer>)Predef$.MODULE$.wrapRefArray((Object[])new Indexer[]{NewAxis$.MODULE$}))).$times(Tensor$.MODULE$.apply(batchSize.dataType(), BoxesRunTime.boxToInteger((int)beamWidth), Predef$.MODULE$.wrapIntArray(new int[0]), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())).toOutput()), Implicits$.MODULE$.outputToMathOps(valueShape.apply((Seq<Indexer>)Predef$.MODULE$.wrapRefArray((Object[])new Indexer[]{Implicits$.MODULE$.intToIndexerConstruction(2).$colon$colon()}))).cast(batchSize.dataType())}))), Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)0), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())), Basic$.MODULE$.concatenate$default$3()), Basic$.MODULE$.reshape$default$3());
                    int staticBatchSize = BoxesRunTime.unboxToInt((Object)Output$.MODULE$.constantValue(batchSize).map((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToInteger((int)BeamSearchDecoder$.$anonfun$mergeBatchBeams$1(x$25))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
                    int batchSizeBeamWidth = staticBatchSize != -1 ? staticBatchSize * beamWidth : -1;
                    Shape expectedReshapedShape = Shape$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{batchSizeBeamWidth})).$plus$plus(shape2);
                    if (!reshapedValue.shape().isCompatibleWith(expectedReshapedShape)) {
                        throw new package.exception.InvalidShapeException(new StringBuilder(158).append("Unexpected behavior when reshaping between beam width and batch size. ").append(new StringBuilder(33).append("The reshaped tensor has shape: ").append(reshapedValue.shape()).append(". ").toString()).append(new StringBuilder(64).append("We expected it to have shape [batchSize, beamWidth, depth] == ").append(expectedReshapedShape).append(". ").toString()).append("Perhaps you forgot to create a zero state with batchSize = encoderBatchSize * beamWidth?").toString(), package$exception$InvalidShapeException$.MODULE$.apply$default$2());
                    }
                    reshapedValue.setShape(expectedReshapedShape);
                    return reshapedValue;
                }
            }
        }
        if (tuple2 == null) throw package$exception$.MODULE$.InvalidArgumentException().apply("Unsupported argument type for use with the beam search decoder.");
        if (!(tuple2._1() instanceof TensorArray)) throw package$exception$.MODULE$.InvalidArgumentException().apply("Unsupported argument type for use with the beam search decoder.");
        return value;
    }

    public OutputConvertible maybeGather(Output gatherIndices, OutputConvertible gatherFrom, Output batchSize, Output rangeSize, Seq<Output> gatherShape, String name) throws InvalidArgumentException {
        OutputConvertible outputConvertible;
        OutputConvertible outputConvertible2 = gatherFrom;
        if (outputConvertible2 instanceof Output) {
            Output output = (Output)outputConvertible2;
            if (output.rank() == -1) {
                throw package$exception$.MODULE$.InvalidArgumentException().apply(new StringBuilder(58).append("Expected tensor (").append(output).append(") to have known rank, but it was unknown.").toString());
            }
            outputConvertible = output.rank() < gatherShape.size() ? gatherFrom : this.gather(gatherIndices, gatherFrom, batchSize, rangeSize, gatherShape, name);
        } else if (outputConvertible2 instanceof TensorArray) {
            outputConvertible = gatherFrom;
        } else {
            throw package$exception$.MODULE$.InvalidArgumentException().apply("Unsupported argument type for use with the beam search decoder.");
        }
        return outputConvertible;
    }

    public String maybeGather$default$6() {
        return "GatherTensorHelper";
    }

    public OutputConvertible gather(Output gatherIndices, OutputConvertible gatherFrom, Output batchSize, Output rangeSize, Seq<Output> gatherShape, String name) throws InvalidArgumentException {
        OutputConvertible outputConvertible;
        OutputConvertible outputConvertible2 = gatherFrom;
        if (outputConvertible2 instanceof Output) {
            Output output = (Output)outputConvertible2;
            outputConvertible = (OutputConvertible)Op$.MODULE$.createWithNameScope(name, Op$.MODULE$.createWithNameScope$default$2(), (Function0 & Serializable & scala.Serializable)() -> {
                Output range = Implicits$.MODULE$.outputToBasicOps(Implicits$.MODULE$.outputToMathOps(Math$.MODULE$.range(Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)0), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())), batchSize, Math$.MODULE$.range$default$3(), Math$.MODULE$.range$default$4(), Math$.MODULE$.range$default$5())).$times(rangeSize)).expandDims(Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)1), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())));
                Output reshapedGatherIndices = Implicits$.MODULE$.outputToBasicOps(Implicits$.MODULE$.outputToMathOps(gatherIndices).$plus(range)).reshape(Implicits$.MODULE$.tensorConvertibleToOutput(Shape$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{-1})), TensorConvertible$.MODULE$.shapeTensorConvertible()));
                Output output = Basic$.MODULE$.gather(Implicits$.MODULE$.outputToBasicOps(output).reshape(Basic$.MODULE$.stack(gatherShape, Basic$.MODULE$.stack$default$2(), Basic$.MODULE$.stack$default$3())), reshapedGatherIndices, Basic$.MODULE$.gather$default$3(), Basic$.MODULE$.gather$default$4());
                Indexer[] indexerArray = new Indexer[1];
                int n = 0;
                indexerArray[0] = IndexerConstructionWithTwoNumbers$.MODULE$.indexerConstructionToIndex(Implicits$.MODULE$.intToIndexerConstruction(1 + gatherShape.size()).$colon$colon(Implicits$.MODULE$.intToIndexerConstruction(n)));
                Output finalShape = Basic$.MODULE$.shape(output, Basic$.MODULE$.shape$default$2(), Basic$.MODULE$.shape$default$3(), Basic$.MODULE$.shape$default$4()).apply((Seq<Indexer>)Predef$.MODULE$.wrapRefArray((Object[])indexerArray));
                int staticBatchSize = BoxesRunTime.unboxToInt((Object)Output$.MODULE$.constantValue(batchSize).map((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToInteger((int)BeamSearchDecoder$.$anonfun$gather$2(x$27))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
                int n2 = 1;
                Shape finalStaticShape = Shape$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{staticBatchSize})).$plus$plus(output.shape().apply(IndexerConstructionWithTwoNumbers$.MODULE$.indexerConstructionToIndex(Implicits$.MODULE$.intToIndexerConstruction(1 + gatherShape.size()).$colon$colon(Implicits$.MODULE$.intToIndexerConstruction(n2)))));
                output = Basic$.MODULE$.reshape(output, finalShape, "Output");
                output.setShape(finalStaticShape);
                return output;
            });
        } else if (outputConvertible2 instanceof TensorArray) {
            outputConvertible = gatherFrom;
        } else {
            throw package$exception$.MODULE$.InvalidArgumentException().apply("Unsupported argument type for use with the beam search decoder.");
        }
        return outputConvertible;
    }

    public String gather$default$6() {
        return "GatherTensorHelper";
    }

    public String gatherTree$default$5() {
        return "GatherTree";
    }

    public boolean checkStaticBatchBeam(Shape shape, int batchSize, int beamWidth) {
        boolean bl;
        if (batchSize != -1 && shape.apply(0) != -1 && (shape.apply(0) != batchSize * beamWidth || shape.rank() > 1 && shape.apply(1) != -1 && (shape.apply(0) != batchSize || shape.apply(1) != beamWidth))) {
            BoxedUnit boxedUnit;
            Shape reshapedShape = Shape$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{batchSize, beamWidth, -1}));
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(125).append("Tensor array reordering expects elements to be reshapable to '").append(reshapedShape).append("' which is incompatible with ").append(new StringBuilder(96).append("the current shape '").append(shape).append("'. Consider setting `reorderTensorArrays` to `false` to disable tensor array ").toString()).append("reordering during the beam search.").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public Op checkBatchBeam(Output tensor, Output batchSize, Output beamWidth) {
        Output shape = Basic$.MODULE$.shape(tensor, Basic$.MODULE$.shape$default$2(), Basic$.MODULE$.shape$default$3(), Basic$.MODULE$.shape$default$4());
        return Checks$.MODULE$.assert(tensor.rank() == 2 ? Math$.MODULE$.equal(shape.apply((Seq<Indexer>)Predef$.MODULE$.wrapRefArray((Object[])new Indexer[]{Implicits$.MODULE$.intToIndex(1)})), Implicits$.MODULE$.outputToMathOps(batchSize).$times(beamWidth), Math$.MODULE$.equal$default$3()) : Math$.MODULE$.logicalOr(Math$.MODULE$.equal(shape.apply((Seq<Indexer>)Predef$.MODULE$.wrapRefArray((Object[])new Indexer[]{Implicits$.MODULE$.intToIndex(1)})), Implicits$.MODULE$.outputToMathOps(batchSize).$times(beamWidth), Math$.MODULE$.equal$default$3()), Math$.MODULE$.logicalAnd(Math$.MODULE$.equal(shape.apply((Seq<Indexer>)Predef$.MODULE$.wrapRefArray((Object[])new Indexer[]{Implicits$.MODULE$.intToIndex(1)})), batchSize, Math$.MODULE$.equal$default$3()), Math$.MODULE$.equal(shape.apply((Seq<Indexer>)Predef$.MODULE$.wrapRefArray((Object[])new Indexer[]{Implicits$.MODULE$.intToIndex(2)})), beamWidth, Math$.MODULE$.equal$default$3()), Math$.MODULE$.logicalAnd$default$3()), Math$.MODULE$.logicalOr$default$3()), (Seq<Output>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Output[]{Implicits$.MODULE$.tensorConvertibleToOutput(new StringBuilder(167).append("Tensor array reordering expects elements to be reshapable to '[batchSize, beamSize, -1]' which is ").append(new StringBuilder(91).append("incompatible with the dynamic shape of '").append(tensor.name()).append("' elements. Consider setting `reorderTensorArrays` ").toString()).append("to `false` to disable tensor array reordering during the beam search.").toString(), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.stringIsSupportedType()))}))), Checks$.MODULE$.assert$default$3(), Checks$.MODULE$.assert$default$4());
    }

    /*
     * Unable to fully structure code
     */
    public OutputConvertible maybeSortTensorArrayBeams(OutputConvertible value, Output sequenceLengths, Output parentIDs, Output batchSize, int beamWidth) {
        block9: {
            block8: {
                var8_6 = false;
                var9_7 = null;
                var10_8 = value;
                if (!(var10_8 instanceof TensorArray)) break block8;
                var8_6 = true;
                var9_7 = (TensorArray)var10_8;
                if (var9_7.inferShape() && !var9_7.elementShape().isEmpty() && ((Shape)var9_7.elementShape().get()).apply(0) != -1 && ((Shape)var9_7.elementShape().get()).apply(1) >= 1) break block8;
                var12_9 = var9_7.elementShape();
                if (!(var12_9 instanceof Some)) ** GOTO lbl-1000
                var13_10 = (Some)var12_9;
                s = (Shape)var13_10.value();
                if (var9_7.inferShape()) {
                    var7_12 = Shape$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{s.apply(0)}));
                } else lbl-1000:
                // 2 sources

                {
                    var7_12 = Shape$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{-1}));
                }
                shape = var7_12;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringBuilder(184).append("The tensor array '").append(var9_7.handle().name()).append("' in the cell state is not amenable to sorting based on the beam ").append("search result. For a tensor array to be sorted, its elements shape must be defined and have at least ").append(new StringBuilder(75).append("a rank of 1. However, the elements shape in the provided tensor array is: ").append(shape).append(".").toString()).toString());
                    v0 = BoxedUnit.UNIT;
                } else {
                    v0 = BoxedUnit.UNIT;
                }
                var6_14 = var9_7;
                break block9;
            }
            if (var8_6 && !this.checkStaticBatchBeam(Shape$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{((Shape)var9_7.elementShape().get()).apply(0)})), BoxesRunTime.unboxToInt((Object)Output$.MODULE$.constantValue(batchSize).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$maybeSortTensorArrayBeams$1$adapted(org.platanios.tensorflow.api.tensors.Tensor ), (Lorg/platanios/tensorflow/api/tensors/Tensor;)Ljava/lang/Object;)()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()I, $anonfun$maybeSortTensorArrayBeams$2(), ()I)())), beamWidth)) {
                var6_14 = var9_7;
            } else if (var8_6) {
                stackedTensorArray = var9_7.stack(var9_7.stack$default$1());
                x$72 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Op[]{this.checkBatchBeam(stackedTensorArray, batchSize, Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)beamWidth), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())))}));
                x$73 = Op$.MODULE$.createWith$default$1();
                x$74 = Op$.MODULE$.createWith$default$2();
                x$75 = Op$.MODULE$.createWith$default$3();
                x$76 = Op$.MODULE$.createWith$default$4();
                x$77 = Op$.MODULE$.createWith$default$5();
                x$78 = Op$.MODULE$.createWith$default$7();
                x$79 = Op$.MODULE$.createWith$default$8();
                x$88 = (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$maybeSortTensorArrayBeams$3(org.platanios.tensorflow.api.ops.Output org.platanios.tensorflow.api.ops.Output org.platanios.tensorflow.api.ops.Output ), ()Lorg/platanios/tensorflow/api/ops/Output;)((Output)sequenceLengths, (Output)parentIDs, (Output)stackedTensorArray);
                var6_14 = (OutputConvertible)Op$.MODULE$.createWith(x$73, x$74, x$75, x$76, x$77, (Set<Op>)x$72, x$78, x$79, x$88);
            } else {
                var6_14 = value;
            }
        }
        return var6_14;
    }

    public static final /* synthetic */ int $anonfun$splitBatchBeams$1(Tensor x$24) {
        return BoxesRunTime.unboxToInt((Object)x$24.scalar());
    }

    public static final /* synthetic */ int $anonfun$mergeBatchBeams$1(Tensor x$25) {
        return BoxesRunTime.unboxToInt((Object)x$25.scalar());
    }

    public static final /* synthetic */ int $anonfun$gather$2(Tensor x$27) {
        return BoxesRunTime.unboxToInt((Object)x$27.scalar());
    }

    public static final /* synthetic */ int $anonfun$maybeSortTensorArrayBeams$1(Tensor x$29) {
        return BoxesRunTime.unboxToInt((Object)x$29.scalar());
    }

    public static final /* synthetic */ int $anonfun$maybeSortTensorArrayBeams$2() {
        return -1;
    }

    public static final /* synthetic */ Output $anonfun$maybeSortTensorArrayBeams$3(Output sequenceLengths$1, Output parentIDs$1, Output stackedTensorArray$1) {
        Output maxTime = Basic$.MODULE$.shape(parentIDs$1, Basic$.MODULE$.shape$default$2(), Basic$.MODULE$.shape$default$3(), Basic$.MODULE$.shape$default$4()).apply((Seq<Indexer>)Predef$.MODULE$.wrapRefArray((Object[])new Indexer[]{Implicits$.MODULE$.intToIndex(0)}));
        Output batchSize = Basic$.MODULE$.shape(parentIDs$1, Basic$.MODULE$.shape$default$2(), Basic$.MODULE$.shape$default$3(), Basic$.MODULE$.shape$default$4()).apply((Seq<Indexer>)Predef$.MODULE$.wrapRefArray((Object[])new Indexer[]{Implicits$.MODULE$.intToIndex(1)}));
        Output beamWidth = Basic$.MODULE$.shape(parentIDs$1, Basic$.MODULE$.shape$default$2(), Basic$.MODULE$.shape$default$3(), Basic$.MODULE$.shape$default$4()).apply((Seq<Indexer>)Predef$.MODULE$.wrapRefArray((Object[])new Indexer[]{Implicits$.MODULE$.intToIndex(2)}));
        Output searchStateIndices = Basic$.MODULE$.tile(Math$.MODULE$.range(Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)0), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())), beamWidth, Math$.MODULE$.range$default$3(), Math$.MODULE$.range$default$4(), Math$.MODULE$.range$default$5()).apply((Seq<Indexer>)Predef$.MODULE$.wrapRefArray((Object[])new Indexer[]{NewAxis$.MODULE$, NewAxis$.MODULE$})), Basic$.MODULE$.stack((Seq<Output>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Output[]{maxTime, batchSize, Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)1), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType()))}))), Basic$.MODULE$.stack$default$2(), Basic$.MODULE$.stack$default$3()), Basic$.MODULE$.tile$default$3());
        Basic.BasicOps qual$3 = Implicits$.MODULE$.outputToBasicOps(Basic$.MODULE$.sequenceMask(sequenceLengths$1, maxTime, package$.MODULE$.INT32(), Basic$.MODULE$.sequenceMask$default$4()));
        Output x$80 = Implicits$.MODULE$.tensorConvertibleToOutput(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1})), TensorConvertible$.MODULE$.traversableTensorConvertible(TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())));
        boolean x$81 = qual$3.transpose$default$2();
        Output mask = qual$3.transpose(x$80, x$81);
        Output maskedSearchStateIndices = Implicits$.MODULE$.outputToMathOps(Implicits$.MODULE$.outputToMathOps(searchStateIndices).$times(mask)).$plus(Implicits$.MODULE$.outputToMathOps(Implicits$.MODULE$.outputConvertibleToMathOps(BoxesRunTime.boxToInteger((int)1), (Function1 & Serializable & scala.Serializable)value -> Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)value)), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType()))).$minus(mask)).$times(Implicits$.MODULE$.outputToMathOps(beamWidth).$plus(Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)1), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())))));
        Math.MathOps qual$4 = Implicits$.MODULE$.outputToMathOps(sequenceLengths$1);
        Output x$84 = Implicits$.MODULE$.tensorConvertibleToOutput(Tensor$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), Predef$.MODULE$.wrapIntArray(new int[0]), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())), TensorConvertible$.MODULE$.tensorLikeTensorConvertible());
        boolean x$85 = qual$4.max$default$2();
        Output maxSequenceLengths = Implicits$.MODULE$.outputToMathOps(qual$4.max(x$84, x$85)).cast(package$.MODULE$.INT32());
        Output sortedSearchStateIndices = MODULE$.gatherTree(maskedSearchStateIndices, parentIDs$1, maxSequenceLengths, Implicits$.MODULE$.outputToMathOps(beamWidth).$plus(Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)1), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType()))), MODULE$.gatherTree$default$5());
        sortedSearchStateIndices = Math$.MODULE$.select(Implicits$.MODULE$.outputToMathOps(mask).cast(package$.MODULE$.BOOLEAN()), sortedSearchStateIndices, searchStateIndices, Math$.MODULE$.select$default$4());
        Output timeIndices = Basic$.MODULE$.tile(Math$.MODULE$.range(Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)0), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())), maxTime, Math$.MODULE$.range$default$3(), Math$.MODULE$.range$default$4(), Math$.MODULE$.range$default$5()).apply((Seq<Indexer>)Predef$.MODULE$.wrapRefArray((Object[])new Indexer[]{NewAxis$.MODULE$, NewAxis$.MODULE$})), Basic$.MODULE$.stack((Seq<Output>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Output[]{Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)1), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())), batchSize, beamWidth}))), Basic$.MODULE$.stack$default$2(), Basic$.MODULE$.stack$default$3()), Basic$.MODULE$.tile$default$3());
        Basic.BasicOps qual$5 = Implicits$.MODULE$.outputToBasicOps(Basic$.MODULE$.tile(Math$.MODULE$.range(Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)0), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())), batchSize, Math$.MODULE$.range$default$3(), Math$.MODULE$.range$default$4(), Math$.MODULE$.range$default$5()).apply((Seq<Indexer>)Predef$.MODULE$.wrapRefArray((Object[])new Indexer[]{NewAxis$.MODULE$, NewAxis$.MODULE$})), Basic$.MODULE$.stack((Seq<Output>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Output[]{Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)1), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())), maxTime, beamWidth}))), Basic$.MODULE$.stack$default$2(), Basic$.MODULE$.stack$default$3()), Basic$.MODULE$.tile$default$3()));
        Output x$86 = Implicits$.MODULE$.tensorConvertibleToOutput(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 2})), TensorConvertible$.MODULE$.traversableTensorConvertible(TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())));
        boolean x$87 = qual$5.transpose$default$2();
        Output batchIndices = qual$5.transpose(x$86, x$87);
        Output indices = Basic$.MODULE$.stack((Seq<Output>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Output[]{timeIndices, batchIndices, sortedSearchStateIndices}))), -1, Basic$.MODULE$.stack$default$3());
        Output finalShape = Basic$.MODULE$.shape(stackedTensorArray$1, Basic$.MODULE$.shape$default$2(), Basic$.MODULE$.shape$default$3(), Basic$.MODULE$.shape$default$4());
        Output gatherFrom = Implicits$.MODULE$.outputToBasicOps(stackedTensorArray$1).reshape(Basic$.MODULE$.stack((Seq<Output>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Output[]{maxTime, batchSize, beamWidth, Implicits$.MODULE$.tensorConvertibleToOutput(BoxesRunTime.boxToInteger((int)-1), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType()))}))), Basic$.MODULE$.stack$default$2(), Basic$.MODULE$.stack$default$3()));
        return Implicits$.MODULE$.outputToBasicOps(Basic$.MODULE$.gatherND(gatherFrom, indices, Basic$.MODULE$.gatherND$default$3())).reshape(finalShape);
    }

    private BeamSearchDecoder$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)"Ops / Beam Search Decoder"));
    }

    public static final /* synthetic */ Object $anonfun$maybeSortTensorArrayBeams$1$adapted(Tensor x$29) {
        return BoxesRunTime.boxToInteger((int)BeamSearchDecoder$.$anonfun$maybeSortTensorArrayBeams$1(x$29));
    }
}

