/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.api.ops.variables;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.platanios.tensorflow.api.core.DeviceSpecification;
import org.platanios.tensorflow.api.core.DeviceSpecification$;
import org.platanios.tensorflow.api.core.Graph;
import org.platanios.tensorflow.api.core.Graph$Keys$GLOBAL_VARIABLES$;
import org.platanios.tensorflow.api.core.Graph$Keys$UNBOUND_INPUTS$;
import org.platanios.tensorflow.api.io.FileIO$;
import org.platanios.tensorflow.api.ops.Op;
import org.platanios.tensorflow.api.ops.Op$;
import org.platanios.tensorflow.api.ops.Output;
import org.platanios.tensorflow.api.ops.variables.CheckpointStateProto;
import org.platanios.tensorflow.api.ops.variables.DefaultSaverDefBuilder$;
import org.platanios.tensorflow.api.ops.variables.Saveable;
import org.platanios.tensorflow.api.ops.variables.Saver;
import org.platanios.tensorflow.api.ops.variables.Saver$V2$;
import org.platanios.tensorflow.api.ops.variables.SaverDefBuilder;
import org.platanios.tensorflow.api.ops.variables.Variable;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.MetaGraphDef;
import org.tensorflow.util.SaverDef;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

public final class Saver$ {
    public static Saver$ MODULE$;
    private final Logger logger;
    private final Regex SHARDED_CHECKPOINT_FILENAME_REGEX;

    static {
        new Saver$();
    }

    private boolean $lessinit$greater$default$2() {
        return false;
    }

    private boolean $lessinit$greater$default$3() {
        return false;
    }

    public Logger logger() {
        return this.logger;
    }

    public Saver apply(Set<Saveable> saveables, boolean reshape, boolean sharded, int maxToKeep, float keepCheckpointEveryNHours, boolean restoreSequentially, String filename, SaverDefBuilder builder, boolean allowEmpty, Saver.WriterVersion writerVersion, boolean saveRelativePaths, boolean padGlobalStep, String name) throws IllegalArgumentException {
        Set collectedSaveables;
        Set set = collectedSaveables = saveables == null ? (Set)Op$.MODULE$.currentGraph().getCollection(Graph$Keys$GLOBAL_VARIABLES$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$4 -> new Saveable.VariableSaveable((Variable)x$4), Set$.MODULE$.canBuildFrom()) : saveables;
        if (collectedSaveables.isEmpty() && !allowEmpty) {
            throw new IllegalArgumentException("No saveables were provided and 'allowEmpty' is set to 'false'.");
        }
        SaverDef saverDef = builder.build((Set<Saveable>)collectedSaveables, reshape, sharded, maxToKeep, keepCheckpointEveryNHours, restoreSequentially, filename, name);
        return new Saver(saverDef, saveRelativePaths, padGlobalStep);
    }

    public Set<Saveable> apply$default$1() {
        return null;
    }

    public boolean apply$default$2() {
        return false;
    }

    public boolean apply$default$3() {
        return false;
    }

    public int apply$default$4() {
        return 5;
    }

    public float apply$default$5() {
        return 10000.0f;
    }

    public boolean apply$default$6() {
        return false;
    }

    public String apply$default$7() {
        return "model";
    }

    public SaverDefBuilder apply$default$8() {
        return DefaultSaverDefBuilder$.MODULE$;
    }

    public boolean apply$default$9() {
        return false;
    }

    public Saver.WriterVersion apply$default$10() {
        return Saver$V2$.MODULE$;
    }

    public boolean apply$default$11() {
        return false;
    }

    public boolean apply$default$12() {
        return false;
    }

    public String apply$default$13() {
        return "Saver";
    }

    /*
     * Unable to fully structure code
     */
    public Saver fromSaverDef(SaverDef saverDef, String importScope, boolean saveRelativePaths, boolean padGlobalStep) {
        if (importScope == null) ** GOTO lbl-1000
        v0 = importScope;
        var6_5 = "";
        if (v0 == null ? var6_5 != null : v0.equals(var6_5) == false) {
            saverDefBuilder = saverDef.toBuilder();
            saverDefBuilder.setFilenameTensorName(Op$.MODULE$.prependNameScope(importScope, saverDefBuilder.getFilenameTensorName()));
            saverDefBuilder.setSaveTensorName(Op$.MODULE$.prependNameScope(importScope, saverDefBuilder.getSaveTensorName()));
            saverDefBuilder.setRestoreOpName(Op$.MODULE$.prependNameScope(importScope, saverDefBuilder.getRestoreOpName()));
            v1 = saverDefBuilder.build();
        } else lbl-1000:
        // 2 sources

        {
            v1 = saverDef;
        }
        newSaverDef = v1;
        return new Saver(newSaverDef, saveRelativePaths, padGlobalStep);
    }

    public String fromSaverDef$default$2() {
        return null;
    }

    public boolean fromSaverDef$default$3() {
        return false;
    }

    public boolean fromSaverDef$default$4() {
        return true;
    }

    public Saver fromProto(SaverDef saverDef, String importScope, boolean saveRelativePaths, boolean padGlobalStep) {
        return this.fromSaverDef(saverDef, importScope, saveRelativePaths, padGlobalStep);
    }

    public String fromProto$default$2() {
        return null;
    }

    public boolean fromProto$default$3() {
        return false;
    }

    public boolean fromProto$default$4() {
        return true;
    }

    public Saver fromMetaGraphDef(MetaGraphDef metaGraphDef, String importScope, boolean saveRelativePaths, boolean padGlobalStep, Map<Tuple2<String, Object>, Output> inputsMap, Map<String, Op> controlDependenciesMap, Set<Op> controlDependencies, boolean clearDevices, Graph.Key<String> unboundInputsCollectionKey, Function1<Graph.Key<?>, Object> restoreCollectionsPredicate) {
        Op$.MODULE$.currentGraph().importMetaGraphDef(metaGraphDef, importScope, inputsMap, controlDependenciesMap, controlDependencies, clearDevices, unboundInputsCollectionKey, restoreCollectionsPredicate);
        SaverDef saverDef = metaGraphDef.getSaverDef();
        return saverDef == null ? this.apply(this.apply$default$1(), this.apply$default$2(), this.apply$default$3(), this.apply$default$4(), this.apply$default$5(), this.apply$default$6(), this.apply$default$7(), this.apply$default$8(), this.apply$default$9(), this.apply$default$10(), this.apply$default$11(), this.apply$default$12(), this.apply$default$13()) : this.fromSaverDef(saverDef, importScope, saveRelativePaths, padGlobalStep);
    }

    public String fromMetaGraphDef$default$2() {
        return null;
    }

    public boolean fromMetaGraphDef$default$3() {
        return false;
    }

    public boolean fromMetaGraphDef$default$4() {
        return true;
    }

    public Map<Tuple2<String, Object>, Output> fromMetaGraphDef$default$5() {
        return Predef$.MODULE$.Map().empty();
    }

    public Map<String, Op> fromMetaGraphDef$default$6() {
        return Predef$.MODULE$.Map().empty();
    }

    public Set<Op> fromMetaGraphDef$default$7() {
        return Predef$.MODULE$.Set().empty();
    }

    public boolean fromMetaGraphDef$default$8() {
        return false;
    }

    public Graph.Key<String> fromMetaGraphDef$default$9() {
        return Graph$Keys$UNBOUND_INPUTS$.MODULE$;
    }

    public Function1<Graph.Key<?>, Object> fromMetaGraphDef$default$10() {
        return (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Saver$.$anonfun$fromMetaGraphDef$default$10$1(x$5));
    }

    public String setCPU0(String device) {
        DeviceSpecification qual$1 = DeviceSpecification$.MODULE$.fromString(device);
        String x$32 = "CPU";
        int x$33 = 0;
        String x$34 = qual$1.copy$default$1();
        int x$35 = qual$1.copy$default$2();
        int x$36 = qual$1.copy$default$3();
        return qual$1.copy(x$34, x$35, x$36, x$32, x$33).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Path> latestCheckpoint(Path directory, String checkpointStateFile) {
        None$ none$;
        Option<CheckpointStateProto.CheckpointState> checkpointState = this.loadCheckpointState(directory, checkpointStateFile);
        if (checkpointState.isDefined() && ((CheckpointStateProto.CheckpointState)checkpointState.get()).getModelCheckpointPath() != null) {
            FileSystem fileSystem = directory.getFileSystem();
            Path modelCheckpointPath = fileSystem.getPath(((CheckpointStateProto.CheckpointState)checkpointState.get()).getModelCheckpointPath(), new String[0]);
            Path v2Path = this.prefixToCheckpointPath(modelCheckpointPath, SaverDef.CheckpointFormatVersion.V2);
            Path v1Path = this.prefixToCheckpointPath(modelCheckpointPath, SaverDef.CheckpointFormatVersion.V1);
            if (!FileIO$.MODULE$.getMatchingPaths(v2Path, FileIO$.MODULE$.getMatchingPaths$default$2()).nonEmpty() && !FileIO$.MODULE$.getMatchingPaths(v1Path, FileIO$.MODULE$.getMatchingPaths$default$2()).nonEmpty()) throw new IllegalArgumentException(new StringBuilder(44).append("Could not match any files for checkpoint '").append(modelCheckpointPath).append("'.").toString());
            none$ = new Some((Object)modelCheckpointPath);
            return none$;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public String latestCheckpoint$default$2() {
        return "checkpoint";
    }

    public void org$platanios$tensorflow$api$ops$variables$Saver$$checkSaverDef(SaverDef saverDef) throws IllegalArgumentException {
        if (saverDef.getSaveTensorName() == null) {
            throw new IllegalArgumentException(new StringBuilder(49).append("The 'saverDef' must specify a save tensor name: ").append(saverDef).append(".").toString());
        }
        if (saverDef.getRestoreOpName() == null) {
            throw new IllegalArgumentException(new StringBuilder(48).append("The 'saverDef' must specify a restore op name: ").append(saverDef).append(".").toString());
        }
    }

    private Path checkpointPath(Path directory, String filename) {
        return directory.resolve(filename);
    }

    private String checkpointPath$default$2() {
        return "checkpoint";
    }

    private boolean checkpointExists(Path checkpointPrefix) {
        Path pathPattern = this.prefixToCheckpointPath(checkpointPrefix, SaverDef.CheckpointFormatVersion.V2);
        return FileIO$.MODULE$.getMatchingPaths(pathPattern, FileIO$.MODULE$.getMatchingPaths$default$2()).nonEmpty() || FileIO$.MODULE$.getMatchingPaths(checkpointPrefix, FileIO$.MODULE$.getMatchingPaths$default$2()).nonEmpty();
    }

    /*
     * Unable to fully structure code
     */
    private CheckpointStateProto.CheckpointState checkpointState(Path directory, Path modelCheckpointPath, Seq<Path> allModelCheckpointPaths) {
        block3: {
            checkpointPath = modelCheckpointPath;
            if (!allModelCheckpointPaths.nonEmpty()) ** GOTO lbl-1000
            v0 = allModelCheckpointPaths.last();
            var6_5 = checkpointPath;
            if (v0 == null ? var6_5 != null : v0.equals(var6_5) == false) {
                v1 = (Seq)allModelCheckpointPaths.$colon$plus((Object)checkpointPath, Seq$.MODULE$.canBuildFrom());
            } else lbl-1000:
            // 2 sources

            {
                v1 = allCheckpointPaths = allModelCheckpointPaths;
            }
            if (directory.isAbsolute()) break block3;
            if (!checkpointPath.isAbsolute()) {
                checkpointPath = directory.relativize(checkpointPath);
            }
            allCheckpointPaths = (Seq)allCheckpointPaths.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$checkpointState$1(java.nio.file.Path java.nio.file.Path ), (Ljava/nio/file/Path;)Ljava/nio/file/Path;)((Path)directory), Seq$.MODULE$.canBuildFrom());
        }
        return CheckpointStateProto.CheckpointState.newBuilder().setModelCheckpointPath(checkpointPath.toString()).addAllAllModelCheckpointPaths((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)allCheckpointPaths.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$checkpointState$2(java.nio.file.Path ), (Ljava/nio/file/Path;)Ljava/lang/String;)(), Seq$.MODULE$.canBuildFrom())).asJava()).build();
    }

    private Seq<Path> checkpointState$default$3() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public void org$platanios$tensorflow$api$ops$variables$Saver$$updateCheckpointStateFile(Path directory, Path modelCheckpointPath, Seq<Path> allModelCheckpointPaths, String checkpointStateFilename, boolean saveRelativePaths) {
        CheckpointStateProto.CheckpointState checkpointState;
        Path coordinatorCheckpointStateFilename = directory.resolve(checkpointStateFilename);
        if (saveRelativePaths) {
            Path modelCheckpointRelativePath = modelCheckpointPath.isAbsolute() ? directory.relativize(modelCheckpointPath) : modelCheckpointPath;
            Seq allModelCheckpointRelativePaths = (Seq)allModelCheckpointPaths.map((Function1 & Serializable & scala.Serializable)path -> path.isAbsolute() ? directory.relativize((Path)path) : path, Seq$.MODULE$.canBuildFrom());
            checkpointState = this.checkpointState(directory, modelCheckpointRelativePath, (Seq<Path>)allModelCheckpointRelativePaths);
        } else {
            checkpointState = this.checkpointState(directory, modelCheckpointPath, allModelCheckpointPaths);
        }
        CheckpointStateProto.CheckpointState state = checkpointState;
        String string = ((Object)coordinatorCheckpointStateFilename).toString();
        String string2 = state.getModelCheckpointPath();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new IllegalArgumentException(new StringBuilder(101).append("Save path '").append(modelCheckpointPath).append("' conflicts with the path used for the checkpoint state. ").append("Please use a different save path.").toString());
        }
        FileIO$.MODULE$.writeStringToFileAtomic(coordinatorCheckpointStateFilename, TextFormat.printToString((MessageOrBuilder)state), FileIO$.MODULE$.writeStringToFileAtomic$default$3());
    }

    private Seq<Path> updateCheckpointStateFile$default$3() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private String updateCheckpointStateFile$default$4() {
        return "checkpoint";
    }

    private boolean updateCheckpointStateFile$default$5() {
        return false;
    }

    public Option<CheckpointStateProto.CheckpointState> loadCheckpointState(Path directory, String checkpointStateFile) throws IllegalArgumentException {
        None$ none$;
        Path coordinatorCheckpointStateFilename = directory.resolve(checkpointStateFile);
        if (Files.exists(coordinatorCheckpointStateFilename, new LinkOption[0])) {
            try {
                String loadedString = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(coordinatorCheckpointStateFilename)).asScala()).mkString("\n");
                CheckpointStateProto.CheckpointState.Builder checkpointStateBuilder = CheckpointStateProto.CheckpointState.newBuilder();
                TextFormat.merge((CharSequence)loadedString, (Message.Builder)checkpointStateBuilder);
                if (checkpointStateBuilder.getModelCheckpointPath() == null) {
                    throw new IllegalArgumentException(new StringBuilder(39).append("Invalid checkpoint state loaded from: ").append(directory).append(".").toString());
                }
                String modelCheckpointPath = checkpointStateBuilder.getModelCheckpointPath();
                Object object = !directory.getFileSystem().getPath(modelCheckpointPath, new String[0]).isAbsolute() ? checkpointStateBuilder.setModelCheckpointPath(((Object)directory.resolve(modelCheckpointPath).toAbsolutePath()).toString()) : BoxedUnit.UNIT;
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), checkpointStateBuilder.getAllModelCheckpointPathsCount()).foreach((Function1 & Serializable & scala.Serializable)i -> Saver$.$anonfun$loadCheckpointState$1(directory, checkpointStateBuilder, BoxesRunTime.unboxToInt((Object)i)));
                none$ = new Some((Object)checkpointStateBuilder.build());
            }
            catch (Throwable t) {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Exception thrown while loading the checkpoint state.", t);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Checkpoint '{}' ignored.", new Object[]{coordinatorCheckpointStateFilename});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                none$ = None$.MODULE$;
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public String loadCheckpointState$default$2() {
        return "checkpoint";
    }

    public Seq<Object> org$platanios$tensorflow$api$ops$variables$Saver$$checkpointTimes(Seq<Path> checkpointPrefixes, TimeUnit unit, boolean followSymbolicLinks) {
        Seq times = (Seq)checkpointPrefixes.map((Function1 & Serializable & scala.Serializable)prefix -> BoxesRunTime.boxToLong((long)Saver$.$anonfun$checkpointTimes$1(unit, followSymbolicLinks, prefix)), Seq$.MODULE$.canBuildFrom());
        int badCheckpointPrefix = times.indexWhere((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$7 -> x$7 < 0L);
        if (badCheckpointPrefix != -1) {
            Path prefix2 = (Path)checkpointPrefixes.apply(badCheckpointPrefix);
            throw new IllegalArgumentException(new StringBuilder(55).append("Could not obtain the time for checkpoint with prefix: ").append(prefix2).append(".").toString());
        }
        return times;
    }

    private TimeUnit checkpointTimes$default$2() {
        return TimeUnit.SECONDS;
    }

    private boolean checkpointTimes$default$3() {
        return true;
    }

    private Path prefixToCheckpointPath(Path prefix, SaverDef.CheckpointFormatVersion checkpointFormatVersion) throws IllegalArgumentException {
        Path path;
        SaverDef.CheckpointFormatVersion checkpointFormatVersion2 = checkpointFormatVersion;
        if (SaverDef.CheckpointFormatVersion.V1.equals(checkpointFormatVersion2)) {
            path = prefix;
        } else if (SaverDef.CheckpointFormatVersion.V2.equals(checkpointFormatVersion2)) {
            path = prefix.resolveSibling(new StringBuilder(6).append(prefix.getFileName()).append(".index").toString());
        } else {
            throw new IllegalArgumentException(new StringBuilder(41).append("Unsupported checkpoint format version '").append(checkpointFormatVersion).append("'.").toString());
        }
        return path;
    }

    public Path org$platanios$tensorflow$api$ops$variables$Saver$$metaGraphFilename(Path checkpointFile, String metaGraphSuffix) {
        String filename = ((Object)checkpointFile.getFileName()).toString();
        String baseName = this.SHARDED_CHECKPOINT_FILENAME_REGEX.pattern().matcher(filename).replaceFirst("");
        return checkpointFile.resolveSibling(new StringBuilder(1).append(baseName).append(".").append(metaGraphSuffix).toString());
    }

    private String metaGraphFilename$default$2() {
        return "meta";
    }

    public static final /* synthetic */ boolean $anonfun$fromMetaGraphDef$default$10$1(Graph.Key x$5) {
        return true;
    }

    public static final /* synthetic */ Path $anonfun$checkpointState$1(Path directory$3, Path path) {
        return !path.isAbsolute() ? directory$3.relativize(path) : path;
    }

    public static final /* synthetic */ String $anonfun$checkpointState$2(Path x$6) {
        return ((Object)x$6).toString();
    }

    public static final /* synthetic */ Object $anonfun$loadCheckpointState$1(Path directory$1, CheckpointStateProto.CheckpointState.Builder checkpointStateBuilder$1, int i) {
        String path = checkpointStateBuilder$1.getAllModelCheckpointPaths(i);
        return !directory$1.getFileSystem().getPath(path, new String[0]).isAbsolute() ? checkpointStateBuilder$1.setAllModelCheckpointPaths(i, ((Object)directory$1.resolve(path).toAbsolutePath()).toString()) : BoxedUnit.UNIT;
    }

    private static final long maybeGetTime$1(Path pattern, TimeUnit unit$1, boolean followSymbolicLinks$1) {
        Set<Path> paths = FileIO$.MODULE$.getMatchingPaths(pattern, FileIO$.MODULE$.getMatchingPaths$default$2());
        return paths.nonEmpty() ? FileIO$.MODULE$.getLastModifiedTime((Path)paths.head(), unit$1, followSymbolicLinks$1) : -1L;
    }

    public static final /* synthetic */ long $anonfun$checkpointTimes$1(TimeUnit unit$1, boolean followSymbolicLinks$1, Path prefix) {
        Path pathPattern = MODULE$.prefixToCheckpointPath(prefix, SaverDef.CheckpointFormatVersion.V2);
        long time = Saver$.maybeGetTime$1(pathPattern, unit$1, followSymbolicLinks$1);
        return time > 0L ? time : Saver$.maybeGetTime$1(prefix, unit$1, followSymbolicLinks$1);
    }

    private Saver$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)"Variables / Saver"));
        this.SHARDED_CHECKPOINT_FILENAME_REGEX = new StringOps(Predef$.MODULE$.augmentString("-[\\d\\?]+-of-\\d+$")).r();
    }
}

