/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.api.tensors;

import com.google.protobuf.ByteString;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.platanios.tensorflow.api.core.Shape;
import org.platanios.tensorflow.api.core.Shape$;
import org.platanios.tensorflow.api.core.package$exception$;
import org.platanios.tensorflow.api.implicits.Implicits$;
import org.platanios.tensorflow.api.io.NPY$;
import org.platanios.tensorflow.api.tensors.Tensor;
import org.platanios.tensorflow.api.tensors.TensorConvertible;
import org.platanios.tensorflow.api.tensors.TensorConvertible$;
import org.platanios.tensorflow.api.tensors.ops.Basic$;
import org.platanios.tensorflow.api.tensors.ops.Random$;
import org.platanios.tensorflow.api.types.DataType;
import org.platanios.tensorflow.api.types.DataType$;
import org.platanios.tensorflow.api.types.SupportedType;
import org.platanios.tensorflow.api.types.SupportedType$;
import org.platanios.tensorflow.api.types.package$;
import org.platanios.tensorflow.api.utilities.Disposer$;
import org.platanios.tensorflow.api.utilities.NativeHandleWrapper;
import org.platanios.tensorflow.api.utilities.NativeHandleWrapper$;
import org.platanios.tensorflow.api.utilities.NativeHandleWrapper$Lock$;
import org.platanios.tensorflow.jni.InvalidArgumentException;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.TensorProto;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class Tensor$ {
    public static Tensor$ MODULE$;
    private final Logger logger;

    static {
        new Tensor$();
    }

    public Logger logger() {
        return this.logger;
    }

    public Tensor fromNativeHandle(long nativeHandle) {
        NativeHandleWrapper nativeHandleWrapper = NativeHandleWrapper$.MODULE$.apply(nativeHandle);
        JFunction0.mcV.sp & Serializable & scala.Serializable closeFn = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            NativeHandleWrapper$Lock$ nativeHandleWrapper$Lock$ = nativeHandleWrapper.Lock();
            synchronized (nativeHandleWrapper$Lock$) {
                if (nativeHandleWrapper.handle() != 0L) {
                    org.platanios.tensorflow.jni.Tensor$.MODULE$.eagerDelete(nativeHandleWrapper.handle());
                    nativeHandleWrapper.handle_$eq(0L);
                }
            }
        };
        Tensor tensor = new Tensor(nativeHandleWrapper, (Function0<BoxedUnit>)closeFn);
        Disposer$.MODULE$.add(tensor, (Function0<BoxedUnit>)closeFn);
        return tensor;
    }

    public Tensor fromHostNativeHandle(long nativeHandle) {
        return this.fromNativeHandle(org.platanios.tensorflow.jni.Tensor$.MODULE$.eagerAllocate(nativeHandle));
    }

    public <T> Tensor apply(T head, Seq<T> tail, TensorConvertible<T> ev) {
        T t = head;
        Seq tensors = (Seq)((TraversableLike)tail.$plus$colon(t, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)value -> ev.toTensor(value), Seq$.MODULE$.canBuildFrom());
        Seq dataTypes = (Seq)tensors.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.dataType(), Seq$.MODULE$.canBuildFrom());
        return this.apply(DataType$.MODULE$.mostPrecise((Seq<DataType>)dataTypes), tensors.head(), (Seq)tensors.tail(), TensorConvertible$.MODULE$.tensorLikeTensorConvertible());
    }

    public <T> Tensor apply(DataType dataType) {
        return this.allocate(dataType, Shape$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{0})));
    }

    public <T> Tensor apply(DataType dataType, T head, Seq<T> tail, TensorConvertible<T> ev) {
        T t = head;
        return Implicits$.MODULE$.tensorToMathOps(Basic$.MODULE$.stack((Seq<Tensor>)((Seq)((TraversableLike)tail.$plus$colon(t, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)value -> ev.toTensor(value), Seq$.MODULE$.canBuildFrom())), 0)).cast(dataType);
    }

    public Tensor zeros(DataType dataType, Shape shape) {
        DataType dataType2 = dataType;
        DataType.Aux<Object> aux = package$.MODULE$.BOOLEAN();
        DataType dataType3 = dataType2;
        Tensor tensor = !(aux != null ? !aux.equals(dataType3) : dataType3 != null) ? this.fill(package$.MODULE$.BOOLEAN(), shape, BoxesRunTime.boxToBoolean((boolean)false), SupportedType$.MODULE$.booleanIsSupportedType()) : this.fill(dataType, shape, BoxesRunTime.boxToInteger((int)0), SupportedType$.MODULE$.intIsSupportedType());
        return tensor;
    }

    public Tensor zerosLike(Tensor tensor) {
        return this.zeros(tensor.dataType(), tensor.shape());
    }

    public Tensor ones(DataType dataType, Shape shape) {
        DataType dataType2 = dataType;
        DataType.Aux<Object> aux = package$.MODULE$.BOOLEAN();
        DataType dataType3 = dataType2;
        Tensor tensor = !(aux != null ? !aux.equals(dataType3) : dataType3 != null) ? this.fill(package$.MODULE$.BOOLEAN(), shape, BoxesRunTime.boxToBoolean((boolean)true), SupportedType$.MODULE$.booleanIsSupportedType()) : this.fill(dataType, shape, BoxesRunTime.boxToInteger((int)1), SupportedType$.MODULE$.intIsSupportedType());
        return tensor;
    }

    public Tensor onesLike(Tensor tensor) {
        return this.ones(tensor.dataType(), tensor.shape());
    }

    public Tensor rand(DataType dataType, Tensor shape, Tensor minValue, Tensor maxValue, Option<Object> seed) {
        return Random$.MODULE$.randomUniform(dataType, shape, minValue, maxValue, seed);
    }

    public DataType rand$default$1() {
        return package$.MODULE$.FLOAT32();
    }

    public Tensor rand$default$2() {
        return Implicits$.MODULE$.tensorConvertibleToTensor(Shape$.MODULE$.scalar(), TensorConvertible$.MODULE$.shapeTensorConvertible());
    }

    public Tensor rand$default$3() {
        return Implicits$.MODULE$.tensorConvertibleToTensor(BoxesRunTime.boxToDouble((double)0.0), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.doubleIsSupportedType()));
    }

    public Tensor rand$default$4() {
        return Implicits$.MODULE$.tensorConvertibleToTensor(BoxesRunTime.boxToDouble((double)1.0), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.doubleIsSupportedType()));
    }

    public Option<Object> rand$default$5() {
        return None$.MODULE$;
    }

    public Tensor randn(DataType dataType, Tensor shape, Tensor mean, Tensor standardDeviation, Option<Object> seed) {
        return Random$.MODULE$.randomNormal(dataType, shape, mean, standardDeviation, seed);
    }

    public DataType randn$default$1() {
        return package$.MODULE$.FLOAT32();
    }

    public Tensor randn$default$2() {
        return Implicits$.MODULE$.tensorConvertibleToTensor(Shape$.MODULE$.scalar(), TensorConvertible$.MODULE$.shapeTensorConvertible());
    }

    public Tensor randn$default$3() {
        return Implicits$.MODULE$.tensorConvertibleToTensor(BoxesRunTime.boxToDouble((double)0.0), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.doubleIsSupportedType()));
    }

    public Tensor randn$default$4() {
        return Implicits$.MODULE$.tensorConvertibleToTensor(BoxesRunTime.boxToDouble((double)1.0), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.doubleIsSupportedType()));
    }

    public Option<Object> randn$default$5() {
        return None$.MODULE$;
    }

    public <T> Tensor fill(DataType dataType, Shape shape, T value, SupportedType<T> ev) {
        Tensor tensor;
        DataType inferredDataType = dataType == null ? ev.dataType() : dataType;
        shape.assertFullyDefined(shape.assertFullyDefined$default$1());
        DataType dataType2 = inferredDataType;
        DataType.Aux<String> aux = package$.MODULE$.STRING();
        DataType dataType3 = dataType2;
        if (!(aux != null ? !aux.equals(dataType3) : dataType3 != null)) {
            int numStringBytes = value.toString().getBytes(Charset.forName("UTF-8")).length;
            int numEncodedBytes = org.platanios.tensorflow.jni.Tensor$.MODULE$.getEncodedStringSize(numStringBytes);
            long numBytes = shape.numElements() * (long)(package$.MODULE$.INT64().byteSize() + numEncodedBytes);
            long hostHandle = org.platanios.tensorflow.jni.Tensor$.MODULE$.allocate(package$.MODULE$.STRING().cValue(), (long[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(shape.asArray())).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$6 -> x$6, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())), numBytes);
            ByteBuffer buffer = org.platanios.tensorflow.jni.Tensor$.MODULE$.buffer(hostHandle).order(ByteOrder.nativeOrder());
            int baseOffset = package$.MODULE$.INT64().byteSize() * (int)shape.numElements();
            int index = 0;
            int i = 0;
            while ((long)i < shape.numElements()) {
                int numEncodedBytes2 = package$.MODULE$.STRING().putElementInBuffer(buffer, baseOffset + index, package$.MODULE$.STRING().cast((String)value, (SupportedType<String>)ev));
                package$.MODULE$.INT64().putElementInBuffer(buffer, i * package$.MODULE$.INT64().byteSize(), BoxesRunTime.boxToLong((long)index));
                index += numEncodedBytes2;
                ++i;
            }
            Tensor tensor2 = this.fromHostNativeHandle(hostHandle);
            org.platanios.tensorflow.jni.Tensor$.MODULE$.delete(hostHandle);
            tensor = tensor2;
        } else {
            long numBytes = shape.numElements() * (long)inferredDataType.byteSize();
            long hostHandle = org.platanios.tensorflow.jni.Tensor$.MODULE$.allocate(inferredDataType.cValue(), (long[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(shape.asArray())).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$7 -> x$7, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())), numBytes);
            ByteBuffer buffer = org.platanios.tensorflow.jni.Tensor$.MODULE$.buffer(hostHandle).order(ByteOrder.nativeOrder());
            int index = 0;
            int i = 0;
            while ((long)i < shape.numElements()) {
                inferredDataType.putElementInBuffer(buffer, index, inferredDataType.cast(value, ev));
                index += inferredDataType.byteSize();
                ++i;
            }
            Tensor tensor3 = this.fromHostNativeHandle(hostHandle);
            org.platanios.tensorflow.jni.Tensor$.MODULE$.delete(hostHandle);
            tensor = tensor3;
        }
        return tensor;
    }

    public <T> DataType fill$default$1() {
        return null;
    }

    public <T> Shape fill$default$2() {
        return Shape$.MODULE$.apply((Seq<Object>)Nil$.MODULE$);
    }

    public Tensor allocate(DataType dataType, Shape shape) throws IllegalArgumentException {
        Tensor tensor;
        DataType dataType2 = dataType;
        DataType.Aux<String> aux = package$.MODULE$.STRING();
        DataType dataType3 = dataType2;
        if (!(aux != null ? !aux.equals(dataType3) : dataType3 != null)) {
            if (shape.numElements() != 0L) {
                throw new IllegalArgumentException("Cannot pre-allocate string tensors because their size is not known.");
            }
            long hostHandle = org.platanios.tensorflow.jni.Tensor$.MODULE$.allocate(dataType.cValue(), (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}), ClassTag$.MODULE$.Long()), 0L);
            Tensor tensor2 = this.fromHostNativeHandle(hostHandle);
            org.platanios.tensorflow.jni.Tensor$.MODULE$.delete(hostHandle);
            tensor = tensor2;
        } else {
            shape.assertFullyDefined(shape.assertFullyDefined$default$1());
            long numBytes = shape.numElements() * (long)dataType.byteSize();
            long hostHandle = org.platanios.tensorflow.jni.Tensor$.MODULE$.allocate(dataType.cValue(), (long[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(shape.asArray())).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$8 -> x$8, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())), numBytes);
            Tensor tensor3 = this.fromHostNativeHandle(hostHandle);
            org.platanios.tensorflow.jni.Tensor$.MODULE$.delete(hostHandle);
            tensor = tensor3;
        }
        return tensor;
    }

    public synchronized Tensor fromBuffer(DataType dataType, Shape shape, long numBytes, ByteBuffer buffer) throws IllegalArgumentException {
        ByteBuffer byteBuffer;
        if (buffer.isDirect()) {
            byteBuffer = buffer;
        } else {
            ByteBuffer direct = ByteBuffer.allocateDirect((int)numBytes);
            ByteBuffer bufferCopy = buffer.duplicate();
            direct.put((ByteBuffer)bufferCopy.limit((int)numBytes));
            byteBuffer = direct;
        }
        ByteBuffer directBuffer = byteBuffer;
        long hostHandle = org.platanios.tensorflow.jni.Tensor$.MODULE$.fromBuffer(dataType.cValue(), (long[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(shape.asArray())).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$9 -> x$9, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())), numBytes, directBuffer);
        Tensor tensor = this.fromHostNativeHandle(hostHandle);
        org.platanios.tensorflow.jni.Tensor$.MODULE$.delete(hostHandle);
        return tensor;
    }

    public Tensor fromNPY(Path file) throws IllegalArgumentException {
        return NPY$.MODULE$.read(file);
    }

    public TensorProto makeProto(Tensor value, DataType dataType, Shape shape) throws InvalidArgumentException {
        DataType inferredDataType = dataType == null ? value.dataType() : dataType;
        Shape inferredShape = shape == null ? value.shape() : shape;
        Tensor castedValue = Implicits$.MODULE$.tensorToMathOps(value).cast(inferredDataType);
        TensorProto.Builder tensorProtoBuilder = TensorProto.newBuilder().setDtype(inferredDataType.protoType()).setTensorShape(inferredShape.toTensorShapeProto());
        if ((long)inferredDataType.byteSize() * value.size() >= Integer.MAX_VALUE) {
            throw package$exception$.MODULE$.InvalidArgumentException().apply("Cannot serialize tensors whose content is larger than 2GB.");
        }
        DataType dataType2 = value.dataType();
        DataType.Aux<String> aux = package$.MODULE$.STRING();
        if ((dataType2 == null ? aux != null : !((Object)dataType2).equals(aux)) && value.size() == inferredShape.numElements()) {
            long resolvedHandle = castedValue.resolve();
            ByteBuffer buffer = org.platanios.tensorflow.jni.Tensor$.MODULE$.buffer(resolvedHandle).order(ByteOrder.nativeOrder());
            tensorProtoBuilder.setTensorContent(ByteString.copyFrom((ByteBuffer)buffer));
            NativeHandleWrapper$Lock$ nativeHandleWrapper$Lock$ = castedValue.NativeHandleLock();
            synchronized (nativeHandleWrapper$Lock$) {
                if (resolvedHandle != 0L) {
                    org.platanios.tensorflow.jni.Tensor$.MODULE$.delete(resolvedHandle);
                }
            }
        } else {
            castedValue.entriesIterator().foreach((Function1 & Serializable & scala.Serializable)v -> {
                inferredDataType.addToTensorProtoBuilder(tensorProtoBuilder, inferredDataType.cast(v, castedValue.dataType().supportedType()));
                return BoxedUnit.UNIT;
            });
        }
        return tensorProtoBuilder.build();
    }

    public DataType makeProto$default$2() {
        return null;
    }

    public Shape makeProto$default$3() {
        return null;
    }

    private Tensor$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)"Tensor"));
    }
}

