/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.api.types;

import org.platanios.tensorflow.api.core.package;
import org.platanios.tensorflow.api.core.package$exception$InvalidDataTypeException$;
import org.platanios.tensorflow.api.types.DataType;
import org.platanios.tensorflow.api.types.SupportedType;
import org.platanios.tensorflow.api.types.package$;
import scala.runtime.BoxesRunTime;
import spire.math.UByte;
import spire.math.UByte$;
import spire.math.UShort;
import spire.math.UShort$;

public final class SupportedType$ {
    public static SupportedType$ MODULE$;
    private final SupportedType<String> stringIsSupportedType;
    private final SupportedType<Object> booleanIsSupportedType;
    private final SupportedType<Object> floatIsSupportedType;
    private final SupportedType<Object> doubleIsSupportedType;
    private final SupportedType<Object> byteIsSupportedType;
    private final SupportedType<Object> shortIsSupportedType;
    private final SupportedType<Object> intIsSupportedType;
    private final SupportedType<Object> longIsSupportedType;
    private final SupportedType<UByte> uByteIsSupportedType;
    private final SupportedType<UShort> uShortIsSupportedType;

    static {
        new SupportedType$();
    }

    public final <T> SupportedType<T> apply(SupportedType<T> evidence) {
        return evidence;
    }

    public <T> SupportedType.SupportedTypeOps<T> toSupportedTypeOps(T value) {
        return new SupportedType.SupportedTypeOps<T>(value);
    }

    public SupportedType<String> stringIsSupportedType() {
        return this.stringIsSupportedType;
    }

    public SupportedType<Object> booleanIsSupportedType() {
        return this.booleanIsSupportedType;
    }

    public SupportedType<Object> floatIsSupportedType() {
        return this.floatIsSupportedType;
    }

    public SupportedType<Object> doubleIsSupportedType() {
        return this.doubleIsSupportedType;
    }

    public SupportedType<Object> byteIsSupportedType() {
        return this.byteIsSupportedType;
    }

    public SupportedType<Object> shortIsSupportedType() {
        return this.shortIsSupportedType;
    }

    public SupportedType<Object> intIsSupportedType() {
        return this.intIsSupportedType;
    }

    public SupportedType<Object> longIsSupportedType() {
        return this.longIsSupportedType;
    }

    public SupportedType<UByte> uByteIsSupportedType() {
        return this.uByteIsSupportedType;
    }

    public SupportedType<UShort> uShortIsSupportedType() {
        return this.uShortIsSupportedType;
    }

    private SupportedType$() {
        MODULE$ = this;
        this.stringIsSupportedType = new SupportedType<String>(){

            public DataType dataType() {
                return package$.MODULE$.STRING();
            }

            public <R> String cast(R value, DataType dataType, SupportedType<R> evidence$2) {
                return value.toString();
            }
            {
                SupportedType.$init$(this);
            }
        };
        this.booleanIsSupportedType = new SupportedType<Object>(){

            public DataType dataType() {
                return package$.MODULE$.BOOLEAN();
            }

            public <R> boolean cast(R value, DataType dataType, SupportedType<R> evidence$3) {
                boolean bl;
                R r = value;
                if (!(r instanceof Boolean)) {
                    throw new package.exception.InvalidDataTypeException("Cannot convert the provided value to a boolean.", package$exception$InvalidDataTypeException$.MODULE$.apply$default$2());
                }
                boolean bl2 = bl = BoxesRunTime.unboxToBoolean(r);
                return bl2;
            }
            {
                SupportedType.$init$(this);
            }
        };
        this.floatIsSupportedType = new SupportedType<Object>(){

            public DataType dataType() {
                return package$.MODULE$.FLOAT32();
            }

            public <R> float cast(R value, DataType dataType, SupportedType<R> evidence$4) {
                float f;
                R r = value;
                if (r instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean(r);
                    f = bl ? 1.0f : 0.0f;
                } else if (r instanceof Float) {
                    float f2;
                    f = f2 = BoxesRunTime.unboxToFloat(r);
                } else if (r instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble(r);
                    f = (float)d;
                } else if (r instanceof Byte) {
                    byte by = BoxesRunTime.unboxToByte(r);
                    f = by;
                } else if (r instanceof Short) {
                    short s = BoxesRunTime.unboxToShort(r);
                    f = s;
                } else if (r instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt(r);
                    f = n;
                } else if (r instanceof Long) {
                    long l = BoxesRunTime.unboxToLong(r);
                    f = l;
                } else if (r instanceof UByte) {
                    byte by = ((UByte)r).signed();
                    f = UByte$.MODULE$.toFloat$extension(by);
                } else if (r instanceof UShort) {
                    char c = ((UShort)r).signed();
                    f = UShort$.MODULE$.toFloat$extension(c);
                } else {
                    throw new package.exception.InvalidDataTypeException("Cannot convert the provided value to a float.", package$exception$InvalidDataTypeException$.MODULE$.apply$default$2());
                }
                return f;
            }
            {
                SupportedType.$init$(this);
            }
        };
        this.doubleIsSupportedType = new SupportedType<Object>(){

            public DataType dataType() {
                return package$.MODULE$.FLOAT64();
            }

            public <R> double cast(R value, DataType dataType, SupportedType<R> evidence$5) {
                double d;
                R r = value;
                if (r instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean(r);
                    d = bl ? 1.0 : 0.0;
                } else if (r instanceof Float) {
                    float f = BoxesRunTime.unboxToFloat(r);
                    d = f;
                } else if (r instanceof Double) {
                    double d2;
                    d = d2 = BoxesRunTime.unboxToDouble(r);
                } else if (r instanceof Byte) {
                    byte by = BoxesRunTime.unboxToByte(r);
                    d = by;
                } else if (r instanceof Short) {
                    short s = BoxesRunTime.unboxToShort(r);
                    d = s;
                } else if (r instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt(r);
                    d = n;
                } else if (r instanceof Long) {
                    long l = BoxesRunTime.unboxToLong(r);
                    d = l;
                } else if (r instanceof UByte) {
                    byte by = ((UByte)r).signed();
                    d = UByte$.MODULE$.toDouble$extension(by);
                } else if (r instanceof UShort) {
                    char c = ((UShort)r).signed();
                    d = UShort$.MODULE$.toDouble$extension(c);
                } else {
                    throw new package.exception.InvalidDataTypeException("Cannot convert the provided value to a double.", package$exception$InvalidDataTypeException$.MODULE$.apply$default$2());
                }
                return d;
            }
            {
                SupportedType.$init$(this);
            }
        };
        this.byteIsSupportedType = new SupportedType<Object>(){

            public DataType dataType() {
                return package$.MODULE$.INT8();
            }

            public <R> byte cast(R value, DataType dataType, SupportedType<R> evidence$6) {
                byte by;
                R r = value;
                if (r instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean(r);
                    by = bl ? (byte)1 : 0;
                } else if (r instanceof Float) {
                    float f = BoxesRunTime.unboxToFloat(r);
                    by = (byte)f;
                } else if (r instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble(r);
                    by = (byte)d;
                } else if (r instanceof Byte) {
                    byte by2;
                    by = by2 = BoxesRunTime.unboxToByte(r);
                } else if (r instanceof Short) {
                    short s = BoxesRunTime.unboxToShort(r);
                    by = (byte)s;
                } else if (r instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt(r);
                    by = (byte)n;
                } else if (r instanceof Long) {
                    long l = BoxesRunTime.unboxToLong(r);
                    by = (byte)l;
                } else if (r instanceof UByte) {
                    byte by3 = ((UByte)r).signed();
                    by = UByte$.MODULE$.toByte$extension(by3);
                } else if (r instanceof UShort) {
                    char c = ((UShort)r).signed();
                    by = UShort$.MODULE$.toByte$extension(c);
                } else {
                    throw new package.exception.InvalidDataTypeException("Cannot convert the provided value to a byte.", package$exception$InvalidDataTypeException$.MODULE$.apply$default$2());
                }
                return by;
            }
            {
                SupportedType.$init$(this);
            }
        };
        this.shortIsSupportedType = new SupportedType<Object>(){

            public DataType dataType() {
                return package$.MODULE$.INT16();
            }

            public <R> short cast(R value, DataType dataType, SupportedType<R> evidence$7) {
                short s;
                R r = value;
                if (r instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean(r);
                    s = bl ? (short)1 : 0;
                } else if (r instanceof Float) {
                    float f = BoxesRunTime.unboxToFloat(r);
                    s = (short)f;
                } else if (r instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble(r);
                    s = (short)d;
                } else if (r instanceof Byte) {
                    byte by = BoxesRunTime.unboxToByte(r);
                    s = by;
                } else if (r instanceof Short) {
                    short s2;
                    s = s2 = BoxesRunTime.unboxToShort(r);
                } else if (r instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt(r);
                    s = (short)n;
                } else if (r instanceof Long) {
                    long l = BoxesRunTime.unboxToLong(r);
                    s = (short)l;
                } else if (r instanceof UByte) {
                    byte by = ((UByte)r).signed();
                    s = UByte$.MODULE$.toShort$extension(by);
                } else if (r instanceof UShort) {
                    char c = ((UShort)r).signed();
                    s = UShort$.MODULE$.toShort$extension(c);
                } else {
                    throw new package.exception.InvalidDataTypeException("Cannot convert the provided value to a short.", package$exception$InvalidDataTypeException$.MODULE$.apply$default$2());
                }
                return s;
            }
            {
                SupportedType.$init$(this);
            }
        };
        this.intIsSupportedType = new SupportedType<Object>(){

            public DataType dataType() {
                return package$.MODULE$.INT32();
            }

            public <R> int cast(R value, DataType dataType, SupportedType<R> evidence$8) {
                int n;
                R r = value;
                if (r instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean(r);
                    n = bl ? 1 : 0;
                } else if (r instanceof Float) {
                    float f = BoxesRunTime.unboxToFloat(r);
                    n = (int)f;
                } else if (r instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble(r);
                    n = (int)d;
                } else if (r instanceof Byte) {
                    byte by = BoxesRunTime.unboxToByte(r);
                    n = by;
                } else if (r instanceof Short) {
                    short s = BoxesRunTime.unboxToShort(r);
                    n = s;
                } else if (r instanceof Integer) {
                    int n2;
                    n = n2 = BoxesRunTime.unboxToInt(r);
                } else if (r instanceof Long) {
                    long l = BoxesRunTime.unboxToLong(r);
                    n = (int)l;
                } else if (r instanceof UByte) {
                    byte by = ((UByte)r).signed();
                    n = UByte$.MODULE$.toInt$extension(by);
                } else if (r instanceof UShort) {
                    char c = ((UShort)r).signed();
                    n = UShort$.MODULE$.toInt$extension(c);
                } else {
                    throw new package.exception.InvalidDataTypeException("Cannot convert the provided value to an integer.", package$exception$InvalidDataTypeException$.MODULE$.apply$default$2());
                }
                return n;
            }
            {
                SupportedType.$init$(this);
            }
        };
        this.longIsSupportedType = new SupportedType<Object>(){

            public DataType dataType() {
                return package$.MODULE$.INT64();
            }

            public <R> long cast(R value, DataType dataType, SupportedType<R> evidence$9) {
                long l;
                R r = value;
                if (r instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean(r);
                    l = bl ? 1L : 0L;
                } else if (r instanceof Float) {
                    float f = BoxesRunTime.unboxToFloat(r);
                    l = (long)f;
                } else if (r instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble(r);
                    l = (long)d;
                } else if (r instanceof Byte) {
                    byte by = BoxesRunTime.unboxToByte(r);
                    l = by;
                } else if (r instanceof Short) {
                    short s = BoxesRunTime.unboxToShort(r);
                    l = s;
                } else if (r instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt(r);
                    l = n;
                } else if (r instanceof Long) {
                    long l2;
                    l = l2 = BoxesRunTime.unboxToLong(r);
                } else if (r instanceof UByte) {
                    byte by = ((UByte)r).signed();
                    l = UByte$.MODULE$.toLong$extension(by);
                } else if (r instanceof UShort) {
                    char c = ((UShort)r).signed();
                    l = UShort$.MODULE$.toLong$extension(c);
                } else {
                    throw new package.exception.InvalidDataTypeException("Cannot convert the provided value to a long.", package$exception$InvalidDataTypeException$.MODULE$.apply$default$2());
                }
                return l;
            }
            {
                SupportedType.$init$(this);
            }
        };
        this.uByteIsSupportedType = new SupportedType<UByte>(){

            public DataType dataType() {
                return package$.MODULE$.UINT8();
            }

            public <R> byte cast(R value, DataType dataType, SupportedType<R> evidence$10) {
                byte by;
                R r = value;
                if (r instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean(r);
                    by = bl ? UByte$.MODULE$.apply(1) : UByte$.MODULE$.apply(0);
                } else if (r instanceof Float) {
                    float f = BoxesRunTime.unboxToFloat(r);
                    by = UByte$.MODULE$.apply((int)f);
                } else if (r instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble(r);
                    by = UByte$.MODULE$.apply((int)d);
                } else if (r instanceof Byte) {
                    byte by2 = BoxesRunTime.unboxToByte(r);
                    by = UByte$.MODULE$.apply(by2);
                } else if (r instanceof Short) {
                    short s = BoxesRunTime.unboxToShort(r);
                    by = UByte$.MODULE$.apply((int)s);
                } else if (r instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt(r);
                    by = UByte$.MODULE$.apply(n);
                } else if (r instanceof Long) {
                    long l = BoxesRunTime.unboxToLong(r);
                    by = UByte$.MODULE$.apply((int)l);
                } else if (r instanceof UByte) {
                    byte by3;
                    by = by3 = ((UByte)r).signed();
                } else if (r instanceof UShort) {
                    char c = ((UShort)r).signed();
                    by = UByte$.MODULE$.apply(UShort$.MODULE$.toInt$extension(c));
                } else {
                    throw new package.exception.InvalidDataTypeException("Cannot convert the provided value to an unsigned byte.", package$exception$InvalidDataTypeException$.MODULE$.apply$default$2());
                }
                return by;
            }
            {
                SupportedType.$init$(this);
            }
        };
        this.uShortIsSupportedType = new SupportedType<UShort>(){

            public DataType dataType() {
                return package$.MODULE$.UINT16();
            }

            public <R> char cast(R value, DataType dataType, SupportedType<R> evidence$11) {
                char c;
                R r = value;
                if (r instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean(r);
                    c = bl ? UShort$.MODULE$.apply(1) : UShort$.MODULE$.apply(0);
                } else if (r instanceof Float) {
                    float f = BoxesRunTime.unboxToFloat(r);
                    c = UShort$.MODULE$.apply((int)f);
                } else if (r instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble(r);
                    c = UShort$.MODULE$.apply((int)d);
                } else if (r instanceof Byte) {
                    byte by = BoxesRunTime.unboxToByte(r);
                    c = UShort$.MODULE$.apply((short)by);
                } else if (r instanceof Short) {
                    short s = BoxesRunTime.unboxToShort(r);
                    c = UShort$.MODULE$.apply(s);
                } else if (r instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt(r);
                    c = UShort$.MODULE$.apply(n);
                } else if (r instanceof Long) {
                    long l = BoxesRunTime.unboxToLong(r);
                    c = UShort$.MODULE$.apply((int)l);
                } else if (r instanceof UByte) {
                    byte by = ((UByte)r).signed();
                    c = UShort$.MODULE$.apply(UByte$.MODULE$.toShort$extension(by));
                } else if (r instanceof UShort) {
                    char c2;
                    c = c2 = ((UShort)r).signed();
                } else {
                    throw new package.exception.InvalidDataTypeException("Cannot convert the provided value to an unsigned short.", package$exception$InvalidDataTypeException$.MODULE$.apply$default$2());
                }
                return c;
            }
            {
                SupportedType.$init$(this);
            }
        };
    }
}

