/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.api.io;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.platanios.tensorflow.api.io.DirectoryLoader;
import org.platanios.tensorflow.api.io.DirectoryLoader$;
import org.platanios.tensorflow.api.io.DirectoryLoaderSuite$ByteLoader$;
import org.platanios.tensorflow.api.io.Loader;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatestplus.junit.AssertionsForJUnit$;
import org.scalatestplus.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t5c\u0001\u0002\u001a4\u0001yBQa\u0012\u0001\u0005\u0002!C\u0011b\u0013\u0001A\u0002\u0003\u0005\u000b\u0015\u0002'\t\u0013Y\u0003\u0001\u0019!A!B\u00139\u0006B\u00021\u0001A\u0003%\u0011\rC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003p\u0001\u0011\u0005\u0001\u000f\u0003\u0004y\u0001\u0001&I!\u001f\u0005\b\u0003'\u0001\u0001\u0015\"\u0003q\u0011!\t)\u0002\u0001Q\u0005\n\u0005]\u0001BBA\u0018\u0001\u0011\u0005\u0001\u000f\u0003\u0004\u0002:\u0001!\t\u0001\u001d\u0005\u0007\u0003{\u0001A\u0011\u00019\t\r\u0005\u0005\u0003\u0001\"\u0001q\u0011\u0019\t)\u0005\u0001C\u0001a\"1\u0011\u0011\n\u0001\u0005\u0002ADa!!\u0014\u0001\t\u0003\u0001\bBBA)\u0001\u0011\u0005\u0001\u000f\u0003\u0004\u0002V\u0001!\t\u0001\u001d\u0005\u0007\u00033\u0002A\u0011\u00019\t\r\u0005u\u0003\u0001\"\u0001q\u0011\u0019\t\t\u0007\u0001C\u0001a\"1\u0011Q\r\u0001\u0005\u0002A<q!!\u001b4\u0011\u0003\tYG\u0002\u00043g!\u0005\u0011Q\u000e\u0005\u0007\u000fb!\t!a\u001f\u0007\u000f\u0005u\u0004\u0004\u0011\r\u0002\u0000!Q\u0011Q\u0012\u000e\u0003\u0016\u0004%\t!a$\t\u0013\u0005E%D!E!\u0002\u0013a\u0005BB$\u001b\t\u0003\t\u0019\nC\u0004P5\u0001\u0006I!a'\t\u000f\u0005\u0015&\u0004\"\u0011\u0002(\"I\u0011q\u0016\u000e\u0002\u0002\u0013\u0005\u0011\u0011\u0017\u0005\n\u0003kS\u0012\u0013!C\u0001\u0003oC\u0011\"!4\u001b\u0003\u0003%\t%a4\t\u0013\u0005m'$!A\u0005\u0002\u0005u\u0007\"CAs5\u0005\u0005I\u0011AAt\u0011%\t\u0019PGA\u0001\n\u0003\n)\u0010C\u0005\u0003\u0002i\t\t\u0011\"\u0001\u0003\u0004!I!Q\u0002\u000e\u0002\u0002\u0013\u0005#q\u0002\u0005\n\u0005#Q\u0012\u0011!C!\u0005'A\u0011B!\u0006\u001b\u0003\u0003%\tEa\u0006\b\u0015\tm\u0001$!A\t\u0002a\u0011iB\u0002\u0006\u0002~a\t\t\u0011#\u0001\u0019\u0005?AaaR\u0016\u0005\u0002\t5\u0002\"\u0003B\tW\u0005\u0005IQ\tB\n\u0011%\u0011ycKA\u0001\n\u0003\u0013\t\u0004C\u0005\u00036-\n\t\u0011\"!\u00038!I!1I\u0016\u0002\u0002\u0013%!Q\t\u0005\n\u0005\u0007B\u0012\u0011!C\u0005\u0005\u000b\u0012A\u0003R5sK\u000e$xN]=M_\u0006$WM]*vSR,'B\u0001\u001b6\u0003\tIwN\u0003\u00027o\u0005\u0019\u0011\r]5\u000b\u0005aJ\u0014A\u0003;f]N|'O\u001a7po*\u0011!hO\u0001\na2\fG/\u00198j_NT\u0011\u0001P\u0001\u0004_J<7\u0001A\n\u0003\u0001}\u0002\"\u0001Q#\u000e\u0003\u0005S!AQ\"\u0002\u000b),h.\u001b;\u000b\u0005\u0011[\u0014!D:dC2\fG/Z:ua2,8/\u0003\u0002G\u0003\nQ!*\u00168jiN+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005I\u0005C\u0001&\u0001\u001b\u0005\u0019\u0014!C0uK6\u0004\b+\u0019;i!\tiE+D\u0001O\u0015\ty\u0005+\u0001\u0003gS2,'BA)S\u0003\rq\u0017n\u001c\u0006\u0002'\u0006!!.\u0019<b\u0013\t)fJ\u0001\u0003QCRD\u0017aB0m_\u0006$WM\u001d\t\u0004\u0015bS\u0016BA-4\u0005=!\u0015N]3di>\u0014\u0018\u0010T8bI\u0016\u0014\bCA._\u001b\u0005a&\"A/\u0002\u000bM\u001c\u0017\r\\1\n\u0005}c&\u0001\u0002\"zi\u0016\f1b\u0018;f[B4u\u000e\u001c3feB\u0011!MZ\u0007\u0002G*\u0011A-Z\u0001\u0006eVdWm\u001d\u0006\u0003\u0005nJ!aZ2\u0003\u001fQ+W\u000e]8sCJLhi\u001c7eKJ\f!\u0002^3na\u001a{G\u000eZ3s+\u0005\t\u0007FA\u0003l!\taW.D\u0001f\u0013\tqWM\u0001\u0003Sk2,\u0017!B:fiV\u0003H#A9\u0011\u0005m\u0013\u0018BA:]\u0005\u0011)f.\u001b;)\u0005\u0019)\bC\u00017w\u0013\t9XM\u0001\u0004CK\u001a|'/Z\u0001\foJLG/\u001a+p\r&dW\r\u0006\u0003ru\u0006=\u0001\"B>\b\u0001\u0004a\u0018\u0001\u00034jY\u0016t\u0017-\\3\u0011\u0007u\fIAD\u0002\u007f\u0003\u000b\u0001\"a /\u000e\u0005\u0005\u0005!bAA\u0002{\u00051AH]8pizJ1!a\u0002]\u0003\u0019\u0001&/\u001a3fM&!\u00111BA\u0007\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0001/\t\r\u0005Eq\u00011\u0001}\u0003\u001d\u0019wN\u001c;f]R\fq\u0001\\8bI\u0006cG.\u0001\nbgN,'\u000f\u001e'pC\u0012,'/W5fY\u0012\u001cHcA9\u0002\u001a!9\u00111D\u0005A\u0002\u0005u\u0011A\u0002<bYV,7\u000fE\u0003\u0002 \u0005%\"L\u0004\u0003\u0002\"\u0005\u0015bbA@\u0002$%\tQ,C\u0002\u0002(q\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002,\u00055\"aA*fc*\u0019\u0011q\u0005/\u0002%Q,7\u000f^#naRLH)\u001b:fGR|'/\u001f\u0015\u0004\u0015\u0005M\u0002c\u00017\u00026%\u0019\u0011qG3\u0003\tQ+7\u000f^\u0001\u0010i\u0016\u001cHoU5oO2,wK]5uK\"\u001a1\"a\r\u0002%Q,7\u000f^'vYRL\u0007\u000f\\3Xe&$Xm\u001d\u0015\u0004\u0019\u0005M\u0012!\u0005;fgRlU\u000f\u001c;ja2,Gj\\1eg\"\u001aQ\"a\r\u0002/Q,7\u000f^'vYRL\u0007\u000f\\3GS2,7/\u0011;P]\u000e,\u0007f\u0001\b\u00024\u0005iC/Z:u\r&t\u0017n\u001d5fg2{\u0017\rZ5oO\u001aKG.Z,iK:\u001cv/\u001b;dQ&tw\rV8OK^4\u0015\u000e\\3)\u0007=\t\u0019$\u0001\u000euKN$\u0018J\u001c;fe6,G-[1uK\u0016k\u0007\u000f^=GS2,7\u000fK\u0002\u0011\u0003g\ta\u0003^3ti\u0012+G/Z2ug:+wo\u00147e\r&dWm\u001d\u0015\u0004#\u0005M\u0012!\u0006;fgRLuM\\8sKNtUm^3s\r&dWm\u001d\u0015\u0004%\u0005M\u0012a\u0007;fgR$U\r^3diN\u001c\u0005.\u00198hS:<w\n\u001c3GS2,7\u000fK\u0002\u0014\u0003g\t\u0011\u0005^3ti\u0012{Wm\u001d(pi\u000e\u0013\u0018m\u001d5XQ\u0016tg)\u001b7f\u0013N$U\r\\3uK\u0012D3\u0001FA\u001a\u0003e\"Xm\u001d;UQJ|wo\u001d#je\u0016\u001cGo\u001c:z\t\u0016dW\r^3e\u000bb\u001cW\r\u001d;j_:<\u0006.\u001a8ESJ,7\r^8ss&\u001bH)\u001a7fi\u0016$\u0007fA\u000b\u00024\u0005qA/Z:u!\u0006$\bNR5mi\u0016\u0014\bf\u0001\f\u00024\u0005!B)\u001b:fGR|'/\u001f'pC\u0012,'oU;ji\u0016\u0004\"A\u0013\r\u0014\u000ba\ty'!\u001e\u0011\u0007m\u000b\t(C\u0002\u0002tq\u0013a!\u00118z%\u00164\u0007cA.\u0002x%\u0019\u0011\u0011\u0010/\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\u0005-$A\u0003\"zi\u0016du.\u00193feNI!$a\u001c\u0002\u0002\u0006\u001d\u0015Q\u000f\t\u0005\u0015\u0006\r%,C\u0002\u0002\u0006N\u0012a\u0001T8bI\u0016\u0014\bcA.\u0002\n&\u0019\u00111\u0012/\u0003\u000fA\u0013x\u000eZ;di\u0006!\u0001/\u0019;i+\u0005a\u0015!\u00029bi\"\u0004C\u0003BAK\u00033\u00032!a&\u001b\u001b\u0005A\u0002BBAG;\u0001\u0007A\n\u0005\u0003\u0002\u001e\u0006\u0005VBAAP\u0015\t!$+\u0003\u0003\u0002$\u0006}%aC%oaV$8\u000b\u001e:fC6\fA\u0001\\8bIR\u0011\u0011\u0011\u0016\t\u0006\u0003?\tYKW\u0005\u0005\u0003[\u000biC\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003\u0011\u0019w\u000e]=\u0015\t\u0005U\u00151\u0017\u0005\t\u0003\u001b\u0003\u0003\u0013!a\u0001\u0019\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA]U\ra\u00151X\u0016\u0003\u0003{\u0003B!a0\u0002J6\u0011\u0011\u0011\u0019\u0006\u0005\u0003\u0007\f)-A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0019/\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002L\u0006\u0005'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!5\u0011\t\u0005M\u0017\u0011\\\u0007\u0003\u0003+T1!a6S\u0003\u0011a\u0017M\\4\n\t\u0005-\u0011Q[\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003?\u00042aWAq\u0013\r\t\u0019\u000f\u0018\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003S\fy\u000fE\u0002\\\u0003WL1!!<]\u0005\r\te.\u001f\u0005\n\u0003c$\u0013\u0011!a\u0001\u0003?\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA|!\u0019\tI0a@\u0002j6\u0011\u00111 \u0006\u0004\u0003{d\u0016AC2pY2,7\r^5p]&!\u0011QVA~\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\u0003\u0005\u0017\u00012a\u0017B\u0004\u0013\r\u0011I\u0001\u0018\u0002\b\u0005>|G.Z1o\u0011%\t\tPJA\u0001\u0002\u0004\tI/\u0001\u0005iCND7i\u001c3f)\t\ty.\u0001\u0005u_N#(/\u001b8h)\t\t\t.\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005\u000b\u0011I\u0002C\u0005\u0002r&\n\t\u00111\u0001\u0002j\u0006Q!)\u001f;f\u0019>\fG-\u001a:\u0011\u0007\u0005]5fE\u0003,\u0005C\t)\bE\u0004\u0003$\t%B*!&\u000e\u0005\t\u0015\"b\u0001B\u00149\u00069!/\u001e8uS6,\u0017\u0002\u0002B\u0016\u0005K\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82)\t\u0011i\"A\u0003baBd\u0017\u0010\u0006\u0003\u0002\u0016\nM\u0002BBAG]\u0001\u0007A*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\te\"q\b\t\u00057\nmB*C\u0002\u0003>q\u0013aa\u00149uS>t\u0007\"\u0003B!_\u0005\u0005\t\u0019AAK\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003HA!\u00111\u001bB%\u0013\u0011\u0011Y%!6\u0003\r=\u0013'.Z2u\u0001")
public class DirectoryLoaderSuite
extends JUnitSuite {
    private Path _tempPath;
    private DirectoryLoader<Object> _loader;
    private final TemporaryFolder _tempFolder = new TemporaryFolder();

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder;
    }

    @Before
    public void setUp() {
        this._tempPath = this.tempFolder().newFolder().toPath();
        this._loader = new DirectoryLoader(this._tempPath, (Function1)DirectoryLoaderSuite$ByteLoader$.MODULE$, DirectoryLoader$.MODULE$.apply$default$3());
    }

    private void writeToFile(String filename, String content) {
        Files.write(this._tempPath.resolve(filename), content.getBytes(Charset.forName("UTF-8")), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
    }

    private void loadAll() {
        this._loader.load().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            DirectoryLoaderSuite.$anonfun$loadAll$1(BoxesRunTime.unboxToByte((Object)x$1));
            return BoxedUnit.UNIT;
        });
    }

    private void assertLoaderYields(Seq<Object> values) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this._loader.load().toSeq());
        Seq<Object> $org_scalatest_assert_macro_right = values;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
    }

    @Test
    public void testEmptyDirectory() {
        this.assertLoaderYields((Seq<Object>)((Seq)Seq$.MODULE$.empty()));
    }

    @Test
    public void testSingleWrite() {
        this.writeToFile("a", "abc");
        this.assertLoaderYields((Seq<Object>)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps("abc".getBytes())).toSeq());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this._loader.outOfOrderWritesDetected(), "DirectoryLoaderSuite.this._loader.outOfOrderWritesDetected", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
    }

    @Test
    public void testMultipleWrites() {
        this.writeToFile("a", "abc");
        this.assertLoaderYields((Seq<Object>)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps("abc".getBytes())).toSeq());
        this.writeToFile("a", "xyz");
        this.assertLoaderYields((Seq<Object>)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps("xyz".getBytes())).toSeq());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this._loader.outOfOrderWritesDetected(), "DirectoryLoaderSuite.this._loader.outOfOrderWritesDetected", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
    }

    @Test
    public void testMultipleLoads() {
        this.writeToFile("a", "a");
        this._loader.load();
        this._loader.load();
        this.assertLoaderYields((Seq<Object>)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps("a".getBytes())).toSeq());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this._loader.outOfOrderWritesDetected(), "DirectoryLoaderSuite.this._loader.outOfOrderWritesDetected", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
    }

    @Test
    public void testMultipleFilesAtOnce() {
        this.writeToFile("b", "b");
        this.writeToFile("a", "a");
        this.assertLoaderYields((Seq<Object>)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps("ab".getBytes())).toSeq());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this._loader.outOfOrderWritesDetected(), "DirectoryLoaderSuite.this._loader.outOfOrderWritesDetected", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
    }

    @Test
    public void testFinishesLoadingFileWhenSwitchingToNewFile() {
        this.writeToFile("a", "a");
        this.assertLoaderYields((Seq<Object>)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps("a".getBytes())).toSeq());
        this.writeToFile("a", "b");
        this.writeToFile("b", "c");
        this.assertLoaderYields((Seq<Object>)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps("bc".getBytes())).toSeq());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this._loader.outOfOrderWritesDetected(), "DirectoryLoaderSuite.this._loader.outOfOrderWritesDetected", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
    }

    @Test
    public void testIntermediateEmptyFiles() {
        this.writeToFile("a", "a");
        this.writeToFile("b", "");
        this.writeToFile("c", "c");
        this.assertLoaderYields((Seq<Object>)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps("ac".getBytes())).toSeq());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this._loader.outOfOrderWritesDetected(), "DirectoryLoaderSuite.this._loader.outOfOrderWritesDetected", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
    }

    @Test
    public void testDetectsNewOldFiles() {
        this.writeToFile("b", "a");
        this.loadAll();
        this.writeToFile("a", "a");
        this.loadAll();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this._loader.outOfOrderWritesDetected(), "DirectoryLoaderSuite.this._loader.outOfOrderWritesDetected", Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
    }

    @Test
    public void testIgnoresNewerFiles() {
        this.writeToFile("a", "a");
        this.loadAll();
        this.writeToFile("q", "a");
        this.loadAll();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this._loader.outOfOrderWritesDetected(), "DirectoryLoaderSuite.this._loader.outOfOrderWritesDetected", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
    }

    @Test
    public void testDetectsChangingOldFiles() {
        this.writeToFile("a", "a");
        this.writeToFile("b", "a");
        this.loadAll();
        this.writeToFile("a", "c");
        this.loadAll();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this._loader.outOfOrderWritesDetected(), "DirectoryLoaderSuite.this._loader.outOfOrderWritesDetected", Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
    }

    @Test
    public void testDoesNotCrashWhenFileIsDeleted() {
        this.writeToFile("a", "a");
        this.loadAll();
        Files.delete(this._tempPath.resolve("a"));
        this.writeToFile("b", "b");
        this.assertLoaderYields((Seq<Object>)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps("b".getBytes())).toSeq());
    }

    @Test
    public void testThrowsDirectoryDeletedExceptionWhenDirectoryIsDeleted() {
        this.writeToFile("a", "a");
        this.loadAll();
        Files.delete(this._tempPath.resolve("a"));
        Files.delete(this._tempPath);
        this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.loadAll(), ClassTag$.MODULE$.apply(DirectoryLoader.DirectoryDeletedException.class), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
    }

    @Test
    public void testPathFilter() {
        this._loader = new DirectoryLoader(this._tempPath, (Function1)DirectoryLoaderSuite$ByteLoader$.MODULE$, (Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)DirectoryLoaderSuite.$anonfun$testPathFilter$1(p)));
        this.writeToFile("a", "a");
        this.writeToFile("do_not_watch_me", "b");
        this.writeToFile("c", "c");
        this.assertLoaderYields((Seq<Object>)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps("ac".getBytes())).toSeq());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this._loader.outOfOrderWritesDetected(), "DirectoryLoaderSuite.this._loader.outOfOrderWritesDetected", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
    }

    public static final /* synthetic */ void $anonfun$loadAll$1(byte x$1) {
    }

    public static final /* synthetic */ boolean $anonfun$testPathFilter$1(Path p) {
        return !((Object)p).toString().contains("do_not_watch_me");
    }

    public static class ByteLoader
    implements Loader<Object>,
    Product,
    scala.Serializable {
        private final Path path;
        public final InputStream org$platanios$tensorflow$api$io$DirectoryLoaderSuite$ByteLoader$$file;

        public Path path() {
            return this.path;
        }

        public Iterator<Object> load() {
            return new Iterator<Object>(this){
                private Option<Object> nextByte;
                private final /* synthetic */ ByteLoader $outer;

                public Iterator<Object> seq() {
                    return Iterator.seq$((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.isEmpty$((Iterator)this);
                }

                public boolean isTraversableAgain() {
                    return Iterator.isTraversableAgain$((Iterator)this);
                }

                public boolean hasDefiniteSize() {
                    return Iterator.hasDefiniteSize$((Iterator)this);
                }

                public Iterator<Object> take(int n) {
                    return Iterator.take$((Iterator)this, (int)n);
                }

                public Iterator<Object> drop(int n) {
                    return Iterator.drop$((Iterator)this, (int)n);
                }

                public Iterator<Object> slice(int from, int until) {
                    return Iterator.slice$((Iterator)this, (int)from, (int)until);
                }

                public Iterator<Object> sliceIterator(int from, int until) {
                    return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                }

                public <B> Iterator<B> map(Function1<Object, B> f) {
                    return Iterator.map$((Iterator)this, f);
                }

                public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                    return Iterator.$plus$plus$((Iterator)this, that);
                }

                public <B> Iterator<B> flatMap(Function1<Object, GenTraversableOnce<B>> f) {
                    return Iterator.flatMap$((Iterator)this, f);
                }

                public Iterator<Object> filter(Function1<Object, Object> p) {
                    return Iterator.filter$((Iterator)this, p);
                }

                public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Object, B, Object> p) {
                    return Iterator.corresponds$((Iterator)this, that, p);
                }

                public Iterator<Object> withFilter(Function1<Object, Object> p) {
                    return Iterator.withFilter$((Iterator)this, p);
                }

                public Iterator<Object> filterNot(Function1<Object, Object> p) {
                    return Iterator.filterNot$((Iterator)this, p);
                }

                public <B> Iterator<B> collect(PartialFunction<Object, B> pf) {
                    return Iterator.collect$((Iterator)this, pf);
                }

                public <B> Iterator<B> scanLeft(B z, Function2<B, Object, B> op) {
                    return Iterator.scanLeft$((Iterator)this, z, op);
                }

                public <B> Iterator<B> scanRight(B z, Function2<Object, B, B> op) {
                    return Iterator.scanRight$((Iterator)this, z, op);
                }

                public Iterator<Object> takeWhile(Function1<Object, Object> p) {
                    return Iterator.takeWhile$((Iterator)this, p);
                }

                public Tuple2<Iterator<Object>, Iterator<Object>> partition(Function1<Object, Object> p) {
                    return Iterator.partition$((Iterator)this, p);
                }

                public Tuple2<Iterator<Object>, Iterator<Object>> span(Function1<Object, Object> p) {
                    return Iterator.span$((Iterator)this, p);
                }

                public Iterator<Object> dropWhile(Function1<Object, Object> p) {
                    return Iterator.dropWhile$((Iterator)this, p);
                }

                public <B> Iterator<Tuple2<Object, B>> zip(Iterator<B> that) {
                    return Iterator.zip$((Iterator)this, that);
                }

                public <A1> Iterator<A1> padTo(int len, A1 elem) {
                    return Iterator.padTo$((Iterator)this, (int)len, elem);
                }

                public Iterator<Tuple2<Object, Object>> zipWithIndex() {
                    return Iterator.zipWithIndex$((Iterator)this);
                }

                public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                    return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                }

                public <U> void foreach(Function1<Object, U> f) {
                    Iterator.foreach$((Iterator)this, f);
                }

                public boolean forall(Function1<Object, Object> p) {
                    return Iterator.forall$((Iterator)this, p);
                }

                public boolean exists(Function1<Object, Object> p) {
                    return Iterator.exists$((Iterator)this, p);
                }

                public boolean contains(Object elem) {
                    return Iterator.contains$((Iterator)this, (Object)elem);
                }

                public Option<Object> find(Function1<Object, Object> p) {
                    return Iterator.find$((Iterator)this, p);
                }

                public int indexWhere(Function1<Object, Object> p) {
                    return Iterator.indexWhere$((Iterator)this, p);
                }

                public int indexWhere(Function1<Object, Object> p, int from) {
                    return Iterator.indexWhere$((Iterator)this, p, (int)from);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.indexOf$((Iterator)this, elem);
                }

                public <B> int indexOf(B elem, int from) {
                    return Iterator.indexOf$((Iterator)this, elem, (int)from);
                }

                public BufferedIterator<Object> buffered() {
                    return Iterator.buffered$((Iterator)this);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.grouped$((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                }

                public <B> int sliding$default$2() {
                    return Iterator.sliding$default$2$((Iterator)this);
                }

                public int length() {
                    return Iterator.length$((Iterator)this);
                }

                public Tuple2<Iterator<Object>, Iterator<Object>> duplicate() {
                    return Iterator.duplicate$((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <B> void copyToArray(Object xs, int start, int len) {
                    Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                }

                public boolean sameElements(Iterator<?> that) {
                    return Iterator.sameElements$((Iterator)this, that);
                }

                public Traversable<Object> toTraversable() {
                    return Iterator.toTraversable$((Iterator)this);
                }

                public Iterator<Object> toIterator() {
                    return Iterator.toIterator$((Iterator)this);
                }

                public Stream<Object> toStream() {
                    return Iterator.toStream$((Iterator)this);
                }

                public String toString() {
                    return Iterator.toString$((Iterator)this);
                }

                public List<Object> reversed() {
                    return TraversableOnce.reversed$((TraversableOnce)this);
                }

                public int size() {
                    return TraversableOnce.size$((TraversableOnce)this);
                }

                public boolean nonEmpty() {
                    return TraversableOnce.nonEmpty$((TraversableOnce)this);
                }

                public int count(Function1<Object, Object> p) {
                    return TraversableOnce.count$((TraversableOnce)this, p);
                }

                public <B> Option<B> collectFirst(PartialFunction<Object, B> pf) {
                    return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                }

                public <B> B $div$colon(B z, Function2<B, Object, B> op) {
                    return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                }

                public <B> B $colon$bslash(B z, Function2<Object, B, B> op) {
                    return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                }

                public <B> B foldLeft(B z, Function2<B, Object, B> op) {
                    return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                }

                public <B> B foldRight(B z, Function2<Object, B, B> op) {
                    return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                }

                public <B> B reduceLeft(Function2<B, Object, B> op) {
                    return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                }

                public <B> B reduceRight(Function2<Object, B, B> op) {
                    return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, Object, B> op) {
                    return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<Object, B, B> op) {
                    return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                }

                public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                }

                public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                    return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                }

                public <B> B aggregate(Function0<B> z, Function2<B, Object, B> seqop, Function2<B, B, B> combop) {
                    return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)TraversableOnce.product$((TraversableOnce)this, num);
                }

                public Object min(Ordering cmp) {
                    return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object max(Ordering cmp) {
                    return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object maxBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public Object minBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public <B> void copyToBuffer(Buffer<B> dest) {
                    TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                }

                public <B> void copyToArray(Object xs, int start) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                }

                public <B> void copyToArray(Object xs) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                }

                public <B> Object toArray(ClassTag<B> evidence$1) {
                    return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                }

                public List<Object> toList() {
                    return TraversableOnce.toList$((TraversableOnce)this);
                }

                public Iterable<Object> toIterable() {
                    return TraversableOnce.toIterable$((TraversableOnce)this);
                }

                public Seq<Object> toSeq() {
                    return TraversableOnce.toSeq$((TraversableOnce)this);
                }

                public IndexedSeq<Object> toIndexedSeq() {
                    return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                }

                public <B> Buffer<B> toBuffer() {
                    return TraversableOnce.toBuffer$((TraversableOnce)this);
                }

                public <B> Set<B> toSet() {
                    return TraversableOnce.toSet$((TraversableOnce)this);
                }

                public Vector<Object> toVector() {
                    return TraversableOnce.toVector$((TraversableOnce)this);
                }

                public <Col> Col to(CanBuildFrom<Nothing$, Object, Col> cbf) {
                    return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                }

                public <T, U> Map<T, U> toMap(Predef.$less$colon$less<Object, Tuple2<T, U>> ev) {
                    return TraversableOnce.toMap$((TraversableOnce)this, ev);
                }

                public String mkString(String start, String sep, String end) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                }

                public String mkString(String sep) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                }

                public String mkString() {
                    return TraversableOnce.mkString$((TraversableOnce)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public StringBuilder addString(StringBuilder b, String sep) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                }

                public StringBuilder addString(StringBuilder b) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                }

                public int sizeHintIfCheap() {
                    return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                }

                private Option<Object> readByte() {
                    None$ none$;
                    block3: {
                        try {
                            int n = this.$outer.org$platanios$tensorflow$api$io$DirectoryLoaderSuite$ByteLoader$$file.read();
                            if (n != -1) {
                                none$ = new Some((Object)BoxesRunTime.boxToByte((byte)((byte)n)));
                                break block3;
                            }
                            none$ = None$.MODULE$;
                        }
                        catch (Throwable throwable) {
                            none$ = None$.MODULE$;
                        }
                    }
                    return none$;
                }

                public boolean hasNext() {
                    block0: {
                        if (!this.nextByte.isEmpty()) break block0;
                        this.nextByte = this.readByte();
                    }
                    return this.nextByte.isDefined();
                }

                /*
                 * WARNING - void declaration
                 */
                public byte next() {
                    void var1_1;
                    if (this.nextByte.isEmpty()) {
                        this.nextByte = this.readByte();
                    }
                    byte by = BoxesRunTime.unboxToByte((Object)this.nextByte.get());
                    this.nextByte = None$.MODULE$;
                    return (byte)var1_1;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    GenTraversableOnce.$init$((GenTraversableOnce)this);
                    TraversableOnce.$init$((TraversableOnce)this);
                    Iterator.$init$((Iterator)this);
                    this.nextByte = None$.MODULE$;
                }
            };
        }

        public ByteLoader copy(Path path) {
            return new ByteLoader(path);
        }

        public Path copy$default$1() {
            return this.path();
        }

        public String productPrefix() {
            return "ByteLoader";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.path();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ByteLoader;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ByteLoader)) return false;
            boolean bl = true;
            if (!bl) return false;
            ByteLoader byteLoader = (ByteLoader)x$1;
            Path path = this.path();
            Path path2 = byteLoader.path();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!((Object)path).equals(path2)) return false;
            if (!byteLoader.canEqual(this)) return false;
            return true;
        }

        public ByteLoader(Path path) {
            this.path = path;
            Product.$init$((Product)this);
            this.org$platanios$tensorflow$api$io$DirectoryLoaderSuite$ByteLoader$$file = Files.newInputStream(path, StandardOpenOption.READ);
        }
    }
}

