/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.api.io.events;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.platanios.tensorflow.api.io.events.EventFileReader;
import org.platanios.tensorflow.api.io.events.EventFileReader$;
import org.platanios.tensorflow.proto.Event;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatestplus.junit.AssertionsForJUnit$;
import org.scalatestplus.junit.JUnitSuite;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r4A\u0001D\u0007\u00015!)1\u0005\u0001C\u0001I!1q\u0005\u0001Q\u0001\n!Ba!\r\u0001!\u0002\u0013\u0011\u0004\"B\u001d\u0001\t\u0003Q\u0004B\u0002!\u0001A\u0013%\u0011\tC\u0003T\u0001\u0011\u0005A\u000bC\u0003Z\u0001\u0011\u0005A\u000bC\u0003\\\u0001\u0011\u0005A\u000bC\u0003^\u0001\u0011\u0005A\u000bC\u0003`\u0001\u0011\u0005A\u000bC\u0003b\u0001\u0011\u0005AK\u0001\u000bFm\u0016tGOR5mKJ+\u0017\rZ3s'VLG/\u001a\u0006\u0003\u001d=\ta!\u001a<f]R\u001c(B\u0001\t\u0012\u0003\tIwN\u0003\u0002\u0013'\u0005\u0019\u0011\r]5\u000b\u0005Q)\u0012A\u0003;f]N|'O\u001a7po*\u0011acF\u0001\na2\fG/\u00198j_NT\u0011\u0001G\u0001\u0004_J<7\u0001A\n\u0003\u0001m\u0001\"\u0001H\u0011\u000e\u0003uQ!AH\u0010\u0002\u000b),h.\u001b;\u000b\u0005\u0001:\u0012!D:dC2\fG/Z:ua2,8/\u0003\u0002#;\tQ!*\u00168jiN+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005)\u0003C\u0001\u0014\u0001\u001b\u0005i\u0011A\u0002:fG>\u0014H\rE\u0002*Y9j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003S=J!\u0001\r\u0016\u0003\t\tKH/Z\u0001\f?R,W\u000e\u001d$pY\u0012,'\u000f\u0005\u00024o5\tAG\u0003\u00026m\u0005)!/\u001e7fg*\u0011adF\u0005\u0003qQ\u0012q\u0002V3na>\u0014\u0018M]=G_2$WM]\u0001\u000bi\u0016l\u0007OR8mI\u0016\u0014X#\u0001\u001a)\u0005\u0011a\u0004CA\u001f?\u001b\u00051\u0014BA 7\u0005\u0011\u0011V\u000f\\3\u0002\u0017]\u0014\u0018\u000e^3U_\u001aKG.\u001a\u000b\u0004\u0005\u0016\u000b\u0006CA\u0015D\u0013\t!%F\u0001\u0003V]&$\b\"\u0002$\u0006\u0001\u00049\u0015\u0001\u00034jY\u0016\u0004\u0016\r\u001e5\u0011\u0005!{U\"A%\u000b\u0005)[\u0015\u0001\u00024jY\u0016T!\u0001T'\u0002\u00079LwNC\u0001O\u0003\u0011Q\u0017M^1\n\u0005AK%\u0001\u0002)bi\"DQAU\u0003A\u0002!\nA\u0001Z1uC\u0006\u0011B/Z:u\u000b6\u0004H/_#wK:$h)\u001b7f)\u0005\u0011\u0005F\u0001\u0004W!\tit+\u0003\u0002Ym\t!A+Z:u\u0003=!Xm\u001d;TS:<G.Z,sSR,\u0007FA\u0004W\u0003I!Xm\u001d;Nk2$\u0018\u000e\u001d7f/JLG/Z:)\u0005!1\u0016!\u0005;fgRlU\u000f\u001c;ja2,Gj\\1eg\"\u0012\u0011BV\u0001\u0019i\u0016\u001cH/T;mi&\u0004H.Z,sSR,7/\u0011;P]\u000e,\u0007F\u0001\u0006W\u0003y!Xm\u001d;Nk2$\u0018\u000e\u001d7f/JLG/Z:XSRD')\u00193Xe&$X\r\u000b\u0002\f-\u0002")
public class EventFileReaderSuite
extends JUnitSuite {
    private final byte[] record = (byte[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{24, 0, 0, 0, 0, 0, 0, 0, 163, 127, 75, 34, 9, 0, 0, 192, 37, 221, 117, 213, 65, 26, 13, 98, 114, 97, 105, 110, 46, 69, 118, 101, 110, 116, 58, 49, 236, 243, 50, 141})).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToByte((byte)EventFileReaderSuite.$anonfun$record$1(BoxesRunTime.unboxToInt((Object)x$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
    private final TemporaryFolder _tempFolder = new TemporaryFolder();

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder;
    }

    private void writeToFile(Path filePath, byte[] data) {
        Files.write(filePath, data, StandardOpenOption.APPEND);
    }

    @Test
    public void testEmptyEventFile() {
        Path filePath = this.tempFolder().newFile().toPath();
        this.writeToFile(filePath, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
        EventFileReader reader = new EventFileReader(filePath, EventFileReader$.MODULE$.apply$default$2());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(reader.load().toSeq());
        Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.empty();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("EventFileReaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
    }

    @Test
    public void testSingleWrite() {
        Path filePath = this.tempFolder().newFile().toPath();
        this.writeToFile(filePath, this.record);
        EventFileReader reader = new EventFileReader(filePath, EventFileReader$.MODULE$.apply$default$2());
        Seq events = reader.load().toSeq();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)events.size()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("EventFileReaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)((Event)events.head()).getWallTime()));
        double $org_scalatest_assert_macro_right2 = 1.440183447E9;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("EventFileReaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
    }

    @Test
    public void testMultipleWrites() {
        Path filePath = this.tempFolder().newFile().toPath();
        this.writeToFile(filePath, this.record);
        EventFileReader reader = new EventFileReader(filePath, EventFileReader$.MODULE$.apply$default$2());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)reader.load().toSeq().size()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("EventFileReaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.writeToFile(filePath, this.record);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)reader.load().toSeq().size()));
        int $org_scalatest_assert_macro_right2 = 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("EventFileReaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
    }

    @Test
    public void testMultipleLoads() {
        Path filePath = this.tempFolder().newFile().toPath();
        this.writeToFile(filePath, this.record);
        EventFileReader reader = new EventFileReader(filePath, EventFileReader$.MODULE$.apply$default$2());
        reader.load();
        reader.load();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)reader.load().toSeq().size()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("EventFileReaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
    }

    @Test
    public void testMultipleWritesAtOnce() {
        Path filePath = this.tempFolder().newFile().toPath();
        this.writeToFile(filePath, this.record);
        this.writeToFile(filePath, this.record);
        EventFileReader reader = new EventFileReader(filePath, EventFileReader$.MODULE$.apply$default$2());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)reader.load().toSeq().size()));
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("EventFileReaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
    }

    @Test
    public void testMultipleWritesWithBadWrite() {
        Path filePath = this.tempFolder().newFile().toPath();
        this.writeToFile(filePath, this.record);
        this.writeToFile(filePath, this.record);
        this.writeToFile(filePath, (byte[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{1, 2, 3})).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToByte((byte)EventFileReaderSuite.$anonfun$testMultipleWritesWithBadWrite$1(BoxesRunTime.unboxToInt((Object)x$2))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())));
        EventFileReader reader = new EventFileReader(filePath, EventFileReader$.MODULE$.apply$default$2());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)reader.load().toSeq().size()));
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("EventFileReaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
    }

    public static final /* synthetic */ byte $anonfun$record$1(int x$1) {
        return (byte)x$1;
    }

    public static final /* synthetic */ byte $anonfun$testMultipleWritesWithBadWrite$1(int x$2) {
        return (byte)x$2;
    }
}

