/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.api.io;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.platanios.tensorflow.api.io.DirectoryLoader;
import org.platanios.tensorflow.api.io.DirectoryLoader$;
import org.platanios.tensorflow.api.io.DirectoryLoaderSuite$ByteLoader$;
import org.platanios.tensorflow.api.io.Loader;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatestplus.junit.AssertionsForJUnit$;
import org.scalatestplus.junit.JUnitSuite;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tec\u0001B\u001a5\u0001}BQ\u0001\u0013\u0001\u0005\u0002%C\u0011\u0002\u0014\u0001A\u0002\u0003\u0005\u000b\u0015B'\t\u0013]\u0003\u0001\u0019!A!B\u0013A\u0006BB1\u0001A\u0003%!\rC\u0003j\u0001\u0011\u0005!\u000eC\u0003q\u0001\u0011\u0005\u0011\u000f\u0003\u0004z\u0001\u0001&IA\u001f\u0005\b\u0003+\u0001\u0001\u0015\"\u0003r\u0011!\t9\u0002\u0001Q\u0005\n\u0005e\u0001BBA\u0019\u0001\u0011\u0005\u0011\u000f\u0003\u0004\u0002<\u0001!\t!\u001d\u0005\u0007\u0003\u007f\u0001A\u0011A9\t\r\u0005\r\u0003\u0001\"\u0001r\u0011\u0019\t9\u0005\u0001C\u0001c\"1\u00111\n\u0001\u0005\u0002EDa!a\u0014\u0001\t\u0003\t\bBBA*\u0001\u0011\u0005\u0011\u000f\u0003\u0004\u0002X\u0001!\t!\u001d\u0005\u0007\u00037\u0002A\u0011A9\t\r\u0005}\u0003\u0001\"\u0001r\u0011\u0019\t\u0019\u0007\u0001C\u0001c\"1\u0011q\r\u0001\u0005\u0002E<q!a\u001b5\u0011\u0003\tiG\u0002\u00044i!\u0005\u0011q\u000e\u0005\u0007\u0011b!\t!!!\u0007\u000f\u0005\r\u0005\u0004\u0011\r\u0002\u0006\"Q\u0011q\u0013\u000e\u0003\u0016\u0004%\t!!'\t\u0013\u0005m%D!E!\u0002\u0013i\u0005B\u0002%\u001b\t\u0003\ti\nC\u0004Q5\u0001\u0006I!!*\t\u000f\u0005-&\u0004\"\u0011\u0002.\"I\u0011Q\u0017\u000e\u0002\u0002\u0013\u0005\u0011q\u0017\u0005\n\u0003wS\u0012\u0013!C\u0001\u0003{C\u0011\"a5\u001b\u0003\u0003%\t%!6\t\u0013\u0005\u0005($!A\u0005\u0002\u0005\r\b\"CAv5\u0005\u0005I\u0011AAw\u0011%\tIPGA\u0001\n\u0003\nY\u0010C\u0005\u0003\bi\t\t\u0011\"\u0001\u0003\n!I!1\u0003\u000e\u0002\u0002\u0013\u0005#Q\u0003\u0005\n\u00053Q\u0012\u0011!C!\u00057A\u0011B!\b\u001b\u0003\u0003%\tEa\b\t\u0013\t\u0005\"$!A\u0005B\t\rrA\u0003B\u00141\u0005\u0005\t\u0012\u0001\r\u0003*\u0019Q\u00111\u0011\r\u0002\u0002#\u0005\u0001Da\u000b\t\r!cC\u0011\u0001B\u001d\u0011%\u0011i\u0002LA\u0001\n\u000b\u0012y\u0002C\u0005\u0003<1\n\t\u0011\"!\u0003>!I!\u0011\t\u0017\u0002\u0002\u0013\u0005%1\t\u0005\n\u0005\u001fb\u0013\u0011!C\u0005\u0005#B\u0011Ba\u0014\u0019\u0003\u0003%IA!\u0015\u0003)\u0011K'/Z2u_JLHj\\1eKJ\u001cV/\u001b;f\u0015\t)d'\u0001\u0002j_*\u0011q\u0007O\u0001\u0004CBL'BA\u001d;\u0003)!XM\\:pe\u001adwn\u001e\u0006\u0003wq\n\u0011\u0002\u001d7bi\u0006t\u0017n\\:\u000b\u0003u\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001!\u0011\u0005\u00053U\"\u0001\"\u000b\u0005\r#\u0015!\u00026v]&$(BA#=\u00035\u00198-\u00197bi\u0016\u001cH\u000f\u001d7vg&\u0011qI\u0011\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001K!\tY\u0005!D\u00015\u0003%yF/Z7q!\u0006$\b\u000e\u0005\u0002O+6\tqJ\u0003\u0002Q#\u0006!a-\u001b7f\u0015\t\u00116+A\u0002oS>T\u0011\u0001V\u0001\u0005U\u00064\u0018-\u0003\u0002W\u001f\n!\u0001+\u0019;i\u0003\u001dyFn\\1eKJ\u00042aS-\\\u0013\tQFGA\bESJ,7\r^8ss2{\u0017\rZ3s!\tav,D\u0001^\u0015\u0005q\u0016!B:dC2\f\u0017B\u00011^\u0005\u0011\u0011\u0015\u0010^3\u0002\u0017}#X-\u001c9G_2$WM\u001d\t\u0003G\u001el\u0011\u0001\u001a\u0006\u0003K\u001a\fQA];mKNT!a\u0011\u001f\n\u0005!$'a\u0004+f[B|'/\u0019:z\r>dG-\u001a:\u0002\u0015Q,W\u000e\u001d$pY\u0012,'/F\u0001cQ\t)A\u000e\u0005\u0002n]6\ta-\u0003\u0002pM\n!!+\u001e7f\u0003\u0015\u0019X\r^+q)\u0005\u0011\bC\u0001/t\u0013\t!XL\u0001\u0003V]&$\bF\u0001\u0004w!\tiw/\u0003\u0002yM\n1!)\u001a4pe\u0016\f1b\u001e:ji\u0016$vNR5mKR!!o_A\t\u0011\u0015ax\u00011\u0001~\u0003!1\u0017\u000e\\3oC6,\u0007c\u0001@\u0002\f9\u0019q0a\u0002\u0011\u0007\u0005\u0005Q,\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001 \u0002\rq\u0012xn\u001c;?\u0013\r\tI!X\u0001\u0007!J,G-\u001a4\n\t\u00055\u0011q\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%Q\f\u0003\u0004\u0002\u0014\u001d\u0001\r!`\u0001\bG>tG/\u001a8u\u0003\u001daw.\u00193BY2\f!#Y:tKJ$Hj\\1eKJL\u0016.\u001a7egR\u0019!/a\u0007\t\u000f\u0005u\u0011\u00021\u0001\u0002 \u00051a/\u00197vKN\u0004R!!\t\u0002,msA!a\t\u0002(9!\u0011\u0011AA\u0013\u0013\u0005q\u0016bAA\u0015;\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0017\u0003_\u00111aU3r\u0015\r\tI#X\u0001\u0013i\u0016\u001cH/R7qif$\u0015N]3di>\u0014\u0018\u0010K\u0002\u000b\u0003k\u00012!\\A\u001c\u0013\r\tID\u001a\u0002\u0005)\u0016\u001cH/A\buKN$8+\u001b8hY\u0016<&/\u001b;fQ\rY\u0011QG\u0001\u0013i\u0016\u001cH/T;mi&\u0004H.Z,sSR,7\u000fK\u0002\r\u0003k\t\u0011\u0003^3ti6+H\u000e^5qY\u0016du.\u00193tQ\ri\u0011QG\u0001\u0018i\u0016\u001cH/T;mi&\u0004H.\u001a$jY\u0016\u001c\u0018\t^(oG\u0016D3ADA\u001b\u00035\"Xm\u001d;GS:L7\u000f[3t\u0019>\fG-\u001b8h\r&dWm\u00165f]N;\u0018\u000e^2iS:<Gk\u001c(fo\u001aKG.\u001a\u0015\u0004\u001f\u0005U\u0012A\u0007;fgRLe\u000e^3s[\u0016$\u0017.\u0019;f\u000b6\u0004H/\u001f$jY\u0016\u001c\bf\u0001\t\u00026\u00051B/Z:u\t\u0016$Xm\u0019;t\u001d\u0016<x\n\u001c3GS2,7\u000fK\u0002\u0012\u0003k\tQ\u0003^3ti&;gn\u001c:fg:+w/\u001a:GS2,7\u000fK\u0002\u0013\u0003k\t1\u0004^3ti\u0012+G/Z2ug\u000eC\u0017M\\4j]\u001e|E\u000e\u001a$jY\u0016\u001c\bfA\n\u00026\u0005\tC/Z:u\t>,7OT8u\u0007J\f7\u000f[,iK:4\u0015\u000e\\3Jg\u0012+G.\u001a;fI\"\u001aA#!\u000e\u0002sQ,7\u000f\u001e+ie><8\u000fR5sK\u000e$xN]=EK2,G/\u001a3Fq\u000e,\u0007\u000f^5p]^CWM\u001c#je\u0016\u001cGo\u001c:z\u0013N$U\r\\3uK\u0012D3!FA\u001b\u00039!Xm\u001d;QCRDg)\u001b7uKJD3AFA\u001b\u0003Q!\u0015N]3di>\u0014\u0018\u0010T8bI\u0016\u00148+^5uKB\u00111\nG\n\u00061\u0005E\u0014q\u000f\t\u00049\u0006M\u0014bAA;;\n1\u0011I\\=SK\u001a\u0004B!!\u001f\u0002~5\u0011\u00111\u0010\u0006\u0003kMKA!a \u0002|\ta1+\u001a:jC2L'0\u00192mKR\u0011\u0011Q\u000e\u0002\u000b\u0005f$X\rT8bI\u0016\u00148#\u0003\u000e\u0002r\u0005\u001d\u0015QRAJ!\u0011Y\u0015\u0011R.\n\u0007\u0005-EG\u0001\u0004M_\u0006$WM\u001d\t\u00049\u0006=\u0015bAAI;\n9\u0001K]8ek\u000e$\b\u0003BA\u0011\u0003+KA!a \u00020\u0005!\u0001/\u0019;i+\u0005i\u0015!\u00029bi\"\u0004C\u0003BAP\u0003G\u00032!!)\u001b\u001b\u0005A\u0002BBAL;\u0001\u0007Q\n\u0005\u0003\u0002z\u0005\u001d\u0016\u0002BAU\u0003w\u00121\"\u00138qkR\u001cFO]3b[\u0006!An\\1e)\t\ty\u000bE\u0003\u0002\"\u0005E6,\u0003\u0003\u00024\u0006=\"\u0001C%uKJ\fGo\u001c:\u0002\t\r|\u0007/\u001f\u000b\u0005\u0003?\u000bI\f\u0003\u0005\u0002\u0018\u0002\u0002\n\u00111\u0001N\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a0+\u00075\u000b\tm\u000b\u0002\u0002DB!\u0011QYAh\u001b\t\t9M\u0003\u0003\u0002J\u0006-\u0017!C;oG\",7m[3e\u0015\r\ti-X\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAi\u0003\u000f\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u001b\t\u0005\u00033\fy.\u0004\u0002\u0002\\*\u0019\u0011Q\\*\u0002\t1\fgnZ\u0005\u0005\u0003\u001b\tY.\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002fB\u0019A,a:\n\u0007\u0005%XLA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002p\u0006U\bc\u0001/\u0002r&\u0019\u00111_/\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002x\u0012\n\t\u00111\u0001\u0002f\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!@\u0011\r\u0005}(QAAx\u001b\t\u0011\tAC\u0002\u0003\u0004u\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019L!\u0001\u0002\u0011\r\fg.R9vC2$BAa\u0003\u0003\u0012A\u0019AL!\u0004\n\u0007\t=QLA\u0004C_>dW-\u00198\t\u0013\u0005]h%!AA\u0002\u0005=\u0018A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a6\u0003\u0018!I\u0011q_\u0014\u0002\u0002\u0003\u0007\u0011Q]\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011Q]\u0001\ti>\u001cFO]5oOR\u0011\u0011q[\u0001\u0007KF,\u0018\r\\:\u0015\t\t-!Q\u0005\u0005\n\u0003oT\u0013\u0011!a\u0001\u0003_\f!BQ=uK2{\u0017\rZ3s!\r\t\t\u000bL\n\u0006Y\t5\u0012q\u000f\t\b\u0005_\u0011)$TAP\u001b\t\u0011\tDC\u0002\u00034u\u000bqA];oi&lW-\u0003\u0003\u00038\tE\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011!\u0011F\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0003?\u0013y\u0004\u0003\u0004\u0002\u0018>\u0002\r!T\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011)Ea\u0013\u0011\tq\u00139%T\u0005\u0004\u0005\u0013j&AB(qi&|g\u000eC\u0005\u0003NA\n\t\u00111\u0001\u0002 \u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tM\u0003\u0003BAm\u0005+JAAa\u0016\u0002\\\n1qJ\u00196fGR\u0004")
public class DirectoryLoaderSuite
extends JUnitSuite {
    private Path _tempPath;
    private DirectoryLoader<Object> _loader;
    private final TemporaryFolder _tempFolder = new TemporaryFolder();

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder;
    }

    @Before
    public void setUp() {
        this._tempPath = this.tempFolder().newFolder().toPath();
        this._loader = new DirectoryLoader(this._tempPath, (Function1)DirectoryLoaderSuite$ByteLoader$.MODULE$, DirectoryLoader$.MODULE$.apply$default$3());
    }

    private void writeToFile(String filename, String content) {
        Files.write(this._tempPath.resolve(filename), content.getBytes(Charset.forName("UTF-8")), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
    }

    private void loadAll() {
        this._loader.load().foreach((Function1 & Serializable)x$3 -> {
            DirectoryLoaderSuite.$anonfun$loadAll$1(BoxesRunTime.unboxToByte((Object)x$3));
            return BoxedUnit.UNIT;
        });
    }

    private void assertLoaderYields(Seq<Object> values) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this._loader.load().toSeq());
        Seq<Object> $org_scalatest_assert_macro_right = values;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
    }

    @Test
    public void testEmptyDirectory() {
        this.assertLoaderYields((Seq<Object>)((Seq)Seq$.MODULE$.empty()));
    }

    @Test
    public void testSingleWrite() {
        this.writeToFile("a", "abc");
        this.assertLoaderYields((Seq<Object>)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.byteArrayOps("abc".getBytes())));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this._loader.outOfOrderWritesDetected(), "DirectoryLoaderSuite.this._loader.outOfOrderWritesDetected", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
    }

    @Test
    public void testMultipleWrites() {
        this.writeToFile("a", "abc");
        this.assertLoaderYields((Seq<Object>)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.byteArrayOps("abc".getBytes())));
        this.writeToFile("a", "xyz");
        this.assertLoaderYields((Seq<Object>)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.byteArrayOps("xyz".getBytes())));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this._loader.outOfOrderWritesDetected(), "DirectoryLoaderSuite.this._loader.outOfOrderWritesDetected", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
    }

    @Test
    public void testMultipleLoads() {
        this.writeToFile("a", "a");
        this._loader.load();
        this._loader.load();
        this.assertLoaderYields((Seq<Object>)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.byteArrayOps("a".getBytes())));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this._loader.outOfOrderWritesDetected(), "DirectoryLoaderSuite.this._loader.outOfOrderWritesDetected", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
    }

    @Test
    public void testMultipleFilesAtOnce() {
        this.writeToFile("b", "b");
        this.writeToFile("a", "a");
        this.assertLoaderYields((Seq<Object>)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.byteArrayOps("ab".getBytes())));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this._loader.outOfOrderWritesDetected(), "DirectoryLoaderSuite.this._loader.outOfOrderWritesDetected", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
    }

    @Test
    public void testFinishesLoadingFileWhenSwitchingToNewFile() {
        this.writeToFile("a", "a");
        this.assertLoaderYields((Seq<Object>)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.byteArrayOps("a".getBytes())));
        this.writeToFile("a", "b");
        this.writeToFile("b", "c");
        this.assertLoaderYields((Seq<Object>)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.byteArrayOps("bc".getBytes())));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this._loader.outOfOrderWritesDetected(), "DirectoryLoaderSuite.this._loader.outOfOrderWritesDetected", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
    }

    @Test
    public void testIntermediateEmptyFiles() {
        this.writeToFile("a", "a");
        this.writeToFile("b", "");
        this.writeToFile("c", "c");
        this.assertLoaderYields((Seq<Object>)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.byteArrayOps("ac".getBytes())));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this._loader.outOfOrderWritesDetected(), "DirectoryLoaderSuite.this._loader.outOfOrderWritesDetected", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
    }

    @Test
    public void testDetectsNewOldFiles() {
        this.writeToFile("b", "a");
        this.loadAll();
        this.writeToFile("a", "a");
        this.loadAll();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this._loader.outOfOrderWritesDetected(), "DirectoryLoaderSuite.this._loader.outOfOrderWritesDetected", Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
    }

    @Test
    public void testIgnoresNewerFiles() {
        this.writeToFile("a", "a");
        this.loadAll();
        this.writeToFile("q", "a");
        this.loadAll();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this._loader.outOfOrderWritesDetected(), "DirectoryLoaderSuite.this._loader.outOfOrderWritesDetected", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
    }

    @Test
    public void testDetectsChangingOldFiles() {
        this.writeToFile("a", "a");
        this.writeToFile("b", "a");
        this.loadAll();
        this.writeToFile("a", "c");
        this.loadAll();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this._loader.outOfOrderWritesDetected(), "DirectoryLoaderSuite.this._loader.outOfOrderWritesDetected", Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
    }

    @Test
    public void testDoesNotCrashWhenFileIsDeleted() {
        this.writeToFile("a", "a");
        this.loadAll();
        Files.delete(this._tempPath.resolve("a"));
        this.writeToFile("b", "b");
        this.assertLoaderYields((Seq<Object>)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.byteArrayOps("b".getBytes())));
    }

    @Test
    public void testThrowsDirectoryDeletedExceptionWhenDirectoryIsDeleted() {
        this.writeToFile("a", "a");
        this.loadAll();
        Files.delete(this._tempPath.resolve("a"));
        Files.delete(this._tempPath);
        this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.loadAll(), ClassTag$.MODULE$.apply(DirectoryLoader.DirectoryDeletedException.class), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
    }

    @Test
    public void testPathFilter() {
        this._loader = new DirectoryLoader(this._tempPath, (Function1)DirectoryLoaderSuite$ByteLoader$.MODULE$, (Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)DirectoryLoaderSuite.$anonfun$testPathFilter$1(p)));
        this.writeToFile("a", "a");
        this.writeToFile("do_not_watch_me", "b");
        this.writeToFile("c", "c");
        this.assertLoaderYields((Seq<Object>)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.byteArrayOps("ac".getBytes())));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this._loader.outOfOrderWritesDetected(), "DirectoryLoaderSuite.this._loader.outOfOrderWritesDetected", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DirectoryLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
    }

    public static final /* synthetic */ void $anonfun$loadAll$1(byte x$3) {
    }

    public static final /* synthetic */ boolean $anonfun$testPathFilter$1(Path p) {
        return !((Object)p).toString().contains("do_not_watch_me");
    }

    public static class ByteLoader
    implements Loader<Object>,
    Product,
    Serializable {
        private final Path path;
        public final InputStream org$platanios$tensorflow$api$io$DirectoryLoaderSuite$ByteLoader$$file;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Path path() {
            return this.path;
        }

        public Iterator<Object> load() {
            return new Iterator<Object>(this){
                private Option<Object> nextByte;
                private final /* synthetic */ ByteLoader $outer;

                public final boolean hasDefiniteSize() {
                    return Iterator.hasDefiniteSize$((Iterator)this);
                }

                public final Iterator<Object> iterator() {
                    return Iterator.iterator$((Iterator)this);
                }

                public Option<Object> nextOption() {
                    return Iterator.nextOption$((Iterator)this);
                }

                public boolean contains(Object elem) {
                    return Iterator.contains$((Iterator)this, (Object)elem);
                }

                public BufferedIterator<Object> buffered() {
                    return Iterator.buffered$((Iterator)this);
                }

                public <B> Iterator<B> padTo(int len, B elem) {
                    return Iterator.padTo$((Iterator)this, (int)len, elem);
                }

                public Tuple2<Iterator<Object>, Iterator<Object>> partition(Function1<Object, Object> p) {
                    return Iterator.partition$((Iterator)this, p);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.grouped$((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                }

                public <B> int sliding$default$2() {
                    return Iterator.sliding$default$2$((Iterator)this);
                }

                public <B> Iterator<B> scanLeft(B z, Function2<B, Object, B> op) {
                    return Iterator.scanLeft$((Iterator)this, z, op);
                }

                public <B> Iterator<B> scanRight(B z, Function2<Object, B, B> op) {
                    return Iterator.scanRight$((Iterator)this, z, op);
                }

                public int indexWhere(Function1<Object, Object> p, int from) {
                    return Iterator.indexWhere$((Iterator)this, p, (int)from);
                }

                public int indexWhere$default$2() {
                    return Iterator.indexWhere$default$2$((Iterator)this);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.indexOf$((Iterator)this, elem);
                }

                public <B> int indexOf(B elem, int from) {
                    return Iterator.indexOf$((Iterator)this, elem, (int)from);
                }

                public final int length() {
                    return Iterator.length$((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.isEmpty$((Iterator)this);
                }

                public Iterator<Object> filter(Function1<Object, Object> p) {
                    return Iterator.filter$((Iterator)this, p);
                }

                public Iterator<Object> filterNot(Function1<Object, Object> p) {
                    return Iterator.filterNot$((Iterator)this, p);
                }

                public Iterator<Object> filterImpl(Function1<Object, Object> p, boolean isFlipped) {
                    return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
                }

                public Iterator<Object> withFilter(Function1<Object, Object> p) {
                    return Iterator.withFilter$((Iterator)this, p);
                }

                public <B> Iterator<B> collect(PartialFunction<Object, B> pf) {
                    return Iterator.collect$((Iterator)this, pf);
                }

                public Iterator<Object> distinct() {
                    return Iterator.distinct$((Iterator)this);
                }

                public <B> Iterator<Object> distinctBy(Function1<Object, B> f) {
                    return Iterator.distinctBy$((Iterator)this, f);
                }

                public <B> Iterator<B> map(Function1<Object, B> f) {
                    return Iterator.map$((Iterator)this, f);
                }

                public <B> Iterator<B> flatMap(Function1<Object, IterableOnce<B>> f) {
                    return Iterator.flatMap$((Iterator)this, f);
                }

                public <B> Iterator<B> flatten(Function1<Object, IterableOnce<B>> ev) {
                    return Iterator.flatten$((Iterator)this, ev);
                }

                public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                    return Iterator.concat$((Iterator)this, xs);
                }

                public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                    return Iterator.$plus$plus$((Iterator)this, xs);
                }

                public Iterator<Object> take(int n) {
                    return Iterator.take$((Iterator)this, (int)n);
                }

                public Iterator<Object> takeWhile(Function1<Object, Object> p) {
                    return Iterator.takeWhile$((Iterator)this, p);
                }

                public Iterator<Object> drop(int n) {
                    return Iterator.drop$((Iterator)this, (int)n);
                }

                public Iterator<Object> dropWhile(Function1<Object, Object> p) {
                    return Iterator.dropWhile$((Iterator)this, p);
                }

                public Tuple2<Iterator<Object>, Iterator<Object>> span(Function1<Object, Object> p) {
                    return Iterator.span$((Iterator)this, p);
                }

                public Iterator<Object> slice(int from, int until) {
                    return Iterator.slice$((Iterator)this, (int)from, (int)until);
                }

                public Iterator<Object> sliceIterator(int from, int until) {
                    return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                }

                public <B> Iterator<Tuple2<Object, B>> zip(IterableOnce<B> that) {
                    return Iterator.zip$((Iterator)this, that);
                }

                public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                    return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                }

                public Iterator<Tuple2<Object, Object>> zipWithIndex() {
                    return Iterator.zipWithIndex$((Iterator)this);
                }

                public <B> boolean sameElements(IterableOnce<B> that) {
                    return Iterator.sameElements$((Iterator)this, that);
                }

                public Tuple2<Iterator<Object>, Iterator<Object>> duplicate() {
                    return Iterator.duplicate$((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <U> Iterator<Object> tapEach(Function1<Object, U> f) {
                    return Iterator.tapEach$((Iterator)this, f);
                }

                public String toString() {
                    return Iterator.toString$((Iterator)this);
                }

                public Iterator<Object> seq() {
                    return Iterator.seq$((Iterator)this);
                }

                public Tuple2<Iterator<Object>, Iterator<Object>> splitAt(int n) {
                    return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
                }

                public boolean isTraversableAgain() {
                    return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
                }

                public <U> void foreach(Function1<Object, U> f) {
                    IterableOnceOps.foreach$((IterableOnceOps)this, f);
                }

                public boolean forall(Function1<Object, Object> p) {
                    return IterableOnceOps.forall$((IterableOnceOps)this, p);
                }

                public boolean exists(Function1<Object, Object> p) {
                    return IterableOnceOps.exists$((IterableOnceOps)this, p);
                }

                public int count(Function1<Object, Object> p) {
                    return IterableOnceOps.count$((IterableOnceOps)this, p);
                }

                public Option<Object> find(Function1<Object, Object> p) {
                    return IterableOnceOps.find$((IterableOnceOps)this, p);
                }

                public <B> B foldLeft(B z, Function2<B, Object, B> op) {
                    return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
                }

                public <B> B foldRight(B z, Function2<Object, B, B> op) {
                    return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
                }

                public final <B> B $div$colon(B z, Function2<B, Object, B> op) {
                    return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
                }

                public final <B> B $colon$bslash(B z, Function2<Object, B, B> op) {
                    return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
                }

                public <B> B reduce(Function2<B, B, B> op) {
                    return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                    return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
                }

                public <B> B reduceLeft(Function2<B, Object, B> op) {
                    return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
                }

                public <B> B reduceRight(Function2<Object, B, B> op) {
                    return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, Object, B> op) {
                    return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<Object, B, B> op) {
                    return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
                }

                public boolean nonEmpty() {
                    return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
                }

                public int size() {
                    return IterableOnceOps.size$((IterableOnceOps)this);
                }

                public final <B> void copyToBuffer(Buffer<B> dest) {
                    IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
                }

                public <B> int copyToArray(Object xs) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
                }

                public <B> int copyToArray(Object xs, int start) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
                }

                public <B> int copyToArray(Object xs, int start, int len) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
                }

                public Object min(Ordering ord) {
                    return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
                }

                public <B> Option<Object> minOption(Ordering<B> ord) {
                    return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
                }

                public Object max(Ordering ord) {
                    return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
                }

                public <B> Option<Object> maxOption(Ordering<B> ord) {
                    return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
                }

                public Object maxBy(Function1 f, Ordering cmp) {
                    return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
                }

                public <B> Option<Object> maxByOption(Function1<Object, B> f, Ordering<B> cmp) {
                    return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
                }

                public Object minBy(Function1 f, Ordering cmp) {
                    return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
                }

                public <B> Option<Object> minByOption(Function1<Object, B> f, Ordering<B> cmp) {
                    return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
                }

                public <B> Option<B> collectFirst(PartialFunction<Object, B> pf) {
                    return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
                }

                public <B> B aggregate(Function0<B> z, Function2<B, Object, B> seqop, Function2<B, B, B> combop) {
                    return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
                }

                public <B> boolean corresponds(IterableOnce<B> that, Function2<Object, B, Object> p) {
                    return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
                }

                public final String mkString(String start, String sep, String end) {
                    return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
                }

                public final String mkString(String sep) {
                    return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
                }

                public final String mkString() {
                    return IterableOnceOps.mkString$((IterableOnceOps)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public final StringBuilder addString(StringBuilder b, String sep) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
                }

                public final StringBuilder addString(StringBuilder b) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
                }

                public <C1> C1 to(Factory<Object, C1> factory) {
                    return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
                }

                public final Iterator<Object> toIterator() {
                    return IterableOnceOps.toIterator$((IterableOnceOps)this);
                }

                public List<Object> toList() {
                    return IterableOnceOps.toList$((IterableOnceOps)this);
                }

                public Vector<Object> toVector() {
                    return IterableOnceOps.toVector$((IterableOnceOps)this);
                }

                public <K, V> Map<K, V> toMap(.less.colon.less<Object, Tuple2<K, V>> ev) {
                    return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
                }

                public <B> Set<B> toSet() {
                    return IterableOnceOps.toSet$((IterableOnceOps)this);
                }

                public Seq<Object> toSeq() {
                    return IterableOnceOps.toSeq$((IterableOnceOps)this);
                }

                public IndexedSeq<Object> toIndexedSeq() {
                    return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
                }

                public final Stream<Object> toStream() {
                    return IterableOnceOps.toStream$((IterableOnceOps)this);
                }

                public final <B> Buffer<B> toBuffer() {
                    return IterableOnceOps.toBuffer$((IterableOnceOps)this);
                }

                public <B> Object toArray(ClassTag<B> evidence$2) {
                    return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
                }

                public Iterable<Object> reversed() {
                    return IterableOnceOps.reversed$((IterableOnceOps)this);
                }

                public <S extends Stepper<?>> S stepper(StepperShape<Object, S> shape) {
                    return (S)IterableOnce.stepper$((IterableOnce)this, shape);
                }

                public int knownSize() {
                    return IterableOnce.knownSize$((IterableOnce)this);
                }

                private Option<Object> readByte() {
                    None$ none$;
                    block3: {
                        try {
                            int n = this.$outer.org$platanios$tensorflow$api$io$DirectoryLoaderSuite$ByteLoader$$file.read();
                            if (n != -1) {
                                none$ = new Some((Object)BoxesRunTime.boxToByte((byte)((byte)n)));
                                break block3;
                            }
                            none$ = None$.MODULE$;
                        }
                        catch (Throwable throwable) {
                            none$ = None$.MODULE$;
                        }
                    }
                    return none$;
                }

                public boolean hasNext() {
                    block0: {
                        if (!this.nextByte.isEmpty()) break block0;
                        this.nextByte = this.readByte();
                    }
                    return this.nextByte.isDefined();
                }

                /*
                 * WARNING - void declaration
                 */
                public byte next() {
                    void var1_1;
                    if (this.nextByte.isEmpty()) {
                        this.nextByte = this.readByte();
                    }
                    byte by = BoxesRunTime.unboxToByte((Object)this.nextByte.get());
                    this.nextByte = None$.MODULE$;
                    return (byte)var1_1;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    IterableOnce.$init$((IterableOnce)this);
                    IterableOnceOps.$init$((IterableOnceOps)this);
                    Iterator.$init$((Iterator)this);
                    this.nextByte = None$.MODULE$;
                }
            };
        }

        public ByteLoader copy(Path path) {
            return new ByteLoader(path);
        }

        public Path copy$default$1() {
            return this.path();
        }

        public String productPrefix() {
            return "ByteLoader";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.path();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ByteLoader;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "path";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ByteLoader)) return false;
            boolean bl = true;
            if (!bl) return false;
            ByteLoader byteLoader = (ByteLoader)x$1;
            Path path = this.path();
            Path path2 = byteLoader.path();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!((Object)path).equals(path2)) return false;
            if (!byteLoader.canEqual(this)) return false;
            return true;
        }

        public ByteLoader(Path path) {
            this.path = path;
            Product.$init$((Product)this);
            this.org$platanios$tensorflow$api$io$DirectoryLoaderSuite$ByteLoader$$file = Files.newInputStream(path, StandardOpenOption.READ);
        }
    }
}

