/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.api.utilities;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.junit.Test;
import org.platanios.tensorflow.api.utilities.Reservoir;
import org.platanios.tensorflow.api.utilities.Reservoir$;
import org.platanios.tensorflow.api.utilities.ReservoirBucket;
import org.platanios.tensorflow.api.utilities.ReservoirBucket$;
import org.platanios.tensorflow.api.utilities.ReservoirSuite;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.compatible.Assertion;
import org.scalatestplus.junit.AssertionsForJUnit$;
import org.scalatestplus.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\r4AAF\f\u0001E!)1\u0006\u0001C\u0001Y!)q\u0006\u0001C\u0001a!)Q\b\u0001C\u0001a!)q\b\u0001C\u0001a!)\u0011\t\u0001C\u0001a!)1\t\u0001C\u0001a!)Q\t\u0001C\u0001a!)q\t\u0001C\u0001a!)\u0011\n\u0001C\u0001a!)1\n\u0001C\u0001a!)Q\n\u0001C\u0001a!)q\n\u0001C\u0001a!)\u0011\u000b\u0001C\u0001a!)1\u000b\u0001C\u0001a!)Q\u000b\u0001C\u0001a!)q\u000b\u0001C\u0001a!)\u0011\f\u0001C\u0001a!)1\f\u0001C\u0001a!)Q\f\u0001C\u0001a!)q\f\u0001C\u0001a!)\u0011\r\u0001C\u0001a\tq!+Z:feZ|\u0017N]*vSR,'B\u0001\r\u001a\u0003%)H/\u001b7ji&,7O\u0003\u0002\u001b7\u0005\u0019\u0011\r]5\u000b\u0005qi\u0012A\u0003;f]N|'O\u001a7po*\u0011adH\u0001\na2\fG/\u00198j_NT\u0011\u0001I\u0001\u0004_J<7\u0001A\n\u0003\u0001\r\u0002\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\u000b),h.\u001b;\u000b\u0005!z\u0012!D:dC2\fG/Z:ua2,8/\u0003\u0002+K\tQ!*\u00168jiN+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005i\u0003C\u0001\u0018\u0001\u001b\u00059\u0012A\u0005;fgR,U\u000e\u001d;z%\u0016\u001cXM\u001d<pSJ$\u0012!\r\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0005+:LG\u000f\u000b\u0002\u0003qA\u0011\u0011hO\u0007\u0002u)\u0011aeH\u0005\u0003yi\u0012A\u0001V3ti\u0006IB/Z:u%\u0016\u001cXM\u001d<pSJ\u0014Vm\u001d9fGR\u001c8+\u001b>fQ\t\u0019\u0001(A\ruKN$(+Z:feZ|\u0017N]%uK6\u001c\u0018I\u001c3LKf\u001c\bF\u0001\u00039\u0003]!Xm\u001d;SKN,'O^8je\u0016C8-\u001a9uS>t7\u000f\u000b\u0002\u0006q\u0005AB/Z:u%\u0016\u001cXM\u001d<pSJ$U\r^3s[&t\u0017n]7)\u0005\u0019A\u0014A\b;fgR\u0014Vm]3sm>L'OQ;dW\u0016$H)\u001a;fe6Lg.[:nQ\t9\u0001(A\u000buKN$(+Z:feZ|\u0017N]+tKN\u001cV-\u001a3)\u0005!A\u0014!\b;fgR\u0014Vm]3sm>L'OR5mi\u0016\u0014\u0018\n^3ng\nK8*Z=)\u0005%A\u0014\u0001\u0007;fgR,U\u000e\u001d;z%\u0016\u001cXM\u001d<pSJ\u0014UoY6fi\"\u0012!\u0002O\u0001\u001ei\u0016\u001cHOU3tKJ4x.\u001b:Ck\u000e\\W\r\u001e$jY2$vnU5{K\"\u00121\u0002O\u0001#i\u0016\u001cHOU3tKJ4x.\u001b:Ck\u000e\\W\r\u001e#pKNtu\u000e^(wKJ4\u0017\u000e\u001c7)\u00051A\u0014!\t;fgR\u0014Vm]3sm>L'OQ;dW\u0016$X*Y5oi\u0006Lgn](sI\u0016\u0014\bFA\u00079\u0003\u0001\"Xm\u001d;SKN,'O^8je\n+8m[3u\u0017\u0016,\u0007o\u001d'bgRLE/Z7)\u00059A\u0014a\b;fgR\u0014Vm]3sm>L'OQ;dW\u0016$x+\u001b;i\u001b\u0006D8+\u001b>fc!\u0012q\u0002O\u0001 i\u0016\u001cHOU3tKJ4x.\u001b:Ck\u000e\\W\r^,ji\"l\u0015\r_*ju\u0016\u0004\u0004F\u0001\t9\u0003\u0015\"Xm\u001d;SKN,'O^8je\n+8m[3u\u001b\u0006D8+\u001b>f%\u0016\fX/\u001b:f[\u0016tG\u000f\u000b\u0002\u0012q\u0005qB/Z:u%\u0016\u001cXM\u001d<pSJ\u0014UoY6fi\u001aKG\u000e^3s\u0013R,Wn\u001d\u0015\u0003%a\n1\u0007^3tiJ+7/\u001a:w_&\u0014()^2lKR\u0014V-\\8wKNLE/Z7t/\",g.\u0013;f[N\f%/\u001a*fa2\f7-\u001a3)\u0005MA\u0014A\u000f;fgR\u0014Vm]3sm>L'OQ;dW\u0016$H*\u0019>z\rVt7\r^5p]\u00163\u0018\r\\;bi&|g.\u00118e\u00032<\u0018-_:LK\u0016\u0004H*Y:uQ\t!\u0002(\u0001\u0016uKN$(+Z:feZ|\u0017N\u001d\"vG.,Go\u0015;bi&\u001cH/[2bY\u0012K7\u000f\u001e:jEV$\u0018n\u001c8)\u0005UA\u0004")
public class ReservoirSuite
extends JUnitSuite {
    @Test
    public void testEmptyReservoir() {
        Reservoir r = new Reservoir(1, Reservoir$.MODULE$.apply$default$2(), Reservoir$.MODULE$.apply$default$3());
        Iterable $org_scalatest_assert_macro_left = r.keys();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
    }

    @Test
    public void testReservoirRespectsSize() {
        Reservoir r = new Reservoir(42, Reservoir$.MODULE$.apply$default$2(), Reservoir$.MODULE$.apply$default$3());
        r.add((Object)"meaning of life", (Object)BoxesRunTime.boxToInteger((int)12), r.add$default$3());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ReservoirBucket)r.buckets().apply((Object)"meaning of life")).maxSize()));
        int $org_scalatest_assert_macro_right = 42;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
    }

    @Test
    public void testReservoirItemsAndKeys() {
        Reservoir r = new Reservoir(42, Reservoir$.MODULE$.apply$default$2(), Reservoir$.MODULE$.apply$default$3());
        r.add((Object)"foo", (Object)BoxesRunTime.boxToInteger((int)4), r.add$default$3());
        r.add((Object)"bar", (Object)BoxesRunTime.boxToInteger((int)9), r.add$default$3());
        r.add((Object)"foo", (Object)BoxesRunTime.boxToInteger((int)19), r.add$default$3());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(r.keys().toSet());
        Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(r.items((Object)"foo"));
        List $org_scalatest_assert_macro_right2 = (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 19}));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(r.items((Object)"bar"));
        List $org_scalatest_assert_macro_right3 = (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{9}));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
    }

    @Test
    public void testReservoirExceptions() {
        this.assertThrows((Function0 & Serializable)() -> new Reservoir(-1, Reservoir$.MODULE$.apply$default$2(), Reservoir$.MODULE$.apply$default$3()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.assertThrows((Function0 & Serializable)() -> new Reservoir(12, Reservoir$.MODULE$.apply$default$2(), Reservoir$.MODULE$.apply$default$3()).items((Object)"missing key"), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
    }

    @Test
    public void testReservoirDeterminism() {
        Reservoir r1 = new Reservoir(10, Reservoir$.MODULE$.apply$default$2(), Reservoir$.MODULE$.apply$default$3());
        Reservoir r2 = new Reservoir(10, Reservoir$.MODULE$.apply$default$2(), Reservoir$.MODULE$.apply$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            r1.add((Object)"key", (Object)BoxesRunTime.boxToInteger((int)i), r1.add$default$3());
            r2.add((Object)"key", (Object)BoxesRunTime.boxToInteger((int)i), r2.add$default$3());
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(r1.items((Object)"key"));
        List $org_scalatest_assert_macro_right = r2.items((Object)"key");
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
    }

    @Test
    public void testReservoirBucketDeterminism() {
        Reservoir r1 = new Reservoir(10, Reservoir$.MODULE$.apply$default$2(), Reservoir$.MODULE$.apply$default$3());
        Reservoir r2 = new Reservoir(10, Reservoir$.MODULE$.apply$default$2(), Reservoir$.MODULE$.apply$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> r1.add((Object)"key1", (Object)BoxesRunTime.boxToInteger((int)i), r1.add$default$3()));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> r1.add((Object)"key2", (Object)BoxesRunTime.boxToInteger((int)i), r1.add$default$3()));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            r2.add((Object)"key1", (Object)BoxesRunTime.boxToInteger((int)i), r2.add$default$3());
            r2.add((Object)"key2", (Object)BoxesRunTime.boxToInteger((int)i), r2.add$default$3());
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(r1.items((Object)"key1"));
        List $org_scalatest_assert_macro_right = r2.items((Object)"key1");
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(r1.items((Object)"key2"));
        List $org_scalatest_assert_macro_right2 = r2.items((Object)"key2");
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
    }

    @Test
    public void testReservoirUsesSeed() {
        Reservoir r1 = new Reservoir(10, 0L, Reservoir$.MODULE$.apply$default$3());
        Reservoir r2 = new Reservoir(10, 1L, Reservoir$.MODULE$.apply$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            r1.add((Object)"key", (Object)BoxesRunTime.boxToInteger((int)i), r1.add$default$3());
            r2.add((Object)"key", (Object)BoxesRunTime.boxToInteger((int)i), r2.add$default$3());
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(r1.items((Object)"key"));
        List $org_scalatest_assert_macro_right = r2.items((Object)"key");
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!==", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bang$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
    }

    @Test
    public void testReservoirFilterItemsByKey() {
        Reservoir r = new Reservoir(100, 0L, Reservoir$.MODULE$.apply$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            r.add((Object)"key1", (Object)BoxesRunTime.boxToInteger((int)i), r.add$default$3());
            r.add((Object)"key2", (Object)BoxesRunTime.boxToInteger((int)i), r.add$default$3());
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)r.items((Object)"key1").size()));
        int $org_scalatest_assert_macro_right = 10;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)r.items((Object)"key2").size()));
        int $org_scalatest_assert_macro_right2 = 10;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)r.filter((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 <= 7, (Option)new Some((Object)"key2"))));
        int $org_scalatest_assert_macro_right3 = 2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)r.items((Object)"key1").size()));
        int $org_scalatest_assert_macro_right4 = 10;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)r.items((Object)"key2").size()));
        int $org_scalatest_assert_macro_right5 = 8;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)r.filter((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 <= 3, (Option)new Some((Object)"key1"))));
        int $org_scalatest_assert_macro_right6 = 6;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)r.items((Object)"key1").size()));
        int $org_scalatest_assert_macro_right7 = 4;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)r.items((Object)"key2").size()));
        int $org_scalatest_assert_macro_right8 = 8;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
    }

    @Test
    public void testEmptyReservoirBucket() {
        ReservoirBucket b = new ReservoirBucket(1, ReservoirBucket$.MODULE$.apply$default$2(), ReservoirBucket$.MODULE$.apply$default$3());
        List $org_scalatest_assert_macro_left = b.items();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
    }

    @Test
    public void testReservoirBucketFillToSize() {
        ReservoirBucket b = new ReservoirBucket(100, ReservoirBucket$.MODULE$.apply$default$2(), ReservoirBucket$.MODULE$.apply$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> b.add((Object)BoxesRunTime.boxToInteger((int)x$3), b.add$default$2()));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(b.items());
        List $org_scalatest_assert_macro_right = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).toList();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)b.numItemsSeen()));
        int $org_scalatest_assert_macro_right2 = 100;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
    }

    @Test
    public void testReservoirBucketDoesNotOverfill() {
        ReservoirBucket b = new ReservoirBucket(10, ReservoirBucket$.MODULE$.apply$default$2(), ReservoirBucket$.MODULE$.apply$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 1000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> b.add((Object)BoxesRunTime.boxToInteger((int)x$4), b.add$default$2()));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)b.items().size()));
        int $org_scalatest_assert_macro_right = 10;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)b.numItemsSeen()));
        int $org_scalatest_assert_macro_right2 = 1000;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
    }

    @Test
    public void testReservoirBucketMaintainsOrder() {
        ReservoirBucket b = new ReservoirBucket(100, ReservoirBucket$.MODULE$.apply$default$2(), ReservoirBucket$.MODULE$.apply$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> b.add((Object)BoxesRunTime.boxToInteger((int)x$5), b.add$default$2()));
        List items = b.items();
        IntRef previous = IntRef.create((int)-1);
        items.foreach((Function1)(JFunction1.mcVI.sp & Serializable)item -> {
            int $org_scalatest_assert_macro_left = item;
            int $org_scalatest_assert_macro_right = previous$1.elem;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            previous$1.elem = item;
        });
    }

    @Test
    public void testReservoirBucketKeepsLastItem() {
        ReservoirBucket b = new ReservoirBucket(5, ReservoirBucket$.MODULE$.apply$default$2(), ReservoirBucket$.MODULE$.apply$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable)i -> ReservoirSuite.$anonfun$testReservoirBucketKeepsLastItem$1(this, b, BoxesRunTime.unboxToInt((Object)i)));
    }

    @Test
    public void testReservoirBucketWithMaxSize1() {
        ReservoirBucket b = new ReservoirBucket(1, ReservoirBucket$.MODULE$.apply$default$2(), ReservoirBucket$.MODULE$.apply$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)i -> ReservoirSuite.$anonfun$testReservoirBucketWithMaxSize1$1(this, b, BoxesRunTime.unboxToInt((Object)i)));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)b.numItemsSeen()));
        int $org_scalatest_assert_macro_right = 20;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
    }

    @Test
    public void testReservoirBucketWithMaxSize0() {
        ReservoirBucket b = new ReservoirBucket(0, ReservoirBucket$.MODULE$.apply$default$2(), ReservoirBucket$.MODULE$.apply$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)i -> ReservoirSuite.$anonfun$testReservoirBucketWithMaxSize0$1(this, b, BoxesRunTime.unboxToInt((Object)i)));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)b.numItemsSeen()));
        int $org_scalatest_assert_macro_right = 20;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
    }

    @Test
    public void testReservoirBucketMaxSizeRequirement() {
        this.assertThrows((Function0 & Serializable)() -> new ReservoirBucket(-1, ReservoirBucket$.MODULE$.apply$default$2(), ReservoirBucket$.MODULE$.apply$default$3()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
    }

    @Test
    public void testReservoirBucketFilterItems() {
        ReservoirBucket b = new ReservoirBucket(100, ReservoirBucket$.MODULE$.apply$default$2(), ReservoirBucket$.MODULE$.apply$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> b.add((Object)BoxesRunTime.boxToInteger((int)x$6), b.add$default$2()));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)b.items().size()));
        int $org_scalatest_assert_macro_right = 10;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)b.numItemsSeen()));
        int $org_scalatest_assert_macro_right2 = 10;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)b.filter((Function1)(JFunction1.mcZI.sp & Serializable)x$7 -> x$7 <= 7)));
        int $org_scalatest_assert_macro_right3 = 2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)b.items().size()));
        int $org_scalatest_assert_macro_right4 = 8;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)b.numItemsSeen()));
        int $org_scalatest_assert_macro_right5 = 8;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
    }

    @Test
    public void testReservoirBucketRemovesItemsWhenItemsAreReplaced() {
        int numFiltered;
        ReservoirBucket b = new ReservoirBucket(100, ReservoirBucket$.MODULE$.apply$default$2(), ReservoirBucket$.MODULE$.apply$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$8 -> b.add((Object)BoxesRunTime.boxToInteger((int)x$8), b.add$default$2()));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)b.numItemsSeen()));
        int $org_scalatest_assert_macro_right = 10000;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        int $org_scalatest_assert_macro_left2 = numFiltered = b.filter((Function1)(JFunction1.mcZI.sp & Serializable)x$9 -> x$9 <= 7);
        int $org_scalatest_assert_macro_right2 = 92;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(b.items().exists((Function1)(JFunction1.mcZI.sp & Serializable)x$10 -> x$10 > 7), "b.items.exists(((x$10: Int) => x$10.>(7)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)b.numItemsSeen()));
        float $org_scalatest_assert_macro_right3 = (float)10000 * (1.0f - (float)numFiltered / (float)100);
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
    }

    @Test
    public void testReservoirBucketLazyFunctionEvaluationAndAlwaysKeepLast() {
        public class Org_platanios_tensorflow_api_utilities_ReservoirSuite$FakeRandom$1
        extends Random {
            public int nextInt(int n) {
                return 999;
            }

            public Org_platanios_tensorflow_api_utilities_ReservoirSuite$FakeRandom$1(ReservoirSuite $outer) {
            }
        }
        ReservoirBucket b1 = new ReservoirBucket(100, (Random)new Org_platanios_tensorflow_api_utilities_ReservoirSuite$FakeRandom$1(null), false);
        public class Org_platanios_tensorflow_api_utilities_ReservoirSuite$Incrementer$1 {
            private int n;

            public int n() {
                return this.n;
            }

            public void n_$eq(int x$1) {
                this.n = x$1;
            }

            public int incrementAndDouble(int x) {
                this.n_$eq(this.n() + 1);
                return x * 2;
            }

            public Org_platanios_tensorflow_api_utilities_ReservoirSuite$Incrementer$1(ReservoirSuite $outer) {
                this.n = 0;
            }
        }
        Org_platanios_tensorflow_api_utilities_ReservoirSuite$Incrementer$1 i1 = new Org_platanios_tensorflow_api_utilities_ReservoirSuite$Incrementer$1(null);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 1000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$11 -> b1.add((Object)BoxesRunTime.boxToInteger((int)x$11), (Function1)(JFunction1.mcII.sp & Serializable)x -> i1.incrementAndDouble(x)));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)i1.n()));
        int $org_scalatest_assert_macro_right = 100;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(b1.items());
        List $org_scalatest_assert_macro_right2 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).map((Function1)(JFunction1.mcII.sp & Serializable)x$12 -> x$12 * 2).toList();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        ReservoirBucket b2 = new ReservoirBucket(100, (Random)new Org_platanios_tensorflow_api_utilities_ReservoirSuite$FakeRandom$1(null), true);
        Org_platanios_tensorflow_api_utilities_ReservoirSuite$Incrementer$1 i2 = new Org_platanios_tensorflow_api_utilities_ReservoirSuite$Incrementer$1(null);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 1000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$13 -> b2.add((Object)BoxesRunTime.boxToInteger((int)x$13), (Function1)(JFunction1.mcII.sp & Serializable)x -> i2.incrementAndDouble(x)));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)i2.n()));
        int $org_scalatest_assert_macro_right3 = 1000;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(b2.items());
        List $org_scalatest_assert_macro_right4 = (List)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 99).map((Function1)(JFunction1.mcII.sp & Serializable)x$14 -> x$14 * 2).toList().$colon$plus((Object)BoxesRunTime.boxToInteger((int)1998));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
    }

    @Test
    public void testReservoirBucketStatisticalDistribution() {
        int numTotal = 10000;
        int numSamples = 100;
        int numBuckets = 10;
        int totalPerBucket = numTotal / numBuckets;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)(numTotal % numBuckets)));
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        int $org_scalatest_assert_macro_left2 = numTotal;
        int $org_scalatest_assert_macro_right2 = numSamples;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        ReservoirBucket b = new ReservoirBucket(numSamples, ReservoirBucket$.MODULE$.apply$default$2(), ReservoirBucket$.MODULE$.apply$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numTotal + 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$15 -> b.add((Object)BoxesRunTime.boxToInteger((int)x$15), b.add$default$2()));
        ArrayBuffer divBins = (ArrayBuffer)ArrayBuffer$.MODULE$.fill(numBuckets, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0);
        ArrayBuffer modBins = (ArrayBuffer)ArrayBuffer$.MODULE$.fill(numBuckets, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0);
        ((List)b.items().dropRight(1)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)item -> {
            int n = item / totalPerBucket;
            divBins.update(n, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)divBins.apply(n)) + 1)));
            int n2 = item % numBuckets;
            modBins.update(n2, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)modBins.apply(n2)) + 1)));
        });
        divBins.foreach((Function1)(JFunction1.mcVI.sp & Serializable)measured -> ReservoirSuite.assertBinomialQuantity$1(measured, numBuckets, numSamples));
        modBins.foreach((Function1)(JFunction1.mcVI.sp & Serializable)measured -> ReservoirSuite.assertBinomialQuantity$1(measured, numBuckets, numSamples));
    }

    public static final /* synthetic */ Assertion $anonfun$testReservoirBucketKeepsLastItem$1(ReservoirSuite $this, ReservoirBucket b$4, int i) {
        b$4.add((Object)BoxesRunTime.boxToInteger((int)i), b$4.add$default$2());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(b$4.items().last());
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
    }

    public static final /* synthetic */ Assertion $anonfun$testReservoirBucketWithMaxSize1$1(ReservoirSuite $this, ReservoirBucket b$5, int i) {
        b$5.add((Object)BoxesRunTime.boxToInteger((int)i), b$5.add$default$2());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(b$5.items());
        List $org_scalatest_assert_macro_right = (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{i}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
    }

    public static final /* synthetic */ Assertion $anonfun$testReservoirBucketWithMaxSize0$1(ReservoirSuite $this, ReservoirBucket b$6, int i) {
        b$6.add((Object)BoxesRunTime.boxToInteger((int)i), b$6.add$default$2());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(b$6.items());
        List $org_scalatest_assert_macro_right = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), i).toList();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
    }

    private static final void assertBinomialQuantity$1(int measured, int numBuckets$1, int numSamples$1) {
        double p = 1.0 * (double)numBuckets$1 / (double)numSamples$1;
        double mean = p * (double)numSamples$1;
        double variance = p * (1.0 - p) * (double)numSamples$1;
        double error = (double)measured - mean;
        double $org_scalatest_assert_macro_left = error * error;
        double $org_scalatest_assert_macro_right = 36.0 * variance;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        AssertionsForJUnit$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReservoirSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
    }
}

