/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.data.image;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.platanios.tensorflow.api.core.Shape;
import org.platanios.tensorflow.api.package;
import org.platanios.tensorflow.api.package$;
import org.platanios.tensorflow.api.tensors.Tensor;
import org.platanios.tensorflow.api.tensors.TensorConvertible$;
import org.platanios.tensorflow.api.tensors.ops.Basic;
import org.platanios.tensorflow.api.types.DataType;
import org.platanios.tensorflow.api.types.SupportedType$;
import org.platanios.tensorflow.data.Loader;
import org.platanios.tensorflow.data.image.STL10Dataset;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class STL10Loader$
implements Loader {
    public static STL10Loader$ MODULE$;
    private final String url;
    private final String compressedFilename;
    private final String trainImagesFilename;
    private final String trainLabelsFilename;
    private final String testImagesFilename;
    private final String testLabelsFilename;
    private final String unlabeledImagesFilename;
    private final int numTrain;
    private final int numTest;
    private final int numUnlabeled;
    private final int imageWidth;
    private final int imageHeight;
    private final int imageChannels;
    private final Logger logger;

    static {
        new STL10Loader$();
    }

    @Override
    public boolean maybeDownload(Path path, String url, int bufferSize) {
        return Loader.maybeDownload$(this, path, url, bufferSize);
    }

    @Override
    public int maybeDownload$default$3() {
        return Loader.maybeDownload$default$3$(this);
    }

    public String url() {
        return this.url;
    }

    public String compressedFilename() {
        return this.compressedFilename;
    }

    public String trainImagesFilename() {
        return this.trainImagesFilename;
    }

    public String trainLabelsFilename() {
        return this.trainLabelsFilename;
    }

    public String testImagesFilename() {
        return this.testImagesFilename;
    }

    public String testLabelsFilename() {
        return this.testLabelsFilename;
    }

    public String unlabeledImagesFilename() {
        return this.unlabeledImagesFilename;
    }

    public int numTrain() {
        return this.numTrain;
    }

    public int numTest() {
        return this.numTest;
    }

    public int numUnlabeled() {
        return this.numUnlabeled;
    }

    public int imageWidth() {
        return this.imageWidth;
    }

    public int imageHeight() {
        return this.imageHeight;
    }

    public int imageChannels() {
        return this.imageChannels;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    public STL10Dataset load(Path path, int bufferSize, boolean loadUnlabeled) {
        BoxedUnit boxedUnit;
        this.maybeDownload(path.resolve(this.compressedFilename()), new StringBuilder(0).append(this.url()).append(this.compressedFilename()).toString(), bufferSize);
        STL10Dataset dataset = this.extractFiles(path.resolve(this.compressedFilename()), bufferSize, loadUnlabeled);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Finished loading the STL-10 dataset.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return dataset;
    }

    public int load$default$2() {
        return 8192;
    }

    public boolean load$default$3() {
        return true;
    }

    private STL10Dataset extractFiles(Path path, int bufferSize, boolean loadUnlabeled) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Extracting data from file '{}'.", new Object[]{path});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        TarArchiveInputStream inputStream = new TarArchiveInputStream((InputStream)new GZIPInputStream(Files.newInputStream(path, new OpenOption[0])));
        STL10Dataset dataset = new STL10Dataset(null, null, null, null, null);
        ObjectRef entry = ObjectRef.create((Object)inputStream.getNextTarEntry());
        while ((TarArchiveEntry)entry.elem != null) {
            String string = ((TarArchiveEntry)entry.elem).getName();
            String string2 = this.unlabeledImagesFilename();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                if (loadUnlabeled) {
                    Shape halfShape = package$.MODULE$.Shape().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.numUnlabeled() / 2, this.imageChannels(), this.imageHeight(), this.imageWidth()}));
                    ObjectRef outputStream = ObjectRef.create((Object)new ByteArrayOutputStream());
                    byte[] buffer = new byte[bufferSize];
                    IntRef numBytesRead = IntRef.create((int)0);
                    scala.package$.MODULE$.Stream().continually((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> inputStream.read(buffer)).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> (long)numBytesRead$1.elem <= ((TarArchiveEntry)entry$1.elem).getSize() / 2L).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)numBytes -> {
                        ((ByteArrayOutputStream)outputStream$1.elem).write(buffer, 0, numBytes);
                        numBytesRead$1.elem += numBytes;
                    });
                    ByteBuffer byteBuffer = ByteBuffer.wrap(((ByteArrayOutputStream)outputStream.elem).toByteArray()).order(ByteOrder.BIG_ENDIAN);
                    ((ByteArrayOutputStream)outputStream.elem).close();
                    Basic.BasicOps qual$1 = package$.MODULE$.tensorToBasicOps(package$.MODULE$.Tensor().fromBuffer((DataType)package$.MODULE$.UINT8(), halfShape, (long)byteBuffer.capacity(), byteBuffer));
                    Tensor x$8 = package$.MODULE$.Tensor().apply((Object)BoxesRunTime.boxToInteger((int)0), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1}), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType()));
                    boolean x$9 = qual$1.transpose$default$2();
                    Tensor tensor1 = qual$1.transpose(x$8, x$9);
                    outputStream.elem = new ByteArrayOutputStream();
                    scala.package$.MODULE$.Stream().continually((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> inputStream.read(buffer)).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 != -1).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> ((ByteArrayOutputStream)outputStream$1.elem).write(buffer, 0, x$3));
                    byteBuffer = ByteBuffer.wrap(((ByteArrayOutputStream)outputStream.elem).toByteArray()).order(ByteOrder.BIG_ENDIAN);
                    ((ByteArrayOutputStream)outputStream.elem).close();
                    Basic.BasicOps qual$2 = package$.MODULE$.tensorToBasicOps(package$.MODULE$.Tensor().fromBuffer((DataType)package$.MODULE$.UINT8(), halfShape, (long)byteBuffer.capacity(), byteBuffer));
                    Tensor x$10 = package$.MODULE$.Tensor().apply((Object)BoxesRunTime.boxToInteger((int)0), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1}), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType()));
                    boolean x$11 = qual$2.transpose$default$2();
                    Tensor tensor2 = qual$2.transpose(x$10, x$11);
                    STL10Dataset qual$3 = dataset;
                    Tensor x$12 = package.tfi$.MODULE$.concatenate((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tensor[]{tensor1, tensor2})), package$.MODULE$.tensorConvertibleToTensor((Object)BoxesRunTime.boxToInteger((int)0), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())));
                    Tensor x$13 = qual$3.copy$default$1();
                    Tensor x$14 = qual$3.copy$default$2();
                    Tensor x$15 = qual$3.copy$default$3();
                    Tensor x$16 = qual$3.copy$default$4();
                    dataset = qual$3.copy(x$13, x$14, x$15, x$16, x$12);
                }
            } else if (((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.trainImagesFilename(), this.trainLabelsFilename(), this.testImagesFilename(), this.testLabelsFilename()}))).contains((Object)((TarArchiveEntry)entry.elem).getName())) {
                BoxedUnit boxedUnit2;
                String string3;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream((int)((TarArchiveEntry)entry.elem).getSize());
                byte[] buffer = new byte[bufferSize];
                scala.package$.MODULE$.Stream().continually((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> inputStream.read(buffer)).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 != -1).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$5 -> outputStream.write(buffer, 0, x$5));
                ByteBuffer byteBuffer = ByteBuffer.wrap(outputStream.toByteArray()).order(ByteOrder.BIG_ENDIAN);
                outputStream.close();
                String string4 = string3 = ((TarArchiveEntry)entry.elem).getName();
                String string5 = this.trainImagesFilename();
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    Shape shape = package$.MODULE$.Shape().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.numTrain(), this.imageChannels(), this.imageHeight(), this.imageWidth()}));
                    Basic.BasicOps qual$4 = package$.MODULE$.tensorToBasicOps(package$.MODULE$.Tensor().fromBuffer((DataType)package$.MODULE$.UINT8(), shape, ((TarArchiveEntry)entry.elem).getSize(), byteBuffer));
                    Tensor x$17 = package$.MODULE$.Tensor().apply((Object)BoxesRunTime.boxToInteger((int)0), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1}), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType()));
                    boolean x$18 = qual$4.transpose$default$2();
                    Tensor tensor = qual$4.transpose(x$17, x$18);
                    STL10Dataset qual$5 = dataset;
                    Tensor x$19 = tensor;
                    Tensor x$20 = qual$5.copy$default$2();
                    Tensor x$21 = qual$5.copy$default$3();
                    Tensor x$22 = qual$5.copy$default$4();
                    Tensor x$23 = qual$5.copy$default$5();
                    dataset = qual$5.copy(x$19, x$20, x$21, x$22, x$23);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    String string6 = string3;
                    String string7 = this.trainLabelsFilename();
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        Tensor tensor = package$.MODULE$.tensorToMathOps(package$.MODULE$.Tensor().fromBuffer((DataType)package$.MODULE$.UINT8(), package$.MODULE$.Shape().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.numTrain()})), ((TarArchiveEntry)entry.elem).getSize(), byteBuffer)).$minus(package$.MODULE$.Tensor().apply((DataType)package$.MODULE$.UINT8(), (Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0]), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())));
                        STL10Dataset qual$6 = dataset;
                        Tensor x$25 = tensor;
                        Tensor x$26 = qual$6.copy$default$1();
                        Tensor x$27 = qual$6.copy$default$3();
                        Tensor x$28 = qual$6.copy$default$4();
                        Tensor x$29 = qual$6.copy$default$5();
                        dataset = qual$6.copy(x$26, x$25, x$27, x$28, x$29);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        String string8 = string3;
                        String string9 = this.testImagesFilename();
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            Shape shape = package$.MODULE$.Shape().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.numTest(), this.imageChannels(), this.imageHeight(), this.imageWidth()}));
                            Basic.BasicOps qual$7 = package$.MODULE$.tensorToBasicOps(package$.MODULE$.Tensor().fromBuffer((DataType)package$.MODULE$.UINT8(), shape, ((TarArchiveEntry)entry.elem).getSize(), byteBuffer));
                            Tensor x$30 = package$.MODULE$.Tensor().apply((Object)BoxesRunTime.boxToInteger((int)0), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1}), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType()));
                            boolean x$31 = qual$7.transpose$default$2();
                            Tensor tensor = qual$7.transpose(x$30, x$31);
                            STL10Dataset qual$8 = dataset;
                            Tensor x$32 = tensor;
                            Tensor x$33 = qual$8.copy$default$1();
                            Tensor x$34 = qual$8.copy$default$2();
                            Tensor x$35 = qual$8.copy$default$4();
                            Tensor x$36 = qual$8.copy$default$5();
                            dataset = qual$8.copy(x$33, x$34, x$32, x$35, x$36);
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            String string10 = string3;
                            String string11 = this.testLabelsFilename();
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                Tensor tensor = package$.MODULE$.tensorToMathOps(package$.MODULE$.Tensor().fromBuffer((DataType)package$.MODULE$.UINT8(), package$.MODULE$.Shape().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.numTest()})), ((TarArchiveEntry)entry.elem).getSize(), byteBuffer)).$minus(package$.MODULE$.Tensor().apply((DataType)package$.MODULE$.UINT8(), (Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0]), TensorConvertible$.MODULE$.supportedTypeTensorConvertible(SupportedType$.MODULE$.intIsSupportedType())));
                                STL10Dataset qual$9 = dataset;
                                Tensor x$37 = tensor;
                                Tensor x$38 = qual$9.copy$default$1();
                                Tensor x$39 = qual$9.copy$default$2();
                                Tensor x$40 = qual$9.copy$default$3();
                                Tensor x$41 = qual$9.copy$default$5();
                                dataset = qual$9.copy(x$38, x$39, x$40, x$37, x$41);
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                        }
                    }
                }
            }
            entry.elem = inputStream.getNextTarEntry();
        }
        inputStream.close();
        return dataset;
    }

    private int extractFiles$default$2() {
        return 8192;
    }

    private boolean extractFiles$default$3() {
        return true;
    }

    private STL10Loader$() {
        MODULE$ = this;
        Loader.$init$(this);
        this.url = "http://ai.stanford.edu/~acoates/stl10/";
        this.compressedFilename = "stl10_binary.tar.gz";
        this.trainImagesFilename = "stl10_binary/train_X.bin";
        this.trainLabelsFilename = "stl10_binary/train_y.bin";
        this.testImagesFilename = "stl10_binary/test_X.bin";
        this.testLabelsFilename = "stl10_binary/test_y.bin";
        this.unlabeledImagesFilename = "stl10_binary/unlabeled_X.bin";
        this.numTrain = 5000;
        this.numTest = 8000;
        this.numUnlabeled = 100000;
        this.imageWidth = 96;
        this.imageHeight = 96;
        this.imageChannels = 3;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)"STL10 Data Loader"));
    }
}

