/*
 * Decompiled with CFR 0.152.
 */
package org.platanios.tensorflow.data.utilities;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CompressedFiles$ {
    public static CompressedFiles$ MODULE$;

    static {
        new CompressedFiles$();
    }

    public void decompressTGZ(Path tgzFilePath, Path destinationPath, int bufferSize) {
        this.decompressTGZStream(Files.newInputStream(tgzFilePath, new OpenOption[0]), destinationPath, bufferSize);
    }

    public int decompressTGZ$default$3() {
        return 8192;
    }

    public void decompressTar(Path tarFilePath, Path destinationPath, int bufferSize) {
        this.decompressTarStream(Files.newInputStream(tarFilePath, new OpenOption[0]), destinationPath, bufferSize);
    }

    public int decompressTar$default$3() {
        return 8192;
    }

    public void decompressTGZStream(InputStream tgzStream, Path destinationPath, int bufferSize) {
        this.decompressTarStream(new GZIPInputStream(tgzStream), destinationPath, bufferSize);
    }

    public int decompressTGZStream$default$3() {
        return 8192;
    }

    public void decompressTarStream(InputStream tarStream, Path destinationPath, int bufferSize) {
        TarArchiveInputStream inputStream = new TarArchiveInputStream(tarStream);
        TarArchiveEntry entry = inputStream.getNextTarEntry();
        while (entry != null) {
            Object object;
            if (!entry.isDirectory()) {
                File currentFile = new File(((Object)destinationPath.toAbsolutePath()).toString(), entry.getName());
                File parentFile = currentFile.getParentFile();
                Object object2 = !parentFile.exists() ? BoxesRunTime.boxToBoolean((boolean)parentFile.mkdirs()) : BoxedUnit.UNIT;
                object = BoxesRunTime.boxToLong((long)IOUtils.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(currentFile)));
            } else {
                object = BoxedUnit.UNIT;
            }
            entry = inputStream.getNextTarEntry();
        }
        inputStream.close();
    }

    public int decompressTarStream$default$3() {
        return 8192;
    }

    private CompressedFiles$() {
        MODULE$ = this;
    }
}

