/*
 * Decompiled with CFR 0.152.
 */
package org.plutext.msgraph.convert.scribe;

import com.github.scribejava.apis.MicrosoftAzureActiveDirectory20Api;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.jdk.JDKHttpClient;
import com.github.scribejava.core.httpclient.jdk.JDKHttpClientConfig;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.plutext.msgraph.convert.scribe.adaption.OurOAuth20ServiceBridge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileService {
    private static final Logger log = LoggerFactory.getLogger(FileService.class);
    private final OAuth20Service authenticationService;
    private final MicrosoftAzureActiveDirectory20Api api;
    private HttpClient httpClient;
    private String bearerToken = null;

    public FileService(OAuth20Service authenticationService, MicrosoftAzureActiveDirectory20Api api) {
        this.authenticationService = authenticationService;
        this.api = api;
    }

    public FileService(OAuth20Service authenticationService, MicrosoftAzureActiveDirectory20Api api, HttpClient httpClient) {
        this.authenticationService = authenticationService;
        this.api = api;
        this.httpClient = httpClient;
    }

    private CompletableFuture<HttpClient> getHttpClient() {
        return CompletableFuture.supplyAsync(new Supplier<HttpClient>(){

            @Override
            public HttpClient get() {
                if (FileService.this.httpClient != null) {
                    return FileService.this.httpClient;
                }
                FileService.this.httpClient = (HttpClient)new JDKHttpClient(JDKHttpClientConfig.defaultConfig());
                return FileService.this.httpClient;
            }
        });
    }

    private CompletableFuture<String> getBearerToken() {
        return CompletableFuture.supplyAsync(new Supplier<String>(){

            @Override
            public String get() {
                if (FileService.this.bearerToken != null) {
                    return FileService.this.bearerToken;
                }
                OAuth2AccessToken accessToken = null;
                try {
                    OurOAuth20ServiceBridge bridge = new OurOAuth20ServiceBridge(FileService.this.authenticationService, FileService.this.api);
                    accessToken = bridge.getAccessTokenClientCredentialsGrant();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                FileService.this.bearerToken = accessToken.getAccessToken();
                System.out.println(FileService.this.bearerToken);
                return FileService.this.bearerToken;
            }
        });
    }

    public Future<Boolean> uploadStreamAsync(String requestUrl, byte[] bodyContents, String contentType) throws InterruptedException, ExecutionException {
        HttpClient client = this.getHttpClient().get();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("ContentType", contentType);
        headers.put("Authorization", "Bearer " + this.getBearerToken().get());
        headers.put("Accept", "application/json;odata.metadata=minimal");
        log.debug(requestUrl);
        return client.executeAsync("ScribeJava", headers, Verb.PUT, requestUrl, bodyContents, (OAuthAsyncRequestCallback)new UploadOAuthAsyncRequestCallback(), (OAuthRequest.ResponseConverter)new UploadResponseConverter());
    }

    public Future<Boolean> uploadStreamAsync(String requestUrl, File bodyContents, String contentType) throws InterruptedException, ExecutionException {
        HttpClient client = this.getHttpClient().get();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("ContentType", contentType);
        headers.put("Authorization", "Bearer " + this.getBearerToken().get());
        headers.put("Accept", "application/json;odata.metadata=minimal");
        log.debug(requestUrl);
        return client.executeAsync("ScribeJava", headers, Verb.PUT, requestUrl, bodyContents, (OAuthAsyncRequestCallback)new UploadOAuthAsyncRequestCallback(), (OAuthRequest.ResponseConverter)new UploadResponseConverter());
    }

    public Future<byte[]> downloadConvertedFileAsync(String requestUrl) throws InterruptedException, ExecutionException {
        HttpClient client = this.getHttpClient().get();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.getBearerToken().get());
        log.debug(requestUrl);
        byte[] nullBytes = null;
        return client.executeAsync("ScribeJava", headers, Verb.GET, requestUrl, nullBytes, (OAuthAsyncRequestCallback)new DownloadOAuthAsyncRequestCallback(), (OAuthRequest.ResponseConverter)new DownloadResponseConverter());
    }

    public Future<Boolean> deleteFileAsync(String requestUrl) throws InterruptedException, ExecutionException {
        HttpClient client = this.getHttpClient().get();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.getBearerToken().get());
        log.debug(requestUrl);
        byte[] nullBytes = new byte[]{};
        return client.executeAsync("ScribeJava", headers, Verb.DELETE, requestUrl, nullBytes, null, (OAuthRequest.ResponseConverter)new DeleteResponseConverter());
    }

    class DeleteResponseConverter
    implements OAuthRequest.ResponseConverter<Boolean> {
        DeleteResponseConverter() {
        }

        public Boolean convert(Response response) throws IOException {
            log.debug("received response for delete");
            String body = null;
            if (log.isDebugEnabled()) {
                log.debug("response status code: " + response.getCode());
                body = response.getBody();
                log.debug("response body: " + body);
            }
            return response.isSuccessful();
        }
    }

    class DownloadResponseConverter
    implements OAuthRequest.ResponseConverter<byte[]> {
        DownloadResponseConverter() {
        }

        public byte[] convert(Response response) throws IOException {
            log.debug("received response for upload");
            byte[] bytes = IOUtils.toByteArray((InputStream)response.getStream());
            response.close();
            return bytes;
        }
    }

    class DownloadOAuthAsyncRequestCallback
    implements OAuthAsyncRequestCallback<byte[]> {
        DownloadOAuthAsyncRequestCallback() {
        }

        public void onCompleted(byte[] response) {
            log.debug("callback oncompleted: downloaded " + response.length + " bytes");
        }

        public void onThrowable(Throwable t) {
            throw new RuntimeException(t);
        }
    }

    class UploadResponseConverter
    implements OAuthRequest.ResponseConverter<Boolean> {
        UploadResponseConverter() {
        }

        public Boolean convert(Response response) throws IOException {
            log.debug("received response for upload");
            String body = null;
            if (log.isDebugEnabled()) {
                log.debug("response status code: " + response.getCode());
                body = response.getBody();
                log.debug("response body: " + body);
            }
            if (!response.isSuccessful()) {
                log.warn(response.getBody());
                response.close();
                return null;
            }
            response.close();
            return true;
        }
    }

    class UploadOAuthAsyncRequestCallback
    implements OAuthAsyncRequestCallback<Boolean> {
        UploadOAuthAsyncRequestCallback() {
        }

        public void onCompleted(Boolean response) {
            log.debug("UploadOAuthAsyncRequestCallback: " + response);
        }

        public void onThrowable(Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

