/*
 * Decompiled with CFR 0.152.
 */
package org.plutext.msgraph.convert.scribe;

import com.github.scribejava.apis.MicrosoftAzureActiveDirectory20Api;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.plutext.msgraph.convert.AuthConfig;
import org.plutext.msgraph.convert.ConversionException;
import org.plutext.msgraph.convert.DocxToPdfConverter;
import org.plutext.msgraph.convert.scribe.FileService;
import org.plutext.msgraph.convert.scribe.adaption.OurMicrosoftAzureActiveDirectoryEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfConverter
extends DocxToPdfConverter {
    private static final Logger log = LoggerFactory.getLogger(PdfConverter.class);
    FileService fs = null;

    public PdfConverter(AuthConfig authConfig) throws ConversionException {
        super(authConfig);
        MicrosoftAzureActiveDirectory20Api api = OurMicrosoftAzureActiveDirectoryEndpoint.custom(authConfig.tenant());
        OAuth20Service azureAuthService = this.getAuthService(api, authConfig);
        this.fs = new FileService(azureAuthService, api);
    }

    public PdfConverter(AuthConfig authConfig, HttpClient httpClient) throws ConversionException {
        super(authConfig);
        MicrosoftAzureActiveDirectory20Api api = OurMicrosoftAzureActiveDirectoryEndpoint.custom(authConfig.tenant());
        OAuth20Service azureAuthService = this.getAuthService(api, authConfig);
        this.fs = new FileService(azureAuthService, api, httpClient);
    }

    public byte[] convert(byte[] docx) throws ConversionException {
        try {
            String tmpFileName = UUID.randomUUID() + ".docx";
            String item = "root:/" + tmpFileName + ":";
            String path = "https://graph.microsoft.com/v1.0/sites/" + this.authConfig.site() + "/drive/items/" + item + "/content";
            Boolean result = this.fs.uploadStreamAsync(path, docx, "application/vnd.openxmlformats-officedocument.wordprocessingml.document").get();
            if (result == null || !result.booleanValue()) {
                throw new ConversionException("upload failed");
            }
            byte[] pdfBytes = this.fs.downloadConvertedFileAsync(path + "?format=pdf").get();
            path = "https://graph.microsoft.com/v1.0/sites/" + this.authConfig.site() + "/drive/items/" + item;
            boolean deleted = this.fs.deleteFileAsync(path).get();
            log.debug("" + deleted);
            return pdfBytes;
        }
        catch (Exception e) {
            throw new ConversionException(e.getMessage(), e);
        }
    }

    public byte[] convert(InputStream docx) throws ConversionException, IOException {
        return this.convert(IOUtils.toByteArray((InputStream)docx));
    }

    public byte[] convert(File inFile) throws ConversionException, IOException {
        try {
            String tmpFileName = UUID.randomUUID() + ".docx";
            String item = "root:/" + tmpFileName + ":";
            String path = "https://graph.microsoft.com/v1.0/sites/" + this.authConfig.site() + "/drive/items/" + item + "/content";
            Boolean result = this.fs.uploadStreamAsync(path, inFile, "application/vnd.openxmlformats-officedocument.wordprocessingml.document").get();
            if (result == null || !result.booleanValue()) {
                throw new ConversionException("upload failed");
            }
            byte[] pdfBytes = this.fs.downloadConvertedFileAsync(path + "?format=pdf").get();
            path = "https://graph.microsoft.com/v1.0/sites/" + this.authConfig.site() + "/drive/items/" + item;
            boolean deleted = this.fs.deleteFileAsync(path).get();
            log.debug("" + deleted);
            return pdfBytes;
        }
        catch (Exception e) {
            throw new ConversionException(e.getMessage(), e);
        }
    }

    private OAuth20Service getAuthService(MicrosoftAzureActiveDirectory20Api api, AuthConfig authConfig) throws ConversionException {
        try {
            log.debug("create connection with apiKey: {} apiSecret: {}", (Object)authConfig.apiKey(), (Object)authConfig.apiSecret());
            return new ServiceBuilder(authConfig.apiKey()).defaultScope("openid Files.ReadWrite.All").apiSecret(authConfig.apiSecret()).build((DefaultApi20)api);
        }
        catch (Exception e) {
            log.error("Office 365 authentication is misconfigured, original error was : {}", (Object)e.getMessage());
            log.debug("Office 365 authentication detail misconfiguration", (Throwable)e);
            throw new ConversionException("Office 365 authentication is misconfigured", e);
        }
    }
}

