/*
 * Decompiled with CFR 0.152.
 */
package org.plutext.msgraph.convert.scribe.adaption;

import com.github.scribejava.apis.MicrosoftAzureActiveDirectory20Api;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public class OurOAuth20ServiceBridge {
    private final OAuth20Service authenticationService;
    private final MicrosoftAzureActiveDirectory20Api api;

    public OurOAuth20ServiceBridge(OAuth20Service authenticationService, MicrosoftAzureActiveDirectory20Api api) {
        this.authenticationService = authenticationService;
        this.api = api;
    }

    public OAuth2AccessToken getAccessTokenClientCredentialsGrant() throws IOException, InterruptedException, ExecutionException {
        OAuthRequest request = this.createAccessTokenClientCredentialsGrantRequest();
        return this.sendAccessTokenRequestSync(request);
    }

    protected OAuthRequest createAccessTokenClientCredentialsGrantRequest() {
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        this.api.getClientAuthentication().addClientAuthentication(request, this.authenticationService.getApiKey(), this.authenticationService.getApiSecret());
        request.addParameter("scope", "openid Files.ReadWrite.All");
        request.addParameter("grant_type", "client_credentials");
        request.addParameter("resource", "https://graph.microsoft.com");
        return request;
    }

    protected OAuth2AccessToken sendAccessTokenRequestSync(OAuthRequest request) throws IOException, InterruptedException, ExecutionException {
        try (Response response = this.execute(request);){
            OAuth2AccessToken oAuth2AccessToken = (OAuth2AccessToken)this.api.getAccessTokenExtractor().extract(response);
            return oAuth2AccessToken;
        }
    }

    public Response execute(OAuthRequest request) throws InterruptedException, ExecutionException, IOException {
        return this.authenticationService.execute(request);
    }
}

