/*
 * Decompiled with CFR 0.152.
 */
package org.polyforms.repository.jpa.querydsl;

import com.mysema.query.types.EntityPath;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueryDslUtils {
    private static final Map<Class<?>, EntityPath<?>> ENTITY_PATH_CACHE = new HashMap();

    protected QueryDslUtils() {
        throw new UnsupportedOperationException();
    }

    protected static EntityPath<?> findEntityPath(Class<?> entityClass) {
        if (!ENTITY_PATH_CACHE.containsKey(entityClass)) {
            String queryClassName = QueryDslUtils.getQueryClassName(entityClass);
            try {
                Class pathClass = ClassUtils.forName((String)queryClassName, (ClassLoader)QueryDslUtils.class.getClassLoader());
                Field field = QueryDslUtils.getStaticFieldOfType(pathClass);
                if (field == null) {
                    throw new IllegalStateException("Cannot find static field of query class " + pathClass);
                }
                ENTITY_PATH_CACHE.put(entityClass, (EntityPath)ReflectionUtils.getField((Field)field, null));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot find query class of entity " + entityClass.getName(), e);
            }
        }
        return ENTITY_PATH_CACHE.get(entityClass);
    }

    private static Field getStaticFieldOfType(Class<?> type) {
        for (Field field : type.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !type.equals(field.getType())) continue;
            return field;
        }
        Class<?> superclass = type.getSuperclass();
        return Object.class.equals(superclass) ? null : QueryDslUtils.getStaticFieldOfType(superclass);
    }

    private static String getQueryClassName(Class<?> domainClass) {
        return domainClass.getPackage().getName() + ".Q" + domainClass.getSimpleName().replace(".", "_");
    }
}

