/*
 * Decompiled with CFR 0.152.
 */
package org.polyvariant.sttp.oauth2.cache.ce2;

import cats.Functor;
import cats.Monad;
import cats.Semigroupal;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.Clock;
import cats.effect.Clock$;
import cats.effect.Concurrent;
import cats.effect.concurrent.Semaphore;
import cats.syntax.package;
import eu.timepit.refined.api.Refined;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import org.polyvariant.sttp.oauth2.AccessTokenProvider;
import org.polyvariant.sttp.oauth2.ClientCredentialsToken;
import org.polyvariant.sttp.oauth2.Secret;
import org.polyvariant.sttp.oauth2.cache.ExpiringCache;
import org.polyvariant.sttp.oauth2.cache.ce2.CachingAccessTokenProvider$;
import org.polyvariant.sttp.oauth2.cache.ce2.CachingAccessTokenProvider$TokenWithExpirationTime$;
import org.polyvariant.sttp.oauth2.common;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\u0015a\u0001B\u00193\u0005}B\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t5\u0002\u0011\t\u0011)A\u00057\"AQ\r\u0001B\u0001B\u0003%a\r\u0003\u0006\u00038\u0002\u0011\u0019\u0011)A\u0006\u0005sC!B!1\u0001\u0005\u0007\u0005\u000b1\u0002Bb\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0005\u000bDqA!6\u0001\t\u0003\u00129\u000eC\u0004\u0003^\u0002!IAa8\t\u000f\t\r\b\u0001\"\u0003\u0003f\"9!Q\u001f\u0001\u0005\n\t]\bb\u0002B~\u0001\u0011%!Q`\u0004\b\u0003\u0017\u0011\u0004\u0012AA\u0007\r\u0019\t$\u0007#\u0001\u0002\u0012!9\u00111C\u0007\u0005\u0002\u0005U\u0001bBA\f\u001b\u0011\u0005\u0011\u0011\u0004\u0005\b\u0005#jA\u0011\u0001B*\r\u0019\ty%\u0004\"\u0002R!Q\u00111N\t\u0003\u0016\u0004%\t!!\u001c\t\u0015\u0005\u0015\u0015C!E!\u0002\u0013\ty\u0007\u0003\u0006\u0002\bF\u0011)\u001a!C\u0001\u0003\u0013C!\"!$\u0012\u0005#\u0005\u000b\u0011BAF\u0011)\ty)\u0005BK\u0002\u0013\u0005\u0011\u0011\u0013\u0005\u000b\u0003G\u000b\"\u0011#Q\u0001\n\u0005M\u0005BCAS#\tU\r\u0011\"\u0001\u0002(\"I\u0011\u0011V\t\u0003\u0012\u0003\u0006IA\u001b\u0005\b\u0003'\tB\u0011AAV\u0011\u001d\t),\u0005C\u0001\u0003oC\u0011\"a3\u0012\u0003\u0003%\t!!4\t\u0013\u0005]\u0017#%A\u0005\u0002\u0005e\u0007\"CAx#E\u0005I\u0011AAy\u0011%\t)0EI\u0001\n\u0003\t9\u0010C\u0005\u0002|F\t\n\u0011\"\u0001\u0002~\"I!\u0011A\t\u0002\u0002\u0013\u0005#1\u0001\u0005\n\u0005\u001f\t\u0012\u0011!C\u0001\u0005#A\u0011B!\u0007\u0012\u0003\u0003%\tAa\u0007\t\u0013\t\u0005\u0012#!A\u0005B\t\r\u0002\"\u0003B\u0019#\u0005\u0005I\u0011\u0001B\u001a\u0011%\u0011i$EA\u0001\n\u0003\u0012y\u0004C\u0005\u0003DE\t\t\u0011\"\u0011\u0003F!I!qI\t\u0002\u0002\u0013\u0005#\u0011\n\u0005\n\u0005\u0017\n\u0012\u0011!C!\u0005\u001b:qAa\u001e\u000e\u0011\u0003\u0011IHB\u0004\u0002P5A\tAa\u001f\t\u000f\u0005M1\u0006\"\u0001\u0003\b\"9!\u0011R\u0016\u0005\u0002\t-\u0005\"CA\fW\u0005\u0005I\u0011\u0011BJ\u0011%\u0011ijKA\u0001\n\u0003\u0013y\nC\u0005\u0003..\n\t\u0011\"\u0003\u00030\nQ2)Y2iS:<\u0017iY2fgN$vn[3o!J|g/\u001b3fe*\u00111\u0007N\u0001\u0004G\u0016\u0014$BA\u001b7\u0003\u0015\u0019\u0017m\u00195f\u0015\t9\u0004(\u0001\u0004pCV$\bN\r\u0006\u0003si\nAa\u001d;ua*\u00111\bP\u0001\fa>d\u0017P^1sS\u0006tGOC\u0001>\u0003\ry'oZ\u0002\u0001+\t\u0001UjE\u0002\u0001\u0003\u001e\u0003\"AQ#\u000e\u0003\rS\u0011\u0001R\u0001\u0006g\u000e\fG.Y\u0005\u0003\r\u000e\u0013a!\u00118z%\u00164\u0007c\u0001%J\u00176\ta'\u0003\u0002Km\t\u0019\u0012iY2fgN$vn[3o!J|g/\u001b3feB\u0011A*\u0014\u0007\u0001\t\u0015q\u0005A1\u0001P\u0005\u00051UC\u0001)X#\t\tF\u000b\u0005\u0002C%&\u00111k\u0011\u0002\b\u001d>$\b.\u001b8h!\t\u0011U+\u0003\u0002W\u0007\n\u0019\u0011I\\=\u0005\u000bak%\u0019\u0001)\u0003\t}#C%M\u0001\tI\u0016dWmZ1uK\u0006I1/Z7ba\"|'/\u001a\t\u00049\u000e\\U\"A/\u000b\u0005y{\u0016AC2p]\u000e,(O]3oi*\u0011\u0001-Y\u0001\u0007K\u001a4Wm\u0019;\u000b\u0003\t\fAaY1ug&\u0011A-\u0018\u0002\n'\u0016l\u0017\r\u001d5pe\u0016\f!\u0002^8lK:\u001c\u0015m\u00195f!\u00159\u0007n\u00136\u0000\u001b\u0005!\u0014BA55\u00055)\u0005\u0010]5sS:<7)Y2iKB\u0019!i[7\n\u00051\u001c%AB(qi&|g\u000e\u0005\u0002oy:\u0011qN\u001f\b\u0003aft!!\u001d=\u000f\u0005I<hBA:w\u001b\u0005!(BA;?\u0003\u0019a$o\\8u}%\tQ(\u0003\u0002<y%\u0011\u0011HO\u0005\u0003oaJ!a\u001f\u001c\u0002\r\r|W.\\8o\u0013\tihPA\u0003TG>\u0004XM\u0003\u0002|mA\u0019\u0011\u0011A\t\u000f\u0007\u0005\rAB\u0004\u0003\u0002\u0006\u0005%abA8\u0002\b%\u0011QGN\u0005\u0003gQ\n!dQ1dQ&tw-Q2dKN\u001cHk\\6f]B\u0013xN^5eKJ\u00042!a\u0004\u000e\u001b\u0005\u00114CA\u0007B\u0003\u0019a\u0014N\\5u}Q\u0011\u0011QB\u0001\u0006CB\u0004H._\u000b\u0005\u00037\t\t\u0003\u0006\u0004\u0002\u001e\u0005\r\u0013q\t\u000b\u0007\u0003?\ti#!\u000f\u0011\u000b1\u000b\t#!\u000b\u0005\r9{!\u0019AA\u0012+\r\u0001\u0016Q\u0005\u0003\b\u0003O\t\tC1\u0001Q\u0005\u0011yF\u0005\n\u001a\u0011\u000b\u0005=\u0001!a\u000b\u0011\u00071\u000b\t\u0003C\u0005\u00020=\t\t\u0011q\u0001\u00022\u0005QQM^5eK:\u001cW\rJ\u001a\u0011\r\u0005M\u0012QGA\u0016\u001b\u0005y\u0016bAA\u001c?\nQ1i\u001c8dkJ\u0014XM\u001c;\t\u0013\u0005mr\"!AA\u0004\u0005u\u0012AC3wS\u0012,gnY3%iA1\u00111GA \u0003WI1!!\u0011`\u0005\u0015\u0019En\\2l\u0011\u0019Iv\u00021\u0001\u0002FA!\u0001*SA\u0016\u0011\u0019)w\u00021\u0001\u0002JA9q\r[A\u0016U\u0006-\u0003cAA'#5\tQBA\fU_.,gnV5uQ\u0016C\b/\u001b:bi&|g\u000eV5nKN1\u0011#QA*\u00033\u00022AQA+\u0013\r\t9f\u0011\u0002\b!J|G-^2u!\u0011\tY&!\u001a\u000f\t\u0005u\u0013\u0011\r\b\u0004g\u0006}\u0013\"\u0001#\n\u0007\u0005\r4)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0014\u0011\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u0003G\u001a\u0015aC1dG\u0016\u001c8\u000fV8lK:,\"!a\u001c\u0011\u000b!\u000b\t(!\u001e\n\u0007\u0005MdG\u0001\u0004TK\u000e\u0014X\r\u001e\t\u0005\u0003o\nyH\u0004\u0003\u0002z\u0005m\u0004CA:D\u0013\r\tihQ\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00151\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005u4)\u0001\u0007bG\u000e,7o\u001d+pW\u0016t\u0007%\u0001\u0004e_6\f\u0017N\\\u000b\u0003\u0003\u0017\u0003BAQ6\u0002v\u00059Am\\7bS:\u0004\u0013AD3ya&\u0014\u0018\r^5p]RKW.Z\u000b\u0003\u0003'\u0003B!!&\u0002 6\u0011\u0011q\u0013\u0006\u0005\u00033\u000bY*\u0001\u0003uS6,'BAAO\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u0016q\u0013\u0002\b\u0013:\u001cH/\u00198u\u0003=)\u0007\u0010]5sCRLwN\u001c+j[\u0016\u0004\u0013!B:d_B,W#\u00016\u0002\rM\u001cw\u000e]3!))\tY%!,\u00020\u0006E\u00161\u0017\u0005\b\u0003WR\u0002\u0019AA8\u0011\u001d\t9I\u0007a\u0001\u0003\u0017Cq!a$\u001b\u0001\u0004\t\u0019\n\u0003\u0004\u0002&j\u0001\rA[\u0001\u0016i>\f5mY3tgR{7.\u001a8SKN\u0004xN\\:f)\u0011\tI,a2\u0011\t\u0005m\u0016\u0011\u0019\b\u0004\u0011\u0006u\u0016bAA`m\u000512\t\\5f]R\u001c%/\u001a3f]RL\u0017\r\\:U_.,g.\u0003\u0003\u0002D\u0006\u0015'aE!dG\u0016\u001c8\u000fV8lK:\u0014Vm\u001d9p]N,'bAA`m!9\u0011\u0011Z\u000eA\u0002\u0005M\u0015a\u00018po\u0006!1m\u001c9z))\tY%a4\u0002R\u0006M\u0017Q\u001b\u0005\n\u0003Wb\u0002\u0013!a\u0001\u0003_B\u0011\"a\"\u001d!\u0003\u0005\r!a#\t\u0013\u0005=E\u0004%AA\u0002\u0005M\u0005\u0002CAS9A\u0005\t\u0019\u00016\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u001c\u0016\u0005\u0003_\nin\u000b\u0002\u0002`B!\u0011\u0011]Av\u001b\t\t\u0019O\u0003\u0003\u0002f\u0006\u001d\u0018!C;oG\",7m[3e\u0015\r\tIoQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAw\u0003G\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a=+\t\u0005-\u0015Q\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tIP\u000b\u0003\u0002\u0014\u0006u\u0017AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u007fT3A[Ao\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!Q\u0001\t\u0005\u0005\u000f\u0011i!\u0004\u0002\u0003\n)!!1BAN\u0003\u0011a\u0017M\\4\n\t\u0005\u0005%\u0011B\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005'\u00012A\u0011B\u000b\u0013\r\u00119b\u0011\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004)\nu\u0001\"\u0003B\u0010G\u0005\u0005\t\u0019\u0001B\n\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\u0005\t\u0006\u0005O\u0011i\u0003V\u0007\u0003\u0005SQ1Aa\u000bD\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005_\u0011IC\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\u001b\u0005w\u00012A\u0011B\u001c\u0013\r\u0011Id\u0011\u0002\b\u0005>|G.Z1o\u0011!\u0011y\"JA\u0001\u0002\u0004!\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BA!\u0002\u0003B!I!q\u0004\u0014\u0002\u0002\u0003\u0007!1C\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!1C\u0001\ti>\u001cFO]5oOR\u0011!QA\u0001\u0007KF,\u0018\r\\:\u0015\t\tU\"q\n\u0005\t\u0005?I\u0013\u0011!a\u0001)\u0006\u0001\"/\u001a4DC\u000eDW-\u00138ti\u0006t7-Z\u000b\u0005\u0005+\u0012Y\u0006\u0006\u0003\u0003X\tMDC\u0002B-\u0005O\u0012i\u0007E\u0003M\u00057\u0012\u0019\u0007\u0002\u0004O!\t\u0007!QL\u000b\u0004!\n}Ca\u0002B1\u00057\u0012\r\u0001\u0015\u0002\u0005?\u0012\"3\u0007E\u0003\u0002\u0010\u0001\u0011)\u0007E\u0002M\u00057B\u0011B!\u001b\u0011\u0003\u0003\u0005\u001dAa\u001b\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$S\u0007\u0005\u0004\u00024\u0005U\"Q\r\u0005\n\u0005_\u0002\u0012\u0011!a\u0002\u0005c\n!\"\u001a<jI\u0016t7-\u001a\u00137!\u0019\t\u0019$a\u0010\u0003f!1\u0011\f\u0005a\u0001\u0005k\u0002B\u0001S%\u0003f\u00059Bk\\6f]^KG\u000f[#ya&\u0014\u0018\r^5p]RKW.\u001a\t\u0004\u0003\u001bZ3\u0003B\u0016B\u0005{\u0002BAa \u0003\u00066\u0011!\u0011\u0011\u0006\u0005\u0005\u0007\u000bY*\u0001\u0002j_&!\u0011q\rBA)\t\u0011I(\u0001\u0003ge>lGCBA&\u0005\u001b\u0013\t\nC\u0004\u0003\u00106\u0002\r!!/\u0002\u000bQ|7.\u001a8\t\u000f\u0005%W\u00061\u0001\u0002\u0014RQ\u00111\nBK\u0005/\u0013IJa'\t\u000f\u0005-d\u00061\u0001\u0002p!9\u0011q\u0011\u0018A\u0002\u0005-\u0005bBAH]\u0001\u0007\u00111\u0013\u0005\u0007\u0003Ks\u0003\u0019\u00016\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0015BU!\u0011\u00115Na)\u0011\u0015\t\u0013)+a\u001c\u0002\f\u0006M%.C\u0002\u0003(\u000e\u0013a\u0001V;qY\u0016$\u0004\"\u0003BV_\u0005\u0005\t\u0019AA&\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005c\u0003BAa\u0002\u00034&!!Q\u0017B\u0005\u0005\u0019y%M[3di\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u000b\tm&QX&\u000e\u0003\u0005L1Aa0b\u0005\u0015iuN\\1e\u0003))g/\u001b3f]\u000e,GE\r\t\u0006\u0003g\tyd\u0013\u000b\t\u0005\u000f\u0014yM!5\u0003TR1!\u0011\u001aBf\u0005\u001b\u0004B!a\u0004\u0001\u0017\"9!q\u0017\u0004A\u0004\te\u0006b\u0002Ba\r\u0001\u000f!1\u0019\u0005\u00063\u001a\u0001\ra\u0012\u0005\u00065\u001a\u0001\ra\u0017\u0005\u0006K\u001a\u0001\rAZ\u0001\re\u0016\fX/Z:u)>\\WM\u001c\u000b\u0005\u00053\u0014Y\u000e\u0005\u0003M\u001b\u0006e\u0006BBAS\u000f\u0001\u0007!.\u0001\u0007bGF,\u0018N]3U_.,g\u000e\u0006\u0003\u0003Z\n\u0005\bBBAS\u0011\u0001\u0007!.\u0001\u0007hKR4%o\\7DC\u000eDW\r\u0006\u0003\u0003h\nM\bc\u0002Bu\u0005_\\\u0015\u0011X\u0007\u0003\u0005WT1A!<b\u0003\u0011!\u0017\r^1\n\t\tE(1\u001e\u0002\b\u001fB$\u0018n\u001c8U\u0011\u0019\t)+\u0003a\u0001U\u0006\tb-\u001a;dQ\u0006sGmU1wKR{7.\u001a8\u0015\t\te'\u0011 \u0005\u0007\u0003KS\u0001\u0019\u00016\u0002-\r\fGnY;mCR,W\t\u001f9jefLen\u001d;b]R$BAa@\u0004\u0002A\u0019A*T@\t\u000f\r\r1\u00021\u0001\u0002:\u0006A!/Z:q_:\u001cX\r")
public final class CachingAccessTokenProvider<F>
implements AccessTokenProvider<F> {
    private final AccessTokenProvider<F> delegate;
    private final Semaphore<F> semaphore;
    private final ExpiringCache<F, Option<Refined<String, common.ValidScope>>, TokenWithExpirationTime> tokenCache;
    private final Monad<F> evidence$1;
    private final Clock<F> evidence$2;

    public static <F> F refCacheInstance(AccessTokenProvider<F> delegate, Concurrent<F> evidence$5, Clock<F> evidence$6) {
        return CachingAccessTokenProvider$.MODULE$.refCacheInstance(delegate, evidence$5, evidence$6);
    }

    public static <F> F apply(AccessTokenProvider<F> delegate, ExpiringCache<F, Option<Refined<String, common.ValidScope>>, TokenWithExpirationTime> tokenCache, Concurrent<F> evidence$3, Clock<F> evidence$4) {
        return CachingAccessTokenProvider$.MODULE$.apply(delegate, tokenCache, evidence$3, evidence$4);
    }

    public F requestToken(Option<Refined<String, common.ValidScope>> scope) {
        return (F)this.getFromCache(scope).getOrElseF((Function0 & Serializable)() -> $this.semaphore.withPermit(this.acquireToken(scope)), this.evidence$1);
    }

    private F acquireToken(Option<Refined<String, common.ValidScope>> scope) {
        return (F)this.getFromCache(scope).getOrElseF((Function0 & Serializable)() -> this.fetchAndSaveToken(scope), this.evidence$1);
    }

    private OptionT<F, ClientCredentialsToken.AccessTokenResponse> getFromCache(Option<Refined<String, common.ValidScope>> scope) {
        return (OptionT)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2((Object)new OptionT(this.tokenCache.get(scope)), (Object)OptionT$.MODULE$.liftF(Clock$.MODULE$.JvmClockOps(Clock$.MODULE$.apply(this.evidence$2)).instantNow(this.evidence$1), this.evidence$1))).mapN((Function2 & Serializable)(x$1, x$2) -> x$1.toAccessTokenResponse((Instant)x$2), (Functor)OptionT$.MODULE$.catsDataMonadErrorMonadForOptionT(this.evidence$1), (Semigroupal)OptionT$.MODULE$.catsDataMonadErrorMonadForOptionT(this.evidence$1));
    }

    private F fetchAndSaveToken(Option<Refined<String, common.ValidScope>> scope) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.delegate.requestToken(scope), this.evidence$1).flatMap((Function1 & Serializable)token -> package.all$.MODULE$.toFlatMapOps(this.calculateExpiryInstant((ClientCredentialsToken.AccessTokenResponse)token), $this.evidence$1).flatMap((Function1 & Serializable)tokenWithExpiry -> package.all$.MODULE$.toFunctorOps($this.tokenCache.put((Object)scope, tokenWithExpiry, tokenWithExpiry.expirationTime()), $this.evidence$1).map((Function1 & Serializable)x$3 -> {
            BoxedUnit boxedUnit = x$3;
            return token;
        })));
    }

    private F calculateExpiryInstant(ClientCredentialsToken.AccessTokenResponse response) {
        return (F)package.all$.MODULE$.toFunctorOps(Clock$.MODULE$.JvmClockOps(Clock$.MODULE$.apply(this.evidence$2)).instantNow(this.evidence$1), this.evidence$1).map((Function1 & Serializable)x$4 -> CachingAccessTokenProvider$TokenWithExpirationTime$.MODULE$.from(response, (Instant)x$4));
    }

    public CachingAccessTokenProvider(AccessTokenProvider<F> delegate, Semaphore<F> semaphore, ExpiringCache<F, Option<Refined<String, common.ValidScope>>, TokenWithExpirationTime> tokenCache, Monad<F> evidence$1, Clock<F> evidence$2) {
        this.delegate = delegate;
        this.semaphore = semaphore;
        this.tokenCache = tokenCache;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
    }

    public static final class TokenWithExpirationTime
    implements Product,
    Serializable {
        private final Secret<String> accessToken;
        private final Option<String> domain;
        private final Instant expirationTime;
        private final Option<Refined<String, common.ValidScope>> scope;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Secret<String> accessToken() {
            return this.accessToken;
        }

        public Option<String> domain() {
            return this.domain;
        }

        public Instant expirationTime() {
            return this.expirationTime;
        }

        public Option<Refined<String, common.ValidScope>> scope() {
            return this.scope;
        }

        public ClientCredentialsToken.AccessTokenResponse toAccessTokenResponse(Instant now) {
            FiniteDuration newExpiresIn = Duration$.MODULE$.fromNanos(Duration.between(now, this.expirationTime()).toNanos());
            return new ClientCredentialsToken.AccessTokenResponse(this.accessToken(), this.domain(), newExpiresIn, this.scope());
        }

        public TokenWithExpirationTime copy(Secret<String> accessToken, Option<String> domain, Instant expirationTime, Option<Refined<String, common.ValidScope>> scope) {
            return new TokenWithExpirationTime(accessToken, domain, expirationTime, scope);
        }

        public Secret<String> copy$default$1() {
            return this.accessToken();
        }

        public Option<String> copy$default$2() {
            return this.domain();
        }

        public Instant copy$default$3() {
            return this.expirationTime();
        }

        public Option<Refined<String, common.ValidScope>> copy$default$4() {
            return this.scope();
        }

        public String productPrefix() {
            return "TokenWithExpirationTime";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.accessToken();
                }
                case 1: {
                    return this.domain();
                }
                case 2: {
                    return this.expirationTime();
                }
                case 3: {
                    return this.scope();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TokenWithExpirationTime;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "accessToken";
                }
                case 1: {
                    return "domain";
                }
                case 2: {
                    return "expirationTime";
                }
                case 3: {
                    return "scope";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TokenWithExpirationTime)) return false;
            boolean bl = true;
            if (!bl) return false;
            TokenWithExpirationTime tokenWithExpirationTime = (TokenWithExpirationTime)x$1;
            Secret<String> secret = this.accessToken();
            Secret<String> secret2 = tokenWithExpirationTime.accessToken();
            if (secret == null) {
                if (secret2 != null) {
                    return false;
                }
            } else if (!secret.equals(secret2)) return false;
            Option<String> option = this.domain();
            Option<String> option2 = tokenWithExpirationTime.domain();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Instant instant = this.expirationTime();
            Instant instant2 = tokenWithExpirationTime.expirationTime();
            if (instant == null) {
                if (instant2 != null) {
                    return false;
                }
            } else if (!((Object)instant).equals(instant2)) return false;
            Option<Refined<String, common.ValidScope>> option3 = this.scope();
            Option<Refined<String, common.ValidScope>> option4 = tokenWithExpirationTime.scope();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public TokenWithExpirationTime(Secret<String> accessToken, Option<String> domain, Instant expirationTime, Option<Refined<String, common.ValidScope>> scope) {
            this.accessToken = accessToken;
            this.domain = domain;
            this.expirationTime = expirationTime;
            this.scope = scope;
            Product.$init$((Product)this);
        }
    }
}

