/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Objects;
import poussecafe.attribute.adapters.DataAdapter;
import poussecafe.attribute.adapters.DataAdapters;
import poussecafe.attribute.list.ListAttributeBuilder;
import poussecafe.attribute.map.MapAttributeBuilder;
import poussecafe.attribute.number.IntegerAttributeBuilder;
import poussecafe.attribute.number.NumberAttributeBuilder;
import poussecafe.attribute.optional.OptionalAttributeBuilder;
import poussecafe.attribute.set.SetAttributeBuilder;
import poussecafe.attribute.single.SingleAttributeBuilder;
import poussecafe.util.StringId;

public class AttributeBuilder {
    private AttributeBuilder() {
    }

    public static <T> SingleAttributeBuilder.ExpectingReaderOrAdapter<T> single(Class<T> valueClass) {
        return new SingleAttributeBuilder<T>().usingValue(valueClass);
    }

    public static <T> ListAttributeBuilder<T> list(Class<T> elementClass) {
        return new ListAttributeBuilder<T>(elementClass);
    }

    public static <T> SetAttributeBuilder<T> set(Class<T> elementClass) {
        return new SetAttributeBuilder<T>(elementClass);
    }

    public static <K, V> MapAttributeBuilder<K, V> map(Class<K> keyClass, Class<V> valueClass) {
        Objects.requireNonNull(keyClass);
        Objects.requireNonNull(valueClass);
        return new MapAttributeBuilder();
    }

    public static <T> OptionalAttributeBuilder<T> optional(Class<T> valueClass) {
        return new OptionalAttributeBuilder<T>(valueClass);
    }

    public static <T extends Number> NumberAttributeBuilder<T> number(Class<T> valueClass) {
        Objects.requireNonNull(valueClass);
        return new NumberAttributeBuilder();
    }

    public static IntegerAttributeBuilder integer() {
        return new IntegerAttributeBuilder();
    }

    public static <T extends StringId> SingleAttributeBuilder.ExpectingAdaptedReader<String, T> stringId(Class<T> stringIdClass) {
        return AttributeBuilder.singleUsingDataAdapter(DataAdapters.stringId(stringIdClass));
    }

    public static <U, T> SingleAttributeBuilder.ExpectingAdaptedReader<U, T> singleUsingDataAdapter(DataAdapter<U, T> dataAdapter) {
        return new SingleAttributeBuilder<T>().usingDataAdapter(dataAdapter);
    }

    public static SingleAttributeBuilder.ExpectingAdaptedReader<String, OffsetDateTime> offsetDateTime() {
        return AttributeBuilder.singleUsingDataAdapter(DataAdapters.stringOffsetDateTime());
    }

    public static SingleAttributeBuilder.ExpectingAdaptedReader<String, LocalDateTime> localDateTime() {
        return AttributeBuilder.singleUsingDataAdapter(DataAdapters.stringLocalDateTime());
    }

    public static SingleAttributeBuilder.ExpectingAdaptedReader<String, LocalDate> localDate() {
        return AttributeBuilder.singleUsingDataAdapter(DataAdapters.stringLocalDate());
    }

    public static SingleAttributeBuilder.ExpectingAdaptedReader<String, BigDecimal> bigDecimal() {
        return AttributeBuilder.singleUsingDataAdapter(DataAdapters.stringBigDecimal());
    }

    public static <E extends Enum<E>> SingleAttributeBuilder.ExpectingAdaptedReader<String, E> enumAttribute(Class<E> enumClass) {
        return AttributeBuilder.singleUsingDataAdapter(DataAdapters.stringEnum(enumClass));
    }

    public static Class<byte[]> byteArrayClass() {
        return new byte[0].getClass();
    }
}

