/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import poussecafe.attribute.Attribute;
import poussecafe.attribute.list.EditableList;

public interface ListAttribute<T>
extends Attribute<List<T>>,
Iterable<T> {
    @Override
    public EditableList<T> value();

    @Override
    default public void value(List<T> value) {
        Objects.requireNonNull(value);
        this.value().clear();
        this.value().addAll(value);
    }

    @Deprecated(since="0.19")
    default public void add(T item) {
        this.value().add(item);
    }

    @Deprecated(since="0.19")
    default public void filter(Predicate<T> predicate) {
        this.value(this.value().stream().filter(predicate).collect(Collectors.toList()));
    }

    @Deprecated(since="0.19")
    default public Stream<T> stream() {
        return this.value().stream();
    }

    @Deprecated(since="0.19")
    default public void addAll(Collection<T> values) {
        this.value().addAll(values);
    }

    @Deprecated(since="0.19")
    default public int size() {
        return this.value().size();
    }

    @Deprecated(since="0.19")
    default public T get(int index) {
        return (T)this.value().get(index);
    }

    @Deprecated(since="0.19")
    default public void clear() {
        this.value().clear();
    }

    @Deprecated(since="0.19")
    default public void set(int index, T item) {
        this.value().set(index, item);
    }

    @Override
    @Deprecated(since="0.19")
    default public Iterator<T> iterator() {
        return this.value().iterator();
    }

    @Override
    @Deprecated(since="0.19")
    default public void forEach(Consumer<? super T> action) {
        this.value().forEach(action);
    }

    @Override
    @Deprecated(since="0.19")
    default public Spliterator<T> spliterator() {
        return this.value().spliterator();
    }
}

