/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.adapters;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;
import poussecafe.attribute.adapters.AdaptingIterator;
import poussecafe.attribute.adapters.Arrays;
import poussecafe.attribute.adapters.DataAdapter;

public abstract class AdaptingCollection<U, T>
implements Collection<T> {
    private Collection<U> mutableCollection;
    private DataAdapter<U, T> adapter;
    private Supplier<Collection<T>> collectionFactory;

    @Override
    public int size() {
        return this.mutableCollection.size();
    }

    protected void mutableCollection(Collection<U> mutableCollection) {
        Objects.requireNonNull(mutableCollection);
        this.mutableCollection = mutableCollection;
    }

    protected Collection<U> mutableCollection() {
        return this.mutableCollection;
    }

    @Override
    public boolean isEmpty() {
        return this.mutableCollection.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.adaptedCollection().contains(o);
    }

    protected Collection<T> adaptedCollection() {
        Collection<T> adaptedCollection = this.collectionFactory.get();
        this.iterator().forEachRemaining(adaptedCollection::add);
        return adaptedCollection;
    }

    protected void collectionFactory(Supplier<Collection<T>> collectionFactory) {
        Objects.requireNonNull(collectionFactory);
        this.collectionFactory = collectionFactory;
    }

    protected Supplier<Collection<T>> collectionFactory() {
        return this.collectionFactory;
    }

    protected void adapter(DataAdapter<U, T> adapter) {
        Objects.requireNonNull(adapter);
        this.adapter = adapter;
    }

    protected DataAdapter<U, T> adapter() {
        return this.adapter;
    }

    @Override
    public Iterator<T> iterator() {
        return new AdaptingIterator.Builder().iterator(this.mutableCollection.iterator()).adapter(this.adapter::adaptGet).build();
    }

    @Override
    public Object[] toArray() {
        return Arrays.toAdaptedArray(this.mutableCollection, this.adapter::adaptGet);
    }

    @Override
    public <V> V[] toArray(V[] a) {
        return Arrays.toAdaptedArray(this.mutableCollection, this.adapter::adaptGet, a);
    }

    @Override
    public boolean add(T e) {
        U newElement = this.adapter.adaptSet(e);
        return this.mutableCollection.add(newElement);
    }

    @Override
    public boolean remove(Object o) {
        U elementToRemove;
        try {
            elementToRemove = this.adapter.adaptSet(o);
        }
        catch (ClassCastException e) {
            return false;
        }
        return this.mutableCollection.remove(elementToRemove);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object element : c) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean someAdded = false;
        for (T element : c) {
            if (!this.add(element)) continue;
            someAdded = true;
        }
        return someAdded;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean someRemoved = false;
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (c.contains(next)) continue;
            iterator.remove();
            someRemoved = true;
        }
        return someRemoved;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean someRemoved = false;
        for (Object element : c) {
            if (!this.remove(element)) continue;
            someRemoved = true;
        }
        return someRemoved;
    }

    @Override
    public void clear() {
        this.mutableCollection.clear();
    }

    protected AdaptingCollection() {
    }
}

