/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.adapters;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import poussecafe.attribute.adapters.DataAdapters;

public class AdaptingIterator<U, T>
implements Iterator<T> {
    private Iterator<U> iterator;
    private U next;
    private Function<U, T> adapter;
    private Consumer<U> onRemove;

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        this.next = this.iterator.next();
        return (T)DataAdapters.nullOrAdapted(this.next, this.adapter::apply);
    }

    @Override
    public void remove() {
        this.iterator.remove();
        if (this.onRemove != null) {
            this.onRemove.accept(this.next);
        }
    }

    protected AdaptingIterator() {
    }

    protected void onRemove(Consumer<U> onRemove) {
        Objects.requireNonNull(onRemove);
        this.onRemove = onRemove;
    }

    protected void adapter(Function<U, T> adapter) {
        Objects.requireNonNull(adapter);
        this.adapter = adapter;
    }

    protected void iterator(Iterator<U> iterator) {
        Objects.requireNonNull(iterator);
        this.iterator = iterator;
    }

    protected Function<U, T> adapter() {
        return this.adapter;
    }

    protected Iterator<U> iterator() {
        return this.iterator;
    }

    public static class Builder<U, T> {
        private AdaptingIterator<U, T> iterator = new AdaptingIterator();

        public AdaptingIterator<U, T> build() {
            Objects.requireNonNull(this.iterator.iterator);
            Objects.requireNonNull(this.iterator.adapter);
            return this.iterator;
        }

        public Builder<U, T> iterator(Iterator<U> iterator) {
            this.iterator.iterator = iterator;
            return this;
        }

        public Builder<U, T> adapter(Function<U, T> adapter) {
            this.iterator.adapter = adapter;
            return this;
        }

        public Builder<U, T> onRemove(Consumer<U> onRemove) {
            this.iterator.onRemove = onRemove;
            return this;
        }
    }
}

